/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.WsnbrConstants;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistration;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.NotificationBrokerRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationFailedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRejectedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisher;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrWriter;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.utils.WsnbrException;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.WsnbrJAXBContext;
import com.ebmwebsourcing.wsstar.common.utils.WsstarCommonUtils;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.utils.WstopUtils;

/**
 * @author Thierry DÉJEAN - eBM WebSourcing
 */
public class WsnbrWriterImpl implements WsnbrWriter {
		
//	private Logger logger = Logger.getLogger(WsnbrWriterImpl.class.getName());
	private WsnbrJAXBContext wsnbrJaxbContext = null;
	
	/**
     * Default constructor
     */
    protected  WsnbrWriterImpl(){
    	this.wsnbrJaxbContext = WsnbrJAXBContext.getInstance();
	} 
        
    protected  WsnbrWriterImpl(String[] nsAndPrefixForMarshalling){
    	this.wsnbrJaxbContext = WsnbrJAXBContext.getInstance(nsAndPrefixForMarshalling);	
	}
    
	@Override
	public final Document writeDestroyRegistrationAsDOM(DestroyRegistration value)
			throws WsnbrException {
		Document result = null;    

		try {

			Marshaller marshaller = this.wsnbrJaxbContext.createWSNotificationMarshaller();

			result = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument(); 
			
			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistration> element = 
			  new JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistration>(WsnbrConstants.DESTROY_REGISTRATION_QNAME,
              		 com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistration.class, DestroyRegistrationImpl.toJaxbModel(value));     
			marshaller.marshal(element, result);

		} catch (final JAXBException ex) {
			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(value), ex);
		}    	          
		return result;
	}

	@Override
	public final Document writeDestroyRegistrationResponseAsDOM(
			DestroyRegistrationResponse value) throws WsnbrException {
		Document result = null;    

		try {

			Marshaller marshaller = this.wsnbrJaxbContext.createWSNotificationMarshaller();

			result = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument(); 
			
			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistrationResponse> element = 
			  new JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistrationResponse>(WsnbrConstants.DESTROY_REGISTRATION_RESPONSE_QNAME,
              		 com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistrationResponse.class, DestroyRegistrationResponseImpl.toJaxbModel(value));     
			marshaller.marshal(element, result);

		} catch (final JAXBException ex) {
			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(value), ex);
		}    	          
		return result;
	}

	@Override
	public final Document writeNotificationBrokerRPAsDOM(NotificationBrokerRP value)
			throws WsnbrException {
		Document result = null;
    	try {
    	
    		Marshaller marshaller = this.wsnbrJaxbContext.createWSNotificationMarshaller();
    		
    		// get from corresponding TopicExpression model object, topicNS to add to Document result object.
    		Map<Integer, List<QName>> topicNSToAdd = new HashMap<Integer,List<QName>>();
    		
    		List<TopicExpressionType> topicExpressions = value.getTopicExpressions(); 
    		for (TopicExpressionType topicExprItem : topicExpressions) {
    			topicNSToAdd.put(Integer.valueOf(topicExpressions.indexOf(topicExprItem)),topicExprItem.getTopicNamespaces());
    			// remove (temporarily) namespace from java object  
    			TopicExpressionTypeImpl.removeTopicNamspacesFromJaxbModel((TopicExpressionTypeImpl)topicExprItem);

			}			
    	
    		result = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument();

    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.NotificationBrokerRP> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.NotificationBrokerRP>(WsnbrConstants.NOTIFICATION_BROKER_RP_QNAME,
    					com.ebmwebsourcing.wsstar.jaxb.notification.brokered.NotificationBrokerRP.class, ((NotificationBrokerRPImpl)value).getJaxbTypeObj());

    		marshaller.marshal(element, result);    			
   			
    		// Trick : Add saved topic additional namespaces to the generated
    		// Document
            NodeList topicExpressionNodes = result.getDocumentElement().getElementsByTagNameNS(
                    WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI(),
                    WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart());
            
            Element currentTopicExprNode = null;            
            for (int i = 0; i < topicExpressionNodes.getLength(); i++) {
            	currentTopicExprNode = (Element) topicExpressionNodes.item(0);            		
            	List<QName> currentTopicsToAdd = topicNSToAdd.get(i);
            	for (QName nsItem : currentTopicsToAdd) {
            		currentTopicExprNode.setAttributeNS(XMLConstants.XMLNS_ATTRIBUTE_NS_URI,
            				XMLConstants.XMLNS_ATTRIBUTE + ":" + nsItem.getLocalPart(),
            				nsItem.getNamespaceURI());
            	}
            }
            
              // --- restore namespaces, previously remove, on java object
            List<QName> currentQNames = null;
            for (TopicExpressionType topicExpressionItem : topicExpressions) {
            	currentQNames = topicNSToAdd.get(topicExpressions.indexOf(topicExpressionItem));
            	if (currentQNames != null){
            		for (QName qnItem : currentQNames) {    		
            			topicExpressionItem.addTopicNamespace(qnItem.getLocalPart(),
            					new URI (qnItem.getNamespaceURI()));
            		} 
            	}
            }

    	} catch (final JAXBException ex) {
			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(value), ex);
		} catch (URISyntaxException ex) {
			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(value), ex);
		}             

    	return result;
	}

	@Override
	public final Document writePublisherRegistrationFailedFaultTypeAsDOM(
			PublisherRegistrationFailedFaultType fault) throws WsnbrException {
		Document result = null;
    	if (fault instanceof PublisherRegistrationFailedFaultTypeImpl){
    		try {

    			Marshaller marshaller = this.wsnbrJaxbContext.createWSNotificationMarshaller();

    			result = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType> element =
    				WsnbrJAXBContext.WSNBR_JAXB_FACTORY.createPublisherRegistrationFailedFault(PublisherRegistrationFailedFaultTypeImpl.toJaxbModel(fault));
    			
    			marshaller.marshal(element, result);            

    		} catch (final JAXBException ex) {
    			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(fault), ex);
    		} 
    	}
    	return result;	
	}

	@Override
	public final Document writePublisherRegistrationRejectedFaultTypeAsDOM(
			PublisherRegistrationRejectedFaultType fault) throws WsnbrException {
		Document result = null;
    	if (fault instanceof PublisherRegistrationRejectedFaultTypeImpl){
    		try {

    			Marshaller marshaller = this.wsnbrJaxbContext.createWSNotificationMarshaller();

    			result = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationRejectedFaultType> element =
    				WsnbrJAXBContext.WSNBR_JAXB_FACTORY.createPublisherRegistrationRejectedFault(PublisherRegistrationRejectedFaultTypeImpl.toJaxbModel(fault));
    			
    			marshaller.marshal(element, result);            

    		} catch (final JAXBException ex) {
    			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(fault), ex);
    		} 
    	}
    	return result;	
	}

	@Override
	public final Document writePublisherRegistrationRPAsDOM(
			PublisherRegistrationRP registration) throws WsnbrException {
		Document result = null;    

		try {

			Marshaller marshaller = this.wsnbrJaxbContext.createWSNotificationMarshaller();
		
			// get from corresponding Topic model object, topicNS to add to Document result object.
			Map<Integer,List<QName>> topicNSToAdd = new HashMap<Integer,List<QName>>();
			List<TopicExpressionType> topics = registration.getTopics(); 
			
			for (TopicExpressionType topicItem : topics) {
				topicNSToAdd.put(Integer.valueOf(topics.indexOf(topicItem)),topicItem.getTopicNamespaces());
				// remove (temporarily) namespace from java object  
				TopicExpressionTypeImpl.removeTopicNamspacesFromJaxbModel((TopicExpressionTypeImpl)topicItem);
			}									

			result = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument(); 
			
			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationRP> element = 
			  new JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationRP>(WsnbrConstants.PUBLISHER_REGISTRATION_RP_QNAME,
              		 com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationRP.class, PublisherRegistrationRPImpl.toJaxbModel(registration));     
			marshaller.marshal(element, result);

			// Trick : Add saved topic additional namespaces to the generated			
			NodeList topicNodes = result.getDocumentElement().getElementsByTagNameNS(
					WsnbrConstants.TOPIC_QNAME.getNamespaceURI(),
					WsnbrConstants.TOPIC_QNAME.getLocalPart());
		
			Element currentTopicAsElt = null;
			List<QName> currentTopicNSsToAdd = null;
			for (int i = 0; i < topicNodes.getLength(); i++) {
				currentTopicAsElt = (Element) topicNodes.item(i);                
				currentTopicNSsToAdd = topicNSToAdd.get(i);
				for (QName nsItem : currentTopicNSsToAdd) {
					currentTopicAsElt.setAttributeNS(XMLConstants.XMLNS_ATTRIBUTE_NS_URI,
							XMLConstants.XMLNS_ATTRIBUTE + ":" + nsItem.getLocalPart(),
							nsItem.getNamespaceURI());
				}
			} 

			// --- restore namespaces, previously remove, on java object
			for (TopicExpressionType topExpItem : topics) {
				for (QName qnItem : topicNSToAdd.get(topics.indexOf(topExpItem))) {    		
					topExpItem.addTopicNamespace(qnItem.getLocalPart(), new URI(qnItem.getNamespaceURI()));
				} 
			}

		} catch (final JAXBException ex) {
			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(registration), ex);
		} catch (URISyntaxException ex) {
			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(registration), ex);
		}        	          
		return result;
	}

	@Override
	public final void writePublisherRegistrationRPToFilesystem(
			PublisherRegistrationRP registration, String path) throws WsnbrException {
		Document registrationAsDoc = this.writePublisherRegistrationRPAsDOM(registration);
    	try{
			// Prepare the DOM document for writing		    
			Source source = new DOMSource(registrationAsDoc);

			// Prepare the output file		
			File persist = new File(path);
			if (!persist.exists()) {
				try {
					persist.createNewFile();
				} catch (IOException e) {
					throw new WsnbrException("The persistance file can not be created respect to given path : \"" + path + "\"",e);
				}
			}        
			
			// Prepare the stream
			Result result = new StreamResult(persist);

			// Write the DOM document to the file
			Transformer xformer = WsstarCommonUtils.getDefaultTransformerFactoryThreadLocal();
			xformer.transform(source, result);
			
		} catch (TransformerConfigurationException e) {
			throw new WsnbrException(WstopUtils.PERSISTENCE_EXCEPETION_MSG,e);
		} catch (TransformerFactoryConfigurationError e) {
			throw new WsnbrException(WstopUtils.PERSISTENCE_EXCEPETION_MSG,e);
		} catch (TransformerException e) {			
			throw new WsnbrException(WstopUtils.PERSISTENCE_EXCEPETION_MSG,e);
		}
	}

	@Override
	public final Document writeRegisterPublisherAsDOM(RegisterPublisher value)
			throws WsnbrException {
		Document result = null;    

		try {

			Marshaller marshaller = this.wsnbrJaxbContext.createWSNotificationMarshaller();
		
			// get from corresponding Topic model object, topicNS to add to Document result object.
			Map<Integer,List<QName>> topicNSToAdd = new HashMap<Integer,List<QName>>();
			List<TopicExpressionType> topics = value.getTopics(); 
			
			for (TopicExpressionType topicItem : topics) {
				topicNSToAdd.put(Integer.valueOf(topics.indexOf(topicItem)),topicItem.getTopicNamespaces());
				// remove (temporarily) namespace from java object  
				TopicExpressionTypeImpl.removeTopicNamspacesFromJaxbModel((TopicExpressionTypeImpl)topicItem);
			}									

			result = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument(); 
			
			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher> element = 
			  new JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher>(WsnbrConstants.REGISTER_PUBLISHER_QNAME,
              		 com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher.class, RegisterPublisherImpl.toJaxbModel(value));     
			marshaller.marshal(element, result);

			// Trick : Add saved topic additional namespaces to the generated			
			NodeList topicNodes = result.getDocumentElement().getElementsByTagNameNS(
					WsnbrConstants.TOPIC_QNAME.getNamespaceURI(),
					WsnbrConstants.TOPIC_QNAME.getLocalPart());
		
			Element currentTopicAsElt = null;
			List<QName> currentTopicNSsToAdd = null;
			for (int i = 0; i < topicNodes.getLength(); i++) {
				currentTopicAsElt = (Element) topicNodes.item(i);                
				currentTopicNSsToAdd = topicNSToAdd.get(i);
				for (QName nsItem : currentTopicNSsToAdd) {
					currentTopicAsElt.setAttributeNS(XMLConstants.XMLNS_ATTRIBUTE_NS_URI,
							XMLConstants.XMLNS_ATTRIBUTE + ":" + nsItem.getLocalPart(),
							nsItem.getNamespaceURI());
				}
			} 

			// --- restore namespaces, previously remove, on java object
			for (TopicExpressionType topExpItem : topics) {
				for (QName qnItem : topicNSToAdd.get(topics.indexOf(topExpItem))) {    		
					topExpItem.addTopicNamespace(qnItem.getLocalPart(), new URI(qnItem.getNamespaceURI()));
				} 
			}

		} catch (final JAXBException ex) {
			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(value), ex);
		} catch (URISyntaxException ex) {
			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(value), ex);
		}        	          
		return result;
	}

	@Override
	public final Document writeRegisterPublisherResponseAsDOM(
			RegisterPublisherResponse value) throws WsnbrException {
		Document result = null;    

		try {

			Marshaller marshaller = this.wsnbrJaxbContext.createWSNotificationMarshaller();

			result = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument(); 
			
			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse> element = 
			  new JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse>(WsnbrConstants.REGISTER_PUBLISHER_RESPONSE_QNAME,
              		 com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse.class, RegisterPublisherResponseImpl.toJaxbModel(value));     
			marshaller.marshal(element, result);

		} catch (final JAXBException ex) {
			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(value), ex);
		}    	          
		return result;
	}

	@Override
	public final Document writeResourceNotDestroyedFaultTypeAsDOM(
			ResourceNotDestroyedFaultType fault) throws WsnbrException {
		Document result = null;
    	if (fault instanceof ResourceNotDestroyedFaultTypeImpl){
    		try {

    			Marshaller marshaller = this.wsnbrJaxbContext.createWSNotificationMarshaller();

    			result = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType> element =
    				WsnbrJAXBContext.WSNBR_JAXB_FACTORY.createResourceNotDestroyedFault(ResourceNotDestroyedFaultTypeImpl.toJaxbModel(fault));
    			
    			marshaller.marshal(element, result);            

    		} catch (final JAXBException ex) {
    			throw new WsnbrException(WsrfbfUtils.getBindingExMessage(fault), ex);
    		} 
    	}
    	return result;	
	}

}
