/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.test;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.refinedabstraction.RefinedWsaFactory;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.test.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsrfrlUnitTestsUtils {
    public static final String WSRFBF_SPECIFICATION_NAME = "OASIS \"WS-BaseFaults\"";
    public static final String WSRFBF_XML_SCHEMA_PATH = "/schemas/bf-2.xsd";
    public static final String WSRFRL_SPECIFICATION_NAME = "OASIS \"WS-ResourceLifetime\"";
    public static final String WSRFRL_XML_SCHEMA_PATH = "/schemas/rl-2.xsd";
    public static final String XML_XML_SCHEMA_PATH = "/schemas/xml.xsd";
    public static final String[] WSRFRL_XML_SCHEMAS_PATHS = new String[]{"/schema/ws-addr.xsd", "/schemas/xml.xsd", "/schemas/bf-2.xsd", "/schemas/rl-2.xsd"};

    public static Element createDefaultFaultCauseContent(String faultCausePath) {
        Document faultCauseContentAsDocument = WsaUnitTestsUtils.fromStreamToDocument((InputStream)WsrfrlUnitTestsUtils.class.getResourceAsStream(faultCausePath));
        return faultCauseContentAsDocument.getDocumentElement();
    }

    public static EndpointReferenceType createDefaultBaseFaultOriginator() throws URISyntaxException, WsaException {
        EndpointReferenceType defaultMinimalEdp = null;
        URI address = new URI("http://myURL/for/test::MyServiceName@myEndpointAddress");
        defaultMinimalEdp = RefinedWsaFactory.getInstance().createEndpointReferenceType(address);
        return defaultMinimalEdp;
    }

    public static Element createTerminationReasonElt(String reason) {
        Element reasonAsElt = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            reasonAsElt = doc.createElementNS("http://docs.oasis-open.org/wsrf/rl-2", "TerminationReason");
            reasonAsElt.setPrefix("wsrf-rl");
            reasonAsElt.setTextContent(reason);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return reasonAsElt;
    }
}

