/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.test;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.test.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.common.utils.WsstarCommonUtils;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.ResourcePropertyValueChangeNotificationType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.WsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.WsrfrpReader;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.WsrfrpWriter;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.test.WsrfrpUnitTestsUtils;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbsWsrfrpTypesAndPayloadsUnitTests
extends TestCase {
    protected boolean isDebug = false;
    private WsrfrpFactory factory;
    protected WsrfrpModelFactory modelFactoryImpl;
    private WsrfrpReader reader;
    private WsrfrpWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.initRefinedWsrfrpFactory();
        this.initRequiredDependencyModelFactories();
    }

    protected abstract void setWsrfrpModelFactory();

    protected abstract void initRequiredDependencyModelFactories();

    public void initRefinedWsrfrpFactory() {
        if (this.modelFactoryImpl == null) {
            this.setWsrfrpModelFactory();
        }
        AbsWsrfrpTypesAndPayloadsUnitTests.assertNotNull((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "the \"WsrfrpModelFactory\" implementation Object has not been set.\n" + "Please provide an instance of \"WsrfrpModelFactory\" implementation class"), (Object)this.modelFactoryImpl);
        if (this.factory == null) {
            this.factory = RefinedWsrfrpFactory.getInstance((WsrfrpModelFactory)this.modelFactoryImpl);
        }
        if (this.reader == null) {
            this.reader = this.factory.getWsrfrpReader();
        }
        if (this.writer == null) {
            this.writer = this.factory.getWsrfrpWriter();
        }
    }

    protected static boolean checkGetResourceProperty(QName expectedResourceName, QName toCheckResourceName, boolean isDebug) {
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckResourceName requested resource property : " + toCheckResourceName + "\n[DEBUG] --> expectedResourceName requested resource property : " + expectedResourceName + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "payload have different requested resource property QName values\n" + "\t(-> toCheckResourceProperty requested QName : " + toCheckResourceName + "\n\t-> expectedResourceProperty requested QName : " + expectedResourceName), (toCheckResourceName != null && toCheckResourceName.equals(expectedResourceName) ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkGetResourcePropertyResponse(GetResourcePropertyResponse expectedResponse, GetResourcePropertyResponse toCheckResponse, boolean isDebug) {
        List toCheckPropertyValues = toCheckResponse.getPropertyValue();
        List expectedPropertyValues = expectedResponse.getPropertyValue();
        int expectedRPValuesCount = expectedPropertyValues != null ? expectedPropertyValues.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "ResourceProperty has different Element values\n" + "\t(-> toCheckRPValues count : " + (toCheckPropertyValues != null ? Integer.valueOf(toCheckPropertyValues.size()) : "none") + "\n\t-> expectedRPValues count : " + (expectedRPValuesCount == -1 ? "none" : Integer.valueOf(expectedRPValuesCount)) + ")"), (toCheckPropertyValues == null && expectedPropertyValues == null || toCheckPropertyValues.size() == expectedRPValuesCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedRPValuesCount; ++i) {
            String expectedPropertyValueItemAsString;
            String toCheckPropertyValueItemAsString = toCheckPropertyValues != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)toCheckPropertyValues.get(i))) : null;
            String string = expectedPropertyValueItemAsString = expectedPropertyValues != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)expectedPropertyValues.get(i))) : null;
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckPropertyValue : " + toCheckPropertyValues + "\n\t(nodeAsString = " + toCheckPropertyValueItemAsString + ")" + "\n[DEBUG] --> expectedPropertyValue : " + expectedPropertyValues + "\n\t(nodeAsString = " + expectedPropertyValueItemAsString + ")\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "ResourceProperty values are different \n" + "\t(-> toCheckResourceProperty value formatted to comparison is : " + (toCheckPropertyValues != null ? toCheckPropertyValues : null) + "\n\t(nodesAsString = " + toCheckPropertyValueItemAsString + ")" + "\n\t-> expectedResourceProperty value formatted to comparison is : " + (expectedPropertyValues != null ? expectedPropertyValues : null) + ")" + "\n\t(nodesAsString = " + expectedPropertyValueItemAsString + ")\n"), (toCheckPropertyValueItemAsString == expectedPropertyValueItemAsString || expectedPropertyValueItemAsString != null && toCheckPropertyValueItemAsString != null && toCheckPropertyValueItemAsString.equals(expectedPropertyValueItemAsString) ? 1 : 0) != 0);
        }
        return true;
    }

    protected static boolean checkUpdateType(UpdateType expectedUpdateObj, UpdateType toCheckUpdateObj, boolean isDebug) {
        List toCheckProperties = toCheckUpdateObj.getUpdateContent();
        List expectedProperties = expectedUpdateObj.getUpdateContent();
        int expectedPropertiesCount = expectedProperties != null ? expectedProperties.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "UpdateType objects have different Element lists\n" + "\t(-> toCheckProperties count : " + (toCheckProperties != null ? Integer.valueOf(toCheckProperties.size()) : "none") + "\n\t-> expectedProperties count : " + (expectedPropertiesCount == -1 ? "none" : Integer.valueOf(expectedPropertiesCount)) + ")"), (toCheckProperties == null && expectedProperties == null || toCheckProperties.size() == expectedPropertiesCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedPropertiesCount; ++i) {
            String expectedPropertyItemAsString;
            String toCheckPropertyItemAsString = toCheckProperties != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)toCheckProperties.get(i))) : null;
            String string = expectedPropertyItemAsString = expectedProperties != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)expectedProperties.get(i))) : null;
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckProperties : " + toCheckProperties + "\n\t(nodeAsString = " + toCheckPropertyItemAsString + ")" + "\n[DEBUG] --> expectedProperties : " + expectedProperties + "\n\t(nodeAsString = " + expectedPropertyItemAsString + ")\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "Properties lists are different \n" + "\t(-> toCheckProperties formatted to comparison is : " + (toCheckProperties != null ? toCheckProperties : null) + "\n\t(nodesAsString = " + toCheckPropertyItemAsString + ")" + "\n\t-> expectedProperties formatted to comparison is : " + (expectedProperties != null ? expectedProperties : null) + ")" + "\n\t(nodesAsString = " + expectedPropertyItemAsString + ")\n"), (toCheckPropertyItemAsString == expectedPropertyItemAsString || expectedPropertyItemAsString != null && toCheckPropertyItemAsString != null && toCheckPropertyItemAsString.equals(expectedPropertyItemAsString) ? 1 : 0) != 0);
        }
        return true;
    }

    protected static boolean checkUpdateResourceProperties(UpdateResourceProperties expectedPayload, UpdateResourceProperties toCheckPayload, boolean isDebug) {
        UpdateType toCheckProperties = toCheckPayload.getUpdate();
        UpdateType expectedProperties = expectedPayload.getUpdate();
        return AbsWsrfrpTypesAndPayloadsUnitTests.checkUpdateType(expectedProperties, toCheckProperties, isDebug);
    }

    protected static boolean checkUpdateResourcePropertiesResponse(UpdateResourcePropertiesResponse expectedResponsePayload, UpdateResourcePropertiesResponse toCheckResponsePayload, boolean isDebug) {
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckResponsePayload : " + (toCheckResponsePayload != null ? toCheckResponsePayload.toString() : "null") + "\n[DEBUG] --> expectedResponsePayload : " + (expectedResponsePayload != null ? expectedResponsePayload.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseFaults\"") + "UpdateResourcePropertiesResponse are \n" + "\t(-> toCheckResponsePayload : " + (toCheckResponsePayload != null ? toCheckResponsePayload.toString() : "null") + "\n\t-> expectedResponsePayload : " + (expectedResponsePayload != null ? expectedResponsePayload.toString() : "null") + ")"), (toCheckResponsePayload != null && expectedResponsePayload != null ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkResourcePropertyValueChangeNotificationType(ResourcePropertyValueChangeNotificationType expectedNotif, ResourcePropertyValueChangeNotificationType toCheckNotif, boolean isDebug) {
        ResourcePropertyValueChangeNotificationType.NewValues expectedNewValues = expectedNotif.getNewValues();
        ResourcePropertyValueChangeNotificationType.NewValues toCheckNewValues = toCheckNotif.getNewValues();
        List toCheckNewValueList = toCheckNewValues.getValues();
        List expectedNewValueList = expectedNewValues.getValues();
        int expectedNewValuesListCount = expectedNewValueList != null ? expectedNewValueList.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "NewValues have different Element values\n" + "\t(-> toCheckNewValues count : " + (toCheckNewValueList != null ? Integer.valueOf(toCheckNewValueList.size()) : "none") + "\n\t-> expectedNewValues count : " + (expectedNewValuesListCount == -1 ? "none" : Integer.valueOf(expectedNewValuesListCount)) + ")"), (toCheckNewValueList != null && expectedNewValueList != null || toCheckNewValueList.size() == expectedNewValuesListCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedNewValuesListCount; ++i) {
            String expectedNewValueItemAsString;
            String toCheckNewValueItemAsString = toCheckNewValueList != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)toCheckNewValueList.get(i))) : null;
            String string = expectedNewValueItemAsString = expectedNewValueList != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)expectedNewValueList.get(i))) : null;
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckNewValue : " + toCheckNewValueList + "\n\t(nodeAsString = " + toCheckNewValueItemAsString + ")" + "\n[DEBUG] --> expectedNewValue : " + expectedNewValueList + "\n\t(nodeAsString = " + expectedNewValueItemAsString + ")\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "NewValues values are different \n" + "\t(-> toCheckNewValue item formatted to comparison is : " + (toCheckNewValueList != null ? toCheckNewValueList : null) + "\n\t(nodesAsString = " + toCheckNewValueItemAsString + ")" + "\n\t-> expectedNewValue item formatted to comparison is : " + (expectedNewValueList != null ? expectedNewValueList : null) + ")" + "\n\t(nodesAsString = " + expectedNewValueItemAsString + ")\n"), (toCheckNewValueItemAsString == expectedNewValueItemAsString || expectedNewValueItemAsString != null && toCheckNewValueItemAsString != null && toCheckNewValueItemAsString.equals(expectedNewValueItemAsString) ? 1 : 0) != 0);
        }
        ResourcePropertyValueChangeNotificationType.OldValues expectedOldValues = expectedNotif.getOldValues();
        ResourcePropertyValueChangeNotificationType.OldValues toCheckOldValues = toCheckNotif.getOldValues();
        List toCheckOldValueList = toCheckOldValues.getValues();
        List expectedOldValueList = expectedOldValues.getValues();
        int expectedOldValuesListCount = expectedOldValueList != null ? expectedOldValueList.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "NewValues have different Element values\n" + "\t(-> toCheckNewValues count : " + (toCheckOldValueList != null ? Integer.valueOf(toCheckOldValueList.size()) : "none") + "\n\t-> expectedNewValues count : " + (expectedOldValuesListCount == -1 ? "none" : Integer.valueOf(expectedOldValuesListCount)) + ")"), (toCheckOldValueList == null && expectedOldValueList == null || toCheckOldValueList.size() == expectedOldValuesListCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedOldValuesListCount; ++i) {
            String expectedOldValueItemAsString;
            String toCheckOldValueItemAsString = toCheckOldValueList != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)toCheckOldValueList.get(i))) : null;
            String string = expectedOldValueItemAsString = expectedOldValueList != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)expectedOldValueList.get(i))) : null;
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckOldValue : " + toCheckOldValueList + "\n\t(nodeAsString = " + toCheckOldValueItemAsString + ")" + "\n[DEBUG] --> expectedOldValue : " + expectedOldValueList + "\n\t(nodeAsString = " + expectedOldValueItemAsString + ")\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + "OldValues values are different \n" + "\t(-> toCheckOldValue item formatted to comparison is : " + (toCheckOldValueList != null ? toCheckOldValueList : null) + "\n\t(nodesAsString = " + toCheckOldValueItemAsString + ")" + "\n\t-> expectedOldValue item formatted to comparison is : " + (expectedOldValueList != null ? expectedOldValueList : null) + ")" + "\n\t(nodesAsString = " + expectedOldValueItemAsString + ")\n"), (toCheckOldValueItemAsString == expectedOldValueItemAsString || expectedOldValueItemAsString != null && toCheckOldValueItemAsString != null && toCheckOldValueItemAsString.equals(expectedOldValueItemAsString) ? 1 : 0) != 0);
        }
        return true;
    }

    @Test
    public final void testCreateWriteAsDOMReadGetResourceProperty() throws WsrfrpException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Write-to-DOM and read-from-DOM GetResourceProperty\" ~~~~~~~ \n");
        QName propertyName = new QName("http://docs.oasis-open.org/wsn/t-1", "TopicSet");
        Document payloadAsDOM = this.writer.writeGetResourcePropertyAsDOM(propertyName);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsrfrpUnitTestsUtils.WSRFRP_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceProperties\"", ((Object)((Object)this)).getClass(), (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + e.getMessage()));
        }
        QName readPropertyName = this.reader.readGetResourceProperty(payloadAsDOM);
        AbsWsrfrpTypesAndPayloadsUnitTests.checkGetResourceProperty(propertyName, readPropertyName, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Write-to-DOM and read-from-DOM GetResourceProperty\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadGetResourcePropertyResponse() throws WsrfrpException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM GetResourcePropertyResponse\" ~~~~~~~ \n");
        GetResourcePropertyResponse payload = this.factory.createGetResourcePropertyResponse();
        ArrayList<Element> propertyValues = new ArrayList<Element>();
        Element valAsElement = WsrfrpUnitTestsUtils.createTopicSetPropertyValue("/SupportedTopicsSet.xml");
        if (this.isDebug) {
            System.out.println("[DEBUG] propertyValues values : \n" + WsstarCommonUtils.prettyPrint((Document)valAsElement.getOwnerDocument()));
        }
        propertyValues.add(valAsElement);
        payload.setPropertyValue(propertyValues);
        Document payloadAsDOM = this.writer.writeGetResourcePropertyResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsrfrpUnitTestsUtils.WSRFRP_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceProperties\"", GetResourcePropertyResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + e.getMessage()));
        }
        GetResourcePropertyResponse readPayload = this.reader.readGetResourcePropertyResponse(payloadAsDOM);
        AbsWsrfrpTypesAndPayloadsUnitTests.checkGetResourcePropertyResponse(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM GetResourcePropertyResponse\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadUpdateResourceProperties() throws WsrfrpException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM UpdateResourceProperties\" ~~~~~~~ \n");
        List<Element> content = WsrfrpUnitTestsUtils.createDefaultProperties();
        UpdateType properties = this.factory.createUpdateType(content);
        UpdateResourceProperties payload = this.factory.createUpdateResourceProperties(properties);
        Document payloadAsDOM = this.writer.writeUpdateResourcePropertiesAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsrfrpUnitTestsUtils.WSRFRP_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceProperties\"", UpdateResourceProperties.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + e.getMessage()));
        }
        UpdateResourceProperties readPayload = this.reader.readUpdateResourceProperties(payloadAsDOM);
        AbsWsrfrpTypesAndPayloadsUnitTests.checkUpdateResourceProperties(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM UpdateResourceProperties\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadUpdateResourcePropertiesResponse() throws WsrfrpException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ Unit test \"Create, Write-to-DOM and read-from-DOM UpdateResourcePropertiesResponse\" ~~~~~~~ \n");
        UpdateResourcePropertiesResponse payload = this.factory.createUpdateResourcePropertiesResponse();
        Document payloadAsDOM = this.writer.writeUpdateResourcePropertiesResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsrfrpUnitTestsUtils.WSRFRP_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceProperties\"", UpdateResourcePropertiesResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + e.getMessage()));
        }
        UpdateResourcePropertiesResponse readPayload = this.reader.readUpdateResourcePropertiesResponse(payloadAsDOM);
        AbsWsrfrpTypesAndPayloadsUnitTests.checkUpdateResourcePropertiesResponse(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM UpdateResourcePropertiesResponse\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadResourcePropertyValueChangeNotificationType() throws WsrfrpException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ Unit test \"Create, Write-to-DOM and read-from-DOM ResourcePropertyValueChangeNotificationType\" ~~~~~~~ \n");
        Element newValAsElt = WsrfrpUnitTestsUtils.createTopicSetPropertyValue("/NewSupportedTopicsSet.xml");
        if (this.isDebug) {
            System.out.println("[DEBUG] NewValues values : \n" + WsstarCommonUtils.prettyPrint((Document)newValAsElt.getOwnerDocument()));
        }
        ResourcePropertyValueChangeNotificationType.NewValues newValues = this.factory.createResourcePropertyValueChangeNotificationTypeNewValues(newValAsElt);
        ResourcePropertyValueChangeNotificationType notifMsg = this.factory.createResourcePropertyValueChangeNotificationType(newValues);
        Element oldValuesAsElt = WsrfrpUnitTestsUtils.createTopicSetPropertyValue("/SupportedTopicsSet.xml");
        if (this.isDebug) {
            System.out.println("[DEBUG] OldValues values : \n" + WsstarCommonUtils.prettyPrint((Document)oldValuesAsElt.getOwnerDocument()));
        }
        ResourcePropertyValueChangeNotificationType.OldValues oldValues = this.factory.createResourcePropertyValueChangeNotificationTypeOldValues((Element)oldValuesAsElt.cloneNode(true));
        notifMsg.setOldValues(oldValues);
        Document notifMsgAsDOM = this.writer.writeResourcePropertyValueChangeNotificationTypeAsDOM(notifMsg);
        if (this.isDebug) {
            System.out.println("[DEBUG] notifMessage as DOM values : \n" + WsstarCommonUtils.prettyPrint((Document)notifMsgAsDOM));
        }
        try {
            WsaUnitTestsUtils.validateResult((Document)notifMsgAsDOM, (String[])WsrfrpUnitTestsUtils.WSRFRP_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceProperties\"", ResourcePropertyValueChangeNotificationType.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceProperties\"") + e.getMessage()));
        }
        ResourcePropertyValueChangeNotificationType readNotifMsg = this.reader.readResourcePropertyValueChangeNotificationType(notifMsgAsDOM);
        AbsWsrfrpTypesAndPayloadsUnitTests.checkResourcePropertyValueChangeNotificationType(notifMsg, readNotifMsg, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM ResourcePropertyValueChangeNotificationType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }
}

