/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.test;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.refinedabstraction.RefinedWsaFactory;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.test.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.ResourcePropertyChangeFailureType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WsrfrpUnitTestsUtils {
    public static final String WSRFBF_SPECIFICATION_NAME = "OASIS \"WS-BaseFaults\"";
    public static final String WSRFBF_XML_SCHEMA_PATH = "/schemas/bf-2.xsd";
    public static final String WSRFRP_SPECIFICATION_NAME = "OASIS \"WS-ResourceProperties\"";
    public static final String WSRFRP_XML_SCHEMA_PATH = "/schemas/rp-2.xsd";
    public static final String XML_XML_SCHEMA_PATH = "/schemas/xml.xsd";
    public static final String WSTOP_XML_SCHEMA_PATH = "/t-1.xsd";
    public static final String WSNB_XML_SCHEMA_PATH = "/b-2.xsd";
    public static final String[] WSRFRP_XML_SCHEMAS_PATHS = new String[]{"/schema/ws-addr.xsd", "/schemas/xml.xsd", "/schemas/bf-2.xsd", "/schemas/rp-2.xsd", "/t-1.xsd", "/b-2.xsd"};

    public static Element createDefaultFaultCauseContent(String faultCausePath) {
        Document faultCauseContentAsDocument = WsaUnitTestsUtils.fromStreamToDocument((InputStream)WsrfrpUnitTestsUtils.class.getResourceAsStream(faultCausePath));
        return faultCauseContentAsDocument.getDocumentElement();
    }

    public static EndpointReferenceType createDefaultBaseFaultOriginator() throws URISyntaxException, WsaException {
        EndpointReferenceType defaultMinimalEdp = null;
        URI address = new URI("http://myURL/for/test::MyServiceName@myEndpointAddress");
        defaultMinimalEdp = RefinedWsaFactory.getInstance().createEndpointReferenceType(address);
        return defaultMinimalEdp;
    }

    public static Element createTopicSetPropertyValue(String topicSetPath) {
        Element supportedTopicsSetAsElt = null;
        InputStream supportedtopicsSet = WsrfrpUnitTestsUtils.class.getResourceAsStream(topicSetPath);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document parsedXmlDoc = builder.parse(supportedtopicsSet);
            supportedTopicsSetAsElt = parsedXmlDoc.getDocumentElement();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return supportedTopicsSetAsElt;
    }

    public static List<Element> createDefaultProperties() {
        ArrayList<Element> propertiesAsElts = new ArrayList<Element>();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element currentElt = doc.createElementNS("http://docs.oasis-open.org/wsn/b-2", "FixedTopicSet");
            currentElt.setPrefix("wsn-b");
            currentElt.setTextContent("false");
            propertiesAsElts.add(currentElt);
            currentElt = doc.createElementNS("http://docs.oasis-open.org/wsn/b-2", "TopicExpressionDialect");
            currentElt.setPrefix("wsn-b");
            currentElt.setTextContent("http://www.w3.org/TR/1999/REC-xpath-19991116");
            propertiesAsElts.add(currentElt);
            propertiesAsElts.add(WsrfrpUnitTestsUtils.createTopicSetPropertyValue("/SupportedTopicsSet.xml"));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return propertiesAsElts;
    }

    public static ResourcePropertyChangeFailureType.CurrentValue createCurrentValues() throws WsrfrpException {
        ArrayList<Element> values = new ArrayList<Element>();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element currentElt = doc.createElementNS("http://docs.oasis-open.org/wsn/b-2", "FixedTopicSet");
            currentElt.setPrefix("wsn-b");
            currentElt.setTextContent("true");
            values.add(currentElt);
            values.add(WsrfrpUnitTestsUtils.createTopicSetPropertyValue("/SupportedTopicsSet.xml"));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return RefinedWsrfrpFactory.getInstance().createResourcePropertyChangeFailureTypeCurrentValue(values);
    }

    public static ResourcePropertyChangeFailureType.RequestedValue createRequestedValues() throws WsrfrpException {
        ArrayList<Element> values = new ArrayList<Element>();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element currentElt = doc.createElementNS("http://docs.oasis-open.org/wsn/b-2", "FixedTopicSet");
            currentElt.setPrefix("wsn-b");
            currentElt.setTextContent("true");
            values.add(currentElt);
            values.add(WsrfrpUnitTestsUtils.createTopicSetPropertyValue("/NewSupportedTopicsSet.xml"));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return RefinedWsrfrpFactory.getInstance().createResourcePropertyChangeFailureTypeRequestedValue(values);
    }
}

