/*
 * Decompiled with CFR 0.152.
 */
package com.trg.search.hibernate;

import com.trg.search.BaseSearchProcessor;
import com.trg.search.Field;
import com.trg.search.ISearch;
import com.trg.search.InternalUtil;
import com.trg.search.SearchResult;
import com.trg.search.SearchUtil;
import com.trg.search.hibernate.HibernateMetadataUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSearchProcessor
extends BaseSearchProcessor {
    private static Logger logger = LoggerFactory.getLogger(HibernateSearchProcessor.class);
    private static Map<SessionFactory, HibernateSearchProcessor> map = new HashMap<SessionFactory, HibernateSearchProcessor>();
    private static final ResultTransformer ARRAY_RESULT_TRANSFORMER = new ResultTransformer(){
        private static final long serialVersionUID = 1L;

        public List transformList(List collection) {
            return collection;
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            return tuple;
        }
    };

    public static HibernateSearchProcessor getInstanceForSessionFactory(SessionFactory sessionFactory) {
        HibernateSearchProcessor instance = map.get(sessionFactory);
        if (instance == null) {
            instance = new HibernateSearchProcessor(HibernateMetadataUtil.getInstanceForSessionFactory(sessionFactory));
            map.put(sessionFactory, instance);
        }
        return instance;
    }

    private HibernateSearchProcessor(HibernateMetadataUtil mdu) {
        super(QLTYPE_HQL, mdu);
    }

    public List search(Session session, ISearch search) {
        if (search == null) {
            return null;
        }
        return this.search(session, search.getSearchClass(), search);
    }

    public List search(Session session, Class<?> searchClass, ISearch search) {
        if (searchClass == null || search == null) {
            return null;
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String hql = this.generateQL(searchClass, search, paramList);
        Query query = session.createQuery(hql);
        this.addParams(query, paramList);
        this.addPaging(query, search);
        this.addResultMode(query, search);
        return query.list();
    }

    public int count(Session session, ISearch search) {
        if (search == null) {
            return 0;
        }
        return this.count(session, search.getSearchClass(), search);
    }

    public int count(Session session, Class<?> searchClass, ISearch search) {
        if (searchClass == null || search == null) {
            return 0;
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String hql = this.generateRowCountQL(searchClass, search, paramList);
        if (hql == null) {
            return 1;
        }
        Query query = session.createQuery(hql);
        this.addParams(query, paramList);
        return ((Number)query.uniqueResult()).intValue();
    }

    public SearchResult searchAndCount(Session session, ISearch search) {
        if (search == null) {
            return null;
        }
        return this.searchAndCount(session, search.getSearchClass(), search);
    }

    public SearchResult searchAndCount(Session session, Class<?> searchClass, ISearch search) {
        if (searchClass == null || search == null) {
            return null;
        }
        SearchResult result = new SearchResult();
        result.setResult(this.search(session, searchClass, search));
        if (search.getMaxResults() > 0) {
            result.setTotalCount(this.count(session, searchClass, search));
        } else {
            result.setTotalCount(result.getResult().size() + SearchUtil.calcFirstResult(search));
        }
        return result;
    }

    public Object searchUnique(Session session, ISearch search) throws NonUniqueResultException {
        if (search == null) {
            return null;
        }
        return this.searchUnique(session, search.getSearchClass(), search);
    }

    public Object searchUnique(Session session, Class<?> entityClass, ISearch search) throws NonUniqueResultException {
        if (search == null) {
            return null;
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String hql = this.generateQL(entityClass, search, paramList);
        Query query = session.createQuery(hql);
        this.addParams(query, paramList);
        this.addResultMode(query, search);
        return query.uniqueResult();
    }

    private void addParams(Query query, List<Object> params) {
        StringBuilder debug = null;
        int i = 1;
        for (Object o : params) {
            if (logger.isDebugEnabled()) {
                if (debug == null) {
                    debug = new StringBuilder();
                } else {
                    debug.append("\n\t");
                }
                debug.append("p");
                debug.append(i);
                debug.append(": ");
                debug.append(InternalUtil.paramDisplayString(o));
            }
            if (o instanceof Collection) {
                query.setParameterList("p" + Integer.toString(i++), (Collection)o);
                continue;
            }
            if (o instanceof Object[]) {
                query.setParameterList("p" + Integer.toString(i++), (Object[])o);
                continue;
            }
            query.setParameter("p" + Integer.toString(i++), o);
        }
        if (debug != null && debug.length() != 0) {
            logger.debug(debug.toString());
        }
    }

    private void addPaging(Query query, ISearch search) {
        int firstResult = SearchUtil.calcFirstResult(search);
        if (firstResult > 0) {
            query.setFirstResult(firstResult);
        }
        if (search.getMaxResults() > 0) {
            query.setMaxResults(search.getMaxResults());
        }
    }

    private void addResultMode(Query query, ISearch search) {
        int resultMode = search.getResultMode();
        if (resultMode == 0) {
            int count = 0;
            for (Field field : search.getFields()) {
                if (field.getKey() != null && !field.getKey().equals("")) {
                    resultMode = 3;
                    break;
                }
                ++count;
            }
            if (resultMode == 0) {
                resultMode = count > 1 ? 1 : 4;
            }
        }
        switch (resultMode) {
            case 1: {
                query.setResultTransformer(ARRAY_RESULT_TRANSFORMER);
                break;
            }
            case 2: {
                query.setResultTransformer((ResultTransformer)Transformers.TO_LIST);
                break;
            }
            case 3: {
                ArrayList<String> keyList = new ArrayList<String>();
                for (Field field : search.getFields()) {
                    if (field.getKey() != null && !field.getKey().equals("")) {
                        keyList.add(field.getKey());
                        continue;
                    }
                    keyList.add(field.getProperty());
                }
                query.setResultTransformer((ResultTransformer)new MapResultTransformer(keyList.toArray(new String[0])));
                break;
            }
        }
    }

    private static class MapResultTransformer
    implements ResultTransformer {
        private static final long serialVersionUID = 1L;
        private String[] keys;

        public MapResultTransformer(String[] keys) {
            this.keys = keys;
        }

        public List transformList(List collection) {
            return collection;
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < this.keys.length; ++i) {
                String key = this.keys[i];
                if (key == null) continue;
                map.put(key, tuple[i]);
            }
            return map;
        }
    }
}

