/*
 * Decompiled with CFR 0.152.
 */
package com.trg.search;

import com.trg.search.Field;
import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.SearchUtil;
import com.trg.search.Sort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Search
implements IMutableSearch,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int firstResult = -1;
    protected int maxResults = -1;
    protected int page = -1;
    protected Class<?> searchClass;
    protected List<Filter> filters = new ArrayList<Filter>();
    protected boolean disjunction;
    protected List<Sort> sorts = new ArrayList<Sort>();
    protected List<Field> fields = new ArrayList<Field>();
    protected boolean distinct;
    protected List<String> fetches = new ArrayList<String>();
    protected int resultMode = 0;

    public Search() {
    }

    public Search(Class<?> searchClass) {
        this.searchClass = searchClass;
    }

    @Override
    public Search setSearchClass(Class<?> searchClass) {
        this.searchClass = searchClass;
        return this;
    }

    @Override
    public Class<?> getSearchClass() {
        return this.searchClass;
    }

    public Search addFilter(Filter filter) {
        SearchUtil.addFilter(this, filter);
        return this;
    }

    public Search addFilters(Filter ... filters) {
        SearchUtil.addFilters(this, filters);
        return this;
    }

    public Search addFilterEqual(String property, Object value) {
        SearchUtil.addFilterEqual(this, property, value);
        return this;
    }

    public Search addFilterGreaterOrEqual(String property, Object value) {
        SearchUtil.addFilterGreaterOrEqual(this, property, value);
        return this;
    }

    public Search addFilterGreaterThan(String property, Object value) {
        SearchUtil.addFilterGreaterThan(this, property, value);
        return this;
    }

    public Search addFilterIn(String property, Collection<?> value) {
        SearchUtil.addFilterIn((IMutableSearch)this, property, value);
        return this;
    }

    public Search addFilterIn(String property, Object ... value) {
        SearchUtil.addFilterIn((IMutableSearch)this, property, value);
        return this;
    }

    public Search addFilterNotIn(String property, Collection<?> value) {
        SearchUtil.addFilterNotIn((IMutableSearch)this, property, value);
        return this;
    }

    public Search addFilterNotIn(String property, Object ... value) {
        SearchUtil.addFilterNotIn((IMutableSearch)this, property, value);
        return this;
    }

    public Search addFilterLessOrEqual(String property, Object value) {
        SearchUtil.addFilterLessOrEqual(this, property, value);
        return this;
    }

    public Search addFilterLessThan(String property, Object value) {
        SearchUtil.addFilterLessThan(this, property, value);
        return this;
    }

    public Search addFilterLike(String property, String value) {
        SearchUtil.addFilterLike(this, property, value);
        return this;
    }

    public Search addFilterILike(String property, String value) {
        SearchUtil.addFilterILike(this, property, value);
        return this;
    }

    public Search addFilterNotEqual(String property, Object value) {
        SearchUtil.addFilterNotEqual(this, property, value);
        return this;
    }

    public Search addFilterNull(String property) {
        SearchUtil.addFilterNull(this, property);
        return this;
    }

    public Search addFilterNotNull(String property) {
        SearchUtil.addFilterNotNull(this, property);
        return this;
    }

    public Search addFilterEmpty(String property) {
        SearchUtil.addFilterEmpty(this, property);
        return this;
    }

    public Search addFilterNotEmpty(String property) {
        SearchUtil.addFilterNotEmpty(this, property);
        return this;
    }

    public Search addFilterAnd(Filter ... filters) {
        SearchUtil.addFilterAnd(this, filters);
        return this;
    }

    public Search addFilterOr(Filter ... filters) {
        SearchUtil.addFilterOr(this, filters);
        return this;
    }

    public Search addFilterNot(Filter filter) {
        SearchUtil.addFilterNot(this, filter);
        return this;
    }

    public Search addFilterSome(String property, Filter filter) {
        SearchUtil.addFilterSome(this, property, filter);
        return this;
    }

    public Search addFilterAll(String property, Filter filter) {
        SearchUtil.addFilterAll(this, property, filter);
        return this;
    }

    public Search addFilterNone(String property, Filter filter) {
        SearchUtil.addFilterNone(this, property, filter);
        return this;
    }

    public void removeFilter(Filter filter) {
        SearchUtil.removeFilter(this, filter);
    }

    public void removeFiltersOnProperty(String property) {
        SearchUtil.removeFiltersOnProperty(this, property);
    }

    public void clearFilters() {
        SearchUtil.clearFilters(this);
    }

    @Override
    public boolean isDisjunction() {
        return this.disjunction;
    }

    @Override
    public Search setDisjunction(boolean disjunction) {
        this.disjunction = disjunction;
        return this;
    }

    public Search addSort(Sort sort) {
        SearchUtil.addSort(this, sort);
        return this;
    }

    public Search addSorts(Sort ... sorts) {
        SearchUtil.addSorts(this, sorts);
        return this;
    }

    public Search addSortAsc(String property) {
        SearchUtil.addSortAsc(this, property);
        return this;
    }

    public Search addSortAsc(String property, boolean ignoreCase) {
        SearchUtil.addSortAsc(this, property, ignoreCase);
        return this;
    }

    public Search addSortDesc(String property) {
        SearchUtil.addSortDesc(this, property);
        return this;
    }

    public Search addSortDesc(String property, boolean ignoreCase) {
        SearchUtil.addSortDesc(this, property, ignoreCase);
        return this;
    }

    public Search addSort(String property, boolean desc) {
        SearchUtil.addSort(this, property, desc);
        return this;
    }

    public Search addSort(String property, boolean desc, boolean ignoreCase) {
        SearchUtil.addSort(this, property, desc, ignoreCase);
        return this;
    }

    public void removeSort(Sort sort) {
        SearchUtil.removeSort((IMutableSearch)this, sort);
    }

    public void removeSort(String property) {
        SearchUtil.removeSort((IMutableSearch)this, property);
    }

    public void clearSorts() {
        SearchUtil.clearSorts(this);
    }

    public Search addField(Field field) {
        SearchUtil.addField((IMutableSearch)this, field);
        return this;
    }

    public Search addFields(Field ... fields) {
        SearchUtil.addFields(this, fields);
        return this;
    }

    public Search addField(String property) {
        SearchUtil.addField((IMutableSearch)this, property);
        return this;
    }

    public Search addField(String property, String key) {
        SearchUtil.addField((IMutableSearch)this, property, key);
        return this;
    }

    public Search addField(String property, int operator) {
        SearchUtil.addField((IMutableSearch)this, property, operator);
        return this;
    }

    public Search addField(String property, int operator, String key) {
        SearchUtil.addField(this, property, operator, key);
        return this;
    }

    public void removeField(Field field) {
        SearchUtil.removeField((IMutableSearch)this, field);
    }

    public void removeField(String property) {
        SearchUtil.removeField((IMutableSearch)this, property);
    }

    public void removeField(String property, String key) {
        SearchUtil.removeField(this, property, key);
    }

    public void clearFields() {
        SearchUtil.clearFields(this);
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public IMutableSearch setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    public int getResultMode() {
        return this.resultMode;
    }

    @Override
    public Search setResultMode(int resultMode) {
        if (resultMode < 0 || resultMode > 4) {
            throw new IllegalArgumentException("Result Mode ( " + resultMode + " ) is not a valid option.");
        }
        this.resultMode = resultMode;
        return this;
    }

    public Search addFetch(String property) {
        SearchUtil.addFetch(this, property);
        return this;
    }

    public Search addFetches(String ... properties) {
        SearchUtil.addFetches(this, properties);
        return this;
    }

    public void removeFetch(String property) {
        SearchUtil.removeFetch(this, property);
    }

    public void clearFetches() {
        SearchUtil.clearFetches(this);
    }

    public void clear() {
        SearchUtil.clear(this);
    }

    @Override
    public int getFirstResult() {
        return this.firstResult;
    }

    @Override
    public Search setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public Search setPage(int page) {
        this.page = page;
        return this;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public Search setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public void clearPaging() {
        SearchUtil.clearPaging(this);
    }

    public Search copy() {
        Search dest = new Search();
        SearchUtil.copy(this, dest);
        return dest;
    }

    public boolean equals(Object obj) {
        return SearchUtil.equals(this, obj);
    }

    public int hashCode() {
        return SearchUtil.hashCode(this);
    }

    public String toString() {
        return SearchUtil.toString(this);
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public Search setFilters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    @Override
    public List<Sort> getSorts() {
        return this.sorts;
    }

    @Override
    public Search setSorts(List<Sort> sorts) {
        this.sorts = sorts;
        return this;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public Search setFields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    @Override
    public List<String> getFetches() {
        return this.fetches;
    }

    @Override
    public Search setFetches(List<String> fetches) {
        this.fetches = fetches;
        return this;
    }
}

