/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import uk.ac.manchester.cs.jfact.CachedOWLReasoner;
import uk.ac.manchester.cs.jfact.JFactReasoner;

public final class CachedJFactFactory
implements OWLReasonerFactory {
    public String getReasonerName() {
        return "CachedJFact";
    }

    public OWLReasoner createReasoner(OWLOntology ontology) {
        JFactReasoner toReturn = new JFactReasoner(ontology, (OWLReasonerConfiguration)new SimpleConfiguration(), BufferingMode.BUFFERING);
        return this.verify(toReturn);
    }

    private OWLReasoner verify(JFactReasoner toReturn) {
        OWLOntologyManager m = toReturn.getRootOntology().getOWLOntologyManager();
        m.addOntologyChangeListener((OWLOntologyChangeListener)toReturn);
        return new CachedOWLReasoner(toReturn, m);
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology ontology) {
        JFactReasoner toReturn = new JFactReasoner(ontology, (OWLReasonerConfiguration)new SimpleConfiguration(), BufferingMode.NON_BUFFERING);
        return this.verify(toReturn);
    }

    public OWLReasoner createReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        JFactReasoner toReturn = new JFactReasoner(ontology, config, BufferingMode.BUFFERING);
        return this.verify(toReturn);
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        JFactReasoner toReturn = new JFactReasoner(ontology, config, BufferingMode.NON_BUFFERING);
        return this.verify(toReturn);
    }
}

