/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.configurables.Computable;
import org.semanticweb.owlapi.apibinding.configurables.ComputableAllThrowables;
import org.semanticweb.owlapi.apibinding.configurables.MemoizingCache;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.util.Version;

public final class CachedOWLReasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    protected final OWLReasoner delegate;
    private final CachedReasoner cache = new CachedReasoner();
    private final OWLOntology rootOntology;

    public CachedOWLReasoner(OWLReasoner reasoner, OWLOntologyManager manager) {
        if (reasoner == null) {
            throw new IllegalArgumentException("The input reasoner cannot be null");
        }
        this.delegate = reasoner;
        manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        this.rootOntology = this.delegate.getRootOntology();
    }

    public String getReasonerName() {
        return this.delegate.getReasonerName();
    }

    public Version getReasonerVersion() {
        return this.delegate.getReasonerVersion();
    }

    public BufferingMode getBufferingMode() {
        return this.delegate.getBufferingMode();
    }

    public void flush() {
        this.cache.clear();
        this.delegate.flush();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this.delegate.getPendingChanges();
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return this.delegate.getPendingAxiomAdditions();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return this.delegate.getPendingAxiomRemovals();
    }

    public OWLOntology getRootOntology() {
        return this.rootOntology;
    }

    public void interrupt() {
        this.cache.clear();
        this.delegate.interrupt();
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        this.cache.clear();
        this.delegate.precomputeInferences(inferenceTypes);
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        return this.delegate.isPrecomputed(inferenceType);
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return this.delegate.getPrecomputableInferenceTypes();
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        return this.delegate.isConsistent();
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        Entailer entailer = new Entailer(classExpression);
        Boolean b = (Boolean)this.cache.get(CacheKeys.issatisfiable, classExpression, (Computable<Object>)entailer);
        if (entailer.hasThrownException()) {
            Throwable e = entailer.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof AxiomNotInProfileException) {
                throw (AxiomNotInProfileException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return b;
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        return this.delegate.getUnsatisfiableClasses();
    }

    public boolean isEntailed(final OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        ComputableAllThrowables<Object> entailer = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.isEntailed(axiom);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        Boolean b = (Boolean)this.cache.get(CacheKeys.isEntailed, axiom, (Computable<Object>)entailer);
        if (entailer.hasThrownException()) {
            Throwable e = entailer.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof UnsupportedEntailmentTypeException) {
                throw (UnsupportedEntailmentTypeException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof AxiomNotInProfileException) {
                throw (AxiomNotInProfileException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return b;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return this.delegate.isEntailmentCheckingSupported(axiomType);
    }

    public Node<OWLClass> getTopClassNode() {
        return this.delegate.getTopClassNode();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.delegate.getBottomClassNode();
    }

    public NodeSet<OWLClass> getSubClasses(final OWLClassExpression ce, final boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        CacheKeys key = direct ? CacheKeys.subclassesDirect : CacheKeys.subclasses;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getSubClasses(ce, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(ce, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof UnsupportedEntailmentTypeException) {
                throw (UnsupportedEntailmentTypeException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof AxiomNotInProfileException) {
                throw (AxiomNotInProfileException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLClass> getSuperClasses(final OWLClassExpression ce, final boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.superclassesDirect : CacheKeys.superclasses;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getSuperClasses(ce, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(ce, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof AxiomNotInProfileException) {
                throw (AxiomNotInProfileException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failure asking for superclasses of " + ce + " " + direct, e);
        }
        return toReturn;
    }

    public Node<OWLClass> getEquivalentClasses(final OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.equivclasses;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getEquivalentClasses(ce);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        Node toReturn = (Node)this.cache.get(key, ce, (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLClass> getDisjointClasses(final OWLClassExpression ce) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        CacheKeys key = CacheKeys.disjointclasses;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getDisjointClasses(ce);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, ce, (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.delegate.getTopObjectPropertyNode();
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.delegate.getBottomObjectPropertyNode();
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(final OWLObjectPropertyExpression pe, final boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.subobjectpropertiesDirect : CacheKeys.subobjectproperties;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getSubObjectProperties(pe, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(pe, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(final OWLObjectPropertyExpression pe, final boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.superobjectpropertiesDirect : CacheKeys.superobjectproperties;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getSuperObjectProperties(pe, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(pe, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(final OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.equivobjectproperties;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getEquivalentObjectProperties(pe);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        Node toReturn = (Node)this.cache.get(key, pe, (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(final OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.disjointobjectproperties;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getDisjointObjectProperties(pe);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, pe, (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(final OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.inverseobjectproperties;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getInverseObjectProperties(pe);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        Node toReturn = (Node)this.cache.get(key, pe, (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(final OWLObjectPropertyExpression pe, final boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.objectpropertiesdomainsDirect : CacheKeys.objectpropertiesdomains;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getObjectPropertyDomains(pe, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(pe, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(final OWLObjectPropertyExpression pe, final boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.objectpropertiesrangesDirect : CacheKeys.objectpropertiesranges;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getObjectPropertyRanges(pe, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(pe, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.delegate.getTopDataPropertyNode();
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.delegate.getBottomDataPropertyNode();
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(final OWLDataProperty pe, final boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.subdatapropertiesDirect : CacheKeys.subdataproperties;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getSubDataProperties(pe, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(pe, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(final OWLDataProperty pe, final boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.superdatapropertiesDirect : CacheKeys.superdataproperties;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getSuperDataProperties(pe, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(pe, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(final OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.equivdataproperties;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getEquivalentDataProperties(pe);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        Node toReturn = (Node)this.cache.get(key, pe, (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(final OWLDataPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.disjointdataproperties;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getDisjointDataProperties(pe);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, pe, (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(final OWLDataProperty pe, final boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.datapropertiesdomainsDirect : CacheKeys.datapropertiesdomains;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getDataPropertyDomains(pe, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(pe, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLClass> getTypes(final OWLNamedIndividual ind, final boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.typesDirect : CacheKeys.types;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getTypes(ind, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(ind, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLNamedIndividual> getInstances(final OWLClassExpression ce, final boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = direct ? CacheKeys.instancesDirect : CacheKeys.instances;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getInstances(ce, direct);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, CachedReasoner.makeKey(ce, direct), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(final OWLNamedIndividual ind, final OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.objectpropertiesvalues;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getObjectPropertyValues(ind, pe);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, new RegKey(ind, pe), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public Set<OWLLiteral> getDataPropertyValues(final OWLNamedIndividual ind, final OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.datapropertiesvalues;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getDataPropertyValues(ind, pe);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        Set toReturn = (Set)this.cache.get(key, new RegKey(ind, pe), (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(final OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.sameindividual;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getSameIndividuals(ind);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        Node toReturn = (Node)this.cache.get(key, ind, (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(final OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        CacheKeys key = CacheKeys.diffindividual;
        ComputableAllThrowables<Object> checker = new ComputableAllThrowables<Object>(){

            public Object compute() {
                try {
                    return CachedOWLReasoner.this.delegate.getDifferentIndividuals(ind);
                }
                catch (Throwable e) {
                    this.exception = e;
                    return null;
                }
            }
        };
        NodeSet toReturn = (NodeSet)this.cache.get(key, ind, (Computable<Object>)checker);
        if (checker.hasThrownException()) {
            Throwable e = checker.thrownException();
            if (e instanceof ReasonerInterruptedException) {
                throw (ReasonerInterruptedException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof TimeOutException) {
                throw (TimeOutException)e;
            }
            if (e instanceof FreshEntitiesException) {
                throw (FreshEntitiesException)e;
            }
            if (e instanceof InconsistentOntologyException) {
                throw (InconsistentOntologyException)e;
            }
            if (e instanceof ClassExpressionNotInProfileException) {
                throw (ClassExpressionNotInProfileException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    public long getTimeOut() {
        return this.delegate.getTimeOut();
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.delegate.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.delegate.getIndividualNodeSetPolicy();
    }

    public void dispose() {
        this.cache.clear();
        this.delegate.dispose();
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        this.cache.clear();
    }

    private static enum CacheKeys {
        isEntailed,
        subclasses,
        subclassesDirect,
        superclassesDirect,
        superclasses,
        equivclasses,
        disjointclasses,
        subobjectpropertiesDirect,
        subobjectproperties,
        superobjectpropertiesDirect,
        superobjectproperties,
        equivobjectproperties,
        disjointobjectproperties,
        inverseobjectproperties,
        objectpropertiesdomainsDirect,
        objectpropertiesdomains,
        objectpropertiesranges,
        objectpropertiesrangesDirect,
        diffindividual,
        datapropertiesdomains,
        datapropertiesdomainsDirect,
        datapropertiesvalues,
        disjointdataproperties,
        equivdataproperties,
        instances,
        instancesDirect,
        objectpropertiesvalues,
        sameindividual,
        subdataproperties,
        subdatapropertiesDirect,
        superdataproperties,
        superdatapropertiesDirect,
        types,
        typesDirect,
        issatisfiable;

    }

    private static final class CachedReasoner {
        MemoizingCache<CacheKeys, MemoizingCache<Object, Object>> mainCache = new MemoizingCache();

        public static final Object makeKey(Object o1, boolean o2) {
            return new BoolKey(o1, o2);
        }

        public void clear() {
            this.mainCache.clear();
        }

        public <T> T get(CacheKeys cachekey, Object key, Computable<Object> c) {
            ComputableAllThrowables<MemoizingCache<Object, Object>> cacheinit = new ComputableAllThrowables<MemoizingCache<Object, Object>>(){

                public MemoizingCache<Object, Object> compute() {
                    try {
                        return new MemoizingCache();
                    }
                    catch (Throwable e) {
                        this.exception = e;
                        return null;
                    }
                }
            };
            Object t = ((MemoizingCache)this.mainCache.get((Computable)cacheinit, (Object)cachekey)).get(c, key);
            if (cacheinit.hasThrownException()) {
                if (cacheinit.thrownException() instanceof Error) {
                    throw (Error)cacheinit.thrownException();
                }
                throw (RuntimeException)cacheinit.thrownException();
            }
            return (T)t;
        }
    }

    private static final class RegKey {
        final Object o1;
        final Object o2;

        public RegKey(Object o1, Object o2) {
            this.o1 = o1;
            this.o2 = o2;
        }

        public int hashCode() {
            return this.o1.hashCode() * this.o2.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof RegKey && this.o1.equals(((RegKey)obj).o1) && this.o2.equals(((RegKey)obj).o2);
        }
    }

    private static final class BoolKey {
        final Object o;
        final boolean b;

        public BoolKey(Object o, boolean b) {
            this.o = o;
            this.b = b;
        }

        public int hashCode() {
            return this.o.hashCode() * (this.b ? 1 : -1);
        }

        public boolean equals(Object obj) {
            return obj instanceof BoolKey && this.b == ((BoolKey)obj).b && this.o.equals(((BoolKey)obj).o);
        }
    }

    private final class Entailer
    extends ComputableAllThrowables<Object> {
        private final OWLClassExpression classExpression;

        public Entailer(OWLClassExpression classExpression) {
            this.classExpression = classExpression;
        }

        public Object compute() {
            try {
                return CachedOWLReasoner.this.delegate.isSatisfiable(this.classExpression);
            }
            catch (Throwable e) {
                this.exception = e;
                return null;
            }
        }
    }
}

