/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.ReasonerFreshEntityException;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.actors.ClassPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.DataPropertyPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.IndividualPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.ObjectPropertyPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.TaxonomyActor;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;

public final class JFactReasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    private static final String REASONER_NAME = "JFact";
    private static final Version VERSION = new Version(0, 0, 0, 0);
    protected final AtomicBoolean interrupted = new AtomicBoolean(false);
    ReasoningKernel kernel;
    private final ExpressionManager em;
    private static final EnumSet<InferenceType> supportedInferenceTypes = EnumSet.of(InferenceType.CLASS_ASSERTIONS, InferenceType.CLASS_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.SAME_INDIVIDUAL);
    private final OWLOntologyManager manager;
    private final OWLOntology rootOntology;
    private final BufferingMode bufferingMode;
    private final List<OWLOntologyChange> rawChanges = new ArrayList<OWLOntologyChange>();
    private final List<OWLAxiom> reasonerAxioms = new ArrayList<OWLAxiom>();
    private final long timeOut;
    private final OWLReasonerConfiguration configuration;
    private final OWLDataFactory df;
    private TranslationMachinery translationMachinery;
    private Boolean consistencyVerified = null;
    private final Set<OWLEntity> knownEntities = new HashSet<OWLEntity>();

    public JFactReasoner(OWLOntology rootOntology, OWLReasonerConfiguration configuration, BufferingMode bufferingMode) {
        this.rootOntology = rootOntology;
        this.df = this.rootOntology.getOWLOntologyManager().getOWLDataFactory();
        this.kernel = new ReasoningKernel(configuration.getTimeOut());
        this.em = this.kernel.getExpressionManager();
        this.bufferingMode = bufferingMode;
        this.configuration = configuration;
        this.timeOut = configuration.getTimeOut();
        this.manager = rootOntology.getOWLOntologyManager();
        this.knownEntities.add((OWLEntity)this.df.getOWLThing());
        this.knownEntities.add((OWLEntity)this.df.getOWLNothing());
        for (OWLOntology ont : rootOntology.getImportsClosure()) {
            OWLAxiom axiom;
            for (OWLLogicalAxiom ax : ont.getLogicalAxioms()) {
                axiom = ax.getAxiomWithoutAnnotations();
                this.reasonerAxioms.add(axiom);
                this.knownEntities.addAll(axiom.getSignature());
            }
            for (OWLLogicalAxiom ax : ont.getAxioms(AxiomType.DECLARATION)) {
                axiom = ax.getAxiomWithoutAnnotations();
                this.reasonerAxioms.add(axiom);
                this.knownEntities.addAll(axiom.getSignature());
            }
        }
        this.kernel.setTopBottomRoleNames("http://www.w3.org/2002/07/owl#topObjectProperty", "http://www.w3.org/2002/07/owl#bottomObjectProperty", "http://www.w3.org/2002/07/owl#topDataProperty", "http://www.w3.org/2002/07/owl#bottomDataProperty");
        this.kernel.setProgressMonitor(configuration.getProgressMonitor());
        this.kernel.setInterruptedSwitch(this.interrupted);
        configuration.getProgressMonitor().reasonerTaskStarted("Loading");
        configuration.getProgressMonitor().reasonerTaskBusy();
        this.kernel.clearKB();
        this.translationMachinery = new TranslationMachinery(this.kernel, this.df);
        this.translationMachinery.loadAxioms(this.reasonerAxioms);
        configuration.getProgressMonitor().reasonerTaskStopped();
    }

    public synchronized Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, ReasonerInterruptedException, TimeOutException {
        Collection<Object> pointers;
        if (this.isFreshName(ce)) {
            pointers = Collections.emptyList();
        } else {
            this.checkConsistency();
            TaxonomyActor actor = new TaxonomyActor(this.em, new ClassPolicy());
            this.kernel.getEquivalentConcepts(this.translationMachinery.toClassPointer(ce), actor);
            pointers = actor.getClassSynonyms();
        }
        return this.translationMachinery.getClassExpressionTranslator().getNodeFromPointers(pointers);
    }

    private boolean isFreshName(OWLClassExpression ce) {
        if (ce.isAnonymous()) {
            return false;
        }
        return !this.knownEntities.contains(ce);
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        this.handleRawOntologyChanges(changes);
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public OWLOntology getRootOntology() {
        return this.rootOntology;
    }

    private synchronized void handleRawOntologyChanges(List<? extends OWLOntologyChange> changes) {
        this.rawChanges.addAll(changes);
        if (this.bufferingMode.equals((Object)BufferingMode.NON_BUFFERING)) {
            this.flush();
        }
    }

    public synchronized List<OWLOntologyChange> getPendingChanges() {
        return new ArrayList<OWLOntologyChange>(this.rawChanges);
    }

    public synchronized Set<OWLAxiom> getPendingAxiomAdditions() {
        if (this.rawChanges.size() > 0) {
            HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
            this.computeDiff(added, new HashSet<OWLAxiom>());
            return added;
        }
        return Collections.emptySet();
    }

    public synchronized Set<OWLAxiom> getPendingAxiomRemovals() {
        if (this.rawChanges.size() > 0) {
            HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
            this.computeDiff(new HashSet<OWLAxiom>(), removed);
            return removed;
        }
        return Collections.emptySet();
    }

    public synchronized void flush() {
        if (this.rawChanges.size() > 0) {
            HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
            HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
            this.computeDiff(added, removed);
            this.rawChanges.clear();
            if (!added.isEmpty() || !removed.isEmpty()) {
                this.reasonerAxioms.removeAll(removed);
                this.reasonerAxioms.addAll(added);
                this.knownEntities.clear();
                for (OWLAxiom ax : this.reasonerAxioms) {
                    this.knownEntities.addAll(ax.getSignature());
                }
                this.consistencyVerified = null;
                this.handleChanges(added, removed);
            }
        }
    }

    private synchronized void computeDiff(Set<OWLAxiom> added, Set<OWLAxiom> removed) {
        for (OWLOntology ont : this.rootOntology.getImportsClosure()) {
            for (OWLLogicalAxiom ax : ont.getLogicalAxioms()) {
                if (this.reasonerAxioms.contains(ax.getAxiomWithoutAnnotations())) continue;
                added.add((OWLAxiom)ax);
            }
            for (OWLLogicalAxiom ax : ont.getAxioms(AxiomType.DECLARATION)) {
                if (this.reasonerAxioms.contains(ax.getAxiomWithoutAnnotations())) continue;
                added.add((OWLAxiom)ax);
            }
        }
        for (OWLAxiom ax : this.reasonerAxioms) {
            if (this.rootOntology.containsAxiomIgnoreAnnotations(ax, true)) continue;
            removed.add(ax);
        }
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.configuration.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.configuration.getIndividualNodeSetPolicy();
    }

    private synchronized void handleChanges(Set<OWLAxiom> addAxioms, Set<OWLAxiom> removeAxioms) {
        this.translationMachinery.loadAxioms(addAxioms);
        for (OWLAxiom ax_r : removeAxioms) {
            this.translationMachinery.retractAxiom(ax_r);
        }
    }

    public String getReasonerName() {
        return REASONER_NAME;
    }

    public Version getReasonerVersion() {
        return VERSION;
    }

    public void interrupt() {
        this.interrupted.set(true);
    }

    public synchronized void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        for (InferenceType it : inferenceTypes) {
            if (!supportedInferenceTypes.contains(it)) continue;
            if (!this.kernel.isKBRealised()) {
                this.kernel.realiseKB();
            }
            return;
        }
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        if (supportedInferenceTypes.contains(inferenceType)) {
            return this.kernel.isKBRealised();
        }
        return true;
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return supportedInferenceTypes;
    }

    public synchronized boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        if (this.consistencyVerified == null) {
            this.consistencyVerified = this.kernel.isKBConsistent();
        }
        return this.consistencyVerified;
    }

    private void checkConsistency() {
        if (this.interrupted.get()) {
            throw new ReasonerInterruptedException();
        }
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
    }

    public synchronized boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.checkConsistency();
        return this.kernel.isSatisfiable(this.translationMachinery.toClassPointer(classExpression));
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        return this.getBottomClassNode();
    }

    public synchronized boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.checkConsistency();
        if (this.reasonerAxioms.contains(axiom.getAxiomWithoutAnnotations())) {
            return true;
        }
        try {
            boolean entailed = (Boolean)axiom.accept((OWLAxiomVisitorEx)this.translationMachinery.getEntailmentChecker());
            return entailed;
        }
        catch (ReasonerFreshEntityException e) {
            String iri = e.getIri();
            if (this.getFreshEntityPolicy() == FreshEntityPolicy.DISALLOW) {
                for (OWLEntity o : axiom.getSignature()) {
                    if (!o.getIRI().toString().equals(iri)) continue;
                    throw new FreshEntitiesException(o);
                }
                throw new FreshEntitiesException(axiom.getSignature());
            }
            System.out.println("JFactReasoner.isEntailed() WARNING: fresh entity exception in the reasoner for entity: " + iri + "; defaulting to axiom not entailed");
            return false;
        }
    }

    public synchronized boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return !axiomType.equals((Object)AxiomType.SWRL_RULE);
    }

    public synchronized Set<OWLAxiom> getTrace(OWLAxiom axiom) {
        this.kernel.needTracing();
        if (this.isEntailed(axiom)) {
            return this.translationMachinery.translateTAxiomSet(this.kernel.getTrace());
        }
        return Collections.emptySet();
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.df.getOWLThing());
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.df.getOWLNothing());
    }

    public synchronized NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        if (this.isFreshName(ce)) {
            if (this.configuration.getFreshEntityPolicy() == FreshEntityPolicy.DISALLOW) {
                throw new FreshEntitiesException(ce.getSignature());
            }
            return new OWLClassNodeSet(this.getBottomClassNode());
        }
        this.checkConsistency();
        TaxonomyActor actor = new TaxonomyActor(this.em, new ClassPolicy());
        this.kernel.getSubConcepts(this.translationMachinery.toClassPointer(ce), direct, actor);
        Collection pointers = actor.getClassElements();
        return this.translationMachinery.getClassExpressionTranslator().getNodeSetFromPointers(pointers);
    }

    public synchronized NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, ReasonerInterruptedException, TimeOutException {
        if (this.isFreshName(ce)) {
            return new OWLClassNodeSet(this.getTopClassNode());
        }
        this.checkConsistency();
        return this.translationMachinery.getClassExpressionTranslator().getNodeSetFromPointers(this.askSuperClasses(this.translationMachinery.toClassPointer(ce), direct));
    }

    public synchronized NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) {
        TaxonomyActor actor = new TaxonomyActor(this.em, new ClassPolicy());
        ConceptExpression p = this.translationMachinery.toClassPointer(ce);
        this.kernel.getDisjointConcepts(p, actor);
        return this.translationMachinery.getClassExpressionTranslator().getNodeSetFromPointers(actor.getClassElements());
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty());
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.df.getOWLBottomObjectProperty());
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        TaxonomyActor actor = new TaxonomyActor(this.em, new ObjectPropertyPolicy());
        this.kernel.getSubRoles(this.translationMachinery.toObjectPropertyPointer(pe), direct, actor);
        return this.translationMachinery.getObjectPropertyTranslator().getNodeSetFromPointers(actor.getObjectPropertyElements());
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        TaxonomyActor actor = new TaxonomyActor(this.em, new ObjectPropertyPolicy());
        this.kernel.getSupRoles(this.translationMachinery.toObjectPropertyPointer(pe), direct, actor);
        return this.translationMachinery.getObjectPropertyTranslator().getNodeSetFromPointers(actor.getObjectPropertyElements());
    }

    public synchronized Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        TaxonomyActor actor = new TaxonomyActor(this.em, new ObjectPropertyPolicy());
        this.kernel.getEquivalentRoles(this.translationMachinery.toObjectPropertyPointer(pe), actor);
        return this.translationMachinery.getObjectPropertyTranslator().getNodeFromPointers(actor.getObjectPropertySynonyms());
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        OWLObjectPropertyNodeSet toReturn = new OWLObjectPropertyNodeSet();
        toReturn.addNode(this.getBottomObjectPropertyNode());
        return toReturn;
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        return this.getEquivalentObjectProperties(pe.getInverseProperty());
    }

    public synchronized NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        ConceptExpression subClass = this.translationMachinery.toClassPointer((OWLClassExpression)this.df.getOWLObjectSomeValuesFrom(pe, (OWLClassExpression)this.df.getOWLThing()));
        return this.translationMachinery.getClassExpressionTranslator().getNodeSetFromPointers(this.askSuperClasses(subClass, direct));
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        return this.getSuperClasses((OWLClassExpression)this.df.getOWLObjectSomeValuesFrom(pe.getInverseProperty(), (OWLClassExpression)this.df.getOWLThing()), direct);
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        OWLDataPropertyNode toReturn = new OWLDataPropertyNode();
        toReturn.add((OWLObject)this.df.getOWLTopDataProperty());
        return toReturn;
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.getEquivalentDataProperties(this.df.getOWLBottomDataProperty());
    }

    public synchronized NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        TaxonomyActor actor = new TaxonomyActor(this.em, new DataPropertyPolicy());
        this.kernel.getSubRoles(this.translationMachinery.toDataPropertyPointer((OWLDataPropertyExpression)pe), direct, actor);
        return this.translationMachinery.getDataPropertyTranslator().getNodeSetFromPointers(actor.getDataPropertyElements());
    }

    public synchronized NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        TaxonomyActor actor = new TaxonomyActor(this.em, new DataPropertyPolicy());
        this.kernel.getSupRoles(this.translationMachinery.toDataPropertyPointer((OWLDataPropertyExpression)pe), direct, actor);
        Collection properties = actor.getDataPropertyElements();
        return this.translationMachinery.getDataPropertyTranslator().getNodeSetFromPointers(properties);
    }

    public synchronized Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        DataRoleExpression p = this.translationMachinery.toDataPropertyPointer((OWLDataPropertyExpression)pe);
        TaxonomyActor actor = new TaxonomyActor(this.em, new DataPropertyPolicy());
        this.kernel.getEquivalentRoles(p, actor);
        Collection<DataRoleExpression> dataPropertySynonyms = actor.getDataPropertySynonyms();
        return this.translationMachinery.getDataPropertyTranslator().getNodeFromPointers(dataPropertySynonyms);
    }

    public synchronized NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        OWLDataPropertyNodeSet toReturn = new OWLDataPropertyNodeSet();
        toReturn.addNode(this.getBottomDataPropertyNode());
        return toReturn;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        return this.getSuperClasses((OWLClassExpression)this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)pe, (OWLDataRange)this.df.getTopDatatype()), direct);
    }

    public synchronized NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        TaxonomyActor actor = new TaxonomyActor(this.em, new ClassPolicy());
        this.kernel.getTypes(this.translationMachinery.toIndividualPointer((OWLIndividual)ind), direct, actor);
        Collection classElements = actor.getClassElements();
        return this.translationMachinery.getClassExpressionTranslator().getNodeSetFromPointers(classElements);
    }

    public synchronized NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        TaxonomyActor actor = new TaxonomyActor(this.em, new IndividualPolicy(true));
        this.kernel.getInstances(this.translationMachinery.toClassPointer(ce), actor, direct);
        return this.translationMachinery.translateIndividualPointersToNodeSet(actor.getPlainIndividualElements());
    }

    public synchronized NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        ArrayList<NamedEntry> fillers = new ArrayList<NamedEntry>();
        this.kernel.getRoleFillers(this.translationMachinery.toIndividualPointer((OWLIndividual)ind), this.translationMachinery.toObjectPropertyPointer(pe), fillers);
        ArrayList<IndividualExpression> acc = new ArrayList<IndividualExpression>();
        for (NamedEntry p : fillers) {
            acc.add(this.em.individual(p.getName()));
        }
        return this.translationMachinery.translateIndividualPointersToNodeSet(acc);
    }

    public synchronized Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return Collections.emptySet();
    }

    public synchronized Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        TaxonomyActor actor = new TaxonomyActor(this.em, new IndividualPolicy(true));
        this.kernel.getSameAs(this.translationMachinery.toIndividualPointer((OWLIndividual)ind), actor);
        return this.translationMachinery.getIndividualTranslator().getNodeFromPointers(actor.getIndividualSynonyms());
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        OWLClassExpression ce = this.df.getOWLObjectOneOf(new OWLIndividual[]{ind}).getObjectComplementOf();
        return this.getInstances(ce, false);
    }

    public synchronized void dispose() {
        this.manager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this.translationMachinery = null;
        this.kernel = null;
    }

    public void dumpClassHierarchy(LeveLogger.LogAdapter pw, boolean includeBottomNode) {
        this.dumpSubClasses(this.getTopClassNode(), pw, 0, includeBottomNode);
    }

    private void dumpSubClasses(Node<OWLClass> node, LeveLogger.LogAdapter pw, int depth, boolean includeBottomNode) {
        if (includeBottomNode || !node.isBottomNode()) {
            for (int i = 0; i < depth; ++i) {
                pw.print("    ");
            }
            pw.println(node.toString());
            for (Node sub : this.getSubClasses((OWLClassExpression)node.getRepresentativeElement(), true)) {
                this.dumpSubClasses((Node<OWLClass>)sub, pw, depth + 1, includeBottomNode);
            }
        }
    }

    private Collection<Collection<ConceptExpression>> askSuperClasses(ConceptExpression arg, boolean direct) {
        TaxonomyActor actor = new TaxonomyActor(this.em, new ClassPolicy());
        this.kernel.getSupConcepts(arg, direct, actor);
        return actor.getClassElements();
    }
}

