/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.vocab.OWLFacet;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataValue;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTypeName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Axiom;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataTypeExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Entity;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.FacetExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleComplexExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public final class TranslationMachinery {
    private volatile AxiomTranslator axiomTranslator;
    private volatile ClassExpressionTranslator classExpressionTranslator;
    private volatile DataRangeTranslator dataRangeTranslator;
    private volatile ObjectPropertyTranslator objectPropertyTranslator;
    private volatile DataPropertyTranslator dataPropertyTranslator;
    private volatile IndividualTranslator individualTranslator;
    private volatile EntailmentChecker entailmentChecker;
    private final Map<OWLAxiom, Axiom> axiom2PtrMap = new HashMap<OWLAxiom, Axiom>();
    private final Map<Axiom, OWLAxiom> ptr2AxiomMap = new HashMap<Axiom, OWLAxiom>();
    protected final ReasoningKernel kernel;
    protected final ExpressionManager em;
    protected final OWLDataFactory df;

    public TranslationMachinery(ReasoningKernel kernel, OWLDataFactory df) {
        this.kernel = kernel;
        this.em = kernel.getExpressionManager();
        this.df = df;
        this.axiomTranslator = new AxiomTranslator();
        this.classExpressionTranslator = new ClassExpressionTranslator();
        this.dataRangeTranslator = new DataRangeTranslator();
        this.objectPropertyTranslator = new ObjectPropertyTranslator();
        this.dataPropertyTranslator = new DataPropertyTranslator();
        this.individualTranslator = new IndividualTranslator();
        this.entailmentChecker = new EntailmentChecker();
    }

    public DataTypeName getBuiltInDataType(String DTName) {
        return new DataTypeName(Datatypes.getBuiltInDataType(DTName));
    }

    public ObjectRoleExpression getTopObjectProperty() {
        return this.em.objectRole("http://www.w3.org/2002/07/owl#topObjectProperty");
    }

    public ObjectRoleExpression getBottomObjectProperty() {
        return this.em.objectRole("http://www.w3.org/2002/07/owl#bottomObjectProperty");
    }

    public DataRoleExpression getTopDataProperty() {
        return this.em.dataRole("http://www.w3.org/2002/07/owl#topDataProperty");
    }

    public DataRoleExpression getBottomDataProperty() {
        return this.em.dataRole("http://www.w3.org/2002/07/owl#bottomDataProperty");
    }

    public void loadAxioms(Collection<OWLAxiom> axioms) {
        for (OWLAxiom axiom : axioms) {
            Axiom axiomPointer;
            if (this.axiom2PtrMap.containsKey(axiom) || (axiomPointer = (Axiom)axiom.accept((OWLAxiomVisitorEx)this.axiomTranslator)) == null) continue;
            this.axiom2PtrMap.put(axiom, axiomPointer);
        }
    }

    public void retractAxiom(OWLAxiom axiom) {
        Axiom ptr = this.axiom2PtrMap.get(axiom);
        if (ptr != null) {
            this.kernel.retract(ptr);
            this.axiom2PtrMap.remove(axiom);
        }
    }

    protected ConceptExpression toClassPointer(OWLClassExpression classExpression) {
        return (ConceptExpression)classExpression.accept((OWLClassExpressionVisitorEx)this.classExpressionTranslator);
    }

    protected DataExpression toDataTypeExpressionPointer(OWLDataRange dataRange) {
        return (DataExpression)dataRange.accept((OWLDataRangeVisitorEx)this.dataRangeTranslator);
    }

    protected ObjectRoleExpression toObjectPropertyPointer(OWLObjectPropertyExpression propertyExpression) {
        OWLObjectPropertyExpression simp = propertyExpression.getSimplified();
        if (simp.isAnonymous()) {
            OWLObjectInverseOf inv = (OWLObjectInverseOf)simp;
            return this.em.inverse((ObjectRoleExpression)this.objectPropertyTranslator.getPointerFromEntity(inv.getInverse().asOWLObjectProperty()));
        }
        return (ObjectRoleExpression)this.objectPropertyTranslator.getPointerFromEntity(simp.asOWLObjectProperty());
    }

    protected DataRoleExpression toDataPropertyPointer(OWLDataPropertyExpression propertyExpression) {
        return (DataRoleExpression)this.dataPropertyTranslator.getPointerFromEntity(propertyExpression.asOWLDataProperty());
    }

    protected synchronized IndividualExpression toIndividualPointer(OWLIndividual individual) {
        if (!individual.isAnonymous()) {
            return (IndividualExpression)this.individualTranslator.getPointerFromEntity(individual.asOWLNamedIndividual());
        }
        return this.em.individual(individual.toStringID());
    }

    protected synchronized DataTypeExpression toDataTypePointer(OWLDatatype datatype) {
        if (datatype == null) {
            throw new NullPointerException();
        }
        return this.getBuiltInDataType(datatype.toStringID());
    }

    protected synchronized DataValue toDataValuePointer(OWLLiteral literal) {
        String value = literal.getLiteral();
        if (literal.isRDFPlainLiteral()) {
            value = value + "@" + literal.getLang();
        }
        return this.em.dataValue(value, this.toDataTypePointer(literal.getDatatype()));
    }

    protected NodeSet<OWLNamedIndividual> translateIndividualPointersToNodeSet(Iterable<IndividualExpression> pointers) {
        OWLNamedIndividualNodeSet ns = new OWLNamedIndividualNodeSet();
        for (IndividualExpression pointer : pointers) {
            OWLNamedIndividual ind;
            if (pointer == null || (ind = (OWLNamedIndividual)this.individualTranslator.getEntityFromPointer(pointer)) == null) continue;
            ns.addEntity((OWLObject)ind);
        }
        return ns;
    }

    protected synchronized List<Expression> translateIndividualSet(Set<OWLIndividual> inds) {
        ArrayList<Expression> l = new ArrayList<Expression>();
        for (OWLIndividual ind : inds) {
            l.add(this.toIndividualPointer(ind));
        }
        return l;
    }

    public ClassExpressionTranslator getClassExpressionTranslator() {
        return this.classExpressionTranslator;
    }

    public DataRangeTranslator getDataRangeTranslator() {
        return this.dataRangeTranslator;
    }

    public ObjectPropertyTranslator getObjectPropertyTranslator() {
        return this.objectPropertyTranslator;
    }

    public DataPropertyTranslator getDataPropertyTranslator() {
        return this.dataPropertyTranslator;
    }

    public IndividualTranslator getIndividualTranslator() {
        return this.individualTranslator;
    }

    public EntailmentChecker getEntailmentChecker() {
        return this.entailmentChecker;
    }

    public Set<OWLAxiom> translateTAxiomSet(Collection<Axiom> trace) {
        HashSet<OWLAxiom> ret = new HashSet<OWLAxiom>();
        for (Axiom ap : trace) {
            ret.add(this.ptr2AxiomMap.get(ap));
        }
        return ret;
    }

    final class IndividualTranslator
    extends OWLEntityTranslator<OWLNamedIndividual, IndividualExpression> {
        @Override
        protected IndividualExpression getTopEntityPointer() {
            return null;
        }

        @Override
        protected IndividualExpression getBottomEntityPointer() {
            return null;
        }

        @Override
        protected IndividualExpression createPointerForEntity(OWLNamedIndividual entity) {
            return TranslationMachinery.this.em.individual(entity.toStringID());
        }

        @Override
        protected OWLNamedIndividual getTopEntity() {
            return null;
        }

        @Override
        protected OWLNamedIndividual getBottomEntity() {
            return null;
        }

        @Override
        protected DefaultNode<OWLNamedIndividual> createDefaultNode() {
            return new OWLNamedIndividualNode();
        }

        @Override
        protected DefaultNodeSet<OWLNamedIndividual> createDefaultNodeSet() {
            return new OWLNamedIndividualNodeSet();
        }
    }

    final class DataRangeTranslator
    extends OWLEntityTranslator<OWLDatatype, DataExpression>
    implements OWLDataRangeVisitorEx<DataExpression> {
        @Override
        protected DataExpression getTopEntityPointer() {
            return TranslationMachinery.this.em.dataTop();
        }

        @Override
        protected DataExpression getBottomEntityPointer() {
            return null;
        }

        @Override
        protected DefaultNode<OWLDatatype> createDefaultNode() {
            return new OWLDatatypeNode();
        }

        @Override
        protected OWLDatatype getTopEntity() {
            return TranslationMachinery.this.df.getTopDatatype();
        }

        @Override
        protected OWLDatatype getBottomEntity() {
            return null;
        }

        @Override
        protected DefaultNodeSet<OWLDatatype> createDefaultNodeSet() {
            return new OWLDatatypeNodeSet();
        }

        @Override
        protected DataExpression createPointerForEntity(OWLDatatype entity) {
            return TranslationMachinery.this.getBuiltInDataType(entity.toStringID());
        }

        public DataTypeExpression visit(OWLDatatype node) {
            return TranslationMachinery.this.getBuiltInDataType(node.toStringID());
        }

        public DataExpression visit(OWLDataOneOf node) {
            ArrayList<Expression> l = new ArrayList<Expression>();
            for (OWLLiteral literal : node.getValues()) {
                l.add(TranslationMachinery.this.toDataValuePointer(literal));
            }
            return TranslationMachinery.this.em.dataOneOf(l);
        }

        public DataExpression visit(OWLDataComplementOf node) {
            return TranslationMachinery.this.em.dataNot((DataExpression)node.getDataRange().accept((OWLDataRangeVisitorEx)this));
        }

        public DataExpression visit(OWLDataIntersectionOf node) {
            return TranslationMachinery.this.em.dataAnd(this.translateDataRangeSet(node.getOperands()));
        }

        private List<Expression> translateDataRangeSet(Set<OWLDataRange> dataRanges) {
            ArrayList<Expression> l = new ArrayList<Expression>();
            for (OWLDataRange op : dataRanges) {
                l.add((Expression)op.accept((OWLDataRangeVisitorEx)this));
            }
            return l;
        }

        public DataExpression visit(OWLDataUnionOf node) {
            return TranslationMachinery.this.em.dataOr(this.translateDataRangeSet(node.getOperands()));
        }

        public DataExpression visit(OWLDatatypeRestriction node) {
            DataTypeExpression dte = (DataTypeExpression)node.getDatatype().accept((OWLDataRangeVisitorEx)this);
            for (OWLFacetRestriction restriction : node.getFacetRestrictions()) {
                FacetExpression facet;
                DataValue dv = TranslationMachinery.this.toDataValuePointer(restriction.getFacetValue());
                if (restriction.getFacet().equals((Object)OWLFacet.MIN_INCLUSIVE)) {
                    facet = TranslationMachinery.this.em.facetMinInclusive(dv);
                } else if (restriction.getFacet().equals((Object)OWLFacet.MAX_INCLUSIVE)) {
                    facet = TranslationMachinery.this.em.facetMaxInclusive(dv);
                } else if (restriction.getFacet().equals((Object)OWLFacet.MIN_EXCLUSIVE)) {
                    facet = TranslationMachinery.this.em.facetMinExclusive(dv);
                } else if (restriction.getFacet().equals((Object)OWLFacet.MAX_EXCLUSIVE)) {
                    facet = TranslationMachinery.this.em.facetMaxExclusive(dv);
                } else {
                    if (restriction.getFacet().equals((Object)OWLFacet.LENGTH)) {
                        throw new ReasonerInternalException("JFact Kernel: unsupported facet 'getLength'");
                    }
                    if (restriction.getFacet().equals((Object)OWLFacet.MIN_LENGTH)) {
                        throw new ReasonerInternalException("JFact Kernel: unsupported facet 'getMinLength'");
                    }
                    if (restriction.getFacet().equals((Object)OWLFacet.MAX_LENGTH)) {
                        throw new ReasonerInternalException("JFact Kernel: unsupported facet 'getMaxLength'");
                    }
                    if (restriction.getFacet().equals((Object)OWLFacet.FRACTION_DIGITS)) {
                        throw new ReasonerInternalException("JFact Kernel: unsupported facet 'getFractionDigitsFacet'");
                    }
                    if (restriction.getFacet().equals((Object)OWLFacet.PATTERN)) {
                        throw new ReasonerInternalException("JFact Kernel: unsupported facet 'getPattern'");
                    }
                    if (restriction.getFacet().equals((Object)OWLFacet.TOTAL_DIGITS)) {
                        throw new ReasonerInternalException("JFact Kernel: unsupported facet 'getTotalDigitsFacet'");
                    }
                    throw new OWLRuntimeException("Unsupported facet: " + restriction.getFacet());
                }
                dte = TranslationMachinery.this.em.restrictedType(dte, facet);
            }
            return dte;
        }
    }

    final class DataPropertyTranslator
    extends OWLEntityTranslator<OWLDataProperty, DataRoleExpression> {
        @Override
        protected DataRoleExpression getTopEntityPointer() {
            return TranslationMachinery.this.getTopDataProperty();
        }

        @Override
        protected DataRoleExpression getBottomEntityPointer() {
            return TranslationMachinery.this.getBottomDataProperty();
        }

        @Override
        protected DataRoleExpression createPointerForEntity(OWLDataProperty entity) {
            return TranslationMachinery.this.em.dataRole(entity.toStringID());
        }

        @Override
        protected OWLDataProperty getTopEntity() {
            return TranslationMachinery.this.df.getOWLTopDataProperty();
        }

        @Override
        protected OWLDataProperty getBottomEntity() {
            return TranslationMachinery.this.df.getOWLBottomDataProperty();
        }

        @Override
        protected DefaultNode<OWLDataProperty> createDefaultNode() {
            return new OWLDataPropertyNode();
        }

        @Override
        protected DefaultNodeSet<OWLDataProperty> createDefaultNodeSet() {
            return new OWLDataPropertyNodeSet();
        }
    }

    final class ClassExpressionTranslator
    extends OWLEntityTranslator<OWLClass, ConceptExpression>
    implements OWLClassExpressionVisitorEx<ConceptExpression> {
        @Override
        protected ConceptExpression getTopEntityPointer() {
            return TranslationMachinery.this.em.top();
        }

        @Override
        protected ConceptExpression getBottomEntityPointer() {
            return TranslationMachinery.this.em.bottom();
        }

        @Override
        protected OWLClass getTopEntity() {
            return TranslationMachinery.this.df.getOWLThing();
        }

        @Override
        protected OWLClass getBottomEntity() {
            return TranslationMachinery.this.df.getOWLNothing();
        }

        @Override
        protected ConceptExpression createPointerForEntity(OWLClass entity) {
            return TranslationMachinery.this.em.concept(entity.getIRI().toString());
        }

        @Override
        protected DefaultNode<OWLClass> createDefaultNode() {
            return new OWLClassNode();
        }

        @Override
        protected DefaultNodeSet<OWLClass> createDefaultNodeSet() {
            return new OWLClassNodeSet();
        }

        public ConceptExpression visit(OWLClass desc) {
            return (ConceptExpression)this.getPointerFromEntity(desc);
        }

        public ConceptExpression visit(OWLObjectIntersectionOf desc) {
            return TranslationMachinery.this.em.and(this.translateClassExpressionSet(desc.getOperands()));
        }

        private List<Expression> translateClassExpressionSet(Set<OWLClassExpression> classExpressions) {
            ArrayList<Expression> l = new ArrayList<Expression>();
            for (OWLClassExpression ce : classExpressions) {
                l.add((Expression)ce.accept((OWLClassExpressionVisitorEx)this));
            }
            return l;
        }

        public ConceptExpression visit(OWLObjectUnionOf desc) {
            return TranslationMachinery.this.em.or(this.translateClassExpressionSet(desc.getOperands()));
        }

        public ConceptExpression visit(OWLObjectComplementOf desc) {
            return TranslationMachinery.this.em.not((ConceptExpression)desc.getOperand().accept((OWLClassExpressionVisitorEx)this));
        }

        public ConceptExpression visit(OWLObjectSomeValuesFrom desc) {
            return TranslationMachinery.this.em.exists(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ConceptExpression visit(OWLObjectAllValuesFrom desc) {
            return TranslationMachinery.this.em.forall(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ConceptExpression visit(OWLObjectHasValue desc) {
            return TranslationMachinery.this.em.value(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)desc.getProperty()), TranslationMachinery.this.toIndividualPointer((OWLIndividual)desc.getValue()));
        }

        public ConceptExpression visit(OWLObjectMinCardinality desc) {
            return TranslationMachinery.this.em.minCardinality(desc.getCardinality(), TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ConceptExpression visit(OWLObjectExactCardinality desc) {
            return TranslationMachinery.this.em.cardinality(desc.getCardinality(), TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ConceptExpression visit(OWLObjectMaxCardinality desc) {
            return TranslationMachinery.this.em.maxCardinality(desc.getCardinality(), TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ConceptExpression visit(OWLObjectHasSelf desc) {
            return TranslationMachinery.this.em.selfReference(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)desc.getProperty()));
        }

        public ConceptExpression visit(OWLObjectOneOf desc) {
            return TranslationMachinery.this.em.oneOf(TranslationMachinery.this.translateIndividualSet(desc.getIndividuals()));
        }

        public ConceptExpression visit(OWLDataSomeValuesFrom desc) {
            return TranslationMachinery.this.em.exists(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)desc.getProperty()), TranslationMachinery.this.toDataTypeExpressionPointer((OWLDataRange)desc.getFiller()));
        }

        public ConceptExpression visit(OWLDataAllValuesFrom desc) {
            return TranslationMachinery.this.em.forall(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)desc.getProperty()), TranslationMachinery.this.toDataTypeExpressionPointer((OWLDataRange)desc.getFiller()));
        }

        public ConceptExpression visit(OWLDataHasValue desc) {
            return TranslationMachinery.this.em.value(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)desc.getProperty()), TranslationMachinery.this.toDataValuePointer((OWLLiteral)desc.getValue()));
        }

        public ConceptExpression visit(OWLDataMinCardinality desc) {
            return TranslationMachinery.this.em.minCardinality(desc.getCardinality(), TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)desc.getProperty()), TranslationMachinery.this.toDataTypeExpressionPointer((OWLDataRange)desc.getFiller()));
        }

        public ConceptExpression visit(OWLDataExactCardinality desc) {
            return TranslationMachinery.this.em.cardinality(desc.getCardinality(), TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)desc.getProperty()), TranslationMachinery.this.toDataTypeExpressionPointer((OWLDataRange)desc.getFiller()));
        }

        public ConceptExpression visit(OWLDataMaxCardinality desc) {
            return TranslationMachinery.this.em.maxCardinality(desc.getCardinality(), TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)desc.getProperty()), TranslationMachinery.this.toDataTypeExpressionPointer((OWLDataRange)desc.getFiller()));
        }
    }

    final class AxiomTranslator
    implements OWLAxiomVisitorEx<Axiom> {
        private final DeclarationVisitorEx v;

        public AxiomTranslator() {
            this.v = new DeclarationVisitorEx();
        }

        public Axiom visit(OWLSubClassOfAxiom axiom) {
            return TranslationMachinery.this.kernel.impliesConcepts(TranslationMachinery.this.toClassPointer(axiom.getSubClass()), TranslationMachinery.this.toClassPointer(axiom.getSuperClass()));
        }

        public Axiom visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return TranslationMachinery.this.kernel.relatedToNot(TranslationMachinery.this.toIndividualPointer(axiom.getSubject()), TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()), TranslationMachinery.this.toIndividualPointer((OWLIndividual)axiom.getObject()));
        }

        public Axiom visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.setAsymmetric(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Axiom visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.setReflexive(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Axiom visit(OWLDisjointClassesAxiom axiom) {
            return TranslationMachinery.this.kernel.disjointConcepts(this.translateClassExpressionSet(axiom.getClassExpressions()));
        }

        private List<Expression> translateClassExpressionSet(Set<OWLClassExpression> classExpressions) {
            ArrayList<Expression> l = new ArrayList<Expression>();
            for (OWLClassExpression ce : classExpressions) {
                l.add(TranslationMachinery.this.toClassPointer(ce));
            }
            return l;
        }

        public Axiom visit(OWLDataPropertyDomainAxiom axiom) {
            return TranslationMachinery.this.kernel.setDDomain(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getProperty()), TranslationMachinery.this.toClassPointer(axiom.getDomain()));
        }

        public Axiom visit(OWLObjectPropertyDomainAxiom axiom) {
            return TranslationMachinery.this.kernel.setODomain(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()), TranslationMachinery.this.toClassPointer(axiom.getDomain()));
        }

        public Axiom visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            return TranslationMachinery.this.kernel.equalORoles(this.translateObjectPropertySet(axiom.getProperties()));
        }

        private List<Expression> translateObjectPropertySet(Collection<OWLObjectPropertyExpression> properties) {
            ArrayList<Expression> l = new ArrayList<Expression>();
            for (OWLObjectPropertyExpression property : properties) {
                l.add(TranslationMachinery.this.toObjectPropertyPointer(property));
            }
            return l;
        }

        public Axiom visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return TranslationMachinery.this.kernel.valueOfNot(TranslationMachinery.this.toIndividualPointer(axiom.getSubject()), TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getProperty()), TranslationMachinery.this.toDataValuePointer((OWLLiteral)axiom.getObject()));
        }

        public Axiom visit(OWLDifferentIndividualsAxiom axiom) {
            return TranslationMachinery.this.kernel.processDifferent(TranslationMachinery.this.translateIndividualSet(axiom.getIndividuals()));
        }

        public Axiom visit(OWLDisjointDataPropertiesAxiom axiom) {
            return TranslationMachinery.this.kernel.disjointDRoles(this.translateDataPropertySet(axiom.getProperties()));
        }

        private List<Expression> translateDataPropertySet(Set<OWLDataPropertyExpression> properties) {
            ArrayList<Expression> l = new ArrayList<Expression>();
            for (OWLDataPropertyExpression property : properties) {
                l.add(TranslationMachinery.this.toDataPropertyPointer(property));
            }
            return l;
        }

        public Axiom visit(OWLDisjointObjectPropertiesAxiom axiom) {
            return TranslationMachinery.this.kernel.disjointORoles(this.translateObjectPropertySet(axiom.getProperties()));
        }

        public Axiom visit(OWLObjectPropertyRangeAxiom axiom) {
            return TranslationMachinery.this.kernel.setORange(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()), TranslationMachinery.this.toClassPointer((OWLClassExpression)axiom.getRange()));
        }

        public Axiom visit(OWLObjectPropertyAssertionAxiom axiom) {
            return TranslationMachinery.this.kernel.relatedTo(TranslationMachinery.this.toIndividualPointer(axiom.getSubject()), TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()), TranslationMachinery.this.toIndividualPointer((OWLIndividual)axiom.getObject()));
        }

        public Axiom visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.setOFunctional(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Axiom visit(OWLSubObjectPropertyOfAxiom axiom) {
            return TranslationMachinery.this.kernel.impliesORoles(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getSubProperty()), TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getSuperProperty()));
        }

        public Axiom visit(OWLDisjointUnionAxiom axiom) {
            return TranslationMachinery.this.kernel.disjointUnion(TranslationMachinery.this.toClassPointer((OWLClassExpression)axiom.getOWLClass()), this.translateClassExpressionSet(axiom.getClassExpressions()));
        }

        public Axiom visit(OWLDeclarationAxiom axiom) {
            OWLEntity entity = axiom.getEntity();
            return (Axiom)entity.accept((OWLEntityVisitorEx)this.v);
        }

        public Axiom visit(OWLAnnotationAssertionAxiom axiom) {
            return null;
        }

        public Axiom visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.setSymmetric(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Axiom visit(OWLDataPropertyRangeAxiom axiom) {
            return TranslationMachinery.this.kernel.setDRange(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getProperty()), TranslationMachinery.this.toDataTypeExpressionPointer((OWLDataRange)axiom.getRange()));
        }

        public Axiom visit(OWLFunctionalDataPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.setDFunctional(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getProperty()));
        }

        public Axiom visit(OWLEquivalentDataPropertiesAxiom axiom) {
            return TranslationMachinery.this.kernel.equalDRoles(this.translateDataPropertySet(axiom.getProperties()));
        }

        public Axiom visit(OWLClassAssertionAxiom axiom) {
            return TranslationMachinery.this.kernel.instanceOf(TranslationMachinery.this.toIndividualPointer(axiom.getIndividual()), TranslationMachinery.this.toClassPointer(axiom.getClassExpression()));
        }

        public Axiom visit(OWLEquivalentClassesAxiom axiom) {
            return TranslationMachinery.this.kernel.equalConcepts(this.translateClassExpressionSet(axiom.getClassExpressions()));
        }

        public Axiom visit(OWLDataPropertyAssertionAxiom axiom) {
            return TranslationMachinery.this.kernel.valueOf(TranslationMachinery.this.toIndividualPointer(axiom.getSubject()), TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getProperty()), TranslationMachinery.this.toDataValuePointer((OWLLiteral)axiom.getObject()));
        }

        public Axiom visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.setTransitive(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Axiom visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.setIrreflexive(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Axiom visit(OWLSubDataPropertyOfAxiom axiom) {
            return TranslationMachinery.this.kernel.impliesDRoles(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getSubProperty()), TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getSuperProperty()));
        }

        public Axiom visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.setInverseFunctional(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Axiom visit(OWLSameIndividualAxiom axiom) {
            return TranslationMachinery.this.kernel.processSame(TranslationMachinery.this.translateIndividualSet(axiom.getIndividuals()));
        }

        public Axiom visit(OWLSubPropertyChainOfAxiom axiom) {
            return TranslationMachinery.this.kernel.impliesORoles(TranslationMachinery.this.em.compose(this.translateObjectPropertySet(axiom.getPropertyChain())), TranslationMachinery.this.toObjectPropertyPointer(axiom.getSuperProperty()));
        }

        public Axiom visit(OWLInverseObjectPropertiesAxiom axiom) {
            return TranslationMachinery.this.kernel.setInverseRoles(TranslationMachinery.this.toObjectPropertyPointer(axiom.getFirstProperty()), TranslationMachinery.this.toObjectPropertyPointer(axiom.getSecondProperty()));
        }

        public Axiom visit(OWLHasKeyAxiom axiom) {
            throw new ReasonerInternalException("JFact Kernel: unsupported operation 'getDataPropertyKey'");
        }

        public Axiom visit(OWLDatatypeDefinitionAxiom axiom) {
            throw new ReasonerInternalException("JFact Kernel: unsupported operation 'OWLDatatypeDefinitionAxiom'");
        }

        public Axiom visit(SWRLRule rule) {
            return null;
        }

        public Axiom visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            return null;
        }

        public Axiom visit(OWLAnnotationPropertyDomainAxiom axiom) {
            return null;
        }

        public Axiom visit(OWLAnnotationPropertyRangeAxiom axiom) {
            return null;
        }
    }

    protected final class DeclarationVisitorEx
    implements OWLEntityVisitorEx<Axiom> {
        protected DeclarationVisitorEx() {
        }

        public Axiom visit(OWLClass cls) {
            return TranslationMachinery.this.kernel.declare(TranslationMachinery.this.toClassPointer((OWLClassExpression)cls));
        }

        public Axiom visit(OWLObjectProperty property) {
            return TranslationMachinery.this.kernel.declare(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)property));
        }

        public Axiom visit(OWLDataProperty property) {
            return TranslationMachinery.this.kernel.declare(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)property));
        }

        public Axiom visit(OWLNamedIndividual individual) {
            return TranslationMachinery.this.kernel.declare(TranslationMachinery.this.toIndividualPointer((OWLIndividual)individual));
        }

        public Axiom visit(OWLDatatype datatype) {
            return TranslationMachinery.this.kernel.declare(TranslationMachinery.this.toDataTypePointer(datatype));
        }

        public Axiom visit(OWLAnnotationProperty property) {
            return null;
        }
    }

    final class ComplexObjectPropertyTranslator
    extends OWLEntityTranslator<OWLObjectPropertyExpression, ObjectRoleComplexExpression> {
        @Override
        protected ObjectRoleComplexExpression getTopEntityPointer() {
            return TranslationMachinery.this.getTopObjectProperty();
        }

        @Override
        protected ObjectRoleComplexExpression getBottomEntityPointer() {
            return TranslationMachinery.this.getBottomObjectProperty();
        }

        @Override
        protected ObjectRoleComplexExpression registerNewEntity(OWLObjectPropertyExpression entity) {
            ObjectRoleComplexExpression pointer = this.createPointerForEntity(entity);
            this.fillMaps(entity, pointer);
            entity = entity.getInverseProperty().getSimplified();
            this.fillMaps(entity, this.createPointerForEntity(entity));
            return pointer;
        }

        @Override
        protected ObjectRoleComplexExpression createPointerForEntity(OWLObjectPropertyExpression entity) {
            ObjectRoleExpression p = TranslationMachinery.this.em.objectRole(entity.getNamedProperty().toStringID());
            return p;
        }

        @Override
        protected OWLObjectProperty getTopEntity() {
            return TranslationMachinery.this.df.getOWLTopObjectProperty();
        }

        @Override
        protected OWLObjectProperty getBottomEntity() {
            return TranslationMachinery.this.df.getOWLBottomObjectProperty();
        }

        @Override
        protected DefaultNode<OWLObjectPropertyExpression> createDefaultNode() {
            return new OWLObjectPropertyNode();
        }

        @Override
        protected DefaultNodeSet<OWLObjectPropertyExpression> createDefaultNodeSet() {
            return new OWLObjectPropertyNodeSet();
        }
    }

    final class ObjectPropertyTranslator
    extends OWLEntityTranslator<OWLObjectPropertyExpression, ObjectRoleExpression> {
        @Override
        protected ObjectRoleExpression getTopEntityPointer() {
            return TranslationMachinery.this.getTopObjectProperty();
        }

        @Override
        protected ObjectRoleExpression getBottomEntityPointer() {
            return TranslationMachinery.this.getBottomObjectProperty();
        }

        @Override
        protected ObjectRoleExpression registerNewEntity(OWLObjectPropertyExpression entity) {
            ObjectRoleExpression pointer = this.createPointerForEntity(entity);
            this.fillMaps(entity, pointer);
            entity = entity.getInverseProperty().getSimplified();
            this.fillMaps(entity, this.createPointerForEntity(entity));
            return pointer;
        }

        @Override
        protected ObjectRoleExpression createPointerForEntity(OWLObjectPropertyExpression entity) {
            ObjectRoleExpression p = TranslationMachinery.this.em.objectRole(entity.getNamedProperty().toStringID());
            if (entity.isAnonymous()) {
                p = TranslationMachinery.this.em.inverse(p);
            }
            return p;
        }

        @Override
        protected OWLObjectProperty getTopEntity() {
            return TranslationMachinery.this.df.getOWLTopObjectProperty();
        }

        @Override
        protected OWLObjectProperty getBottomEntity() {
            return TranslationMachinery.this.df.getOWLBottomObjectProperty();
        }

        @Override
        protected DefaultNode<OWLObjectPropertyExpression> createDefaultNode() {
            return new OWLObjectPropertyNode();
        }

        @Override
        protected DefaultNodeSet<OWLObjectPropertyExpression> createDefaultNodeSet() {
            return new OWLObjectPropertyNodeSet();
        }
    }

    abstract class OWLEntityTranslator<E extends OWLObject, T extends Entity> {
        private final Map<E, T> entity2dlentity = new HashMap<E, T>();
        private final Map<T, E> dlentity2entity = new HashMap<T, E>();

        protected final void fillMaps(E entity, T dlentity) {
            this.entity2dlentity.put(entity, dlentity);
            this.dlentity2entity.put(dlentity, entity);
        }

        protected OWLEntityTranslator() {
            E bottomEntity;
            E topEntity = this.getTopEntity();
            if (topEntity != null) {
                this.fillMaps(topEntity, this.getTopEntityPointer());
            }
            if ((bottomEntity = this.getBottomEntity()) != null) {
                this.fillMaps(bottomEntity, this.getBottomEntityPointer());
            }
        }

        protected T registerNewEntity(E entity) {
            T pointer = this.createPointerForEntity(entity);
            this.fillMaps(entity, pointer);
            return pointer;
        }

        public final E getEntityFromPointer(T pointer) {
            return (E)((OWLObject)this.dlentity2entity.get(pointer));
        }

        public final T getPointerFromEntity(E entity) {
            Entity pointer = (Entity)this.entity2dlentity.get(entity);
            if (pointer == null) {
                pointer = this.registerNewEntity(entity);
            }
            return (T)pointer;
        }

        public Node<E> getNodeFromPointers(Collection<T> pointers) {
            DefaultNode<E> node = this.createDefaultNode();
            for (Entity pointer : pointers) {
                node.add(this.getEntityFromPointer(pointer));
            }
            return node;
        }

        public NodeSet<E> getNodeSetFromPointers(Collection<Collection<T>> pointers) {
            DefaultNodeSet<E> nodeSet = this.createDefaultNodeSet();
            for (Collection<T> pointerArray : pointers) {
                nodeSet.addNode(this.getNodeFromPointers(pointerArray));
            }
            return nodeSet;
        }

        protected abstract DefaultNode<E> createDefaultNode();

        protected abstract DefaultNodeSet<E> createDefaultNodeSet();

        protected abstract T getTopEntityPointer();

        protected abstract T getBottomEntityPointer();

        protected abstract T createPointerForEntity(E var1);

        protected abstract E getTopEntity();

        protected abstract E getBottomEntity();
    }

    public final class EntailmentChecker
    implements OWLAxiomVisitorEx<Boolean> {
        public Boolean visit(OWLSubClassOfAxiom axiom) {
            if (axiom.getSuperClass().equals(TranslationMachinery.this.df.getOWLThing()) || axiom.getSubClass().equals(TranslationMachinery.this.df.getOWLNothing())) {
                return true;
            }
            return TranslationMachinery.this.kernel.isSubsumedBy(TranslationMachinery.this.toClassPointer(axiom.getSubClass()), TranslationMachinery.this.toClassPointer(axiom.getSuperClass()));
        }

        public Boolean visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.isAsymmetric(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Boolean visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.isReflexive(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Boolean visit(OWLDisjointClassesAxiom axiom) {
            Set classExpressions = axiom.getClassExpressions();
            if (classExpressions.size() == 2) {
                Iterator it = classExpressions.iterator();
                return TranslationMachinery.this.kernel.isDisjoint(TranslationMachinery.this.toClassPointer((OWLClassExpression)it.next()), TranslationMachinery.this.toClassPointer((OWLClassExpression)it.next()));
            }
            for (OWLSubClassOfAxiom ax : axiom.asOWLSubClassOfAxioms()) {
                if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLDataPropertyDomainAxiom axiom) {
            return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLObjectPropertyDomainAxiom axiom) {
            return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLSubObjectPropertyOfAxiom ax : axiom.asSubObjectPropertyOfAxioms()) {
                if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLDifferentIndividualsAxiom axiom) {
            for (OWLSubClassOfAxiom ax : axiom.asOWLSubClassOfAxioms()) {
                if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLDisjointDataPropertiesAxiom axiom) {
            ArrayList l = new ArrayList(axiom.getProperties());
            for (int i = 0; i < l.size() - 1; ++i) {
                for (int j = i + 1; j < l.size(); ++j) {
                    if (TranslationMachinery.this.kernel.isDisjointRoles(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)l.get(i)), TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)l.get(i)))) continue;
                    return false;
                }
            }
            return true;
        }

        public Boolean visit(OWLDisjointObjectPropertiesAxiom axiom) {
            ArrayList l = new ArrayList(axiom.getProperties());
            for (int i = 0; i < l.size() - 1; ++i) {
                for (int j = i + 1; j < l.size(); ++j) {
                    if (TranslationMachinery.this.kernel.isDisjointRoles(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)l.get(i)), TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)l.get(i)))) continue;
                    return false;
                }
            }
            return true;
        }

        public Boolean visit(OWLObjectPropertyRangeAxiom axiom) {
            return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLObjectPropertyAssertionAxiom axiom) {
            return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.isFunctional(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Boolean visit(OWLSubObjectPropertyOfAxiom axiom) {
            return TranslationMachinery.this.kernel.isSubRoles(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getSubProperty()), TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getSuperProperty()));
        }

        public Boolean visit(OWLDisjointUnionAxiom axiom) {
            return (Boolean)axiom.getOWLEquivalentClassesAxiom().accept((OWLAxiomVisitorEx)this) != false && (Boolean)axiom.getOWLDisjointClassesAxiom().accept((OWLAxiomVisitorEx)this) != false;
        }

        public Boolean visit(OWLDeclarationAxiom axiom) {
            return false;
        }

        public Boolean visit(OWLAnnotationAssertionAxiom axiom) {
            return false;
        }

        public Boolean visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.isSymmetric(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Boolean visit(OWLDataPropertyRangeAxiom axiom) {
            return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLFunctionalDataPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.isFunctional(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getProperty()));
        }

        public Boolean visit(OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLSubDataPropertyOfAxiom ax : axiom.asSubDataPropertyOfAxioms()) {
                if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLClassAssertionAxiom axiom) {
            return TranslationMachinery.this.kernel.isInstance(TranslationMachinery.this.toIndividualPointer(axiom.getIndividual()), TranslationMachinery.this.toClassPointer(axiom.getClassExpression()));
        }

        public Boolean visit(OWLEquivalentClassesAxiom axiom) {
            Set classExpressionSet = axiom.getClassExpressions();
            if (classExpressionSet.size() == 2) {
                Iterator it = classExpressionSet.iterator();
                return TranslationMachinery.this.kernel.isEquivalent(TranslationMachinery.this.toClassPointer((OWLClassExpression)it.next()), TranslationMachinery.this.toClassPointer((OWLClassExpression)it.next()));
            }
            for (OWLSubClassOfAxiom ax : axiom.asOWLSubClassOfAxioms()) {
                if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLDataPropertyAssertionAxiom axiom) {
            return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.isTransitive(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Boolean visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.isIrreflexive(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Boolean visit(OWLSubDataPropertyOfAxiom axiom) {
            return TranslationMachinery.this.kernel.isSubRoles(TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getSubProperty()), TranslationMachinery.this.toDataPropertyPointer((OWLDataPropertyExpression)axiom.getSuperProperty()));
        }

        public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return TranslationMachinery.this.kernel.isInverseFunctional(TranslationMachinery.this.toObjectPropertyPointer((OWLObjectPropertyExpression)axiom.getProperty()));
        }

        public Boolean visit(OWLSameIndividualAxiom axiom) {
            for (OWLSameIndividualAxiom ax : axiom.asPairwiseAxioms()) {
                Iterator it = ax.getIndividuals().iterator();
                OWLIndividual indA = (OWLIndividual)it.next();
                OWLIndividual indB = (OWLIndividual)it.next();
                if (TranslationMachinery.this.kernel.isSameIndividuals(TranslationMachinery.this.toIndividualPointer(indA), TranslationMachinery.this.toIndividualPointer(indB))) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLSubPropertyChainOfAxiom axiom) {
            ArrayList<Expression> l = new ArrayList<Expression>();
            for (OWLObjectPropertyExpression p : axiom.getPropertyChain()) {
                l.add(TranslationMachinery.this.toObjectPropertyPointer(p));
            }
            return TranslationMachinery.this.kernel.isSubChain(TranslationMachinery.this.toObjectPropertyPointer(axiom.getSuperProperty()), l);
        }

        public Boolean visit(OWLInverseObjectPropertiesAxiom axiom) {
            for (OWLSubObjectPropertyOfAxiom ax : axiom.asSubObjectPropertyOfAxioms()) {
                if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLHasKeyAxiom axiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)axiom);
        }

        public Boolean visit(OWLDatatypeDefinitionAxiom axiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)axiom);
        }

        public Boolean visit(SWRLRule rule) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)rule);
        }

        public Boolean visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            return false;
        }

        public Boolean visit(OWLAnnotationPropertyDomainAxiom axiom) {
            return false;
        }

        public Boolean visit(OWLAnnotationPropertyRangeAxiom axiom) {
            return false;
        }
    }
}

