/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.util.Arrays;

public final class ArrayIntMap {
    private int[][] values;
    private int size = 0;
    private static int defaultSize = 16;

    private int insertionIndex(int key) {
        int lowerbound;
        if (this.size == 0) {
            return -1;
        }
        if (key < this.values[0][0]) {
            return -1;
        }
        if (key > this.values[0][this.size - 1]) {
            return -this.size - 1;
        }
        if (this.size < 5) {
            for (lowerbound = 0; lowerbound < this.size; ++lowerbound) {
                if (this.values[0][lowerbound] == key) {
                    return lowerbound;
                }
                if (this.values[0][lowerbound] <= key) continue;
                return -lowerbound - 1;
            }
            return -lowerbound - 1;
        }
        int upperbound = this.size - 1;
        while (lowerbound <= upperbound) {
            int intermediate = lowerbound + (upperbound - lowerbound) / 2;
            if (this.values[0][intermediate] == key) {
                return intermediate;
            }
            if (this.values[0][intermediate] < key) {
                lowerbound = intermediate + 1;
                continue;
            }
            upperbound = intermediate - 1;
        }
        return -lowerbound - 1;
    }

    private void init() {
        this.values = new int[2][defaultSize];
        this.size = 0;
    }

    public void put(int e, int v) {
        int pos = -1;
        if (this.values == null) {
            this.init();
        } else {
            pos = this.insertionIndex(e);
        }
        if (pos > -1) {
            return;
        }
        int i = -pos - 1;
        if (i >= this.values[0].length || this.size >= this.values[0].length) {
            int[][] replacementvalues = new int[2][this.values[0].length + defaultSize];
            for (int j = 0; j < this.values[0].length; ++j) {
                replacementvalues[0][j] = this.values[0][j];
                replacementvalues[1][j] = this.values[1][j];
            }
            this.values = replacementvalues;
        }
        for (int j = this.size - 1; j >= i; --j) {
            this.values[0][j + 1] = this.values[0][j];
            this.values[1][j + 1] = this.values[1][j];
        }
        this.values[0][i] = e;
        this.values[1][i] = v;
        ++this.size;
    }

    public void clear() {
        this.values = null;
        this.size = 0;
    }

    public boolean containsKey(int o) {
        if (this.values != null) {
            boolean b = this.insertionIndex(o) > -1;
            return b;
        }
        return false;
    }

    public boolean containsAll(ArrayIntMap c) {
        if (c.size == 0) {
            return true;
        }
        if (this.size == 0) {
            return false;
        }
        if (c.size > this.size) {
            return false;
        }
        if (this.size == c.size) {
            for (int i = 0; i < this.size; ++i) {
                if (this.values[0][i] == c.values[0][i]) continue;
                return false;
            }
            return true;
        }
        if (this.values[0][0] > c.values[0][0] || this.values[0][this.size - 1] < c.values[0][c.size() - 1]) {
            return false;
        }
        int i = 0;
        for (int j = 0; j < c.size(); ++j) {
            int currentValue = c.values[0][j];
            boolean found = false;
            while (i < this.size) {
                if (this.values[0][i] == currentValue) {
                    found = true;
                    break;
                }
                if (this.values[0][i] > currentValue) {
                    return false;
                }
                ++i;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.values == null;
    }

    public void remove(int o) {
        if (this.values == null) {
            return;
        }
        int i = this.insertionIndex(o);
        this.removeAt(i);
    }

    public int size() {
        return this.size;
    }

    public void removeAt(int i) {
        if (this.values == null) {
            return;
        }
        if (i > -1 && i < this.size) {
            if (this.size == 1) {
                this.values = null;
                this.size = 0;
                return;
            }
            for (int j = i; j < this.size - 1; ++j) {
                this.values[0][j] = this.values[0][j + 1];
                this.values[1][j] = this.values[1][j + 1];
            }
            --this.size;
        }
        if (this.size == 0) {
            this.values = null;
        }
    }

    public boolean containsValue(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.values[1][i] != value) continue;
            return true;
        }
        return false;
    }

    public int[] values() {
        return Arrays.copyOf(this.values[1], this.size);
    }

    public int get(int key) {
        int index = this.insertionIndex(key);
        if (index < 0) {
            return Integer.MIN_VALUE;
        }
        return this.values[1][index];
    }

    public int[] keySet() {
        return Arrays.copyOf(this.values[0], this.size);
    }

    public int keySet(int i) {
        return this.values[0][i];
    }

    public int hashCode() {
        int sum = 0;
        for (int i = 0; i < this.size; ++i) {
            sum += this.values[0][i];
        }
        return sum;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ArrayIntMap) {
            ArrayIntMap o = (ArrayIntMap)obj;
            if (this.size != o.size) {
                return false;
            }
            if (this.size == 0) {
                return true;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.values[0][i] == o.values[0][i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.values != null) {
            return Arrays.toString(Arrays.copyOf(this.values[0], this.size)) + "\n" + Arrays.toString(Arrays.copyOf(this.values[1], this.size));
        }
        return "[]";
    }
}

