/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.helpers.DLVertexTagDFS;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.SortedIntList;
import uk.ac.manchester.cs.jfact.helpers.StatIndex;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.MergableLabel;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataEntry;

public final class DLVertex
extends DLVertexTagDFS {
    private final ChildSet child = new ChildSet();
    private NamedEntry concept = null;
    private final Role role;
    private final Role projRole;
    private int conceptIndex;
    private final int n;
    private final MergableLabel sort = new MergableLabel();
    protected final int[] stat = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected long posUsage = 0L;
    protected long negUsage = 0L;

    public MergableLabel getSort() {
        return this.sort;
    }

    public void merge(MergableLabel label) {
        this.sort.merge(label);
    }

    public DLVertex(DagTag op) {
        this(op, 0, null, 0, null);
    }

    public DLVertex(DagTag op, int m, Role R, int c, Role ProjR) {
        super(op);
        this.role = R;
        this.projRole = ProjR;
        this.conceptIndex = c;
        this.n = m;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DLVertex) {
            DLVertex v = (DLVertex)obj;
            return this.op == v.op && this.compare(this.role, v.role) && this.compare(this.projRole, v.projRole) && this.conceptIndex == v.conceptIndex && this.n == v.n && this.child.equals(v.child);
        }
        return false;
    }

    private boolean compare(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        return (this.op == null ? 0 : this.op.hashCode()) + (this.role == null ? 0 : this.role.hashCode()) + (this.projRole == null ? 0 : this.projRole.hashCode()) + this.conceptIndex + this.n + (this.child == null ? 0 : this.child.hashCode());
    }

    public int getConceptIndex() {
        return this.conceptIndex;
    }

    public int getNumberLE() {
        return this.n;
    }

    public int getNumberGE() {
        return this.n + 1;
    }

    public int getState() {
        return this.n;
    }

    public int[] begin() {
        return this.child.sorted();
    }

    public Role getRole() {
        return this.role;
    }

    public Role getProjRole() {
        return this.projRole;
    }

    public NamedEntry getConcept() {
        return this.concept;
    }

    public void setConcept(NamedEntry p) {
        this.concept = p;
    }

    public void setChild(int p) {
        this.conceptIndex = p;
    }

    public boolean addChild(int p) {
        if (p == 1) {
            return false;
        }
        if (this.op == DagTag.dtBad) {
            return true;
        }
        if (p == -1) {
            this.child.clear();
            this.op = DagTag.dtBad;
            return true;
        }
        if (this.child.contains(-p)) {
            this.child.clear();
            this.op = DagTag.dtBad;
            return true;
        }
        this.child.add(p);
        return false;
    }

    public int getAndToDagValue() {
        if (this.child.set.size() == 0) {
            return 1;
        }
        if (this.child.set.size() == 1) {
            return this.child.set.get(0);
        }
        return 0;
    }

    public void sortEntry(DLDag dag) {
        if (this.op != DagTag.dtAnd) {
            return;
        }
        this.child.setSorter(dag);
    }

    public void print(LeveLogger.LogAdapter o) {
        o.print(LeveLogger.Templates.DLVERTEXPrint, this.stat[0], this.stat[1], this.stat[2], this.stat[3], this.stat[4], this.stat[5], this.stat[6], this.stat[7], this.stat[8], this.stat[9], this.op.getName());
        switch (this.op) {
            case dtAnd: 
            case dtCollection: 
            case dtSplitConcept: {
                break;
            }
            case dtTop: 
            case dtUAll: 
            case dtNN: {
                return;
            }
            case dtDataExpr: {
                o.print(LeveLogger.Templates.SPACE, ((DataEntry)this.concept).getFacet());
                return;
            }
            case dtDataValue: 
            case dtDataType: 
            case dtPConcept: 
            case dtNConcept: 
            case dtPSingleton: 
            case dtNSingleton: {
                o.print(LeveLogger.Templates.DLVERTEXPrint2, this.concept.getName(), this.op.isNNameTag() ? "=" : "[=", this.conceptIndex);
                return;
            }
            case dtLE: {
                o.print(LeveLogger.Templates.SPACE, this.n);
                o.print(LeveLogger.Templates.SPACE, this.role.getName());
                o.print(LeveLogger.Templates.SPACE, this.conceptIndex);
                return;
            }
            case dtForall: {
                o.print(LeveLogger.Templates.DLVERTEXPrint3, this.role.getName(), this.n, this.conceptIndex);
                return;
            }
            case dtIrr: {
                o.print(LeveLogger.Templates.SPACE, this.role.getName());
                return;
            }
            case dtProj: {
                o.print(LeveLogger.Templates.DLVERTEXPrint4, this.role.getName(), this.conceptIndex, this.projRole.getName());
                return;
            }
            case dtChoose: {
                o.print(" ");
                o.print(this.getConceptIndex());
                return;
            }
            default: {
                throw new ReasonerInternalException(String.format("Error printing vertex of type %s(%s)", new Object[]{this.op.getName(), this.op}));
            }
        }
        for (int q : this.child.sorted()) {
            o.print(LeveLogger.Templates.SPACE, q);
        }
    }

    public String toString() {
        LeveLogger.LogAdapterStringBuilder l = new LeveLogger.LogAdapterStringBuilder();
        this.print(l);
        return ((Object)l).toString();
    }

    public void updateStatValues(int d, int s, int b, int g, boolean pos) {
        StatIndex.updateStatValues(d, s, b, g, pos, this.stat);
    }

    public void updateStatValues(DLVertex v, boolean posV, boolean pos) {
        StatIndex.updateStatValues(v, posV, pos, this.stat);
    }

    public void incFreqValue(boolean pos) {
        StatIndex.incFreqValue(pos, this.stat);
    }

    public int getStat(int i) {
        return this.stat[i];
    }

    public int getDepth(boolean pos) {
        return StatIndex.getDepth(pos, this.stat);
    }

    public long getUsage(boolean pos) {
        return pos ? this.posUsage : this.negUsage;
    }

    static class ChildSet {
        private Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (ChildSet.this.sorter.less(o1, o2)) {
                    return -1;
                }
                return 1;
            }
        };
        final FastSet set = FastSetFactory.create();
        private final SortedIntList original = new SortedIntList();
        int[] sorted = null;
        protected DLDag sorter = null;

        ChildSet() {
        }

        public boolean equals(Object arg0) {
            if (arg0 == null) {
                return false;
            }
            if (this == arg0) {
                return true;
            }
            if (arg0 instanceof ChildSet) {
                ChildSet arg = (ChildSet)arg0;
                return this.set.equals(arg.set);
            }
            return false;
        }

        public int hashCode() {
            return this.set.hashCode();
        }

        public void setSorter(DLDag d) {
            this.sorter = d;
            this.sorted = null;
        }

        public int[] sorted() {
            block5: {
                if (this.sorted != null) break block5;
                this.sorted = new int[this.set.size()];
                if (this.sorter == null) {
                    for (int i = 0; i < this.set.size(); ++i) {
                        this.sorted[i] = this.original.get(i);
                    }
                } else {
                    int i;
                    ArrayList<Integer> l = new ArrayList<Integer>();
                    for (i = 0; i < this.set.size(); ++i) {
                        l.add(this.set.get(i));
                    }
                    Collections.sort(l, this.c);
                    for (i = 0; i < this.sorted.length; ++i) {
                        this.sorted[i] = (Integer)l.get(i);
                    }
                }
            }
            return this.sorted;
        }

        public boolean contains(int inverse) {
            return this.set.contains(inverse);
        }

        public void clear() {
            this.set.clear();
            this.sorted = null;
        }

        public boolean add(int p) {
            int size = this.set.size();
            this.set.add(p);
            if (this.set.size() > size) {
                this.original.add(p);
                this.sorted = null;
                return true;
            }
            return false;
        }
    }
}

