/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.util.ArrayList;
import java.util.List;

public final class IntMap<V> {
    private List<Entry> values = new ArrayList<Entry>();
    int size = 0;

    public void clear() {
        this.values.clear();
        this.size = 0;
    }

    public boolean containsKey(int key) {
        boolean toReturn = this.insertionIndex(key) > -1;
        return toReturn;
    }

    private int insertionIndex(int key) {
        int lowerbound;
        if (this.size == 0) {
            return -1;
        }
        if (key < this.values.get((int)0).index) {
            return -1;
        }
        if (key > this.values.get((int)(this.size - 1)).index) {
            return -this.size() - 1;
        }
        if (this.size < 5) {
            for (lowerbound = 0; lowerbound < this.size; ++lowerbound) {
                int v = this.values.get((int)lowerbound).index;
                if (v == key) {
                    return lowerbound;
                }
                if (v <= key) continue;
                return -lowerbound - 1;
            }
            return -lowerbound - 1;
        }
        int upperbound = this.size - 1;
        while (lowerbound <= upperbound) {
            int intermediate = lowerbound + (upperbound - lowerbound) / 2;
            int v = this.values.get((int)intermediate).index;
            if (v == key) {
                return intermediate;
            }
            if (v < key) {
                lowerbound = intermediate + 1;
                continue;
            }
            upperbound = intermediate - 1;
        }
        return -lowerbound - 1;
    }

    public boolean containsValue(V value) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.values.get((int)i).value.equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(IntMap<V> c) {
        if (c.size == 0) {
            return true;
        }
        if (this.size == 0) {
            return false;
        }
        if (c.size > this.size) {
            return false;
        }
        if (this.values.get((int)0).index > c.values.get((int)0).index || this.values.get((int)(this.size - 1)).index < c.values.get((int)(c.size - 1)).index) {
            return false;
        }
        int i = 0;
        for (int j = 0; j < c.size; ++j) {
            int currentValue = c.values.get((int)j).index;
            boolean found = false;
            while (i < this.size) {
                if (this.values.get((int)i).index == currentValue) {
                    found = true;
                    break;
                }
                if (this.values.get((int)i).index > currentValue) {
                    return false;
                }
                ++i;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public List<Entry> entrySet() {
        return this.values;
    }

    public int index(int key) {
        return this.insertionIndex(key);
    }

    public V get(int key) {
        int index = this.insertionIndex(key);
        if (index < 0) {
            return null;
        }
        return this.values.get((int)index).value;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int[] keySet() {
        int[] keys = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            keys[i] = this.values.get((int)i).index;
        }
        return keys;
    }

    public void put(int key, V value) {
        int index = this.insertionIndex(key);
        if (index > -1) {
            this.values.get((int)index).value = value;
            return;
        }
        index = -index - 1;
        Entry e = new Entry();
        e.index = key;
        e.value = value;
        this.values.add(index, e);
        ++this.size;
    }

    public V remove(int key) {
        int index = this.insertionIndex(key);
        if (index > -1) {
            --this.size;
            return this.values.remove((int)index).value;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public int hashCode() {
        return ((Object)this.values).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntMap) {
            return ((Object)this.values).equals(((IntMap)obj).values);
        }
        return false;
    }

    public String toString() {
        return this.values.toString();
    }

    class Entry
    implements Comparable<Entry> {
        int index;
        V value;

        Entry() {
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof Entry) {
                return this.index == ((Entry)obj).index;
            }
            return false;
        }

        @Override
        public int compareTo(Entry arg0) {
            return this.index - arg0.index;
        }

        public String toString() {
            return "{" + this.index + " " + this.value + "}";
        }
    }
}

