/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.util.Arrays;
import uk.ac.manchester.cs.jfact.helpers.AbstractFastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetSimple;

public final class IntSet
extends AbstractFastSet {
    private static final int size = 17;
    FastSetSimple[] hashvalues = new FastSetSimple[17];
    private int[] allValues = null;

    private int hash(int value) {
        return Math.abs(value % 17);
    }

    @Override
    public void clear() {
        this.hashvalues = new FastSetSimple[17];
    }

    @Override
    public boolean contains(int key) {
        int hash = this.hash(key);
        if (this.hashvalues[hash] == null) {
            return false;
        }
        boolean b = this.hashvalues[hash].contains(key);
        return b;
    }

    @Override
    public void add(int e) {
        int hash = this.hash(e);
        if (this.hashvalues[hash] == null) {
            this.hashvalues[hash] = new FastSetSimple();
        }
        int previous = this.hashvalues[hash].size();
        this.hashvalues[hash].add(e);
        if (this.hashvalues[hash].size() != previous) {
            this.allValues = null;
        }
    }

    @Override
    public void addAll(FastSet c) {
        for (int i = 0; i < c.size(); ++i) {
            this.add(c.get(i));
        }
    }

    @Override
    public boolean containsAll(FastSet c) {
        if (c instanceof IntSet) {
            int i;
            IntSet set = (IntSet)c;
            for (i = 0; i < set.hashvalues.length; ++i) {
                if (set.hashvalues[i] == null || this.hashvalues[i] != null) continue;
                return false;
            }
            for (i = 0; i < set.hashvalues.length; ++i) {
                if (set.hashvalues[i] == null || this.hashvalues[i].containsAll(set.hashvalues[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < c.size(); ++i) {
                if (this.contains(c.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAny(FastSet c) {
        if (c instanceof IntSet) {
            IntSet set = (IntSet)c;
            for (int i = 0; i < set.hashvalues.length; ++i) {
                if (set.hashvalues[i] == null || this.hashvalues[i] == null || !this.hashvalues[i].containsAny(set.hashvalues[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < c.size(); ++i) {
                if (!this.contains(c.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void remove(int o) {
        int hash = this.hash(o);
        if (this.hashvalues[hash] == null) {
            return;
        }
        int previous = this.hashvalues[hash].size();
        this.hashvalues[hash].remove(o);
        if (this.hashvalues[hash].size() != previous) {
            this.allValues = null;
            if (this.hashvalues[hash].size() == 0) {
                this.hashvalues[hash] = null;
            }
        }
    }

    @Override
    public int[] toIntArray() {
        if (this.allValues == null) {
            int i = 0;
            for (FastSetSimple f : this.hashvalues) {
                if (f == null) continue;
                i += f.size();
            }
            this.allValues = new int[i];
            int j = 0;
            for (FastSetSimple f : this.hashvalues) {
                if (f == null) continue;
                for (int k = 0; k < f.size(); ++k) {
                    this.allValues[j] = f.get(k);
                    ++j;
                }
            }
            Arrays.sort(this.allValues);
        }
        return Arrays.copyOf(this.allValues, 17);
    }

    @Override
    public boolean intersect(FastSet f) {
        for (int i = 0; i < f.size(); ++i) {
            if (!this.contains(f.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int get(int i) {
        if (this.allValues == null) {
            this.toIntArray();
        }
        return this.allValues[i];
    }

    @Override
    public void removeAt(int o) {
        if (this.allValues == null) {
            this.toIntArray();
        }
        this.remove(this.allValues[o]);
        this.allValues = null;
    }

    @Override
    public void removeAll(int i, int end) {
        for (int j = i; j < end; ++j) {
            this.removeAt(j);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        int i = 0;
        for (FastSetSimple f : this.hashvalues) {
            if (f == null) continue;
            i += f.size();
        }
        return i;
    }

    @Override
    public void removeAllValues(int ... values) {
        for (int i : values) {
            this.remove(i);
        }
    }

    @Override
    public void completeSet(int value) {
        for (int i = 0; i <= value; ++i) {
            this.add(i);
        }
    }
}

