/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.util.ArrayList;
import java.util.Collection;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeVisitor;
import uk.ac.manchester.cs.jfact.helpers.DLTreeVisitorEx;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;

class NDLTree
extends DLTree {
    public NDLTree(Lexeme l, Collection<DLTree> trees) {
        super(l);
        this.children = new ArrayList();
        if (trees.size() < 2) {
            throw new RuntimeException("not enough elements in the n-ary element");
        }
        for (DLTree d : trees) {
            this.addChild(d);
        }
    }

    public NDLTree(Lexeme l, DLTree C, DLTree D) {
        super(l);
        this.children = new ArrayList();
        if (C == null || D == null) {
            throw new RuntimeException("not enough elements in the n-ary element");
        }
        this.addChild(C);
        this.addChild(D);
    }

    @Override
    public DLTree getChild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DLTree getLeft() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DLTree getRight() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(DLTreeVisitor v) {
        v.visit(this);
    }

    @Override
    public <O> O accept(DLTreeVisitorEx<O> v) {
        return v.visit(this);
    }

    @Override
    public void replace(DLTree toReplace, DLTree replacement) {
        if (this.children.contains(toReplace)) {
            this.children.remove(toReplace);
            if (replacement != null) {
                this.children.add(replacement);
                replacement.ancestor = this;
            }
        }
    }
}

