/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.util.Arrays;

public final class SortedIntList {
    protected int[] values;
    protected int size = 0;
    protected static final int defaultSize = 16;

    protected final int insertionIndex(int key) {
        if (this.size == 0) {
            return 0;
        }
        for (int i = 0; i < this.size; ++i) {
            if (key > this.values[i]) {
                return i;
            }
            if (key != this.values[i]) continue;
            return -1;
        }
        return this.size;
    }

    public final int get(int i) {
        if (this.values != null) {
            return this.values[i];
        }
        throw new IllegalArgumentException("Illegal argument " + i + ": no such element");
    }

    protected final void init() {
        this.values = new int[16];
        Arrays.fill(this.values, Integer.MIN_VALUE);
        this.size = 0;
    }

    public final void add(int e) {
        int pos = -1;
        if (this.values == null) {
            this.init();
        }
        if ((pos = this.insertionIndex(e)) < 0) {
            return;
        }
        int i = pos;
        if (i >= this.values.length || this.size >= this.values.length) {
            this.values = Arrays.copyOf(this.values, this.values.length + 16);
        }
        for (int j = this.size - 1; j >= i; --j) {
            this.values[j + 1] = this.values[j];
        }
        this.values[i] = e;
        ++this.size;
    }

    public final void clear() {
        this.values = null;
        this.size = 0;
    }

    public final boolean contains(int o) {
        if (this.values != null) {
            int i = this.insertionIndex(o);
            boolean toReturn = i > -1;
            return toReturn;
        }
        return false;
    }

    public final boolean isEmpty() {
        return this.values == null;
    }

    public final void remove(int o) {
        if (this.values == null) {
            return;
        }
        int i = this.insertionIndex(o);
        this.removeAt(i);
    }

    public final int size() {
        return this.size;
    }

    public final int[] toIntArray() {
        if (this.values == null) {
            return new int[0];
        }
        return Arrays.copyOf(this.values, this.size);
    }

    public final void removeAt(int i) {
        if (this.values == null) {
            return;
        }
        if (i > -1 && i < this.size) {
            if (this.size == 1) {
                this.values = null;
                this.size = 0;
                return;
            }
            for (int j = i; j < this.size - 1; ++j) {
                this.values[j] = this.values[j + 1];
            }
            --this.size;
        }
        if (this.size == 0) {
            this.values = null;
        }
    }
}

