/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.InAx;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Token;

public final class Axiom {
    private final LinkedHashSet<DLTree> disjuncts = new LinkedHashSet();

    public boolean absorbIntoNegConcept(TBox KB) {
        Concept Concept2;
        ArrayList<DLTree> Cons = new ArrayList<DLTree>();
        DLTree bestConcept = null;
        for (DLTree p : this.disjuncts) {
            if (p.token() != Token.NOT || !p.getChild().isName() || !(Concept2 = InAx.getConcept(p.getChild())).isPrimitive() || Concept2.isSingleton() || Concept2.getDescription() != null) continue;
            InAx.SAbsNAttempt();
            Cons.add(p);
        }
        if (Cons.isEmpty()) {
            return false;
        }
        InAx.SAbsNApply();
        if (bestConcept == null) {
            bestConcept = (DLTree)Cons.get(0);
        }
        Concept2 = InAx.getConcept(bestConcept.getChild());
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.print(" N-Absorb GCI to concept " + Concept2.getName());
            if (Cons.size() > 1) {
                LeveLogger.logger_absorption.print(" (other options are");
                for (int j = 1; j < Cons.size(); ++j) {
                    LeveLogger.logger_absorption.print(" " + InAx.getConcept(((DLTree)Cons.get(j)).getChild()).getName());
                }
                LeveLogger.logger_absorption.print(")");
            }
        }
        Concept nC = KB.getAuxConcept(this.createAnAxiom(bestConcept));
        KB.makeNonPrimitive(Concept2, DLTreeFactory.createSNFNot(KB.getTree(nC)));
        return true;
    }

    private Axiom copy(DLTree skip) {
        Axiom ret = new Axiom();
        for (DLTree i : this.disjuncts) {
            if (i.equals(skip)) continue;
            ret.disjuncts.add(i.copy());
        }
        return ret;
    }

    private Axiom simplifyPosNP(DLTree pos) {
        InAx.SAbsRepCN();
        Axiom ret = this.copy(pos);
        ret.add(DLTreeFactory.createSNFNot(InAx.getConcept(pos.getChild()).getDescription().copy()));
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.print(" simplify CN expression for " + pos.getChild());
        }
        return ret;
    }

    private Axiom simplifyNegNP(DLTree pos) {
        InAx.SAbsRepCN();
        Axiom ret = this.copy(pos);
        ret.add(InAx.getConcept(pos).getDescription().copy());
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.print(" simplify ~CN expression for " + pos);
        }
        return ret;
    }

    private List<Axiom> split(List<Axiom> acc, DLTree pos, DLTree pAnd) {
        if (pAnd.isAND()) {
            ArrayList<DLTree> children = new ArrayList<DLTree>(pAnd.getChildren());
            acc = this.split(acc, pos, (DLTree)children.remove(0));
            if (children.size() > 0) {
                acc = this.split(acc, pos, DLTreeFactory.createSNFAnd(children));
            }
        } else {
            Axiom ret = this.copy(pos);
            ret.add(DLTreeFactory.createSNFNot(pAnd.copy()));
            acc.add(ret);
        }
        return acc;
    }

    public List<Axiom> split() {
        List<Axiom> acc = new ArrayList<Axiom>();
        for (DLTree p : this.disjuncts) {
            if (!InAx.isAnd(p)) continue;
            InAx.SAbsSplit();
            if (LeveLogger.isAbsorptionActive()) {
                LeveLogger.logger_absorption.print(" split AND espression " + p.getChild());
            }
            acc = this.split(acc, p, p.getChildren().iterator().next());
            return acc;
        }
        return acc;
    }

    public void add(DLTree p) {
        if (InAx.isBot(p)) {
            return;
        }
        if (InAx.isOr(p)) {
            for (DLTree d : p.getChildren()) {
                this.add(d);
            }
            return;
        }
        this.disjuncts.add(p);
    }

    public void dump(LeveLogger.LogAdapter o) {
        o.print(" (neg-and");
        for (DLTree p : this.disjuncts) {
            o.print(p.toString());
        }
        o.print(")");
    }

    public Axiom simplifyCN() {
        for (DLTree p : this.disjuncts) {
            if (InAx.isPosNP(p)) {
                return this.simplifyPosNP(p);
            }
            if (!InAx.isNegNP(p)) continue;
            return this.simplifyNegNP(p);
        }
        return null;
    }

    public Axiom simplifyForall(TBox KB) {
        for (DLTree i : this.disjuncts) {
            if (!InAx.isAbsForall(i)) continue;
            return this.simplifyForall(i, KB);
        }
        return null;
    }

    private Axiom simplifyForall(DLTree pos, TBox KB) {
        InAx.SAbsRepForall();
        DLTree pAll = pos.getChild();
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.print(" simplify ALL expression" + pAll);
        }
        Axiom ret = this.copy(pos);
        ret.add(KB.getTree(KB.replaceForall(pAll.copy())));
        return ret;
    }

    public DLTree createAnAxiom(DLTree replaced) {
        assert (!this.disjuncts.isEmpty());
        ArrayList<DLTree> leaves = new ArrayList<DLTree>();
        for (DLTree d : this.disjuncts) {
            if (d.equals(replaced)) continue;
            leaves.add(d.copy());
        }
        DLTree result = DLTreeFactory.createSNFAnd(leaves);
        return DLTreeFactory.createSNFNot(result);
    }

    public boolean absorbIntoBottom() {
        ArrayList<DLTree> Pos = new ArrayList<DLTree>();
        ArrayList<DLTree> Neg = new ArrayList<DLTree>();
        block5: for (DLTree p : this.disjuncts) {
            switch (p.token()) {
                case BOTTOM: {
                    InAx.SAbsBApply();
                    return true;
                }
                case TOP: {
                    continue block5;
                }
                case NOT: {
                    Neg.add(p.getChild());
                    continue block5;
                }
            }
            Pos.add(p);
        }
        for (DLTree q : Neg) {
            for (DLTree s : Pos) {
                if (!q.equals(s)) continue;
                InAx.SAbsBApply();
                return true;
            }
        }
        return false;
    }

    public boolean absorbIntoConcept(TBox KB) {
        ArrayList<DLTree> Cons = new ArrayList<DLTree>();
        DLTree bestConcept = null;
        for (DLTree p : this.disjuncts) {
            if (!InAx.isNegPC(p)) continue;
            InAx.SAbsCAttempt();
            Cons.add(p);
            if (!InAx.getConcept(p).isSystem()) continue;
            bestConcept = p;
        }
        if (Cons.isEmpty()) {
            return false;
        }
        InAx.SAbsCApply();
        if (bestConcept == null) {
            bestConcept = (DLTree)Cons.get(0);
        }
        Concept Concept2 = InAx.getConcept(bestConcept);
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.print(" C-Absorb GCI to concept " + Concept2.getName());
            if (Cons.size() > 1) {
                LeveLogger.logger_absorption.print(" (other options are");
                for (int j = 1; j < Cons.size(); ++j) {
                    LeveLogger.logger_absorption.print(" " + InAx.getConcept((DLTree)Cons.get(j)).getName());
                }
                LeveLogger.logger_absorption.print(")");
            }
        }
        Concept2.addDesc(this.createAnAxiom(bestConcept));
        Concept2.removeSelfFromDescription();
        KB.clearRelevanceInfo();
        KB.checkToldCycle(Concept2);
        KB.clearRelevanceInfo();
        return true;
    }

    public boolean absorbIntoDomain() {
        ArrayList<DLTree> Cons = new ArrayList<DLTree>();
        DLTree bestSome = null;
        for (DLTree p : this.disjuncts) {
            if (p.token() != Token.NOT || p.getChild().token() != Token.FORALL && p.getChild().token() != Token.LE) continue;
            InAx.SAbsRAttempt();
            Cons.add(p);
            if (!p.getChild().getRight().isBOTTOM()) continue;
            bestSome = p;
            break;
        }
        if (Cons.isEmpty()) {
            return false;
        }
        InAx.SAbsRApply();
        Role role = bestSome != null ? Role.resolveRole(bestSome.getChild().getLeft()) : Role.resolveRole(((DLTree)Cons.get(0)).getChild().getLeft());
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.print(" R-Absorb GCI to the domain of role " + role.getName());
            if (Cons.size() > 1) {
                LeveLogger.logger_absorption.print(" (other options are");
                for (int j = 1; j < Cons.size(); ++j) {
                    LeveLogger.logger_absorption.print(" " + Role.resolveRole(((DLTree)Cons.get(j)).getChild().getLeft()).getName());
                }
                LeveLogger.logger_absorption.print(")");
            }
        }
        role.setDomain(this.createAnAxiom(bestSome));
        return true;
    }

    public boolean absorbIntoTop(TBox KB) {
        Concept C = null;
        for (DLTree p : this.disjuncts) {
            if (InAx.isBot(p)) continue;
            if (InAx.isPosCN(p)) {
                if (C != null) {
                    return false;
                }
                C = InAx.getConcept(p.getChild());
                if (!C.isSingleton()) continue;
                return false;
            }
            return false;
        }
        if (C == null) {
            return false;
        }
        InAx.SAbsTApply();
        DLTree desc = KB.makeNonPrimitive(C, DLTreeFactory.createTop());
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.println("TAxiom.absorbIntoTop() T-Absorb GCI to axiom");
            if (desc != null) {
                LeveLogger.logger_absorption.println("s *TOP* [=" + desc + " and");
            }
            LeveLogger.logger.println(" " + C.getName() + " = *TOP*");
        }
        if (desc != null) {
            KB.addSubsumeAxiom(DLTreeFactory.createTop(), desc);
        }
        return true;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof Axiom) {
            Axiom ax = (Axiom)arg0;
            return this.disjuncts.equals(ax.disjuncts);
        }
        return false;
    }

    public int hashCode() {
        return this.disjuncts.hashCode();
    }
}

