/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.Axiom;
import uk.ac.manchester.cs.jfact.kernel.InAx;
import uk.ac.manchester.cs.jfact.kernel.TBox;

public final class AxiomSet {
    protected final TBox tboxHost;
    private List<Axiom> accumulator = new ArrayList<Axiom>();
    private final List<Abs> actions = new ArrayList<Abs>();

    private void insertGCI(Axiom p) {
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.print("\n new axiom (" + this.accumulator.size() + "):");
            p.dump(LeveLogger.logger_absorption);
        }
        this.accumulator.add(p);
    }

    private boolean insertIfNew(Axiom q) {
        if (!this.accumulator.contains(q)) {
            this.insertGCI(q);
            return false;
        }
        return true;
    }

    protected boolean processNewAxiom(Axiom q) {
        if (q == null) {
            return false;
        }
        return !this.insertIfNew(q);
    }

    public AxiomSet(TBox host) {
        this.tboxHost = host;
    }

    public void addAxiom(DLTree C, DLTree D) {
        InAx.SAbsInput();
        Axiom p = new Axiom();
        p.add(C);
        p.add(DLTreeFactory.createSNFNot(D));
        this.insertGCI(p);
    }

    private int size() {
        return this.accumulator.size();
    }

    public boolean wasRoleAbsorptionApplied() {
        String string = "SAbsRApply";
        return InAx.created.containsKey(string);
    }

    public DLTree getGCI() {
        ArrayList<DLTree> l = new ArrayList<DLTree>();
        for (Axiom p : this.accumulator) {
            l.add(p.createAnAxiom(null));
        }
        return DLTreeFactory.createSNFAnd(l);
    }

    protected boolean split(Axiom p) {
        List<Axiom> splitted = p.split();
        if (splitted.isEmpty()) {
            return false;
        }
        for (Axiom q : splitted) {
            if (!this.accumulator.contains(q)) continue;
            return false;
        }
        for (Axiom q : splitted) {
            this.insertGCI(q);
        }
        return true;
    }

    public int absorb() {
        ArrayList<Axiom> GCIs = new ArrayList<Axiom>();
        for (int i = 0; i < this.accumulator.size(); ++i) {
            Axiom ax = this.accumulator.get(i);
            if (LeveLogger.isAbsorptionActive()) {
                LeveLogger.logger_absorption.print("\nProcessing (" + i++ + "):");
            }
            if (this.absorbGCI(ax)) continue;
            GCIs.add(ax);
        }
        this.accumulator = GCIs;
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.print("\nAbsorption done with " + this.accumulator.size() + " GCIs left\n");
        }
        this.printStatistics();
        return this.size();
    }

    private boolean absorbGCI(Axiom p) {
        InAx.SAbsAction();
        for (Abs abs : this.actions) {
            if (!abs.absMethod(p)) continue;
            return true;
        }
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.print(" keep as GCI");
        }
        return false;
    }

    public boolean initAbsorptionFlags(String flags) {
        this.actions.clear();
        block10: for (char c : flags.toCharArray()) {
            switch (c) {
                case 'B': {
                    this.actions.add(new Abs(){

                        @Override
                        public boolean absMethod(Axiom ax) {
                            return ax.absorbIntoBottom();
                        }
                    });
                    continue block10;
                }
                case 'T': {
                    this.actions.add(new Abs(){

                        @Override
                        public boolean absMethod(Axiom ax) {
                            return ax.absorbIntoTop(AxiomSet.this.tboxHost);
                        }
                    });
                    continue block10;
                }
                case 'E': {
                    this.actions.add(new Abs(){

                        @Override
                        public boolean absMethod(Axiom ax) {
                            return AxiomSet.this.processNewAxiom(ax.simplifyCN());
                        }
                    });
                    continue block10;
                }
                case 'C': {
                    this.actions.add(new Abs(){

                        @Override
                        public boolean absMethod(Axiom ax) {
                            return ax.absorbIntoConcept(AxiomSet.this.tboxHost);
                        }
                    });
                    continue block10;
                }
                case 'N': {
                    this.actions.add(new Abs(){

                        @Override
                        public boolean absMethod(Axiom ax) {
                            return ax.absorbIntoNegConcept(AxiomSet.this.tboxHost);
                        }
                    });
                    continue block10;
                }
                case 'F': {
                    this.actions.add(new Abs(){

                        @Override
                        public boolean absMethod(Axiom ax) {
                            return AxiomSet.this.processNewAxiom(ax.simplifyForall(AxiomSet.this.tboxHost));
                        }
                    });
                    continue block10;
                }
                case 'R': {
                    this.actions.add(new Abs(){

                        @Override
                        public boolean absMethod(Axiom ax) {
                            return ax.absorbIntoDomain();
                        }
                    });
                    continue block10;
                }
                case 'S': {
                    this.actions.add(new Abs(){

                        @Override
                        public boolean absMethod(Axiom ax) {
                            return AxiomSet.this.split(ax);
                        }
                    });
                    continue block10;
                }
                default: {
                    return true;
                }
            }
        }
        LeveLogger.logger.print("Init absorption order as ");
        LeveLogger.logger.println(flags);
        return false;
    }

    private void printStatistics() {
        if (!InAx.created.containsKey("SAbsAction")) {
            return;
        }
        LeveLogger.logger.print("\nAbsorption dealt with " + InAx.get("SAbsInput") + " input axioms\nThere were made " + InAx.get("SAbsAction") + " absorption actions, of which:");
        if (InAx.get("SAbsRepCN") > 0) {
            LeveLogger.logger.print("\n\t" + InAx.get("SAbsRepCN") + " concept name replacements");
        }
        if (InAx.get("SAbsRepForall") > 0) {
            LeveLogger.logger.print("\n\t" + InAx.get("SAbsRepForall") + " universals replacements");
        }
        if (InAx.get("SAbsSplit") > 0) {
            LeveLogger.logger.print("\n\t" + InAx.get("SAbsSplit") + " conjunction splits");
        }
        if (InAx.get("SAbsBApply") > 0) {
            LeveLogger.logger.print("\n\t" + InAx.get("SAbsBApply") + " BOTTOM absorptions");
        }
        if (InAx.get("SAbsTApply") > 0) {
            LeveLogger.logger.print("\n\t" + InAx.get("SAbsTApply") + " TOP absorptions");
        }
        if (InAx.get("SAbsCApply") > 0) {
            LeveLogger.logger.print("\n\t" + InAx.get("SAbsCApply") + " concept absorption with " + InAx.get("SAbsCAttempt") + " possibilities");
        }
        if (InAx.get("SAbsNApply") > 0) {
            LeveLogger.logger.print("\n\t" + InAx.get("SAbsNApply") + " negated concept absorption with " + InAx.get("SAbsNAttempt") + " possibilities");
        }
        if (InAx.get("SAbsRApply") > 0) {
            LeveLogger.logger.print("\n\t" + InAx.get("SAbsRApply") + " role domain absorption with " + InAx.get("SAbsRAttempt") + " possibilities");
        }
        if (!this.accumulator.isEmpty()) {
            LeveLogger.logger.print("\nThere are " + this.accumulator.size() + " GCIs left");
        }
    }

    private static interface Abs {
        public boolean absMethod(Axiom var1);
    }
}

