/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import uk.ac.manchester.cs.jfact.helpers.ArrayIntMap;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.CWDArray;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.state.SaveState;

public final class CGLabel {
    private static int idcounter = 0;
    private final CWDArray scLabel;
    private final CWDArray ccLabel;
    private final int id;
    private final Set<CGLabel> lesserEquals = Collections.newSetFromMap(new IdentityHashMap());

    private static int getnewId() {
        return idcounter++;
    }

    public CGLabel() {
        this.scLabel = new CWDArray();
        this.ccLabel = new CWDArray();
        this.id = CGLabel.getnewId();
    }

    public List<ConceptWDep> get_sc() {
        return this.scLabel.getBase();
    }

    public List<ConceptWDep> get_cc() {
        return this.ccLabel.getBase();
    }

    public ArrayIntMap get_sc_concepts() {
        return this.scLabel.getContainedConcepts();
    }

    public ArrayIntMap get_cc_concepts() {
        return this.ccLabel.getContainedConcepts();
    }

    public CWDArray getLabel(DagTag tag) {
        return tag.isComplexConcept() ? this.ccLabel : this.scLabel;
    }

    public void add(DagTag tag, ConceptWDep p) {
        this.getLabel(tag).private_add(p);
        this.clearMyCache();
    }

    protected final void clearMyCache() {
        this.lesserEquals.clear();
    }

    protected final void clearOthersCache() {
        for (CGLabel c : this.lesserEquals) {
            c.lesserEquals.remove(this);
        }
    }

    public boolean containsCC(int p) {
        return this.ccLabel.contains(p);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean lesserequal(CGLabel label) {
        boolean toReturn;
        if (this == label) {
            return true;
        }
        if (this.lesserEquals.contains(label)) {
            return true;
        }
        boolean bl = toReturn = this.scLabel.lesserequal(label.scLabel) && this.ccLabel.lesserequal(label.ccLabel);
        if (toReturn) {
            this.lesserEquals.add(label);
        }
        return toReturn;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof CGLabel) {
            CGLabel obj2 = (CGLabel)obj;
            boolean toReturn = this.scLabel.equals(obj2.scLabel) && this.ccLabel.equals(obj2.ccLabel);
            return toReturn;
        }
        return false;
    }

    public void save(SaveState ss) {
        ss.setSc(this.scLabel.save());
        ss.setCc(this.ccLabel.save());
    }

    public final void restore(SaveState ss, int level) {
        this.scLabel.restore(ss.getSc(), level);
        this.ccLabel.restore(ss.getCc(), level);
        this.clearOthersCache();
    }

    public void print(LeveLogger.LogAdapter o) {
        this.scLabel.print(o);
        this.ccLabel.print(o);
    }

    public String toString() {
        LeveLogger.LogAdapterStringBuilder l = new LeveLogger.LogAdapterStringBuilder();
        this.print(l);
        return ((Object)l).toString();
    }

    public final void init() {
        this.clearOthersCache();
        this.clearMyCache();
        this.scLabel.init();
        this.ccLabel.init();
    }

    public boolean contains(int p) {
        assert (Helper.isCorrect(p));
        if (p == 1) {
            return true;
        }
        if (p == -1) {
            return false;
        }
        boolean b = this.scLabel.contains(p) || this.ccLabel.contains(p);
        return b;
    }

    public ConceptWDep getConceptWithBP(int bp) {
        ConceptWDep toReturn = this.scLabel.getConceptWithBP(bp);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = this.ccLabel.getConceptWithBP(bp);
        return toReturn;
    }

    public int baseSize() {
        return this.ccLabel.size() + this.scLabel.size();
    }

    public int getId() {
        return this.id;
    }
}

