/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.ArrayIntMap;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.UnMerge;

public final class CWDArray {
    private static final double distribution = 0.025;
    private final List<ConceptWDep> base = new ArrayList<ConceptWDep>();
    private BitSet cache;
    private final ArrayIntMap indexes = new ArrayIntMap();
    private boolean createCache = false;
    private static final int cacheLimit = 1;
    private int size = 0;

    public void init() {
        this.base.clear();
        this.cache = null;
        this.indexes.clear();
        this.createCache = false;
        this.size = 0;
    }

    public List<ConceptWDep> getBase() {
        return this.base;
    }

    public ArrayIntMap getContainedConcepts() {
        return this.indexes;
    }

    protected void private_add(ConceptWDep p) {
        this.base.add(p);
        ++this.size;
        if (this.cache != null) {
            this.cache.set(this.asPositive(p.getConcept()));
        }
        this.indexes.put(p.getConcept(), this.size - 1);
        int span = Math.max(this.asPositive(this.indexes.keySet(0)), this.indexes.keySet(this.indexes.size() - 1));
        this.createCache = this.size > 1 && (double)this.size / (double)(span + 1) > 0.025;
    }

    public boolean contains(int bp) {
        if (this.cache == null && this.createCache) {
            this.initCache();
        }
        if (this.cache != null) {
            return this.cache.get(this.asPositive(bp));
        }
        return this.indexes.containsKey(bp);
    }

    private void initCache() {
        this.cache = new BitSet();
        for (int i = 0; i < this.indexes.size(); ++i) {
            this.cache.set(this.asPositive(this.indexes.keySet(i)));
        }
    }

    final int asPositive(int p) {
        return p >= 0 ? 2 * p : 1 - 2 * p;
    }

    public int index(int bp) {
        if (this.cache != null && !this.cache.get(this.asPositive(bp))) {
            return -1;
        }
        return this.indexes.get(bp);
    }

    public DepSet get(int bp) {
        if (this.cache != null && !this.cache.get(this.asPositive(bp))) {
            return null;
        }
        int i = this.indexes.get(bp);
        if (i < 0) {
            return null;
        }
        return this.base.get(i).getDep();
    }

    public ConceptWDep getConceptWithBP(int bp) {
        if (this.cache != null && !this.cache.get(this.asPositive(bp))) {
            return null;
        }
        int i = this.indexes.get(bp);
        if (i < 0) {
            return null;
        }
        return this.base.get(i);
    }

    public int size() {
        return this.size;
    }

    public boolean lesserequal(CWDArray label) {
        if (label.cache != null) {
            for (int i = 0; i < this.indexes.size(); ++i) {
                if (label.cache.get(this.asPositive(this.indexes.keySet(i)))) continue;
                return false;
            }
            return true;
        }
        return label.indexes.containsAll(this.indexes);
    }

    public int hashCode() {
        return this.indexes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof CWDArray) {
            CWDArray obj2 = (CWDArray)obj;
            return this.indexes.equals(obj2.indexes);
        }
        return false;
    }

    public int save() {
        return this.size;
    }

    public Restorer updateDepSet(int index, DepSet dep) {
        if (dep.isEmpty()) {
            throw new IllegalArgumentException();
        }
        UnMerge ret = new UnMerge(this, this.base.get(index), index);
        this.base.get(index).addDep(dep);
        return ret;
    }

    public List<Restorer> updateDepSet(DepSet dep) {
        if (dep.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Restorer> toReturn = new ArrayList<Restorer>(this.size);
        for (int i = 0; i < this.size; ++i) {
            UnMerge ret = new UnMerge(this, this.base.get(i), i);
            this.base.get(i).addDep(dep);
            toReturn.add(ret);
        }
        return toReturn;
    }

    public void restore(int ss, int level) {
        for (int i = ss; i < this.size; ++i) {
            int concept = this.base.get(i).getConcept();
            this.indexes.remove(concept);
            if (this.cache == null) continue;
            this.cache.clear(this.asPositive(concept));
        }
        Helper.resize(this.base, ss);
        this.size = ss;
    }

    public void print(LeveLogger.LogAdapter o) {
        o.print(" [");
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                o.print(", ");
            }
            this.base.get(i).print(o);
        }
        o.print("]");
    }

    public String toString() {
        LeveLogger.LogAdapterStringBuilder b = new LeveLogger.LogAdapterStringBuilder();
        this.print(b);
        return b.toString();
    }
}

