/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;

public class ClassifiableEntry
extends NamedEntry {
    protected TaxonomyVertex taxVertex = null;
    protected final LinkedHashSet<ClassifiableEntry> toldSubsumers = new LinkedHashSet();
    protected ClassifiableEntry pSynonym = null;
    protected int index = 0;
    private boolean completelyDefined;
    private boolean nonClassifiable;

    protected ClassifiableEntry(String name) {
        super(name);
    }

    public final boolean isClassified() {
        return this.taxVertex != null;
    }

    public final void setTaxVertex(TaxonomyVertex vertex) {
        this.taxVertex = vertex;
    }

    public final TaxonomyVertex getTaxVertex() {
        return this.taxVertex;
    }

    public final boolean isCompletelyDefined() {
        return this.completelyDefined;
    }

    public final void clearCompletelyDefined() {
        this.completelyDefined = false;
    }

    public final void setCompletelyDefined(boolean action) {
        this.completelyDefined = action;
    }

    public final boolean isNonClassifiable() {
        return this.nonClassifiable;
    }

    public final void setNonClassifiable() {
        this.nonClassifiable = true;
    }

    public final void clearNonClassifiable() {
        this.nonClassifiable = false;
    }

    public final void setNonClassifiable(boolean action) {
        this.nonClassifiable = action;
    }

    public final Collection<ClassifiableEntry> getToldSubsumers() {
        return this.toldSubsumers;
    }

    public final boolean hasToldSubsumers() {
        return !this.toldSubsumers.isEmpty();
    }

    public final void addParent(ClassifiableEntry parent) {
        this.toldSubsumers.add(parent);
    }

    public final void addParents(Collection<ClassifiableEntry> entries) {
        for (ClassifiableEntry c : entries) {
            this.addParentIfNew(c);
        }
    }

    public final int index() {
        return this.index;
    }

    public void setIndex(int ind) {
        this.index = ind;
    }

    public final boolean isSynonym() {
        return this.pSynonym != null;
    }

    public final ClassifiableEntry getSynonym() {
        return this.pSynonym;
    }

    public final void canonicaliseSynonym() {
        if (this.isSynonym()) {
            while (this.pSynonym.isSynonym()) {
                this.pSynonym = this.pSynonym.pSynonym;
            }
        }
    }

    public final void setSynonym(ClassifiableEntry syn) {
        assert (this.pSynonym == null);
        HashSet<ClassifiableEntry> set = new HashSet<ClassifiableEntry>();
        set.add(this);
        ClassifiableEntry runner = syn;
        while (runner.isSynonym() && !set.contains(runner.pSynonym)) {
            set.add(runner.pSynonym);
            runner = runner.pSynonym;
        }
        if (set.contains(runner.pSynonym)) {
            System.out.println("ClassifiableEntry.setSynonym(): warning: assigning this synonym would create a loop; ignored\nignored synonym: " + this + " -> " + syn + "\nPrevious synonyms: " + set);
        } else {
            this.pSynonym = syn;
            this.canonicaliseSynonym();
        }
    }

    public final void removeSynonymsFromParents() {
        ArrayList<ClassifiableEntry> toRemove = new ArrayList<ClassifiableEntry>();
        for (ClassifiableEntry c : this.toldSubsumers) {
            if (this != ClassifiableEntry.resolveSynonym(c)) continue;
            toRemove.add(c);
        }
        this.toldSubsumers.removeAll(toRemove);
    }

    public static final <T extends ClassifiableEntry> T resolveSynonym(T p) {
        return (T)(p == null ? null : (p.isSynonym() ? ClassifiableEntry.resolveSynonym(p.pSynonym) : (ClassifiableEntry)p));
    }

    public final void addParentIfNew(ClassifiableEntry parent) {
        if ((parent = ClassifiableEntry.resolveSynonym(parent)) == this) {
            return;
        }
        this.toldSubsumers.add(parent);
    }
}

