/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.LogicFeatures;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Token;

public class Concept
extends ClassifiableEntry {
    private long rel = 0L;
    private CTTag classTag;
    private int tsDepth = 0;
    private int pName = 0;
    private int pBody = 0;
    private final LogicFeatures posFeatures = new LogicFeatures();
    private final LogicFeatures negFeatures = new LogicFeatures();
    private final FastSet extraRules = FastSetFactory.create();
    protected DLTree description;
    private static final EnumSet<Token> replacements = EnumSet.of(Token.CNAME, Token.INAME, Token.RNAME, Token.DNAME);
    private boolean primitive;
    private boolean hasSP;
    private boolean nominal;

    public static final Concept getBOTTOM() {
        Concept toReturn = new Concept("BOTTOM");
        toReturn.setBottom();
        toReturn.setId(-1);
        toReturn.setpName(-1);
        toReturn.setpBody(-1);
        return toReturn;
    }

    public static final Concept getTOP() {
        Concept toReturn = new Concept("TOP");
        toReturn.setTop();
        toReturn.setId(-1);
        toReturn.setpName(1);
        toReturn.setpBody(1);
        toReturn.setTsDepth(1);
        toReturn.setClassTag(CTTag.cttTrueCompletelyDefined);
        return toReturn;
    }

    public static Concept getTEMP() {
        Concept TEMP = new Concept(" ");
        TEMP.setId(-1);
        TEMP.setTsDepth(1);
        TEMP.setClassTag(CTTag.cttTrueCompletelyDefined);
        return TEMP;
    }

    private boolean addToldSubsumer(Concept p) {
        if (p != this) {
            this.addParentIfNew(p);
            if (p.isSingleton() || p.isHasSP()) {
                this.setHasSP(true);
            }
        }
        return p.isPrimitive();
    }

    public Concept(String name) {
        super(name);
        this.classTag = CTTag.cttUnspecified;
        this.setPrimitive();
    }

    public void addExtraRule(int p) {
        this.extraRules.add(p);
        this.setCompletelyDefined(false);
    }

    public boolean hasExtraRules() {
        return !this.extraRules.isEmpty();
    }

    public FastSet getExtraRules() {
        return this.extraRules;
    }

    public boolean isSingleton() {
        return false;
    }

    public CTTag getClassTagPlain() {
        return this.classTag;
    }

    public CTTag getClassTag() {
        if (this.classTag == CTTag.cttUnspecified) {
            this.classTag = this.determineClassTag();
        }
        return this.classTag;
    }

    public void removeSelfFromDescription() {
        this.description = this.replaceWithConstOld(this.description);
        this.initToldSubsumers();
    }

    public void removeDescription() {
        this.description = null;
    }

    public boolean canInitNonPrim(DLTree desc) {
        if (this.description == null) {
            return true;
        }
        return this.isNonPrimitive() && this.description.equals(desc);
    }

    public DLTree makeNonPrimitive(DLTree desc) {
        DLTree ret = this.description;
        this.removeDescription();
        this.addDesc(desc);
        this.setPrimitive(false);
        return ret;
    }

    @Override
    public String toString() {
        return this.extName;
    }

    public void initToldSubsumers() {
        boolean CD;
        this.toldSubsumers.clear();
        this.setHasSP(false);
        if (this.isPrimitive() && this.description != null && this.description.isTOP()) {
            this.removeDescription();
        }
        boolean bl = CD = !this.hasExtraRules() && this.isPrimitive();
        if (this.description != null) {
            CD &= this.initToldSubsumers(this.description, new HashSet<Role>());
        }
        this.setCompletelyDefined(CD);
    }

    public void setToldTop(Concept top) {
        if (this.description == null && !this.hasToldSubsumers()) {
            this.addParent(top);
        }
    }

    public int resolveId() {
        Concept r;
        if (this.pName == 0) {
            return this.pBody;
        }
        if (this.isSynonym() && (r = Concept.resolveSynonym(this)) != this) {
            return r.resolveId();
        }
        return this.pName;
    }

    public void addDesc(DLTree Desc) {
        if (Desc == null) {
            return;
        }
        assert (!this.isNonPrimitive());
        if (this.description == null) {
            this.description = Desc.copy();
            return;
        }
        if (Desc.isAND()) {
            if (this.description.isAND()) {
                this.description.addFirstChildren(Desc.getChildren());
            } else {
                DLTree temp = this.description;
                this.description = Desc.copy();
                this.description.addChild(temp);
            }
        } else if (this.description.isAND()) {
            this.description.addFirstChild(Desc);
        } else {
            this.description = DLTreeFactory.createSNFAnd(Desc, this.description);
        }
    }

    public void addLeaves(Collection<DLTree> Desc) {
        assert (!this.isNonPrimitive());
        if (this.description == null) {
            this.description = DLTreeFactory.createSNFAnd(Desc);
        } else if (this.description.isAND()) {
            for (DLTree d : Desc) {
                this.description.addChild(d);
            }
        } else {
            ArrayList<DLTree> l = new ArrayList<DLTree>(Desc);
            l.add(this.description);
            this.description = DLTreeFactory.createSNFAnd(l);
        }
    }

    private CTTag determineClassTag() {
        if (this.isSynonym()) {
            return Concept.resolveSynonym(this).getClassTag();
        }
        if (this.isNonPrimitive()) {
            return CTTag.cttNonPrimitive;
        }
        if (!this.hasToldSubsumers()) {
            return CTTag.cttOrphan;
        }
        boolean hasLCD = false;
        boolean hasOther = false;
        boolean hasNP = false;
        block6: for (ClassifiableEntry p : this.toldSubsumers) {
            switch (((Concept)p).getClassTag()) {
                case cttTrueCompletelyDefined: {
                    continue block6;
                }
                case cttOrphan: 
                case cttLikeCompletelyDefined: {
                    hasLCD = true;
                    continue block6;
                }
                case cttRegular: {
                    hasOther = true;
                    continue block6;
                }
                case cttHasNonPrimitiveTS: 
                case cttNonPrimitive: {
                    hasNP = true;
                    continue block6;
                }
            }
            throw new UnreachableSituationException();
        }
        if (hasNP) {
            return CTTag.cttHasNonPrimitiveTS;
        }
        if (hasOther || !this.isCompletelyDefined()) {
            return CTTag.cttRegular;
        }
        if (hasLCD) {
            return CTTag.cttLikeCompletelyDefined;
        }
        return CTTag.cttTrueCompletelyDefined;
    }

    public void push(LinkedList<DLTree> stack, DLTree current) {
        for (DLTree t : current.getChildren()) {
            if (t == null) continue;
            stack.push(t);
        }
    }

    private DLTree replaceWithConstOld(DLTree t) {
        if (t == null) {
            return null;
        }
        Token token = t.token();
        if (replacements.contains((Object)token) && Concept.resolveSynonym((ClassifiableEntry)t.elem().getNE()).equals(this)) {
            return DLTreeFactory.createTop();
        }
        if (token == Token.AND) {
            ArrayList<DLTree> l = new ArrayList<DLTree>();
            for (DLTree d : t.getChildren()) {
                l.add(this.replaceWithConstOld(d));
            }
            return DLTreeFactory.createSNFAnd(l, t);
        }
        if (token == Token.NOT && (t.getChild().isAND() || replacements.contains((Object)t.getChild().token()))) {
            return DLTreeFactory.createSNFNot(this.replaceWithConstOld(t.getChild()));
        }
        return t;
    }

    public boolean initToldSubsumers(DLTree _desc, Set<Role> RolesProcessed) {
        if (_desc == null || _desc.isTOP()) {
            return true;
        }
        DLTree desc = _desc;
        Token token = desc.token();
        if (replacements.contains((Object)token)) {
            return this.addToldSubsumer((Concept)desc.elem().getNE());
        }
        if (token == Token.NOT) {
            if (desc.getChild().token() == Token.FORALL || desc.getChild().token() == Token.LE) {
                this.searchTSbyRoleAndSupers(Role.resolveRole(desc.getChild().getLeft()), RolesProcessed);
            }
            return false;
        }
        if (token == Token.SELF) {
            Role R = Role.resolveRole(desc.getChild());
            this.searchTSbyRoleAndSupers(R, RolesProcessed);
            this.searchTSbyRoleAndSupers(R.inverse(), RolesProcessed);
            return false;
        }
        if (token == Token.AND) {
            boolean toReturn = true;
            for (DLTree t : desc.getChildren()) {
                toReturn &= this.initToldSubsumers(t, RolesProcessed);
            }
            return toReturn;
        }
        return false;
    }

    private void searchTSbyRole(Role R, Set<Role> rolesProcessed) {
        if (rolesProcessed.contains(R)) {
            return;
        }
        DLTree Domain = R.getTDomain();
        if (Domain == null || Domain.isConst()) {
            return;
        }
        rolesProcessed.add(R);
        this.initToldSubsumers(Domain, rolesProcessed);
    }

    public void searchTSbyRoleAndSupers(Role r, Set<Role> RolesProcessed) {
        this.searchTSbyRole(r, RolesProcessed);
        List<Role> list = r.getAncestor();
        for (int i = 0; i < list.size(); ++i) {
            Role q = list.get(i);
            this.searchTSbyRole(q, RolesProcessed);
        }
    }

    public int calculateTSDepth() {
        if (this.tsDepth > 0) {
            return this.tsDepth;
        }
        int max = 0;
        for (ClassifiableEntry p : this.toldSubsumers) {
            int cur;
            if (p.getToldSubsumers().contains(this) || max >= (cur = ((Concept)p).calculateTSDepth())) continue;
            max = cur;
        }
        this.tsDepth = max + 1;
        return this.tsDepth;
    }

    public int getpName() {
        return this.pName;
    }

    public void setpName(int pName) {
        this.pName = pName;
    }

    public int getpBody() {
        return this.pBody;
    }

    public void setpBody(int pBody) {
        this.pBody = pBody;
    }

    public DLTree getDescription() {
        return this.description;
    }

    public int getTsDepth() {
        return this.tsDepth;
    }

    private void setTsDepth(int tsDepth) {
        this.tsDepth = tsDepth;
    }

    public LogicFeatures getNegFeatures() {
        return this.negFeatures;
    }

    public LogicFeatures getPosFeatures() {
        return this.posFeatures;
    }

    private void setClassTag(CTTag classTag) {
        this.classTag = classTag;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public void setPrimitive() {
        this.primitive = true;
    }

    public void clearPrimitive() {
        this.primitive = false;
    }

    public void setPrimitive(boolean action) {
        this.primitive = action;
    }

    public boolean isHasSP() {
        return this.hasSP;
    }

    public void setHasSP(boolean action) {
        this.hasSP = action;
    }

    public boolean isNominal() {
        return this.nominal;
    }

    public void setNominal(boolean action) {
        this.nominal = action;
    }

    public boolean isNonPrimitive() {
        return !this.isPrimitive();
    }

    public boolean isRelevant(long lab) {
        return lab == this.rel;
    }

    public void setRelevant(long lab) {
        this.rel = lab;
    }

    public void dropRelevant(long lab) {
        this.rel = 0L;
    }

    public static enum CTTag {
        cttUnspecified('u'),
        cttTrueCompletelyDefined('T'),
        cttOrphan('O'),
        cttLikeCompletelyDefined('L'),
        cttHasNonPrimitiveTS('N'),
        cttRegular('r'),
        cttNonPrimitive('n');

        private final char c;

        private CTTag(char c) {
            this.c = c;
        }

        protected char getCTTagName() {
            return this.c;
        }
    }
}

