/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import uk.ac.manchester.cs.jfact.helpers.IfDefs;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBFlags;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.split.TSplitVar;
import uk.ac.manchester.cs.jfact.split.TSplitVars;

public final class DLConceptTaxonomy
extends Taxonomy {
    TSplitVars Splits;
    boolean inSplitCheck;
    private final TBox tBox;
    private final List<TaxonomyVertex> common = new ArrayList<TaxonomyVertex>();
    private long nConcepts;
    private long nTries;
    private long nPositives;
    private long nNegatives;
    private long nSearchCalls;
    private long nSubCalls;
    private long nNonTrivialSubCalls;
    private long nCachedPositive;
    private long nCachedNegative;
    private long nSortedNegative;
    private ReasonerProgressMonitor pTaxProgress;
    private boolean flagNeedBottomUp;
    protected int nCommon = 1;

    private final Concept curConcept() {
        return (Concept)this.curEntry;
    }

    private boolean enhancedSubs(boolean upDirection, TaxonomyVertex cur) {
        ++this.nSubCalls;
        if (cur.isValued(this.valueLabel)) {
            return cur.getValue();
        }
        return cur.setValued(this.enhancedSubs2(upDirection, cur), this.valueLabel);
    }

    @Override
    public void runTopDown() {
        this.searchBaader(false, this.getTopVertex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runBottomUp() {
        try {
            if (this.propagateUp()) {
                return;
            }
            if (this.isEqualToTop()) {
                return;
            }
            if (!this.willInsertIntoTaxonomy) {
                this.searchBaader(true, this.getBottomVertex());
                return;
            }
            for (int i = 0; i < this.common.size(); ++i) {
                TaxonomyVertex p = this.common.get(i);
                if (!p.noNeighbours(false)) continue;
                this.searchBaader(true, p);
            }
        }
        finally {
            this.clearCommon();
        }
    }

    @Override
    public void preClassificationActions() {
        ++this.nConcepts;
        if (this.pTaxProgress != null) {
            this.pTaxProgress.reasonerTaskProgressChanged((int)this.nConcepts, this.tBox.getNItems());
        }
    }

    @Override
    protected boolean needLogging() {
        return true;
    }

    public DLConceptTaxonomy(Concept pTop, Concept pBottom, TBox kb) {
        super(pTop, pBottom);
        this.tBox = kb;
        this.nConcepts = 0L;
        this.nTries = 0L;
        this.nPositives = 0L;
        this.nNegatives = 0L;
        this.nSearchCalls = 0L;
        this.nSubCalls = 0L;
        this.nNonTrivialSubCalls = 0L;
        this.nCachedPositive = 0L;
        this.nCachedNegative = 0L;
        this.nSortedNegative = 0L;
        this.pTaxProgress = null;
        this.inSplitCheck = false;
    }

    void processSplits() {
        for (TSplitVar v : this.Splits.getEntries()) {
            this.mergeSplitVars(v);
        }
    }

    void setSplitVars(TSplitVars s) {
        this.Splits = s;
    }

    TSplitVars getSplits() {
        return this.Splits;
    }

    public void setBottomUp(KBFlags GCIs) {
        this.flagNeedBottomUp = GCIs.isGCI() || GCIs.isReflexive() && GCIs.isRnD();
    }

    public void setProgressIndicator(ReasonerProgressMonitor pMon) {
        this.pTaxProgress = pMon;
    }

    private boolean isUnsatisfiable() {
        Concept p = this.curConcept();
        if (this.tBox.isSatisfiable(p)) {
            return false;
        }
        this.insertCurrent(this.getBottomVertex());
        return true;
    }

    @Override
    protected boolean immediatelyClassified() {
        if (this.classifySynonym()) {
            return true;
        }
        if (this.curConcept().getClassTagPlain() == Concept.CTTag.cttTrueCompletelyDefined) {
            return false;
        }
        this.tBox.initCache(this.curConcept(), false);
        return this.isUnsatisfiable();
    }

    @Override
    protected boolean needTopDown() {
        return !this.useCompletelyDefined || !this.curEntry.isCompletelyDefined();
    }

    @Override
    protected boolean needBottomUp() {
        return this.flagNeedBottomUp || !this.useCompletelyDefined || this.curConcept().isNonPrimitive();
    }

    private boolean testSub(Concept p, Concept q) {
        assert (p != null);
        assert (q != null);
        if (q.isSingleton() && q.isPrimitive() && !q.isNominal()) {
            return false;
        }
        if (this.inSplitCheck) {
            if (q.isPrimitive()) {
                return false;
            }
            return this.testSubTBox(p, q);
        }
        LeveLogger.logger.print(LeveLogger.Templates.TAX_TRYING, p.getName(), q.getName());
        if (this.tBox.testSortedNonSubsumption(p, q)) {
            LeveLogger.logger.print("NOT holds (sorted result)");
            ++this.nSortedNegative;
            return false;
        }
        switch (this.tBox.testCachedNonSubsumption(p, q)) {
            case csValid: {
                LeveLogger.logger.print("NOT holds (cached result)");
                ++this.nCachedNegative;
                return false;
            }
            case csInvalid: {
                LeveLogger.logger.print("holds (cached result)");
                ++this.nCachedPositive;
                return true;
            }
        }
        LeveLogger.logger.print("wasted cache test");
        return this.testSubTBox(p, q);
    }

    private boolean testSubTBox(Concept p, Concept q) {
        boolean res = this.tBox.isSubHolds(p, q);
        ++this.nTries;
        if (res) {
            ++this.nPositives;
        } else {
            ++this.nNegatives;
        }
        return res;
    }

    @Override
    public void print(LeveLogger.LogAdapter o) {
        o.print(LeveLogger.Templates.DLCONCEPTTAXONOMY, this.nTries, this.nPositives, this.nPositives * 100L / Math.max(1L, this.nTries), this.nCachedPositive, this.nCachedNegative, this.nSortedNegative > 0L ? String.format("Sorted reasoning deals with %s non-subsumptions\n", this.nSortedNegative) : "", this.nSearchCalls, this.nSubCalls, this.nNonTrivialSubCalls, (long)(this.nEntries * (this.nEntries - 1)) / Math.max(1L, this.nTries));
        super.print(o);
    }

    private void searchBaader(boolean upDirection, TaxonomyVertex cur) {
        cur.setChecked(this.checkLabel);
        ++this.nSearchCalls;
        boolean noPosSucc = true;
        List<TaxonomyVertex> neigh = cur.neigh(upDirection);
        int size = neigh.size();
        for (int i = 0; i < size; ++i) {
            TaxonomyVertex p = neigh.get(i);
            if (!this.enhancedSubs(upDirection, p)) continue;
            if (!p.isChecked(this.checkLabel)) {
                this.searchBaader(upDirection, p);
            }
            noPosSucc = false;
        }
        if (!cur.isValued(this.valueLabel)) {
            cur.setValued(this.testSubsumption(upDirection, cur), this.valueLabel);
        }
        if (noPosSucc && cur.getValue()) {
            this.current.addNeighbour(!upDirection, cur);
        }
    }

    private boolean enhancedSubs1(boolean upDirection, TaxonomyVertex cur) {
        ++this.nNonTrivialSubCalls;
        List<TaxonomyVertex> neigh = cur.neigh(!upDirection);
        int size = neigh.size();
        for (int i = 0; i < size; ++i) {
            if (this.enhancedSubs(upDirection, neigh.get(i))) continue;
            return false;
        }
        return this.testSubsumption(upDirection, cur);
    }

    private boolean enhancedSubs2(boolean upDirection, TaxonomyVertex cur) {
        if (upDirection && !cur.isCommon()) {
            return false;
        }
        if (IfDefs.splits && !this.inSplitCheck && !upDirection && !this.possibleSub(cur)) {
            return false;
        }
        return this.enhancedSubs1(upDirection, cur);
    }

    private boolean possibleSub(TaxonomyVertex v) {
        Concept C = (Concept)v.getPrimer();
        if (!C.isPrimitive()) {
            return true;
        }
        return ((Taxonomy.KnownSubsumers)this.ksStack.peek()).isPossibleSub(C);
    }

    private boolean testSubsumption(boolean upDirection, TaxonomyVertex cur) {
        Concept testC = (Concept)cur.getPrimer();
        if (upDirection) {
            return this.testSub(testC, this.curConcept());
        }
        return this.testSub(this.curConcept(), testC);
    }

    private void propagateOneCommon(TaxonomyVertex node) {
        if (node.isChecked(this.checkLabel)) {
            return;
        }
        node.setChecked(this.checkLabel);
        node.setCommon();
        if (node.correctCommon(this.nCommon)) {
            this.common.add(node);
        }
        List<TaxonomyVertex> neigh = node.neigh(false);
        for (int i = 0; i < neigh.size(); ++i) {
            this.propagateOneCommon(neigh.get(i));
        }
    }

    private boolean propagateUp() {
        boolean upDirection = true;
        this.nCommon = 1;
        List<TaxonomyVertex> list = this.current.neigh(true);
        int size = list.size();
        assert (size > 0);
        TaxonomyVertex p = list.get(0);
        this.propagateOneCommon(p);
        this.clearCheckedLabel();
        for (int i = 1; i < size; ++i) {
            p = list.get(i);
            if (p.noNeighbours(false)) {
                return true;
            }
            if (this.common.isEmpty()) {
                return true;
            }
            ++this.nCommon;
            ArrayList<TaxonomyVertex> aux = new ArrayList<TaxonomyVertex>(this.common);
            this.common.clear();
            this.propagateOneCommon(p);
            this.clearCheckedLabel();
            int auxSize = aux.size();
            for (int j = 0; j < auxSize; ++j) {
                ((TaxonomyVertex)aux.get(j)).correctCommon(this.nCommon);
            }
        }
        return false;
    }

    private void clearCommon() {
        int size = this.common.size();
        for (int i = 0; i < size; ++i) {
            this.common.get(i).clearCommon();
        }
        this.common.clear();
    }

    private boolean isEqualToTop() {
        ModelCacheInterface cache = this.tBox.initCache(this.curConcept(), true);
        if (cache.getState() != ModelCacheState.csInvalid) {
            return false;
        }
        this.current.addNeighbour(false, this.getTopVertex());
        return true;
    }

    @Override
    protected boolean classifySynonym() {
        Individual curI;
        if (super.classifySynonym()) {
            return true;
        }
        if (this.curConcept().isSingleton() && this.tBox.isBlockedInd(curI = (Individual)this.curConcept())) {
            Individual syn = this.tBox.getBlockingInd(curI);
            assert (syn.getTaxVertex() != null);
            if (this.tBox.isBlockingDet(curI)) {
                this.insertCurrent(syn.getTaxVertex());
                return true;
            }
            LeveLogger.logger.print("\nTAX: trying '" + curI.getName() + "' = '" + syn.getName() + "'... ");
            if (this.testSubTBox(curI, syn)) {
                this.insertCurrent(syn.getTaxVertex());
                return true;
            }
        }
        return false;
    }

    void checkExtraParents() {
        this.inSplitCheck = true;
        for (TaxonomyVertex p : this.current.neigh(true)) {
            this.propagateTrueUp(p);
        }
        this.current.clearLinks(true);
        this.runTopDown();
        ArrayList<TaxonomyVertex> vec = new ArrayList<TaxonomyVertex>();
        for (TaxonomyVertex p : this.current.neigh(true)) {
            if (this.isDirectParent(p)) continue;
            vec.add(p);
        }
        for (TaxonomyVertex p : vec) {
            p.removeLink(false, this.current);
            this.current.removeLink(true, p);
        }
        this.clearLabels();
        this.inSplitCheck = false;
    }

    void mergeSplitVars(TSplitVar split) {
        this.setCurrentEntry(split.C);
        HashSet<TaxonomyVertex> excludes = new HashSet<TaxonomyVertex>();
        excludes.add(this.getTopVertex());
        TaxonomyVertex v = split.C.getTaxVertex();
        if (v != null) {
            excludes.add(v);
        }
        for (TSplitVar.Entry q : split.getEntries()) {
            excludes.add(q.concept.getTaxVertex());
        }
        if (v != null) {
            this.current.mergeIndepNode(v, excludes, this.curEntry);
            this.removeNode(v);
        }
        for (TSplitVar.Entry q : split.getEntries()) {
            v = q.concept.getTaxVertex();
            this.current.mergeIndepNode(v, excludes, this.curEntry);
            this.removeNode(v);
        }
        this.checkExtraParents();
        v = this.current;
        this.insertCurrent(null);
    }

    class DerivedSubsumers
    extends Taxonomy.KnownSubsumers {
        protected final List<ClassifiableEntry> Sure;
        protected final List<ClassifiableEntry> Possible;

        public DerivedSubsumers(List<ClassifiableEntry> sure, List<ClassifiableEntry> possible) {
            super(DLConceptTaxonomy.this);
            this.Sure = new ArrayList<ClassifiableEntry>(sure);
            this.Possible = new ArrayList<ClassifiableEntry>(possible);
        }

        @Override
        public List<ClassifiableEntry> s_begin() {
            return this.Sure;
        }

        @Override
        public List<ClassifiableEntry> p_begin() {
            return this.Possible;
        }
    }
}

