/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.StatIndex;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.DLVTable;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.IFOptionSet;
import uk.ac.manchester.cs.jfact.kernel.MergableLabel;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataEntry;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;

public final class DLDag {
    private final List<DLVertex> heap = new ArrayList<DLVertex>();
    private final FastSet listAnds = FastSetFactory.create();
    private final EnumMap<DagTag, DLVTable> indexes = new EnumMap(DagTag.class);
    private int nCacheHits;
    private int sortArraySize;
    private String orSortSat;
    private String orSortSub;
    private int iSort;
    private boolean sortAscend;
    private boolean preferNonGen;
    private boolean useDLVCache;

    public void replaceVertex(int i, DLVertex v, NamedEntry C) {
        this.heap.set(i > 0 ? i : -i, v);
        v.setConcept(C);
    }

    public int index(NamedEntry c) {
        for (int i = 0; i < this.heap.size(); ++i) {
            NamedEntry concept = this.heap.get(i).getConcept();
            if (concept == null || !concept.equals(c)) continue;
            return i;
        }
        return 0;
    }

    private boolean isCorrectOption(String str) {
        if (str == null) {
            return false;
        }
        int n = str.length();
        if (n < 1 || n > 3) {
            return false;
        }
        char Method2 = str.charAt(0);
        int Order = n >= 2 ? (int)str.charAt(1) : 97;
        int NGPref = n == 3 ? (int)str.charAt(2) : 112;
        return !(Method2 != 'S' && Method2 != 'D' && Method2 != 'F' && Method2 != 'B' && Method2 != 'G' && Method2 != '0' || Order != 97 && Order != 100 || NGPref != 112 && NGPref != 110);
    }

    private void recompute() {
        for (int p = 0; p < this.listAnds.size(); ++p) {
            this.heap.get(this.listAnds.get(p)).sortEntry(this);
        }
    }

    private void clearDFS() {
        for (DLVertex d : this.heap) {
            d.clearDFS();
        }
    }

    public void updateIndex(DagTag tag, int value) {
        if (!this.indexes.containsKey((Object)tag)) {
            return;
        }
        this.indexes.get((Object)tag).addElement(value);
        if (tag == DagTag.dtCollection || tag == DagTag.dtAnd) {
            this.listAnds.add(value);
        }
    }

    public int directAdd(DLVertex v) {
        this.heap.add(v);
        return this.heap.size() - 1;
    }

    public int directAddAndCache(DLVertex v) {
        int ret = this.directAdd(v);
        if (this.useDLVCache) {
            this.updateIndex(v.getType(), ret);
        }
        return ret;
    }

    public boolean isLast(int p) {
        return p == this.heap.size() - 1 || -p == this.heap.size() - 1;
    }

    public void setExpressionCache(boolean val) {
        this.useDLVCache = val;
    }

    public final DLVertex get(int i) {
        assert (Helper.isValid(i));
        return this.heap.get(i < 0 ? -i : i);
    }

    public int size() {
        return this.heap.size();
    }

    public int maxSize() {
        return this.size() + (this.size() < 220 ? 10 : this.size() / 20);
    }

    public void setSubOrder() {
        this.setOrderOptions(this.orSortSub);
    }

    public void setSatOrder() {
        this.setOrderOptions(this.orSortSat);
    }

    public final ModelCacheInterface getCache(int p) {
        return this.get(p).getCache(p > 0);
    }

    public void setCache(int p, ModelCacheInterface cache) {
        this.get(p).setCache(p > 0, cache);
    }

    public void merge(MergableLabel ml, int p) {
        if (p != 0 && p != 1 && p != -1) {
            this.get(p).merge(ml);
        }
    }

    public boolean haveSameSort(int p, int q) {
        return true;
    }

    public void printStat(LeveLogger.LogAdapter o) {
        o.print(LeveLogger.Templates.PRINT_STAT, this.heap.size(), this.nCacheHits);
    }

    public void print(LeveLogger.LogAdapter o) {
        o.print("\nDag structure");
        for (int i = 1; i < this.size(); ++i) {
            o.print("\n");
            o.print(i);
            o.print(" ");
            this.get(i).print(o);
        }
        o.print("\n");
    }

    public String toString() {
        LeveLogger.LogAdapterStringBuilder l = new LeveLogger.LogAdapterStringBuilder();
        this.print(l);
        return ((Object)l).toString();
    }

    public int add(DLVertex v) {
        int ret;
        int n = ret = this.useDLVCache ? this.indexes.get((Object)v.getType()).locate(v) : 0;
        if (!Helper.isValid(ret)) {
            ret = this.directAddAndCache(v);
            return ret;
        }
        ++this.nCacheHits;
        return ret;
    }

    public DLDag(IFOptionSet Options) {
        DLVTable indexAnd = new DLVTable(this);
        DLVTable indexAll = new DLVTable(this);
        DLVTable indexLE = new DLVTable(this);
        this.indexes.put(DagTag.dtCollection, indexAnd);
        this.indexes.put(DagTag.dtAnd, indexAnd);
        this.indexes.put(DagTag.dtIrr, indexAll);
        this.indexes.put(DagTag.dtUAll, indexAll);
        this.indexes.put(DagTag.dtForall, indexAll);
        this.indexes.put(DagTag.dtLE, indexLE);
        this.nCacheHits = 0;
        this.useDLVCache = true;
        this.heap.add(new DLVertex(DagTag.dtBad));
        this.heap.add(new DLVertex(DagTag.dtTop));
        this.readConfig(Options);
    }

    public void removeAfter(int n) {
        assert (n < this.size());
        for (int i = n; i < this.heap.size(); ++i) {
            DLVertex v = this.heap.get(i);
            if (v.getConcept() == null || !(v.getConcept() instanceof DataEntry)) continue;
            ((DataEntry)v.getConcept()).setBP(0);
        }
        Helper.resize(this.heap, n);
    }

    public void readConfig(IFOptionSet Options) {
        assert (Options != null);
        this.orSortSat = Options.getText("orSortSat");
        this.orSortSub = Options.getText("orSortSub");
        if (!this.isCorrectOption(this.orSortSat) || !this.isCorrectOption(this.orSortSub)) {
            throw new OWLRuntimeException("DAG: wrong OR sorting options");
        }
    }

    public void setOrderDefaults(String defSat, String defSub) {
        assert (this.isCorrectOption(defSat) && this.isCorrectOption(defSub));
        LeveLogger.logger.print(LeveLogger.Templates.SET_ORDER_DEFAULTS1, this.orSortSat, defSat);
        if (this.orSortSat.charAt(0) == '0') {
            this.orSortSat = defSat;
        }
        LeveLogger.logger.print(LeveLogger.Templates.SET_ORDER_DEFAULTS2, this.orSortSat, this.orSortSub, defSub);
        if (this.orSortSub.charAt(0) == '0') {
            this.orSortSub = defSub;
        }
        LeveLogger.logger.print(LeveLogger.Templates.SET_ORDER_DEFAULTS3, this.orSortSub);
    }

    public void setOrderOptions(String opt) {
        if (opt.charAt(0) == '0') {
            return;
        }
        this.sortAscend = opt.charAt(1) == 'a';
        this.preferNonGen = opt.charAt(2) == 'p';
        this.iSort = StatIndex.choose(opt.charAt(0));
        this.recompute();
    }

    private void computeVertexStat(DLVertex v, boolean pos, int depth) {
        if (v.isVisited(pos)) {
            v.setInCycle(pos);
            return;
        }
        v.setVisited(pos);
        switch (v.getType()) {
            case dtCollection: {
                if (!pos) break;
            }
            case dtAnd: 
            case dtSplitConcept: {
                for (int q : v.begin()) {
                    boolean pos2;
                    int index = Helper.createBiPointer(q, pos);
                    DLVertex vertex = this.get(index);
                    boolean bl = pos2 = index > 0;
                    if (vertex.isProcessed(pos2)) continue;
                    this.computeVertexStat(vertex, pos2, depth + 1);
                }
                break;
            }
            case dtProj: {
                if (!pos) break;
            }
            case dtPConcept: 
            case dtNConcept: 
            case dtPSingleton: 
            case dtNSingleton: 
            case dtForall: 
            case dtUAll: 
            case dtChoose: 
            case dtLE: {
                boolean pos2;
                int index = Helper.createBiPointer(v.getConceptIndex(), pos);
                DLVertex vertex = this.get(index);
                boolean bl = pos2 = index > 0;
                if (vertex.isProcessed(pos2)) break;
                this.computeVertexStat(vertex, pos2, depth + 1);
                break;
            }
        }
        v.setProcessed(pos);
        this.updateVertexStat(v, pos);
    }

    private void updateVertexStat(DLVertex v, boolean pos) {
        int d = 0;
        int s = 1;
        int b = 0;
        int g = 0;
        if (!v.getType().omitStat(pos)) {
            if (Helper.isValid(v.getConceptIndex())) {
                this.updateVertexStat(v, v.getConceptIndex(), pos);
            } else {
                for (int q : v.begin()) {
                    this.updateVertexStat(v, q, pos);
                }
            }
        }
        d = v.getDepth(pos);
        switch (v.getType()) {
            case dtAnd: {
                if (pos) break;
                ++b;
                break;
            }
            case dtForall: {
                ++d;
                if (pos) break;
                ++g;
                break;
            }
            case dtLE: {
                ++d;
                if (!pos) {
                    ++g;
                    break;
                }
                if (v.getNumberLE() == 1) break;
                ++b;
                break;
            }
            case dtProj: {
                if (!pos) break;
                ++b;
                break;
            }
        }
        v.updateStatValues(d, s, b, g, pos);
    }

    private void computeVertexFreq(int p) {
        boolean pos;
        DLVertex v = this.get(p);
        boolean bl = pos = p > 0;
        if (v.isVisited(pos)) {
            return;
        }
        v.incFreqValue(pos);
        v.setVisited(pos);
        if (v.getType().omitStat(pos)) {
            return;
        }
        if (Helper.isValid(v.getConceptIndex())) {
            this.computeVertexFreq(v.getConceptIndex(), pos);
        } else {
            for (int q : v.begin()) {
                this.computeVertexFreq(q, pos);
            }
        }
    }

    private void updateVertexStat(DLVertex v, int p, boolean pos) {
        boolean same;
        DLVertex w = this.get(p);
        boolean bl = same = pos == p > 0;
        if (w.isInCycle(same)) {
            v.setInCycle(pos);
        }
        v.updateStatValues(w, same, pos);
    }

    private void computeVertexFreq(int p, boolean pos) {
        this.computeVertexFreq(Helper.createBiPointer(p, pos));
    }

    public void gatherStatistic() {
        int i;
        for (i = 0; i < this.listAnds.size(); ++i) {
            boolean pos;
            int index = -this.listAnds.get(i);
            DLVertex v = this.get(index);
            boolean bl = pos = index > 0;
            if (v.isProcessed(pos)) continue;
            this.computeVertexStat(v, pos, 0);
        }
        if (this.orSortSat.charAt(0) != 'F' && this.orSortSub.charAt(0) != 'F') {
            return;
        }
        this.clearDFS();
        for (i = this.size() - 1; i > 1; --i) {
            if (!this.get(i).getType().isCNameTag()) continue;
            this.computeVertexFreq(i);
        }
    }

    public boolean less(int p1, int p2) {
        if (this.preferNonGen) {
            if (p1 < 0 && p2 > 0) {
                return true;
            }
            if (p1 > 0 && p2 < 0) {
                return false;
            }
        }
        DLVertex v1 = this.get(p1);
        DLVertex v2 = this.get(p2);
        int key1 = v1.getStat(this.iSort);
        int key2 = v2.getStat(this.iSort);
        if (this.sortAscend) {
            return key1 < key2;
        }
        return key2 < key1;
    }

    public void printDAGUsage(LeveLogger.LogAdapter o) {
        int n = 0;
        int total = this.heap.size() * 2 - 2;
        for (DLVertex i : this.heap) {
            if (i.getUsage(true) == 0L) {
                ++n;
            }
            if (i.getUsage(false) != 0L) continue;
            ++n;
        }
        o.print(LeveLogger.Templates.PRINTDAGUSAGE, n, n * 100 / total, total);
    }

    public void determineSorts(RoleMaster ORM, RoleMaster DRM) {
        MergableLabel lab;
        this.sortArraySize = this.heap.size();
        List<Role> ORM_Begin = ORM.getRoles();
        for (Role p : ORM_Begin) {
            if (p.isSynonym()) continue;
            this.mergeSorts(p);
        }
        List<Role> DRM_Begin = DRM.getRoles();
        for (Role p : DRM_Begin) {
            if (p.isSynonym()) continue;
            this.mergeSorts(p);
        }
        for (int i = 2; i < this.heap.size(); ++i) {
            this.mergeSorts(this.heap.get(i));
        }
        int sum = 0;
        for (int i = 2; i < this.heap.size(); ++i) {
            MergableLabel lab2 = this.heap.get(i).getSort();
            lab2.resolve();
            if (!lab2.isSample()) continue;
            ++sum;
        }
        for (Role p : ORM_Begin) {
            if (p.isSynonym()) continue;
            lab = p.getDomainLabel();
            lab.resolve();
            if (!lab.isSample()) continue;
            ++sum;
        }
        for (Role p : DRM_Begin) {
            if (p.isSynonym()) continue;
            lab = p.getDomainLabel();
            lab.resolve();
            if (!lab.isSample()) continue;
            ++sum;
        }
        if (sum > 0) {
            --sum;
        }
        LeveLogger.logger.print(LeveLogger.Templates.DETERMINE_SORTS, sum > 0 ? Integer.valueOf(sum) : "no");
    }

    private void mergeSorts(Role R) {
        R.mergeSupersDomain();
        this.merge(R.getDomainLabel(), R.getBPDomain());
        for (Role q : R.begin_topfunc()) {
            this.merge(R.getDomainLabel(), q.getFunctional());
        }
    }

    private void mergeSorts(DLVertex v) {
        switch (v.getType()) {
            case dtForall: 
            case dtLE: {
                v.merge(v.getRole().getDomainLabel());
                this.merge(v.getRole().getRangeLabel(), v.getConceptIndex());
                break;
            }
            case dtProj: {
                v.merge(v.getRole().getDomainLabel());
                v.merge(v.getProjRole().getDomainLabel());
                this.merge(v.getRole().getDomainLabel(), v.getConceptIndex());
                v.getRole().getRangeLabel().merge(v.getProjRole().getRangeLabel());
                break;
            }
            case dtIrr: {
                v.merge(v.getRole().getDomainLabel());
                v.merge(v.getRole().getRangeLabel());
                break;
            }
            case dtCollection: 
            case dtAnd: 
            case dtSplitConcept: {
                for (int q : v.begin()) {
                    this.merge(v.getSort(), q);
                }
                break;
            }
            case dtPConcept: 
            case dtNConcept: 
            case dtPSingleton: 
            case dtNSingleton: 
            case dtChoose: {
                this.merge(v.getSort(), v.getConceptIndex());
                break;
            }
            case dtDataType: 
            case dtDataValue: 
            case dtDataExpr: 
            case dtNN: {
                break;
            }
            default: {
                throw new UnreachableSituationException();
            }
        }
    }

    public void updateSorts(int a, Role R, int b) {
        this.merge(R.getDomainLabel(), a);
        this.merge(R.getRangeLabel(), b);
    }
}

