/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.Reference;
import uk.ac.manchester.cs.jfact.helpers.SaveStack;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.DlSatTester;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.SaveStackRare;
import uk.ac.manchester.cs.jfact.kernel.state.DLCompletionGraphSaveState;

public final class DlCompletionGraph {
    private static final int initIRLevel = 0;
    private final List<DlCompletionTreeArc> ctEdgeHeap = new ArrayList<DlCompletionTreeArc>();
    private final List<DlCompletionTree> nodeBase;
    private final List<DlCompletionTree> savedNodes = new ArrayList<DlCompletionTree>();
    private final DlSatTester pReasoner;
    private int nodeId = 0;
    private int endUsed;
    private int branchingLevel;
    private int irLevel;
    private final SaveStackRare rareStack = new SaveStackRare();
    private final SaveStack<DLCompletionGraphSaveState> stack = new SaveStack();
    private final FastSet cgpFlag = FastSetFactory.create();
    private int cgpIndent;
    private int nNodeSaves;
    private int nNodeRestores;
    private boolean useLazyBlocking;
    private boolean useAnywhereBlocking;
    private boolean sessionHasInverseRoles;
    private boolean sessionHasNumberRestrictions;

    private void initNodeArray(List<DlCompletionTree> l, int b, int e) {
        for (int p = b; p < e; ++p) {
            l.set(p, new DlCompletionTree(this.nodeId++));
        }
    }

    private void grow() {
        int size = this.nodeBase.size();
        Helper.resize(this.nodeBase, size * 2);
        this.initNodeArray(this.nodeBase, size, this.nodeBase.size());
    }

    private void initRoot() {
        assert (this.endUsed == 0);
        this.getNewNode();
    }

    private void invalidateEdge(DlCompletionTreeArc edge) {
        this.saveRareCond(edge.save());
    }

    private boolean isStillDBlocked(DlCompletionTree node) {
        return node.isDBlocked() && this.isBlockedBy(node, node.blocker);
    }

    private void findDBlocker(DlCompletionTree node) {
        this.saveNode(node, this.branchingLevel);
        node.clearAffected();
        if (node.isBlocked()) {
            this.saveRareCond(node.setUBlocked());
        }
        if (this.useAnywhereBlocking) {
            this.findDAnywhereBlocker(node);
        } else {
            this.findDAncestorBlocker(node);
        }
    }

    private void unblockNodeChildren(DlCompletionTree node) {
        List<DlCompletionTreeArc> neighbour = node.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc q = neighbour.get(i);
            if (!q.isSuccEdge() || q.isIBlocked() || q.isReflexiveEdge()) continue;
            this.unblockNode(q.getArcEnd(), false);
        }
    }

    private void setNodeDBlocked(DlCompletionTree node, DlCompletionTree blocker) {
        this.saveRareCond(node.setDBlocked(blocker));
        this.propagateIBlockedStatus(node, node);
    }

    private void setNodeIBlocked(DlCompletionTree node, DlCompletionTree blocker) {
        if (node.isPBlocked() || node.isNominalNode()) {
            return;
        }
        node.clearAffected();
        if (node.isIBlocked() && node.blocker.equals(blocker)) {
            return;
        }
        if (node.equals(blocker)) {
            return;
        }
        this.saveRareCond(node.setIBlocked(blocker));
        this.propagateIBlockedStatus(node, blocker);
    }

    private void propagateIBlockedStatus(DlCompletionTree node, DlCompletionTree blocker) {
        List<DlCompletionTreeArc> neighbour = node.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc q = neighbour.get(i);
            if (!q.isSuccEdge() || q.isIBlocked()) continue;
            this.setNodeIBlocked(q.getArcEnd(), blocker);
        }
    }

    private boolean canBeUnBlocked(DlCompletionTree node) {
        if (this.sessionHasInverseRoles) {
            return true;
        }
        return node.isAffected() || node.isIllegallyDBlocked();
    }

    private void printIndent(LeveLogger.LogAdapter o) {
        o.print("\n|");
        for (int i = 1; i < this.cgpIndent; ++i) {
            o.print(" |");
        }
    }

    public DlCompletionGraph(int initSize, DlSatTester p) {
        this.nodeBase = new ArrayList<DlCompletionTree>();
        Helper.resize(this.nodeBase, initSize);
        this.pReasoner = p;
        this.nodeId = 0;
        this.endUsed = 0;
        this.branchingLevel = 1;
        this.irLevel = 0;
        this.initNodeArray(this.nodeBase, 0, this.nodeBase.size());
        this.clearStatistics();
        this.initRoot();
    }

    public void initContext(boolean useLB, boolean useAB) {
        this.useLazyBlocking = useLB;
        this.useAnywhereBlocking = useAB;
    }

    public void setBlockingMethod(boolean hasInverse, boolean hasQCR) {
        this.sessionHasInverseRoles = hasInverse;
        this.sessionHasNumberRestrictions = hasQCR;
    }

    public void addConceptToNode(DlCompletionTree node, ConceptWDep c, DagTag tag) {
        node.addConcept(c, tag);
        if (this.useLazyBlocking) {
            node.setAffected();
        } else {
            this.detectBlockedStatus(node);
        }
    }

    public DlCompletionTree getRoot() {
        return this.nodeBase.get(0).resolvePBlocker();
    }

    public DlCompletionTree getNode(int i) {
        if (i >= this.endUsed) {
            return null;
        }
        return this.nodeBase.get(i);
    }

    public DlCompletionTree getNewNode() {
        if (this.endUsed >= this.nodeBase.size()) {
            this.grow();
        }
        DlCompletionTree ret = this.nodeBase.get(this.endUsed++);
        ret.init(this.branchingLevel);
        return ret;
    }

    public void updateDBlockedStatus(DlCompletionTree node) {
        if (!this.canBeUnBlocked(node)) {
            return;
        }
        if (this.isStillDBlocked(node)) {
            node.clearAffected();
        } else {
            this.detectBlockedStatus(node);
        }
        assert (!node.isAffected());
    }

    public void retestCGBlockedStatus() {
        boolean repeat = false;
        block0: do {
            DlCompletionTree p;
            int i;
            for (i = 0; i < this.endUsed; ++i) {
                p = this.nodeBase.get(i);
                if (!p.isDBlocked()) continue;
                this.updateDBlockedStatus(p);
            }
            repeat = false;
            for (i = 0; i < this.endUsed; ++i) {
                p = this.nodeBase.get(i);
                if (!p.isIllegallyDBlocked()) continue;
                repeat = true;
                continue block0;
            }
        } while (repeat);
    }

    public void clearStatistics() {
        this.nNodeSaves = 0;
        this.nNodeRestores = 0;
    }

    public void clear() {
        this.ctEdgeHeap.clear();
        this.endUsed = 0;
        this.branchingLevel = 1;
        this.irLevel = 0;
        this.rareStack.clear();
        this.stack.clear();
        this.savedNodes.clear();
        this.initRoot();
    }

    public int maxSize() {
        return this.nodeBase.size();
    }

    public void saveRareCond(Restorer p) {
        if (p == null) {
            throw new IllegalArgumentException();
        }
        this.rareStack.push(p);
    }

    public void saveRareCond(List<Restorer> p) {
        for (int i = 0; i < p.size(); ++i) {
            this.rareStack.push(p.get(i));
        }
    }

    public DlCompletionTreeArc addRoleLabel(DlCompletionTree from, DlCompletionTree to, boolean isPredEdge, Role R, DepSet dep) {
        DlCompletionTreeArc ret = from.getEdgeLabelled(R, to);
        if (ret == null) {
            ret = this.createEdge(from, to, isPredEdge, R, dep);
        } else if (!dep.isEmpty()) {
            this.saveRareCond(ret.addDep(dep));
        }
        return ret;
    }

    public DlCompletionTreeArc createNeighbour(DlCompletionTree from, boolean isPredEdge, Role r, DepSet dep) {
        return this.createEdge(from, this.getNewNode(), isPredEdge, r, dep);
    }

    public DlCompletionTreeArc createLoop(DlCompletionTree node, Role r, DepSet dep) {
        return this.addRoleLabel(node, node, false, r, dep);
    }

    public void saveNode(DlCompletionTree node, int level) {
        if (node.needSave(level)) {
            node.save(level);
            this.savedNodes.add(node);
            ++this.nNodeSaves;
        }
    }

    private void restoreNode(DlCompletionTree node, int level) {
        if (node.needRestore(level)) {
            node.restore(level);
            ++this.nNodeRestores;
        }
    }

    private boolean isBlockedBy(DlCompletionTree node, DlCompletionTree blocker) {
        boolean ret;
        assert (!node.isNominalNode());
        assert (!blocker.isNominalNode());
        if (blocker.isBlocked()) {
            return false;
        }
        if (!blocker.canBlockInit(node.getInit())) {
            return false;
        }
        if (this.sessionHasInverseRoles) {
            DLDag dag = this.pReasoner.getDAG();
            ret = this.sessionHasNumberRestrictions ? node.isBlockedBy_SHIQ(dag, blocker) : node.isBlockedBy_SHI(dag, blocker);
        } else {
            ret = node.isBlockedBy_SH(blocker);
        }
        return ret;
    }

    public void detectBlockedStatus(DlCompletionTree node) {
        DlCompletionTree p = node;
        boolean wasBlocked = node.isBlocked();
        boolean wasDBlocked = node.isDBlocked();
        node.setAffected();
        while (p.hasParent() && p.isBlockableNode() && p.isAffected()) {
            this.findDBlocker(p);
            if (p.isBlocked()) {
                return;
            }
            p = p.getParentNode();
        }
        p.clearAffected();
        if (wasBlocked && !node.isBlocked()) {
            this.unblockNode(node, wasDBlocked);
        }
    }

    private void unblockNode(DlCompletionTree node, boolean wasDBlocked) {
        if (node.isPBlocked() || !node.isBlockableNode()) {
            return;
        }
        if (!wasDBlocked) {
            this.saveRareCond(node.setUBlocked());
        }
        this.pReasoner.repeatUnblockedNode(node, wasDBlocked);
        this.unblockNodeChildren(node);
    }

    private void findDAncestorBlocker(DlCompletionTree node) {
        DlCompletionTree p = node;
        while (p.hasParent()) {
            if (!(p = p.getParentNode()).isBlockableNode()) {
                return;
            }
            if (!this.isBlockedBy(node, p)) continue;
            this.setNodeDBlocked(node, p);
            return;
        }
    }

    private void findDAnywhereBlocker(DlCompletionTree node) {
        for (int i = 0; i < this.endUsed && i != node.getId(); ++i) {
            DlCompletionTree p = this.nodeBase.get(i);
            if (p.isBlockedPBlockedNominalNodeCached() || !this.isBlockedBy(node, p)) continue;
            this.setNodeDBlocked(node, p);
            return;
        }
    }

    public boolean nonMergable(DlCompletionTree p, DlCompletionTree q, Reference<DepSet> dep) {
        return p.nonMergable(q, dep);
    }

    private void updateIR(DlCompletionTree p, DlCompletionTree q, DepSet toAdd) {
        if (!q.inequalityRelation.isEmpty()) {
            this.saveRareCond(p.updateIR(q, toAdd));
        }
    }

    public void initIR() {
        ++this.irLevel;
    }

    public boolean setCurIR(DlCompletionTree node, DepSet ds) {
        return node.initIR(this.irLevel, ds);
    }

    public void finiIR() {
    }

    private DlCompletionTreeArc createEdge(DlCompletionTree from, DlCompletionTree to, boolean isPredEdge, Role roleName, DepSet dep) {
        DlCompletionTreeArc forward = new DlCompletionTreeArc(roleName, dep, to);
        this.ctEdgeHeap.add(forward);
        forward.setSuccEdge(!isPredEdge);
        DlCompletionTreeArc backward = new DlCompletionTreeArc(roleName.inverse(), dep, from);
        this.ctEdgeHeap.add(backward);
        backward.setSuccEdge(isPredEdge);
        forward.setReverse(backward);
        this.saveNode(from, this.branchingLevel);
        this.saveNode(to, this.branchingLevel);
        from.addNeighbour(forward);
        to.addNeighbour(backward);
        return forward;
    }

    private DlCompletionTreeArc moveEdge(DlCompletionTree node, DlCompletionTreeArc edge, boolean isPredEdge, DepSet dep) {
        if (edge.isIBlocked()) {
            return null;
        }
        if (!isPredEdge && !edge.getArcEnd().isNominalNode()) {
            return null;
        }
        Role R = edge.getRole();
        if (edge.isReflexiveEdge()) {
            return this.createLoop(node, R, dep);
        }
        DlCompletionTree to = edge.getArcEnd();
        if (R != null) {
            this.invalidateEdge(edge);
        }
        for (DlCompletionTreeArc p : node.getNeighbour()) {
            if (!p.getArcEnd().equals(to) || p.isPredEdge() == isPredEdge) continue;
            return this.addRoleLabel(node, to, !isPredEdge, R, dep);
        }
        return this.addRoleLabel(node, to, isPredEdge, R, dep);
    }

    public void merge(DlCompletionTree from, DlCompletionTree to, DepSet dep, List<DlCompletionTreeArc> edges) {
        edges.clear();
        List<DlCompletionTreeArc> neighbour = from.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc temp;
            DlCompletionTreeArc p = neighbour.get(i);
            if ((p.isPredEdge() || p.getArcEnd().isNominalNode()) && (temp = this.moveEdge(to, p, p.isPredEdge(), dep)) != null) {
                edges.add(temp);
            }
            if (!p.isSuccEdge()) continue;
            this.purgeEdge(p, to, dep);
        }
        this.updateIR(to, from, dep);
        this.purgeNode(from, to, dep);
    }

    private void purgeNode(DlCompletionTree p, DlCompletionTree root, DepSet dep) {
        if (p.isPBlocked()) {
            return;
        }
        this.saveRareCond(p.setPBlocked(root, dep));
        List<DlCompletionTreeArc> neighbour = p.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc q = neighbour.get(i);
            if (!q.isSuccEdge() || q.isIBlocked()) continue;
            this.purgeEdge(q, root, dep);
        }
    }

    private void purgeEdge(DlCompletionTreeArc e, DlCompletionTree root, DepSet dep) {
        if (e.getRole() != null) {
            this.invalidateEdge(e);
        }
        if (e.getArcEnd().isBlockableNode()) {
            this.purgeNode(e.getArcEnd(), root, dep);
        }
    }

    public void save() {
        DLCompletionGraphSaveState s = new DLCompletionGraphSaveState();
        this.stack.push(s);
        s.setnNodes(this.endUsed);
        s.setsNodes(this.savedNodes.size());
        s.setnEdges(this.ctEdgeHeap.size());
        this.rareStack.incLevel();
        ++this.branchingLevel;
    }

    public void restore(int level) {
        assert (level > 0);
        this.branchingLevel = level;
        this.rareStack.restore(level);
        DLCompletionGraphSaveState s = this.stack.pop(level);
        this.endUsed = s.getnNodes();
        int nSaved = s.getsNodes();
        if (this.endUsed < Math.abs(this.savedNodes.size() - nSaved)) {
            for (int i = 0; i < this.endUsed; ++i) {
                this.restoreNode(this.nodeBase.get(i), level);
            }
        } else {
            for (int i = nSaved; i < this.savedNodes.size(); ++i) {
                if (this.savedNodes.get(i).getId() >= this.endUsed) continue;
                this.restoreNode(this.savedNodes.get(i), level);
            }
        }
        Helper.resize(this.savedNodes, nSaved);
        Helper.resize(this.ctEdgeHeap, s.getnEdges());
    }

    public void print(LeveLogger.LogAdapter o) {
        int i;
        this.cgpIndent = 0;
        this.cgpFlag.clear();
        List<DlCompletionTree> l = this.nodeBase;
        for (i = 1; i < this.endUsed && l.get(i).isNominalNode(); ++i) {
            this.cgpFlag.add(i);
        }
        this.printNode(l.get(0), o);
        for (i = 1; i < this.endUsed && l.get(i).isNominalNode(); ++i) {
            this.cgpFlag.remove(l.get(i).getId());
            this.printNode(l.get(i), o);
        }
        o.print("\n");
    }

    private void printEdge(List<DlCompletionTreeArc> l, int pos, DlCompletionTreeArc _edge, DlCompletionTree parent, LeveLogger.LogAdapter o) {
        DlCompletionTreeArc edge = _edge;
        DlCompletionTree node = edge.getArcEnd();
        boolean succEdge = edge.isSuccEdge();
        this.printIndent(o);
        if (edge.getArcEnd().equals(node) && edge.isSuccEdge() == succEdge) {
            o.print(" ");
            edge.print(o);
        }
        while (pos < l.size()) {
            edge = l.get(pos);
            if (edge.getArcEnd().equals(node) && edge.isSuccEdge() == succEdge) {
                o.print(" ");
                edge.print(o);
            }
            ++pos;
        }
        if (node.equals(parent)) {
            this.printIndent(o);
            o.print("-loop to node ");
            o.print(parent.getId());
        } else {
            this.printNode(node, o);
        }
    }

    private void printNode(DlCompletionTree node, LeveLogger.LogAdapter o) {
        if (this.cgpIndent > 0) {
            this.printIndent(o);
            o.print("-");
        } else {
            o.print("\n");
        }
        node.printBody(o);
        if (this.cgpFlag.contains(node.getId())) {
            o.print("d");
            return;
        }
        this.cgpFlag.add(node.getId());
        boolean wantPred = node.isNominalNode();
        ++this.cgpIndent;
        List<DlCompletionTreeArc> l = node.getNeighbour();
        for (int i = 0; i < l.size(); ++i) {
            if (!l.get(i).isSuccEdge() && (!wantPred || !l.get(i).getArcEnd().isNominalNode())) continue;
            this.printEdge(l, i + 1, l.get(i), node, o);
        }
        --this.cgpIndent;
    }
}

