/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.dep.DepSetFactory;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.FastSetSimple;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.Reference;
import uk.ac.manchester.cs.jfact.helpers.SaveStack;
import uk.ac.manchester.cs.jfact.helpers.Stats;
import uk.ac.manchester.cs.jfact.helpers.Timer;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.AddConceptResult;
import uk.ac.manchester.cs.jfact.kernel.CGLabel;
import uk.ac.manchester.cs.jfact.kernel.CWDArray;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionGraph;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.EdgeCompare;
import uk.ac.manchester.cs.jfact.kernel.IFOptionSet;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBFlags;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.Redo;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.ToDoList;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataTypeReasoner;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Axiom;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheConst;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheIan;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.TModularizer;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.split.TSplitVar;

public class DlSatTester {
    private final List<SingleSplit> SplitRules = new ArrayList<SingleSplit>();
    private final List<Integer> SessionGCIs = new ArrayList<Integer>();
    private final FastSet ActiveSplits = FastSetFactory.create();
    private final Set<NamedEntity> ActiveSignature = new HashSet<NamedEntity>();
    private final Set<NamedEntity> PossibleSignature = new HashSet<NamedEntity>();
    private final List<NamedEntity> EntityMap = new ArrayList<NamedEntity>();
    boolean useActiveSignature;
    boolean duringClassification;
    protected final TBox tBox;
    protected final DLDag dlHeap;
    private final List<Role> reflexiveRoles = new ArrayList<Role>();
    protected final DlCompletionGraph cGraph;
    private final ToDoList TODO = new ToDoList();
    private final DataTypeReasoner datatypeReasoner;
    private final FastSet used = new LocalFastSet();
    private final KBFlags gcis;
    private final FastSet inProcess = FastSetFactory.create();
    private final Timer satTimer = new Timer();
    private final Timer subTimer = new Timer();
    private Timer testTimer = new Timer();
    private long testTimeout;
    protected final BCStack stack = new BCStack();
    protected BranchingContext bContext;
    private int tryLevel;
    protected int nonDetShift;
    protected DlCompletionTree curNode;
    private DepSet curConceptDepSet;
    private int curConceptConcept;
    private int dagSize;
    private List<ConceptWDep> orConceptsToTest = new ArrayList<ConceptWDep>();
    private List<DlCompletionTreeArc> edgesToMerge = new ArrayList<DlCompletionTreeArc>();
    private DepSet clashSet = DepSetFactory.create();
    private boolean useSemanticBranching;
    private boolean useBackjumping;
    private boolean useLazyBlocking;
    private boolean useAnywhereBlocking;
    private boolean encounterNominal;
    private boolean checkDataNode;
    ModelCacheIan newNodeCache;
    ModelCacheIan newNodeEdges;
    Stats stats = new Stats();
    private static final EnumSet<DagTag> handlecollection = EnumSet.of(DagTag.dtAnd, DagTag.dtCollection);
    private static final EnumSet<DagTag> handleforallle = EnumSet.of(DagTag.dtForall, DagTag.dtLE);
    private static final EnumSet<DagTag> handlesingleton = EnumSet.of(DagTag.dtPSingleton, DagTag.dtNSingleton, DagTag.dtNConcept, DagTag.dtPConcept);

    boolean updateActiveSignature(NamedEntity entity, DepSet dep) {
        if (entity == null || this.ActiveSignature.contains(entity)) {
            return false;
        }
        return this.updateActiveSignature1(entity, dep);
    }

    void addSplitRule(Set<NamedEntity> eqSig, Set<NamedEntity> impSig, int bp) {
        this.SplitRules.add(new SingleSplit(eqSig, impSig, bp));
    }

    Set<NamedEntity> buildSet(TSignature sig, NamedEntity entity) {
        HashSet<NamedEntity> set = new HashSet<NamedEntity>();
        for (NamedEntity p : sig.begin()) {
            if (p.equals(entity) || !(p instanceof ConceptName)) continue;
            set.add(p);
        }
        this.PossibleSignature.addAll(set);
        return set;
    }

    void initSplit(TSplitVar split) {
        List<TSplitVar.Entry> vars = split.getEntries();
        TSplitVar.Entry p = null;
        if (vars.size() > 0) {
            p = vars.get(0);
            Set<NamedEntity> impSet = this.buildSet(p.sig, p.name);
            int bp = split.C.getpBody() + 1;
            for (int i = 1; i < vars.size(); ++i) {
                p = vars.get(i);
                if (p.Module.size() == 1) {
                    this.addSplitRule(this.buildSet(p.sig, p.name), impSet, bp);
                    continue;
                }
                HashSet<TSignature> Out = new HashSet<TSignature>();
                ArrayList<NamedEntity> Allowed = new ArrayList<NamedEntity>();
                ArrayList<Axiom> Module2 = new ArrayList<Axiom>(p.Module);
                TSignature sig = p.sig;
                this.prepareStartSig(Module2, sig, Allowed);
                this.BuildAllSeedSigs(Allowed, sig, Module2, Out);
                for (TSignature q : Out) {
                    this.addSplitRule(this.buildSet(q, p.name), impSet, bp);
                }
            }
        }
    }

    void initSplits() {
        for (TSplitVar p : this.tBox.getSplits().getEntries()) {
            this.initSplit(p);
        }
        for (int i = 1; i < this.EntityMap.size(); ++i) {
            if (this.PossibleSignature.contains(this.EntityMap.get(i))) continue;
            this.EntityMap.set(i, null);
        }
    }

    boolean containsInActive(Set<NamedEntity> S) {
        return this.ActiveSignature.containsAll(S);
    }

    boolean intersectsWithActive(Collection<? extends NamedEntity> S) {
        for (NamedEntity namedEntity : S) {
            if (!this.ActiveSignature.contains(namedEntity)) continue;
            return true;
        }
        return false;
    }

    NamedEntity getEntity(int bp) {
        return this.EntityMap.get(bp > 0 ? bp : -bp);
    }

    void updateName(DlCompletionTree node, int bp) {
        CGLabel lab = node.label();
        ConceptWDep c = lab.getConceptWithBP(bp);
        if (c == null) {
            c = lab.getConceptWithBP(-bp);
        }
        if (c != null) {
            this.addExistingToDoEntry(node, c, "sp");
        }
    }

    void updateName(int bp) {
        int n = 0;
        DlCompletionTree node = null;
        while ((node = this.cGraph.getNode(n++)) != null) {
            if (node.isDataNode()) continue;
            this.updateName(node, bp);
        }
    }

    void prepareStartSig(List<Axiom> Module2, TSignature sig, List<NamedEntity> Allowed) {
        for (Axiom p : Module2) {
            AxiomConceptInclusion ci;
            if (p instanceof AxiomEquivalentConcepts) {
                for (ConceptExpression q : ((AxiomEquivalentConcepts)p).getArguments()) {
                    if (!(q instanceof ConceptName)) continue;
                    sig.remove((ConceptName)q);
                }
                continue;
            }
            if (!(p instanceof AxiomConceptInclusion) || !((ci = (AxiomConceptInclusion)p).getSubConcept() instanceof ConceptName)) continue;
            sig.remove((ConceptName)ci.getSubConcept());
        }
        for (NamedEntity r : sig.begin()) {
            if (!(r instanceof ConceptName)) continue;
            Allowed.add(r);
        }
    }

    void BuildAllSeedSigs(List<NamedEntity> Allowed, TSignature StartSig, List<Axiom> Module2, Set<TSignature> Out) {
        TSignature sig = new TSignature(StartSig);
        ArrayList<NamedEntity> RecAllowed = new ArrayList<NamedEntity>();
        ArrayList<NamedEntity> Keepers = new ArrayList<NamedEntity>();
        HashSet<Axiom> outModule = new HashSet<Axiom>();
        TModularizer mod = new TModularizer();
        for (NamedEntity p : Allowed) {
            if (!sig.containsNamedEntity(p)) continue;
            sig.remove(p);
            mod.extract(Module2, sig, ModuleType.M_STAR, outModule);
            if (outModule.size() == Module2.size()) {
                RecAllowed.add(p);
            } else {
                Keepers.add(p);
            }
            sig.add(p);
        }
        if (RecAllowed.isEmpty()) {
            Out.add(StartSig);
            return;
        }
        if (!Keepers.isEmpty()) {
            for (NamedEntity p : RecAllowed) {
                sig.remove(p);
            }
            mod.extract(Module2, sig, ModuleType.M_STAR, outModule);
            if (outModule.size() == Module2.size()) {
                Out.add(sig);
                return;
            }
        }
        sig = StartSig;
        for (NamedEntity p : RecAllowed) {
            sig.remove(p);
            this.BuildAllSeedSigs(RecAllowed, sig, Module2, Out);
            sig.add(p);
        }
    }

    boolean findConcept(CWDArray lab, ConceptWDep C) {
        return this.findConcept(lab, C.getConcept());
    }

    boolean findConceptClash(CWDArray lab, ConceptWDep C) {
        return this.findConceptClash(lab, C.getConcept(), C.getDep());
    }

    private void addExistingToDoEntry(DlCompletionTree node, ConceptWDep C, String reason) {
        int bp = C.getConcept();
        this.TODO.addEntry(node, this.dlHeap.get(bp).getType(), C);
    }

    private void redoNodeLabel(DlCompletionTree node, String reason) {
        int i;
        CGLabel lab = node.label();
        List<ConceptWDep> l = lab.get_sc();
        for (i = 0; i < l.size(); ++i) {
            this.addExistingToDoEntry(node, l.get(i), reason);
        }
        l = lab.get_cc();
        for (i = 0; i < l.size(); ++i) {
            this.addExistingToDoEntry(node, l.get(i), reason);
        }
    }

    private void ensureDAGSize() {
        if (this.dagSize < this.dlHeap.size()) {
            this.dagSize = this.dlHeap.maxSize();
            Helper.resize(this.EntityMap, this.dagSize);
        }
    }

    protected final ModelCacheInterface createModelCache(DlCompletionTree p) {
        return new ModelCacheIan(this.dlHeap, p, this.encounterNominal, this.tBox.nC, this.tBox.nR);
    }

    private ModelCacheState tryCacheNode(DlCompletionTree node) {
        boolean val;
        ModelCacheState ret = this.canBeCached(node) ? this.reportNodeCached(node) : ModelCacheState.csFailed;
        boolean bl = val = ret == ModelCacheState.csValid;
        if (node.isCached() != val) {
            Restorer setCached = node.setCached(val);
            this.cGraph.saveRareCond(setCached);
        }
        return ret;
    }

    private boolean applyExtraRulesIf(Concept p) {
        if (!p.hasExtraRules()) {
            return false;
        }
        assert (p.isPrimitive());
        return this.applyExtraRules(p);
    }

    public boolean hasNominals() {
        return false;
    }

    private boolean isIBlocked() {
        return this.curNode.isIBlocked();
    }

    private boolean isSomeExists(Role R, int C) {
        if (!this.used.contains(C)) {
            return false;
        }
        DlCompletionTree where = this.curNode.isSomeApplicable(R, C);
        if (where != null) {
            // empty if block
        }
        return where != null;
    }

    private boolean isFirstBranchCall() {
        return this.bContext == null;
    }

    protected void initBC(BranchingContext c) {
        c.node = this.curNode;
        c.concept = new ConceptWDep(this.curConceptConcept, this.curConceptDepSet);
        c.branchDep = DepSetFactory.create(this.curConceptDepSet);
        c.SGsize = this.SessionGCIs.size();
    }

    private void createBCOr() {
        this.bContext = this.stack.pushOr();
        if (LeveLogger.isAbsorptionActive()) {
            LeveLogger.logger_absorption.println("s.push(" + this.bContext + ")");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream p = new PrintStream(out);
            new Exception().printStackTrace(p);
            p.flush();
            LeveLogger.logger_absorption.print(out.toString());
        }
    }

    private void createBCNN() {
        this.bContext = this.stack.pushNN();
    }

    private void createBCLE() {
        this.bContext = this.stack.pushLE();
    }

    private void createBCCh() {
        this.bContext = this.stack.pushCh();
    }

    private static boolean isFunctionalVertex(DLVertex v) {
        return v.getType() == DagTag.dtLE && v.getNumberLE() == 1 && v.getConceptIndex() == 1;
    }

    private boolean checkNRclash(DLVertex atleast, DLVertex atmost) {
        return (atmost.getConceptIndex() == 1 || atleast.getConceptIndex() == atmost.getConceptIndex()) && atleast.getNumberGE() > atmost.getNumberLE() && atleast.getRole().lesserequal(atmost.getRole());
    }

    private boolean isQuickClashLE(DLVertex atmost) {
        List<ConceptWDep> list = this.curNode.beginl_cc();
        for (int i = 0; i < list.size(); ++i) {
            ConceptWDep q = list.get(i);
            if (q.getConcept() >= 0 || !this.isNRClash(this.dlHeap.get(q.getConcept()), atmost, q)) continue;
            return true;
        }
        return false;
    }

    private boolean isQuickClashGE(DLVertex atleast) {
        List<ConceptWDep> list = this.curNode.beginl_cc();
        for (int i = 0; i < list.size(); ++i) {
            ConceptWDep q = list.get(i);
            if (q.getConcept() <= 0 || !this.isNRClash(atleast, this.dlHeap.get(q.getConcept()), q)) continue;
            return true;
        }
        return false;
    }

    private boolean findChooseRuleConcept(CWDArray label, int C, DepSet d) {
        if (C == 1) {
            return true;
        }
        if (this.findConceptClash(label, C, d)) {
            if (d != null) {
                d.add(this.clashSet);
            }
            return true;
        }
        if (this.findConceptClash(label, -C, d)) {
            if (d != null) {
                d.add(this.clashSet);
            }
            return false;
        }
        throw new UnreachableSituationException();
    }

    private boolean checkDisjointRoleClash(DlCompletionTreeArc edge, DlCompletionTree to, Role R, DepSet dep) {
        if (edge.getArcEnd().equals(to) && edge.getRole().isDisjoint(R)) {
            this.setClashSet(dep);
            this.updateClashSet(edge.getDep());
            return true;
        }
        return false;
    }

    private boolean checkIrreflexivity(DlCompletionTreeArc edge, Role R, DepSet dep) {
        if (!edge.getArcEnd().equals(edge.getReverse().getArcEnd())) {
            return false;
        }
        if (!edge.isNeighbour(R) && !edge.isNeighbour(R.inverse())) {
            return false;
        }
        this.setClashSet(dep);
        this.updateClashSet(edge.getDep());
        return true;
    }

    private boolean checkDataClash(DlCompletionTree node) {
        if (this.hasDataClash(node)) {
            this.setClashSet(this.datatypeReasoner.getClashSet());
            return true;
        }
        return false;
    }

    private void logNCEntry(DlCompletionTree n, int bp, DepSet dep, String action, String reason) {
        LeveLogger.logger.print(LeveLogger.Templates.SPACE, action);
        LeveLogger.logger.print("(");
        n.logNode();
        LeveLogger.logger.print(String.format(",%s%s)", bp, dep));
        if (reason != null) {
            LeveLogger.logger.print(reason);
        }
    }

    private void logEntry(DlCompletionTree n, int bp, DepSet dep, String reason) {
        this.logNCEntry(n, bp, dep, "+", reason);
    }

    private void logClash(DlCompletionTree n, int bp, DepSet dep) {
        this.logNCEntry(n, bp, dep, "x", this.dlHeap.get(bp).getType().getName());
    }

    private int getCurLevel() {
        return this.tryLevel;
    }

    private void setCurLevel(int level) {
        this.tryLevel = level;
    }

    protected boolean noBranchingOps() {
        return this.tryLevel == 1 + this.nonDetShift;
    }

    private int getSaveRestoreLevel(DepSet ds) {
        return this.getCurLevel();
    }

    private void restore() {
        this.restore(this.getCurLevel() - 1);
    }

    private void updateLevel(DlCompletionTree n, DepSet ds) {
        this.cGraph.saveNode(n, this.getSaveRestoreLevel(ds));
    }

    private void determiniseBranchingOp() {
        this.bContext = null;
        this.stack.pop();
    }

    private void setClashSet(DepSet d) {
        this.clashSet = d;
    }

    private void setClashSet(List<DepSet> d) {
        DepSet dep = DepSetFactory.create();
        for (int i = 0; i < d.size(); ++i) {
            dep.add(d.get(i));
        }
        this.clashSet = dep;
    }

    private void updateClashSet(DepSet d) {
        this.clashSet.add(d);
    }

    private DepSet getCurDepSet() {
        return DepSetFactory.create(this.getCurLevel() - 1);
    }

    private DepSet getBranchDep() {
        return this.bContext.branchDep;
    }

    private void updateBranchDep() {
        this.getBranchDep().add(this.clashSet);
    }

    private void prepareBranchDep() {
        this.getBranchDep().restrict(this.getCurLevel());
    }

    private void useBranchDep() {
        this.prepareBranchDep();
        this.setClashSet(this.getBranchDep());
    }

    public void repeatUnblockedNode(DlCompletionTree node, boolean direct) {
        if (direct) {
            this.applyAllGeneratingRules(node);
        } else {
            this.redoNodeLabel(node, "ubi");
        }
    }

    public final DLDag getDAG() {
        return this.tBox.getDLHeap();
    }

    private final DlCompletionTree getRootNode() {
        return this.cGraph.getRoot();
    }

    public void initToDoPriorities(IFOptionSet OptionSet) {
        assert (OptionSet != null);
        this.TODO.initPriorities(OptionSet, "IAOEFLG");
    }

    public void setBlockingMethod(boolean hasInverse, boolean hasQCR) {
        this.cGraph.setBlockingMethod(hasInverse, hasQCR);
    }

    public void setTestTimeout(long ms) {
        this.testTimeout = ms;
    }

    public void setDuringClassification(boolean value) {
        this.duringClassification = value;
    }

    public final ModelCacheInterface buildCacheByCGraph(boolean sat) {
        if (sat) {
            return this.createModelCache(this.getRootNode());
        }
        return ModelCacheConst.createConstCache(-1);
    }

    public void writeTotalStatistic(LeveLogger.LogAdapter o) {
        o.print("\n");
    }

    public ModelCacheInterface createCache(int p, FastSet f) {
        assert (Helper.isValid(p));
        ModelCacheInterface cache = this.dlHeap.getCache(p);
        if (cache != null) {
            return cache;
        }
        this.prepareCascadedCache(p, f);
        cache = this.dlHeap.getCache(p);
        if (cache != null) {
            return cache;
        }
        cache = this.buildCache(p);
        this.dlHeap.setCache(p, cache);
        return cache;
    }

    private void prepareCascadedCache(int p, FastSet f) {
        Role R;
        boolean pos;
        if (this.inProcess.contains(p)) {
            return;
        }
        if (f.contains(p)) {
            return;
        }
        DLVertex v = this.dlHeap.get(p);
        boolean bl = pos = p > 0;
        if (v.getCache(pos) != null) {
            return;
        }
        DagTag type = v.getType();
        if (handlecollection.contains((Object)type)) {
            for (int q : v.begin()) {
                this.prepareCascadedCache(pos ? q : -q, f);
            }
        } else if (handlesingleton.contains((Object)type)) {
            if (!pos && type.isPNameTag()) {
                return;
            }
            this.inProcess.add(p);
            this.prepareCascadedCache(pos ? v.getConceptIndex() : -v.getConceptIndex(), f);
            this.inProcess.remove(p);
        } else if (handleforallle.contains((Object)type) && !(R = v.getRole()).isDataRole() && !R.isTop()) {
            int x;
            int n = x = pos ? v.getConceptIndex() : -v.getConceptIndex();
            if (x != 1) {
                this.inProcess.add(x);
                this.createCache(x, f);
                this.inProcess.remove(x);
            }
            if ((x = R.getBPRange()) != 1) {
                this.inProcess.add(x);
                this.createCache(x, f);
                this.inProcess.remove(x);
            }
        }
        f.add(p);
    }

    private final ModelCacheInterface buildCache(int p) {
        LeveLogger.logger.print(":\n");
        boolean sat = this.runSat(p, 1);
        if (!sat) {
            // empty if block
        }
        return this.buildCacheByCGraph(sat);
    }

    protected void resetSessionFlags() {
        this.ensureDAGSize();
        this.used.add(1);
        this.used.add(-1);
        this.encounterNominal = false;
        this.checkDataNode = true;
    }

    protected boolean initNewNode(DlCompletionTree node, DepSet dep, int C) {
        if (node.isDataNode()) {
            this.checkDataNode = false;
        }
        node.setInit(C);
        if (this.addToDoEntry(node, C, dep, null)) {
            return true;
        }
        if (node.isDataNode()) {
            return false;
        }
        if (this.addToDoEntry(node, this.tBox.getTG(), dep, null)) {
            return true;
        }
        if (this.gcis.isReflexive() && this.applyReflexiveRoles(node, dep)) {
            return true;
        }
        if (!this.SessionGCIs.isEmpty()) {
            for (int i : this.SessionGCIs) {
                if (!this.addToDoEntry(node, i, dep, "sg")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean runSat(int p, int q) {
        this.prepareReasoner();
        if (this.initNewNode(this.cGraph.getRoot(), DepSetFactory.create(), p) || this.addToDoEntry(this.cGraph.getRoot(), q, DepSetFactory.create(), null)) {
            return false;
        }
        Timer timer = q == 1 ? this.satTimer : this.subTimer;
        timer.start();
        boolean result = this.runSat();
        timer.stop();
        return result;
    }

    public boolean checkDisjointRoles(Role R, Role S) {
        this.prepareReasoner();
        DepSet dummy = DepSetFactory.create();
        if (this.initNewNode(this.cGraph.getRoot(), dummy, 1)) {
            return true;
        }
        this.curNode = this.cGraph.getRoot();
        DlCompletionTreeArc edgeR = this.createOneNeighbour(R, dummy);
        DlCompletionTreeArc edgeS = this.createOneNeighbour(S, dummy);
        if (this.initNewNode(edgeR.getArcEnd(), dummy, 1) || this.initNewNode(edgeS.getArcEnd(), dummy, 1) || this.setupEdge(edgeR, dummy, 0) || this.setupEdge(edgeS, dummy, 0) || this.merge(edgeS.getArcEnd(), edgeR.getArcEnd(), dummy)) {
            return true;
        }
        this.curNode = null;
        return !this.runSat();
    }

    public boolean checkIrreflexivity(Role R) {
        this.prepareReasoner();
        DepSet dummy = DepSetFactory.create();
        if (this.initNewNode(this.cGraph.getRoot(), dummy, 1)) {
            return true;
        }
        this.curNode = this.cGraph.getRoot();
        DlCompletionTreeArc edgeR = this.createOneNeighbour(R, dummy);
        if (this.initNewNode(edgeR.getArcEnd(), dummy, 1) || this.setupEdge(edgeR, dummy, 0) || this.merge(edgeR.getArcEnd(), this.cGraph.getRoot(), dummy)) {
            return true;
        }
        this.curNode = null;
        return !this.runSat();
    }

    private boolean backJumpedRestore() {
        if (this.clashSet == null || this.clashSet.isEmpty()) {
            return true;
        }
        this.restore(this.clashSet.level());
        return false;
    }

    private boolean straightforwardRestore() {
        if (this.noBranchingOps()) {
            return true;
        }
        this.restore();
        return false;
    }

    private boolean tunedRestore() {
        if (this.useBackjumping) {
            return this.backJumpedRestore();
        }
        return this.straightforwardRestore();
    }

    private boolean commonTacticBodyAll(DLVertex cur) {
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.dtForall);
        if (cur.getRole().isTop()) {
            this.stats.getnAllCalls().inc();
            return this.addSessionGCI(cur.getConceptIndex(), this.curConceptDepSet);
        }
        if (cur.getRole().isSimple()) {
            return this.commonTacticBodyAllSimple(cur);
        }
        return this.commonTacticBodyAllComplex(cur);
    }

    private boolean addSessionGCI(int C, DepSet dep) {
        this.SessionGCIs.add(C);
        int n = 0;
        DlCompletionTree node = null;
        while ((node = this.cGraph.getNode(n++)) != null) {
            if (node.isDataNode() || !this.addToDoEntry(node, C, dep, "sg")) continue;
            return true;
        }
        return false;
    }

    protected DlSatTester(TBox tbox, IFOptionSet Options) {
        this.tBox = tbox;
        this.dlHeap = tbox.getDLHeap();
        this.cGraph = new DlCompletionGraph(1, this);
        this.datatypeReasoner = new DataTypeReasoner(tbox.getDLHeap());
        this.newNodeCache = new ModelCacheIan(true, tbox.nC, tbox.nR);
        this.newNodeEdges = new ModelCacheIan(false, tbox.nC, tbox.nR);
        this.gcis = tbox.getGCIs();
        this.testTimeout = 0L;
        this.bContext = null;
        this.tryLevel = 1;
        this.nonDetShift = 0;
        this.curNode = null;
        this.dagSize = 0;
        this.duringClassification = false;
        this.readConfig(Options);
        if (this.tBox.hasFC() && this.useAnywhereBlocking) {
            this.useAnywhereBlocking = false;
            LeveLogger.logger.print("Fairness constraints: set useAnywhereBlocking = false\n");
        }
        this.cGraph.initContext(this.useLazyBlocking, this.useAnywhereBlocking);
        this.tBox.getDataTypeCenter().initDataTypeReasoner(this.datatypeReasoner);
        tbox.getORM().fillReflexiveRoles(this.reflexiveRoles);
        boolean bl = this.useActiveSignature = !this.tBox.getSplits().empty();
        if (this.useActiveSignature) {
            this.initSplits();
            int size = this.dlHeap.size();
            Helper.resize(this.EntityMap, size);
            this.EntityMap.set(0, null);
            this.EntityMap.set(1, null);
            for (int i = 2; i < size - 1; ++i) {
                if (this.dlHeap.get(i).getConcept() != null) {
                    this.EntityMap.set(i, this.dlHeap.get(i).getConcept().getEntity());
                    continue;
                }
                this.EntityMap.set(i, null);
            }
            this.EntityMap.set(size - 1, null);
        }
        this.resetSessionFlags();
    }

    private void readConfig(IFOptionSet Options) {
        assert (Options != null);
        this.useSemanticBranching = Options.getBool("useSemanticBranching");
        this.useBackjumping = Options.getBool("useBackjumping");
        this.useLazyBlocking = Options.getBool("useLazyBlocking");
        this.useAnywhereBlocking = Options.getBool("useAnywhereBlocking");
        LeveLogger.logger.print(LeveLogger.Templates.READCONFIG, this.useSemanticBranching, this.useBackjumping, this.useLazyBlocking, this.useAnywhereBlocking);
    }

    protected void prepareReasoner() {
        this.cGraph.clear();
        this.stack.clear();
        this.TODO.clear();
        if (!this.TODO.isSaveStateGenerationStarted()) {
            this.TODO.startSaveStateGeneration();
        }
        this.used.clear();
        this.SessionGCIs.clear();
        this.ActiveSplits.clear();
        this.ActiveSignature.clear();
        this.curNode = null;
        this.bContext = null;
        this.tryLevel = 1;
        this.resetSessionFlags();
    }

    public boolean findConcept(CWDArray lab, int p) {
        assert (Helper.isCorrect(p));
        assert (p != 1);
        assert (p != -1);
        this.stats.getnLookups().inc();
        return lab.contains(p);
    }

    private AddConceptResult checkAddedConcept(CWDArray lab, int p, DepSet dep) {
        assert (Helper.isCorrect(p));
        assert (p != 1);
        assert (p != -1);
        this.stats.getnLookups().inc();
        this.stats.getnLookups().inc();
        if (lab.contains(p)) {
            return AddConceptResult.acrExist;
        }
        int inv_p = -p;
        DepSet depset = lab.get(inv_p);
        if (depset != null) {
            this.clashSet = DepSetFactory.plus(depset, dep);
            return AddConceptResult.acrClash;
        }
        return AddConceptResult.acrDone;
    }

    private boolean findConceptClash(CWDArray lab, int bp, DepSet dep) {
        this.stats.getnLookups().inc();
        DepSet depset = lab.get(bp);
        if (depset != null) {
            this.clashSet = DepSetFactory.plus(depset, dep);
            return true;
        }
        return false;
    }

    private AddConceptResult tryAddConcept(CWDArray lab, int bp, DepSet dep) {
        boolean canC = this.used.contains(bp);
        boolean canNegC = this.used.contains(-bp);
        if (canC) {
            if (canNegC) {
                return this.checkAddedConcept(lab, bp, dep);
            }
            this.stats.getnLookups().inc();
            return this.findConcept(lab, bp) ? AddConceptResult.acrExist : AddConceptResult.acrDone;
        }
        if (canNegC) {
            return this.findConceptClash(lab, -bp, dep) ? AddConceptResult.acrClash : AddConceptResult.acrDone;
        }
        return AddConceptResult.acrDone;
    }

    private boolean addToDoEntry(DlCompletionTree n, int bp, DepSet dep, String reason) {
        if (bp == 1) {
            return false;
        }
        if (bp == -1) {
            this.setClashSet(dep);
            return true;
        }
        DLVertex v = this.dlHeap.get(bp);
        DagTag tag = v.getType();
        if (tag == DagTag.dtCollection) {
            if (bp < 0) {
                return false;
            }
            this.stats.getnTacticCalls().inc();
            DlCompletionTree oldNode = this.curNode;
            int oldConceptConcept = this.curConceptConcept;
            FastSetSimple oldConceptDepSetDelegate = this.curConceptDepSet.getDelegate();
            this.curNode = n;
            this.curConceptConcept = bp;
            this.curConceptDepSet = DepSetFactory.create(this.curConceptDepSet);
            boolean ret = this.commonTacticBodyAnd(v);
            this.curNode = oldNode;
            this.curConceptConcept = oldConceptConcept;
            this.curConceptDepSet = DepSetFactory.create(oldConceptDepSetDelegate);
            return ret;
        }
        switch (this.tryAddConcept(n.label().getLabel(tag), bp, dep)) {
            case acrClash: {
                return true;
            }
            case acrExist: {
                return false;
            }
            case acrDone: {
                return this.insertToDoEntry(n, bp, dep, tag, reason);
            }
        }
        throw new UnreachableSituationException();
    }

    private boolean insertToDoEntry(DlCompletionTree n, int bp, DepSet dep, DagTag tag, String reason) {
        ConceptWDep p = new ConceptWDep(bp, dep);
        this.updateLevel(n, dep);
        this.cGraph.addConceptToNode(n, p, tag);
        this.used.add(bp);
        if (this.useActiveSignature && this.updateActiveSignature(this.getEntity(bp), dep)) {
            return true;
        }
        if (n.isCached()) {
            return this.correctCachedEntry(n);
        }
        this.TODO.addEntry(n, tag, p);
        if (n.isDataNode()) {
            return this.checkDataNode ? this.checkDataClash(n) : false;
        }
        return false;
    }

    private boolean canBeCached(DlCompletionTree node) {
        ConceptWDep p;
        int i;
        boolean shallow = true;
        int size = 0;
        if (node.isNominalNode()) {
            return false;
        }
        this.stats.getnCacheTry().inc();
        List<ConceptWDep> list = node.beginl_sc();
        for (i = 0; i < list.size(); ++i) {
            p = list.get(i);
            if (this.dlHeap.getCache(p.getConcept()) == null) {
                this.stats.getnCacheFailedNoCache().inc();
                return false;
            }
            shallow &= this.dlHeap.getCache(p.getConcept()).shallowCache();
            ++size;
        }
        list = node.beginl_cc();
        for (i = 0; i < list.size(); ++i) {
            p = list.get(i);
            if (this.dlHeap.getCache(p.getConcept()) == null) {
                this.stats.getnCacheFailedNoCache().inc();
                return false;
            }
            shallow &= this.dlHeap.getCache(p.getConcept()).shallowCache();
            ++size;
        }
        if (shallow && size != 0) {
            this.stats.getnCacheFailedShallow().inc();
            LeveLogger.logger.print(" cf(s)");
            return false;
        }
        return true;
    }

    private void doCacheNode(DlCompletionTree node) {
        ArrayList<DepSet> deps = new ArrayList<DepSet>();
        this.newNodeCache.clear();
        List<ConceptWDep> beginl_sc = node.beginl_sc();
        for (int i = 0; i < beginl_sc.size(); ++i) {
            ConceptWDep p = beginl_sc.get(i);
            deps.add(p.getDep());
            ModelCacheState merge = this.newNodeCache.merge(this.dlHeap.getCache(p.getConcept()));
            if (merge == ModelCacheState.csValid) continue;
            if (merge == ModelCacheState.csInvalid) {
                this.setClashSet(deps);
            }
            return;
        }
        List<ConceptWDep> list = node.beginl_cc();
        for (int i = 0; i < list.size(); ++i) {
            ConceptWDep p = list.get(i);
            deps.add(p.getDep());
            ModelCacheState merge = this.newNodeCache.merge(this.dlHeap.getCache(p.getConcept()));
            if (merge == ModelCacheState.csValid) continue;
            if (merge == ModelCacheState.csInvalid) {
                this.setClashSet(deps);
            }
            return;
        }
        this.newNodeEdges.clear();
        this.newNodeEdges.initRolesFromArcs(node);
        this.newNodeCache.merge(this.newNodeEdges);
    }

    private ModelCacheState reportNodeCached(DlCompletionTree node) {
        this.doCacheNode(node);
        ModelCacheState status = this.newNodeCache.getState();
        switch (status) {
            case csValid: {
                this.stats.getnCachedSat().inc();
                break;
            }
            case csInvalid: {
                this.stats.getnCachedUnsat().inc();
                break;
            }
            case csFailed: 
            case csUnknown: {
                this.stats.getnCacheFailed().inc();
                LeveLogger.logger.print(" cf(c)");
                status = ModelCacheState.csFailed;
                break;
            }
            default: {
                throw new UnreachableSituationException();
            }
        }
        return status;
    }

    private boolean correctCachedEntry(DlCompletionTree n) {
        assert (n.isCached());
        ModelCacheState status = this.tryCacheNode(n);
        if (status == ModelCacheState.csFailed) {
            this.redoNodeLabel(n, "uc");
        }
        return status.usageByState();
    }

    private boolean hasDataClash(DlCompletionTree node) {
        assert (node != null && node.isDataNode());
        this.datatypeReasoner.clear();
        List<ConceptWDep> beginl_sc = node.beginl_sc();
        int size = beginl_sc.size();
        for (int i = 0; i < size; ++i) {
            ConceptWDep r = beginl_sc.get(i);
            if (!this.datatypeReasoner.addDataEntry(r.getConcept(), r.getDep())) continue;
            return true;
        }
        return this.datatypeReasoner.checkClash();
    }

    protected boolean runSat() {
        this.testTimer.start();
        boolean result = this.checkSatisfiability();
        this.testTimer.stop();
        this.testTimer.reset();
        this.finaliseStatistic();
        if (result) {
            // empty if block
        }
        return result;
    }

    private void finaliseStatistic() {
        this.cGraph.clearStatistics();
    }

    private boolean applyReflexiveRoles(DlCompletionTree node, DepSet dep) {
        for (Role p : this.reflexiveRoles) {
            DlCompletionTreeArc pA = this.cGraph.addRoleLabel(node, node, false, p, dep);
            if (!this.setupEdge(pA, dep, 0)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSatisfiability() {
        int loop = 0;
        while (true) {
            if (this.curNode == null) {
                if (this.TODO.isEmpty()) {
                    this.cGraph.retestCGBlockedStatus();
                    if (this.TODO.isEmpty()) {
                        return true;
                    }
                }
                ToDoList.ToDoEntry curTDE = this.TODO.getNextEntry();
                assert (curTDE != null);
                this.curNode = curTDE.getNode();
                this.curConceptConcept = curTDE.getOffsetConcept();
                this.curConceptDepSet = DepSetFactory.create(curTDE.getOffsetDepSet());
            }
            if (++loop == 50) {
                loop = 0;
                if (this.tBox.isCancelled().get()) {
                    return false;
                }
                if (this.testTimer.calcDelta() >= this.testTimeout) {
                    throw new TimeOutException();
                }
            }
            if (this.commonTactic()) {
                if (!this.tunedRestore()) continue;
                return false;
            }
            this.curNode = null;
        }
    }

    private void restoreBC() {
        this.curNode = this.bContext.node;
        if (this.bContext.concept == null) {
            this.curConceptConcept = 0;
            this.curConceptDepSet = DepSetFactory.create();
        } else {
            this.curConceptConcept = this.bContext.concept.getConcept();
            this.curConceptDepSet = DepSetFactory.create(this.bContext.concept.getDep());
        }
        if (!this.SessionGCIs.isEmpty()) {
            Helper.resize(this.SessionGCIs, this.bContext.SGsize);
        }
        this.updateBranchDep();
        this.bContext.nextOption();
    }

    protected void save() {
        this.cGraph.save();
        this.TODO.save();
        ++this.tryLevel;
        this.bContext = null;
        this.stats.getnStateSaves().inc();
    }

    protected void restore(int newTryLevel) {
        assert (!this.stack.isEmpty());
        assert (newTryLevel > 0);
        this.setCurLevel(newTryLevel);
        this.bContext = (BranchingContext)this.stack.top(this.getCurLevel());
        this.restoreBC();
        this.cGraph.restore(this.getCurLevel());
        this.TODO.restore(this.getCurLevel());
        this.stats.getnStateRestores().inc();
    }

    private void logIndentation() {
        char[] bytes = new char[this.getCurLevel()];
        Arrays.fill(bytes, ' ');
        bytes[0] = 10;
        LeveLogger.logger.print(new String(bytes));
    }

    private void logStartEntry() {
        this.logIndentation();
        LeveLogger.logger.print("[*(");
        this.curNode.logNode();
        LeveLogger.logger.print(",");
        LeveLogger.logger.print(this.curConceptConcept);
        if (this.curConceptDepSet != null) {
            this.curConceptDepSet.print(LeveLogger.logger);
        }
        LeveLogger.logger.print("){");
        if (this.curConceptConcept < 0) {
            LeveLogger.logger.print("~");
        }
        LeveLogger.logger.print(this.dlHeap.get(this.curConceptConcept).getType().getName());
        LeveLogger.logger.print("}:");
    }

    private void logFinishEntry(boolean res) {
        LeveLogger.logger.print("]");
        if (res) {
            LeveLogger.logger.print(LeveLogger.Templates.LOG_FINISH_ENTRY, this.clashSet);
        }
    }

    public float printReasoningTime(LeveLogger.LogAdapter o) {
        o.print(String.format("\n     SAT takes %s seconds\n     SUB takes %s seconds", this.satTimer, this.subTimer));
        return this.satTimer.calcDelta() + this.subTimer.calcDelta();
    }

    private boolean commonTactic() {
        if (this.curNode.isCached() || this.curNode.isPBlocked()) {
            return false;
        }
        boolean ret = false;
        if (!this.isIBlocked()) {
            ret = this.commonTacticBody(this.dlHeap.get(this.curConceptConcept));
        }
        return ret;
    }

    private boolean commonTacticBody(DLVertex cur) {
        this.stats.getnTacticCalls().inc();
        switch (cur.getType()) {
            case dtTop: {
                throw new UnreachableSituationException();
            }
            case dtDataType: 
            case dtDataValue: {
                this.stats.getnUseless().inc();
                return false;
            }
            case dtPSingleton: 
            case dtNSingleton: {
                if (this.curConceptConcept > 0) {
                    return this.commonTacticBodySingleton(cur);
                }
                return this.commonTacticBodyId(cur);
            }
            case dtNConcept: 
            case dtPConcept: {
                return this.commonTacticBodyId(cur);
            }
            case dtAnd: {
                if (this.curConceptConcept > 0) {
                    return this.commonTacticBodyAnd(cur);
                }
                return this.commonTacticBodyOr(cur);
            }
            case dtForall: {
                if (this.curConceptConcept < 0) {
                    return this.commonTacticBodySome(cur);
                }
                return this.commonTacticBodyAll(cur);
            }
            case dtIrr: {
                if (this.curConceptConcept < 0) {
                    return this.commonTacticBodySomeSelf(cur.getRole());
                }
                return this.commonTacticBodyIrrefl(cur.getRole());
            }
            case dtLE: {
                if (this.curConceptConcept < 0) {
                    return this.commonTacticBodyGE(cur);
                }
                if (DlSatTester.isFunctionalVertex(cur)) {
                    return this.commonTacticBodyFunc(cur);
                }
                return this.commonTacticBodyLE(cur);
            }
            case dtProj: {
                assert (this.curConceptConcept > 0);
                return this.commonTacticBodyProj(cur.getRole(), cur.getConceptIndex(), cur.getProjRole());
            }
            case dtSplitConcept: {
                return this.commonTacticBodySplit(cur);
            }
            case dtChoose: {
                assert (this.curConceptConcept > 0);
                return this.applyChooseRule(this.curNode, cur.getConceptIndex());
            }
        }
        throw new UnreachableSituationException();
    }

    private boolean commonTacticBodyId(DLVertex cur) {
        assert (cur.getType().isCNameTag());
        this.stats.getnIdCalls().inc();
        int C = this.curConceptConcept > 0 ? cur.getConceptIndex() : -cur.getConceptIndex();
        return this.addToDoEntry(this.curNode, C, this.curConceptDepSet, null);
    }

    boolean updateActiveSignature1(NamedEntity entity, DepSet dep) {
        this.ActiveSignature.add(entity);
        for (SingleSplit p : this.SplitRules) {
            if (this.ActiveSplits.contains(p.bp - 1) || !this.containsInActive(p.eqSig) || !this.intersectsWithActive(p.impSig)) continue;
            this.ActiveSplits.add(p.bp - 1);
            if (this.addSessionGCI(p.bp, dep)) {
                return true;
            }
            this.updateName(p.bp - 1);
        }
        return false;
    }

    protected boolean applicable(TBox.SimpleRule rule) {
        CWDArray lab = this.curNode.label().getLabel(DagTag.dtPConcept);
        DepSet loc = DepSetFactory.create(this.curConceptDepSet);
        for (Concept p : rule.getBody()) {
            if (p.getpName() == this.curConceptConcept) continue;
            if (this.findConceptClash(lab, p.getpName(), loc)) {
                loc.add(this.clashSet);
                continue;
            }
            return false;
        }
        this.setClashSet(loc);
        return true;
    }

    private boolean applyExtraRules(Concept C) {
        FastSet er_begin = C.getExtraRules();
        for (int i = 0; i < er_begin.size(); ++i) {
            TBox.SimpleRule rule = this.tBox.getSimpleRule(er_begin.get(i));
            this.stats.getnSRuleAdd().inc();
            if (!rule.applicable(this)) continue;
            this.stats.getnSRuleFire().inc();
            if (!this.addToDoEntry(this.curNode, rule.getBpHead(), this.clashSet, null)) continue;
            return true;
        }
        return false;
    }

    private boolean commonTacticBodySingleton(DLVertex cur) {
        assert (cur.getType() == DagTag.dtPSingleton || cur.getType() == DagTag.dtNSingleton);
        this.stats.getnSingletonCalls().inc();
        assert (this.hasNominals());
        this.encounterNominal = true;
        Individual C = (Individual)cur.getConcept();
        assert (C.getNode() != null);
        DepSet dep = DepSetFactory.create(this.curConceptDepSet);
        DlCompletionTree realNode = C.getNode().resolvePBlocker(dep);
        if (!realNode.equals(this.curNode)) {
            return this.merge(this.curNode, realNode, dep);
        }
        return this.commonTacticBodyId(cur);
    }

    private boolean commonTacticBodyAnd(DLVertex cur) {
        int[] begin;
        this.stats.getnAndCalls().inc();
        for (int q : begin = cur.begin()) {
            if (!this.addToDoEntry(this.curNode, q, this.curConceptDepSet, null)) continue;
            return true;
        }
        return false;
    }

    private boolean commonTacticBodyOr(DLVertex cur) {
        assert (this.curConceptConcept < 0 && cur.getType() == DagTag.dtAnd);
        this.stats.getnOrCalls().inc();
        if (this.isFirstBranchCall()) {
            Reference<DepSet> dep = new Reference<DepSet>(DepSetFactory.create());
            if (this.planOrProcessing(cur, dep)) {
                LeveLogger.logger.print(LeveLogger.Templates.COMMON_TACTIC_BODY_OR, this.orConceptsToTest.get(this.orConceptsToTest.size() - 1));
                return false;
            }
            if (this.orConceptsToTest.isEmpty()) {
                this.setClashSet(dep.getReference());
                return true;
            }
            if (this.orConceptsToTest.size() == 1) {
                ConceptWDep C = this.orConceptsToTest.get(0);
                return this.insertToDoEntry(this.curNode, C.getConcept(), dep.getReference(), this.dlHeap.get(C.getConcept()).getType(), "bcp");
            }
            this.createBCOr();
            this.bContext.branchDep = DepSetFactory.create(dep.getReference());
            this.orConceptsToTest = ((BCOr)this.bContext).setApplicableOrEntries(this.orConceptsToTest);
        }
        return this.processOrEntry();
    }

    private boolean planOrProcessing(DLVertex cur, Reference<DepSet> dep) {
        this.orConceptsToTest.clear();
        dep.setReference(DepSetFactory.create(this.curConceptDepSet));
        CGLabel lab = this.curNode.label();
        block5: for (int q : cur.begin()) {
            int inverse = -q;
            switch (this.tryAddConcept(lab.getLabel(this.dlHeap.get(inverse).getType()), inverse, null)) {
                case acrClash: {
                    dep.getReference().add(this.clashSet);
                    continue block5;
                }
                case acrExist: {
                    this.orConceptsToTest.clear();
                    this.orConceptsToTest.add(new ConceptWDep(-q));
                    return true;
                }
                case acrDone: {
                    this.orConceptsToTest.add(new ConceptWDep(-q));
                    continue block5;
                }
                default: {
                    throw new UnreachableSituationException();
                }
            }
        }
        return false;
    }

    private boolean processOrEntry() {
        DepSet dep;
        BCOr bcOr = (BCOr)this.bContext;
        String reason = null;
        if (bcOr.isLastOrEntry()) {
            this.prepareBranchDep();
            dep = this.getBranchDep();
            this.determiniseBranchingOp();
            reason = "bcp";
        } else {
            this.save();
            dep = this.getCurDepSet();
            this.stats.getnOrBrCalls().inc();
        }
        if (this.useSemanticBranching) {
            for (int i : bcOr.getApplicableOrEntriesConcepts()) {
                if (!this.addToDoEntry(this.curNode, -i, dep, "sb")) continue;
                throw new UnreachableSituationException();
            }
        }
        return this.insertToDoEntry(this.curNode, bcOr.orCur().getConcept(), dep, this.dlHeap.get(bcOr.orCur().getConcept()).getType(), reason);
    }

    private boolean commonTacticBodyAllComplex(DLVertex cur) {
        int i;
        List<Object> list;
        int state = cur.getState();
        int C = this.curConceptConcept - state;
        RAStateTransitions RST = cur.getRole().getAutomaton().getBase().get(state);
        if (RST.hasEmptyTransition()) {
            list = RST.begin();
            for (i = 0; i < list.size(); ++i) {
                RATransition q = list.get(i);
                this.stats.getnAutoEmptyLookups().inc();
                if (!q.isEmpty() || !this.addToDoEntry(this.curNode, C + q.final_state(), this.curConceptDepSet, "e")) continue;
                return true;
            }
        }
        if (state == 1 && this.addToDoEntry(this.curNode, cur.getConceptIndex(), this.curConceptDepSet, null)) {
            return true;
        }
        this.stats.getnAllCalls().inc();
        list = this.curNode.getNeighbour();
        for (i = 0; i < list.size(); ++i) {
            DlCompletionTreeArc p = (DlCompletionTreeArc)list.get(i);
            if (!RST.recognise(p.getRole()) || !this.applyTransitions(p, RST, C, DepSetFactory.plus(this.curConceptDepSet, p.getDep()), null)) continue;
            return true;
        }
        return false;
    }

    private boolean commonTacticBodyAllSimple(DLVertex cur) {
        RAStateTransitions RST = cur.getRole().getAutomaton().getBase().get(0);
        int C = cur.getConceptIndex();
        this.stats.getnAllCalls().inc();
        List<DlCompletionTreeArc> neighbour = this.curNode.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc p = neighbour.get(i);
            if (!RST.recognise(p.getRole()) || !this.addToDoEntry(p.getArcEnd(), C, DepSetFactory.plus(this.curConceptDepSet, p.getDep()), null)) continue;
            return true;
        }
        return false;
    }

    private boolean applyTransitions(DlCompletionTreeArc edge, RAStateTransitions RST, int C, DepSet dep, String reason) {
        Role R = edge.getRole();
        DlCompletionTree node = edge.getArcEnd();
        if (RST.isSingleton()) {
            return this.addToDoEntry(node, C + RST.getTransitionEnd(), dep, reason);
        }
        List<RATransition> begin = RST.begin();
        int size = begin.size();
        for (int i = 0; i < size; ++i) {
            RATransition q = begin.get(i);
            this.stats.getnAutoTransLookups().inc();
            if (!q.applicable(R) || !this.addToDoEntry(node, C + q.final_state(), dep, reason)) continue;
            return true;
        }
        return false;
    }

    private boolean applyUniversalNR(DlCompletionTree Node2, DlCompletionTreeArc arcSample, DepSet dep_, int flags) {
        if (flags == 0) {
            return false;
        }
        Role R = arcSample.getRole();
        DepSet dep = DepSetFactory.plus(dep_, arcSample.getDep());
        List<ConceptWDep> base = Node2.beginl_cc();
        int size = base.size();
        block5: for (int i = 0; i < size; ++i) {
            ConceptWDep p = base.get(i);
            if (p.getConcept() < 0) continue;
            DLVertex v = this.dlHeap.get(p.getConcept());
            Role vR = v.getRole();
            switch (v.getType()) {
                case dtIrr: {
                    if ((flags & Redo.redoIrr.getValue()) <= 0 || !this.checkIrreflexivity(arcSample, vR, dep)) continue block5;
                    return true;
                }
                case dtForall: {
                    RAStateTransitions RST;
                    if ((flags & Redo.redoForall.getValue()) == 0 || vR.isTop() || !(RST = vR.getAutomaton().getBase().get(v.getState())).recognise(R) || !(vR.isSimple() ? this.addToDoEntry(arcSample.getArcEnd(), v.getConceptIndex(), DepSetFactory.plus(dep, p.getDep()), "ae") : this.applyTransitions(arcSample, RST, p.getConcept() - v.getState(), DepSetFactory.plus(dep, p.getDep()), "ae"))) continue block5;
                    return true;
                }
                case dtLE: {
                    if (DlSatTester.isFunctionalVertex(v)) {
                        if ((flags & Redo.redoFunc.getValue()) <= 0 || !R.lesserequal(vR)) continue block5;
                        this.addExistingToDoEntry(Node2, p, "f");
                        continue block5;
                    }
                    if ((flags & Redo.redoAtMost.getValue()) <= 0 || !R.lesserequal(vR)) continue block5;
                    this.addExistingToDoEntry(Node2, p, "le");
                    continue block5;
                }
            }
        }
        return false;
    }

    private boolean commonTacticBodySome(DLVertex cur) {
        DLVertex nom;
        Role R = cur.getRole();
        int C = -cur.getConceptIndex();
        if (R.isTop()) {
            return this.commonTacticBodySomeUniv(cur);
        }
        if (R.isTop()) {
            return this.commonTacticBodySomeUniv(cur);
        }
        if (this.isSomeExists(R, C)) {
            return false;
        }
        if (C < 0 && this.dlHeap.get(C).getType() == DagTag.dtAnd) {
            for (int q : this.dlHeap.get(C).begin()) {
                if (!this.isSomeExists(R, -q)) continue;
                return false;
            }
        }
        if (C > 0 && this.tBox.testHasNominals() && ((nom = this.dlHeap.get(C)).getType() == DagTag.dtPSingleton || nom.getType() == DagTag.dtNSingleton)) {
            return this.commonTacticBodyValue(R, (Individual)nom.getConcept());
        }
        this.stats.getnSomeCalls().inc();
        if (R.isFunctional()) {
            List<Role> list = R.begin_topfunc();
            block6: for (int i = 0; i < list.size(); ++i) {
                int functional = list.get(i).getFunctional();
                switch (this.tryAddConcept(this.curNode.label().getLabel(DagTag.dtLE), functional, this.curConceptDepSet)) {
                    case acrClash: {
                        return true;
                    }
                    case acrDone: {
                        this.updateLevel(this.curNode, this.curConceptDepSet);
                        ConceptWDep rFuncRestriction1 = new ConceptWDep(functional, this.curConceptDepSet);
                        this.cGraph.addConceptToNode(this.curNode, rFuncRestriction1, DagTag.dtLE);
                        this.used.add(rFuncRestriction1.getConcept());
                        LeveLogger.logger.print(LeveLogger.Templates.COMMON_TACTIC_BODY_SOME, rFuncRestriction1);
                        continue block6;
                    }
                    case acrExist: {
                        continue block6;
                    }
                    default: {
                        throw new UnreachableSituationException();
                    }
                }
            }
        }
        boolean rFunc = false;
        Role RF = R;
        ConceptWDep rFuncRestriction = null;
        List<ConceptWDep> list = this.curNode.beginl_cc();
        for (int i = 0; i < list.size(); ++i) {
            ConceptWDep LC = list.get(i);
            DLVertex ver = this.dlHeap.get(LC.getConcept());
            if (LC.getConcept() <= 0 || !DlSatTester.isFunctionalVertex(ver) || !R.lesserequal(ver.getRole()) || rFunc && !RF.lesserequal(ver.getRole())) continue;
            rFunc = true;
            RF = ver.getRole();
            rFuncRestriction = LC;
        }
        if (rFunc) {
            DlCompletionTreeArc functionalArc = null;
            DepSet newDep = DepSetFactory.create();
            for (int i = 0; i < this.curNode.getNeighbour().size() && functionalArc == null; ++i) {
                DlCompletionTreeArc pr = this.curNode.getNeighbour().get(i);
                if (!pr.isNeighbour(RF, newDep)) continue;
                functionalArc = pr;
            }
            if (functionalArc != null) {
                LeveLogger.logger.print(LeveLogger.Templates.COMMON_TACTIC_BODY_SOME2, rFuncRestriction);
                DlCompletionTree succ = functionalArc.getArcEnd();
                newDep.add(this.curConceptDepSet);
                if (R.isDisjoint() && this.checkDisjointRoleClash(this.curNode, succ, R, newDep)) {
                    return true;
                }
                functionalArc = this.cGraph.addRoleLabel(this.curNode, succ, functionalArc.isPredEdge(), R, newDep);
                if (this.addToDoEntry(succ, C, newDep, null)) {
                    return true;
                }
                if (!RF.equals(R)) {
                    if (this.initHeadOfNewEdge(this.curNode, R, newDep, "RD")) {
                        return true;
                    }
                    if (this.initHeadOfNewEdge(succ, R.inverse(), newDep, "RR")) {
                        return true;
                    }
                    if (this.applyUniversalNR(this.curNode, functionalArc, newDep, Redo.redoForall.getValue() | Redo.redoFunc.getValue())) {
                        return true;
                    }
                    if (this.applyUniversalNR(succ, functionalArc.getReverse(), newDep, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue())) {
                        return true;
                    }
                }
                return false;
            }
        }
        return this.createNewEdge(cur.getRole(), C, Redo.redoForall.getValue() | Redo.redoAtMost.getValue());
    }

    private boolean commonTacticBodyValue(Role R, Individual nom) {
        DepSet dep = DepSetFactory.create(this.curConceptDepSet);
        if (this.isCurNodeBlocked()) {
            return false;
        }
        this.stats.getnSomeCalls().inc();
        assert (nom.getNode() != null);
        DlCompletionTree realNode = nom.getNode().resolvePBlocker(dep);
        if (R.isDisjoint() && this.checkDisjointRoleClash(this.curNode, realNode, R, dep)) {
            return true;
        }
        this.encounterNominal = true;
        DlCompletionTreeArc edge = this.cGraph.addRoleLabel(this.curNode, realNode, false, R, dep);
        return this.setupEdge(edge, dep, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue() | Redo.redoIrr.getValue());
    }

    boolean commonTacticBodySomeUniv(DLVertex cur) {
        DlCompletionTree node;
        if (this.isCurNodeBlocked()) {
            return false;
        }
        this.stats.getnSomeCalls().inc();
        int C = -cur.getConceptIndex();
        int i = 0;
        while ((node = this.cGraph.getNode(i++)) != null) {
            if (!node.label().contains(C)) continue;
            return false;
        }
        node = this.cGraph.getNewNode();
        return this.initNewNode(node, this.curConceptDepSet, C);
    }

    private boolean createNewEdge(Role R, int C, int flags) {
        if (this.isCurNodeBlocked()) {
            this.stats.getnUseless().inc();
            return false;
        }
        DlCompletionTreeArc pA = this.createOneNeighbour(R, this.curConceptDepSet);
        return this.initNewNode(pA.getArcEnd(), this.curConceptDepSet, C) || this.setupEdge(pA, this.curConceptDepSet, flags);
    }

    private DlCompletionTreeArc createOneNeighbour(Role R, DepSet dep) {
        return this.createOneNeighbour(R, dep, Integer.MAX_VALUE);
    }

    private DlCompletionTreeArc createOneNeighbour(Role R, DepSet dep, int level) {
        boolean forNN = level != Integer.MAX_VALUE;
        DlCompletionTreeArc pA = this.cGraph.createNeighbour(this.curNode, forNN, R, dep);
        DlCompletionTree node = pA.getArcEnd();
        if (forNN) {
            node.setNominalLevel(level);
        }
        if (R.isDataRole()) {
            node.setDataNode();
        }
        return pA;
    }

    private boolean isCurNodeBlocked() {
        if (!this.useLazyBlocking) {
            return this.curNode.isBlocked();
        }
        if (!this.curNode.isBlocked() && this.curNode.isAffected()) {
            this.updateLevel(this.curNode, this.curConceptDepSet);
            this.cGraph.detectBlockedStatus(this.curNode);
        }
        return this.curNode.isBlocked();
    }

    private void applyAllGeneratingRules(DlCompletionTree node) {
        List<ConceptWDep> base = node.label().get_cc();
        for (int i = 0; i < base.size(); ++i) {
            DLVertex v;
            ConceptWDep p = base.get(i);
            if (p.getConcept() > 0 || (v = this.dlHeap.get(p.getConcept())).getType() != DagTag.dtLE && v.getType() != DagTag.dtForall) continue;
            this.addExistingToDoEntry(node, p, "ubd");
        }
    }

    public boolean setupEdge(DlCompletionTreeArc pA, DepSet dep, int flags) {
        DlCompletionTree child = pA.getArcEnd();
        DlCompletionTree from = pA.getReverse().getArcEnd();
        if (this.initHeadOfNewEdge(from, pA.getRole(), dep, "RD")) {
            return true;
        }
        if (this.initHeadOfNewEdge(child, pA.getReverse().getRole(), dep, "RR")) {
            return true;
        }
        if (this.applyUniversalNR(from, pA, dep, flags)) {
            return true;
        }
        if (pA.isPredEdge() || child.isNominalNode() || child.equals(from)) {
            if (this.applyUniversalNR(child, pA.getReverse(), dep, flags)) {
                return true;
            }
        } else if (child.isDataNode()) {
            this.checkDataNode = true;
            if (this.checkDataClash(child)) {
                return true;
            }
        } else if (this.tryCacheNode(child).usageByState()) {
            return true;
        }
        return false;
    }

    private boolean initHeadOfNewEdge(DlCompletionTree node, Role R, DepSet dep, String reason) {
        if (R.isFunctional()) {
            List<Role> begin_topfunc = R.begin_topfunc();
            int size = begin_topfunc.size();
            for (int i = 0; i < size; ++i) {
                if (!this.addToDoEntry(node, begin_topfunc.get(i).getFunctional(), dep, "fr")) continue;
                return true;
            }
        }
        if (this.addToDoEntry(node, R.getBPDomain(), dep, reason)) {
            return true;
        }
        List<Role> list = R.getAncestor();
        for (int i = 0; i < list.size(); ++i) {
            Role q = list.get(i);
            if (!this.addToDoEntry(node, q.getBPDomain(), dep, reason)) continue;
            return true;
        }
        return false;
    }

    private boolean commonTacticBodyFunc(DLVertex cur) {
        assert (this.curConceptConcept > 0 && DlSatTester.isFunctionalVertex(cur));
        if (this.isNNApplicable(cur.getRole(), 1, this.curConceptConcept + 1)) {
            return this.commonTacticBodyNN(cur);
        }
        this.stats.getnFuncCalls().inc();
        if (this.isQuickClashLE(cur)) {
            return true;
        }
        this.findNeighbours(cur.getRole(), 1, null);
        if (this.edgesToMerge.size() < 2) {
            return false;
        }
        DlCompletionTreeArc q = this.edgesToMerge.get(0);
        DlCompletionTree sample = q.getArcEnd();
        DepSet depF = DepSetFactory.create(this.curConceptDepSet);
        depF.add(q.getDep());
        for (int i = 1; i < this.edgesToMerge.size(); ++i) {
            q = this.edgesToMerge.get(i);
            if (q.getArcEnd().isPBlocked() || !this.merge(q.getArcEnd(), sample, DepSetFactory.plus(depF, q.getDep()))) continue;
            return true;
        }
        return false;
    }

    private boolean applyCh(DLVertex cur) {
        int C = cur.getConceptIndex();
        Role R = cur.getRole();
        BCLE bcLE = null;
        if (C != 1 && this.commonTacticBodyChoose(R, C)) {
            return true;
        }
        if (this.isNNApplicable(R, C, this.curConceptConcept + cur.getNumberLE())) {
            return this.commonTacticBodyNN(cur);
        }
        if (this.isQuickClashLE(cur)) {
            return true;
        }
        do {
            if (this.isFirstBranchCall()) {
                DepSet dep = DepSetFactory.create();
                this.findNeighbours(R, C, dep);
                if (this.edgesToMerge.size() <= cur.getNumberLE()) {
                    return false;
                }
                this.createBCLE();
                this.bContext.branchDep.add(dep);
                bcLE = (BCLE)this.bContext;
                List<DlCompletionTreeArc> temp = this.edgesToMerge;
                this.edgesToMerge = bcLE.getEdgesToMerge();
                bcLE.setEdgesToMerge(temp);
                bcLE.resetMCI();
            }
            DlCompletionTreeArc from = null;
            DlCompletionTreeArc to = null;
            boolean applyLE = true;
            while (applyLE) {
                applyLE = false;
                bcLE = (BCLE)this.bContext;
                if (bcLE.noMoreLEOptions()) {
                    this.useBranchDep();
                    return true;
                }
                from = bcLE.getFrom();
                to = bcLE.getTo();
                Reference<DepSet> dep = new Reference<DepSet>(DepSetFactory.create());
                if (!this.cGraph.nonMergable(from.getArcEnd(), to.getArcEnd(), dep)) continue;
                if (C == 1) {
                    this.setClashSet(dep.getReference());
                } else {
                    DagTag tag = this.dlHeap.get(C).getType();
                    boolean test = this.findConceptClash(from.getArcEnd().label().getLabel(tag), C, dep.getReference());
                    assert (test);
                    dep.setReference(DepSetFactory.plus(dep.getReference(), this.clashSet));
                    test = this.findConceptClash(to.getArcEnd().label().getLabel(tag), C, dep.getReference());
                    assert (test);
                }
                this.updateBranchDep();
                this.bContext.nextOption();
                applyLE = true;
            }
            this.save();
            DepSet curDep = this.getCurDepSet();
            curDep.add(from.getDep());
            if (!this.merge(from.getArcEnd(), to.getArcEnd(), curDep)) continue;
            return true;
        } while (C == 1 || !this.commonTacticBodyChoose(R, C));
        return true;
    }

    private boolean commonTacticBodyLE(DLVertex cur) {
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.dtLE);
        this.stats.getnLeCalls().inc();
        int C = cur.getConceptIndex();
        Role R = cur.getRole();
        BCLE bcLE = null;
        if (!this.isFirstBranchCall()) {
            if (this.bContext instanceof BCNN) {
                return this.commonTacticBodyNN(cur);
            }
            if (this.bContext instanceof BCLE) {
                while (true) {
                    DlCompletionTreeArc from = null;
                    DlCompletionTreeArc to = null;
                    boolean applyLE = true;
                    while (applyLE) {
                        applyLE = false;
                        bcLE = (BCLE)this.bContext;
                        if (bcLE.noMoreLEOptions()) {
                            this.useBranchDep();
                            return true;
                        }
                        from = bcLE.getFrom();
                        to = bcLE.getTo();
                        Reference<DepSet> dep = new Reference<DepSet>(DepSetFactory.create());
                        if (!this.cGraph.nonMergable(from.getArcEnd(), to.getArcEnd(), dep)) continue;
                        if (C == 1) {
                            this.setClashSet(dep.getReference());
                        } else {
                            DagTag tag = this.dlHeap.get(C).getType();
                            boolean test = this.findConceptClash(from.getArcEnd().label().getLabel(tag), C, dep.getReference());
                            assert (test);
                            dep.setReference(DepSetFactory.plus(dep.getReference(), this.clashSet));
                            test = this.findConceptClash(to.getArcEnd().label().getLabel(tag), C, dep.getReference());
                            assert (test);
                        }
                        this.updateBranchDep();
                        this.bContext.nextOption();
                        applyLE = true;
                    }
                    this.save();
                    DepSet curDep = this.getCurDepSet();
                    curDep.add(from.getDep());
                    if (this.merge(from.getArcEnd(), to.getArcEnd(), curDep)) {
                        return true;
                    }
                    if (C != 1 && this.commonTacticBodyChoose(R, C)) {
                        return true;
                    }
                    if (!this.isFirstBranchCall()) continue;
                    DepSet dep = DepSetFactory.create();
                    this.findNeighbours(R, C, dep);
                    if (this.edgesToMerge.size() <= cur.getNumberLE()) {
                        return false;
                    }
                    this.createBCLE();
                    this.bContext.branchDep.add(dep);
                    bcLE = (BCLE)this.bContext;
                    List<DlCompletionTreeArc> temp = this.edgesToMerge;
                    this.edgesToMerge = bcLE.getEdgesToMerge();
                    bcLE.setEdgesToMerge(temp);
                    bcLE.resetMCI();
                }
            }
            assert (this.bContext instanceof BCChoose);
            return this.applyCh(cur);
        }
        return this.applyCh(cur);
    }

    private boolean commonTacticBodyGE(DLVertex cur) {
        if (this.isCurNodeBlocked()) {
            return false;
        }
        this.stats.getnGeCalls().inc();
        if (this.isQuickClashGE(cur)) {
            return true;
        }
        return this.createDifferentNeighbours(cur.getRole(), cur.getConceptIndex(), this.curConceptDepSet, cur.getNumberGE(), Integer.MAX_VALUE);
    }

    private boolean createDifferentNeighbours(Role R, int C, DepSet dep, int n, int level) {
        DlCompletionTreeArc pA = null;
        this.cGraph.initIR();
        for (int i = 0; i < n; ++i) {
            pA = this.createOneNeighbour(R, dep, level);
            DlCompletionTree child = pA.getArcEnd();
            this.cGraph.setCurIR(child, dep);
            if (this.initNewNode(child, dep, C)) {
                return true;
            }
            if (!this.setupEdge(pA, dep, Redo.redoForall.getValue())) continue;
            return true;
        }
        this.cGraph.finiIR();
        return this.applyUniversalNR(this.curNode, pA, dep, Redo.redoFunc.getValue() | Redo.redoAtMost.getValue());
    }

    private boolean isNRClash(DLVertex atleast, DLVertex atmost, ConceptWDep reason) {
        if (atmost.getType() != DagTag.dtLE || atleast.getType() != DagTag.dtLE) {
            return false;
        }
        if (!this.checkNRclash(atleast, atmost)) {
            return false;
        }
        this.setClashSet(DepSetFactory.plus(this.curConceptDepSet, reason.getDep()));
        return true;
    }

    private boolean checkMergeClash(CGLabel from, CGLabel to, DepSet dep, int nodeId) {
        DepSet clashDep = DepSetFactory.create(dep);
        boolean clash = false;
        List<ConceptWDep> list = from.get_sc();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ConceptWDep p = list.get(i);
            int inverse = -p.getConcept();
            if (!this.used.contains(inverse) || !this.findConceptClash(to.getLabel(DagTag.dtPConcept), inverse, p.getDep())) continue;
            clash = true;
            clashDep.add(this.clashSet);
            LeveLogger.logger.print(LeveLogger.Templates.CHECK_MERGE_CLASH, nodeId, p.getConcept(), DepSetFactory.plus(this.clashSet, dep));
        }
        list = from.get_cc();
        int ccsize = list.size();
        for (int i = 0; i < ccsize; ++i) {
            ConceptWDep p = list.get(i);
            int inverse = -p.getConcept();
            if (!this.used.contains(inverse) || !this.findConceptClash(to.getLabel(DagTag.dtForall), inverse, p.getDep())) continue;
            clash = true;
            clashDep.add(this.clashSet);
            LeveLogger.logger.print(LeveLogger.Templates.CHECK_MERGE_CLASH, nodeId, p.getConcept(), DepSetFactory.plus(this.clashSet, dep));
        }
        if (clash) {
            this.setClashSet(clashDep);
        }
        return clash;
    }

    private boolean mergeLabels(CGLabel from, DlCompletionTree to, DepSet dep) {
        int index;
        int bp;
        ConceptWDep p;
        int i;
        CGLabel lab = to.label();
        CWDArray sc = lab.getLabel(DagTag.dtPConcept);
        CWDArray cc = lab.getLabel(DagTag.dtForall);
        if (!dep.isEmpty()) {
            this.cGraph.saveRareCond(sc.updateDepSet(dep));
            this.cGraph.saveRareCond(cc.updateDepSet(dep));
        }
        List<ConceptWDep> list = from.get_sc();
        for (i = 0; i < list.size(); ++i) {
            p = list.get(i);
            bp = p.getConcept();
            this.stats.getnLookups().inc();
            index = sc.index(bp);
            if (index > -1) {
                if (p.getDep().isEmpty()) continue;
                this.cGraph.saveRareCond(sc.updateDepSet(index, p.getDep()));
                continue;
            }
            if (!this.insertToDoEntry(to, bp, DepSetFactory.plus(dep, p.getDep()), this.dlHeap.get(bp).getType(), "M")) continue;
            return true;
        }
        list = from.get_cc();
        for (i = 0; i < list.size(); ++i) {
            p = list.get(i);
            bp = p.getConcept();
            this.stats.getnLookups().inc();
            index = cc.index(bp);
            if (index > -1) {
                if (p.getDep().isEmpty()) continue;
                this.cGraph.saveRareCond(cc.updateDepSet(index, p.getDep()));
                continue;
            }
            if (!this.insertToDoEntry(to, bp, DepSetFactory.plus(dep, p.getDep()), this.dlHeap.get(bp).getType(), "M")) continue;
            return true;
        }
        return false;
    }

    private boolean merge(DlCompletionTree from, DlCompletionTree to, DepSet depF) {
        assert (!from.isPBlocked());
        assert (!from.equals(to));
        assert (to.getNominalLevel() <= from.getNominalLevel());
        LeveLogger.logger.print(LeveLogger.Templates.MERGE, from.getId(), to.getId());
        this.stats.getnMergeCalls().inc();
        DepSet dep = DepSetFactory.create(depF);
        Reference<DepSet> ref = new Reference<DepSet>(dep);
        if (this.cGraph.nonMergable(from, to, ref)) {
            this.setClashSet(ref.getReference());
            return true;
        }
        if (this.checkMergeClash(from.label(), to.label(), depF, to.getId())) {
            return true;
        }
        if (this.mergeLabels(from.label(), to, depF)) {
            return true;
        }
        ArrayList<DlCompletionTreeArc> edges = new ArrayList<DlCompletionTreeArc>();
        this.cGraph.merge(from, to, depF, edges);
        int size = edges.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc q = (DlCompletionTreeArc)edges.get(i);
            if (!q.getRole().isDisjoint() || !this.checkDisjointRoleClash(q.getReverse().getArcEnd(), q.getArcEnd(), q.getRole(), depF)) continue;
            return true;
        }
        if (to.isDataNode()) {
            return this.checkDataClash(to);
        }
        for (DlCompletionTreeArc q : edges) {
            if (!this.applyUniversalNR(to, q, depF, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue() | Redo.redoIrr.getValue())) continue;
            return true;
        }
        return false;
    }

    protected boolean checkDisjointRoleClash(DlCompletionTree from, DlCompletionTree to, Role R, DepSet dep) {
        for (DlCompletionTreeArc p : from.getNeighbour()) {
            if (!this.checkDisjointRoleClash(p, to, R, dep)) continue;
            return true;
        }
        return false;
    }

    private boolean isNewEdge(DlCompletionTree node, List<DlCompletionTreeArc> e) {
        int size = e.size();
        for (int i = 0; i < size; ++i) {
            if (!e.get(i).getArcEnd().equals(node)) continue;
            return false;
        }
        return true;
    }

    private void findNeighbours(Role Role2, int c, DepSet Dep) {
        this.edgesToMerge.clear();
        DagTag tag = this.dlHeap.get(c).getType();
        List<DlCompletionTreeArc> neighbour = this.curNode.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc p = neighbour.get(i);
            if (!p.isNeighbour(Role2) || !this.isNewEdge(p.getArcEnd(), this.edgesToMerge) || !this.findChooseRuleConcept(p.getArcEnd().label().getLabel(tag), c, Dep)) continue;
            this.edgesToMerge.add(p);
        }
        Collections.sort(this.edgesToMerge, new EdgeCompare());
    }

    private boolean commonTacticBodyChoose(Role R, int C) {
        List<DlCompletionTreeArc> neighbour = this.curNode.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc p = neighbour.get(i);
            if (!p.isNeighbour(R) || !this.applyChooseRule(p.getArcEnd(), C)) continue;
            return true;
        }
        return false;
    }

    private boolean applyChooseRule(DlCompletionTree node, int C) {
        if (node.isLabelledBy(C) || node.isLabelledBy(-C)) {
            return false;
        }
        if (this.isFirstBranchCall()) {
            this.createBCCh();
            this.save();
            return this.addToDoEntry(node, -C, this.getCurDepSet(), "cr0");
        }
        this.prepareBranchDep();
        DepSet dep = DepSetFactory.create(this.getBranchDep());
        this.determiniseBranchingOp();
        return this.addToDoEntry(node, C, dep, "cr1");
    }

    private boolean commonTacticBodyNN(DLVertex cur) {
        BCNN bcNN;
        this.stats.getnNNCalls().inc();
        if (this.isFirstBranchCall()) {
            this.createBCNN();
        }
        if ((bcNN = (BCNN)this.bContext).noMoreNNOptions(cur.getNumberLE())) {
            this.useBranchDep();
            return true;
        }
        int NN = bcNN.getBranchIndex();
        this.save();
        DepSet curDep = this.getCurDepSet();
        if (this.addToDoEntry(this.curNode, this.curConceptConcept + cur.getNumberLE(), DepSetFactory.create(), "NNs")) {
            return true;
        }
        if (this.createDifferentNeighbours(cur.getRole(), cur.getConceptIndex(), curDep, NN, this.curNode.getNominalLevel() + 1)) {
            return true;
        }
        return this.addToDoEntry(this.curNode, this.curConceptConcept + cur.getNumberLE() - NN, curDep, "NN");
    }

    protected boolean isNNApplicable(Role r, int C, int stopper) {
        if (!this.curNode.isNominalNode()) {
            return false;
        }
        if (this.used.contains(stopper) && this.curNode.isLabelledBy(stopper)) {
            return false;
        }
        for (DlCompletionTreeArc p : this.curNode.getNeighbour()) {
            DlCompletionTree suspect = p.getArcEnd();
            if (!p.isPredEdge() || !suspect.isBlockableNode() || !p.isNeighbour(r) || !suspect.isLabelledBy(C)) continue;
            LeveLogger.logger.print(suspect.getId());
            LeveLogger.logger.print(")");
            return true;
        }
        return false;
    }

    private boolean commonTacticBodySomeSelf(Role R) {
        if (this.isCurNodeBlocked()) {
            return false;
        }
        for (DlCompletionTreeArc p : this.curNode.getNeighbour()) {
            if (!p.getArcEnd().equals(this.curNode) || !p.isNeighbour(R)) continue;
            return false;
        }
        DepSet dep = DepSetFactory.create(this.curConceptDepSet);
        DlCompletionTreeArc pA = this.cGraph.createLoop(this.curNode, R, dep);
        return this.setupEdge(pA, dep, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue() | Redo.redoIrr.getValue());
    }

    private boolean commonTacticBodyIrrefl(Role R) {
        for (DlCompletionTreeArc p : this.curNode.getNeighbour()) {
            if (!this.checkIrreflexivity(p, R, this.curConceptDepSet)) continue;
            return true;
        }
        return false;
    }

    private boolean commonTacticBodyProj(Role R, int C, Role ProjR) {
        if (this.curNode.isLabelledBy(-C)) {
            return false;
        }
        for (int i = 0; i < this.curNode.getNeighbour().size(); ++i) {
            if (!this.curNode.getNeighbour().get(i).isNeighbour(R) || !this.checkProjection(this.curNode.getNeighbour().get(i), C, ProjR)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProjection(DlCompletionTreeArc pA, int C, Role ProjR) {
        if (pA.isNeighbour(ProjR)) {
            return false;
        }
        if (this.curNode.isLabelledBy(-C)) {
            return false;
        }
        DepSet dep = DepSetFactory.create(this.curConceptDepSet);
        dep.add(pA.getDep());
        if (!this.curNode.isLabelledBy(C)) {
            if (this.isFirstBranchCall()) {
                this.createBCCh();
                this.save();
                return this.addToDoEntry(this.curNode, -C, this.getCurDepSet(), "cr0");
            }
            this.prepareBranchDep();
            dep.add(this.getBranchDep());
            this.determiniseBranchingOp();
            if (this.addToDoEntry(this.curNode, C, dep, "cr1")) {
                return true;
            }
        }
        DlCompletionTree child = pA.getArcEnd();
        return this.setupEdge(this.cGraph.addRoleLabel(this.curNode, child, pA.isPredEdge(), ProjR, dep), dep, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue() | Redo.redoIrr.getValue());
    }

    private boolean commonTacticBodySplit(DLVertex cur) {
        if (this.duringClassification && !this.ActiveSplits.contains(this.curConceptConcept > 0 ? this.curConceptConcept : -this.curConceptConcept)) {
            return false;
        }
        DepSet dep = this.curConceptDepSet;
        boolean pos = this.curConceptConcept > 0;
        for (int q : cur.begin()) {
            if (!this.addToDoEntry(this.curNode, Helper.createBiPointer(q, pos), dep, null)) continue;
            return true;
        }
        return false;
    }

    class SingleSplit {
        Set<NamedEntity> eqSig;
        Set<NamedEntity> impSig;
        int bp;

        SingleSplit() {
        }

        SingleSplit(Set<NamedEntity> es, Set<NamedEntity> is, int p) {
            this.eqSig = new HashSet<NamedEntity>(es);
            this.impSig = new HashSet<NamedEntity>(is);
            this.bp = p;
        }
    }

    final class BCOr
    extends BranchingContext {
        private int branchIndex;
        private int size;
        private List<ConceptWDep> applicableOrEntries;

        BCOr() {
            this.size = 0;
            this.applicableOrEntries = new ArrayList<ConceptWDep>();
        }

        @Override
        public void init() {
            this.branchIndex = 0;
        }

        @Override
        public void nextOption() {
            ++this.branchIndex;
        }

        protected boolean isLastOrEntry() {
            return this.size == this.branchIndex + 1;
        }

        protected ConceptWDep orCur() {
            return this.applicableOrEntries.get(this.branchIndex);
        }

        protected int getBranchIndex() {
            return this.branchIndex;
        }

        protected int[] getApplicableOrEntriesConcepts() {
            int[] toReturn = new int[this.branchIndex];
            for (int i = 0; i < toReturn.length; ++i) {
                toReturn[i] = this.applicableOrEntries.get(i).getConcept();
            }
            return toReturn;
        }

        protected List<ConceptWDep> setApplicableOrEntries(List<ConceptWDep> list) {
            List<ConceptWDep> toReturn = this.applicableOrEntries;
            this.applicableOrEntries = list;
            this.size = this.applicableOrEntries.size();
            return toReturn;
        }

        @Override
        public String toString() {
            StringBuilder o = new StringBuilder();
            o.append("BCOR ");
            o.append(this.branchIndex);
            o.append(" dep ");
            o.append(this.branchDep);
            o.append(" curconcept ");
            o.append(this.concept == null ? new ConceptWDep(0) : this.concept);
            o.append(" curnode ");
            o.append(this.node);
            o.append(" orentries [");
            o.append(this.applicableOrEntries);
            o.append("]");
            return o.toString();
        }
    }

    final class BCNN
    extends BranchingContext {
        private int branchIndex;

        BCNN() {
        }

        @Override
        public void init() {
            this.branchIndex = 1;
        }

        @Override
        public void nextOption() {
            ++this.branchIndex;
        }

        protected boolean noMoreNNOptions(int n) {
            return this.branchIndex > n;
        }

        protected int getBranchIndex() {
            return this.branchIndex;
        }

        public void setBranchIndex(int branchIndex) {
            this.branchIndex = branchIndex;
        }
    }

    final class BCLE
    extends BranchingContext {
        private int branchIndex;
        private int mergeCandIndex;
        private List<DlCompletionTreeArc> edges;

        BCLE() {
            this.edges = new ArrayList<DlCompletionTreeArc>();
        }

        @Override
        public void init() {
            this.branchIndex = 0;
            this.mergeCandIndex = 0;
        }

        protected void resetMCI() {
            this.mergeCandIndex = this.edges.size() - 1;
        }

        @Override
        public void nextOption() {
            --this.mergeCandIndex;
            if (this.mergeCandIndex == this.branchIndex) {
                ++this.branchIndex;
                this.resetMCI();
            }
        }

        protected DlCompletionTreeArc getFrom() {
            return this.edges.get(this.mergeCandIndex);
        }

        protected DlCompletionTreeArc getTo() {
            return this.edges.get(this.branchIndex);
        }

        protected boolean noMoreLEOptions() {
            return this.mergeCandIndex <= this.branchIndex;
        }

        protected List<DlCompletionTreeArc> getEdgesToMerge() {
            return this.edges;
        }

        protected void setEdgesToMerge(List<DlCompletionTreeArc> edgesToMerge) {
            this.edges = edgesToMerge;
        }
    }

    final class BCBarrier
    extends BranchingContext {
        BCBarrier() {
        }

        @Override
        public void init() {
        }

        @Override
        public void nextOption() {
        }
    }

    final class BCStack
    extends SaveStack<BranchingContext> {
        private final BCBarrier bcBarrier;

        @Override
        public void push(BranchingContext p) {
            p.init();
            DlSatTester.this.initBC(p);
            super.push(p);
        }

        BCStack() {
            this.bcBarrier = new BCBarrier();
        }

        protected BranchingContext pushOr() {
            BCOr o = new BCOr();
            this.push(o);
            return o;
        }

        protected BranchingContext pushNN() {
            BCNN n = new BCNN();
            this.push(n);
            return n;
        }

        protected BranchingContext pushLE() {
            BCLE e = new BCLE();
            this.push(e);
            return e;
        }

        protected BranchingContext pushCh() {
            BCChoose c = new BCChoose(){

                @Override
                public void nextOption() {
                }

                @Override
                public void init() {
                }
            };
            this.push(c);
            return c;
        }

        protected BranchingContext pushBarrier() {
            this.push(this.bcBarrier);
            return this.bcBarrier;
        }
    }

    abstract class BCChoose
    extends BranchingContext {
        BCChoose() {
        }
    }

    abstract class BranchingContext {
        protected DlCompletionTree node = null;
        protected ConceptWDep concept = null;
        protected DepSet branchDep = DepSetFactory.create();
        int SGsize;

        public abstract void init();

        public abstract void nextOption();

        public String toString() {
            return this.getClass().getSimpleName() + " dep '" + this.branchDep + "' curconcept '" + (this.concept == null ? new ConceptWDep(0) : this.concept) + "' curnode '" + this.node + "'";
        }
    }

    private final class LocalFastSet
    implements FastSet {
        final BitSet pos = new BitSet();

        @Override
        public int[] toIntArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAt(int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAllValues(int ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAll(int i, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean intersect(FastSet f) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int get(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAny(FastSet c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(FastSet c) {
            throw new UnsupportedOperationException();
        }

        private final int asPositive(int p) {
            return p >= 0 ? 2 * p : 1 - 2 * p;
        }

        @Override
        public boolean contains(int o) {
            return this.pos.get(this.asPositive(o));
        }

        @Override
        public void clear() {
            this.pos.clear();
        }

        @Override
        public void addAll(FastSet c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int e) {
            this.pos.set(this.asPositive(e));
        }

        @Override
        public void completeSet(int value) {
            for (int i = 0; i <= value; ++i) {
                this.pos.set(i);
            }
        }
    }
}

