/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.io.PrintStream;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DIOp;
import uk.ac.manchester.cs.jfact.kernel.DumpInterface;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;

final class DumpLisp
extends DumpInterface {
    public DumpLisp(PrintStream oo) {
        super(oo);
    }

    @Override
    public void dumpTop() {
        this.o.print("*TOP*");
    }

    @Override
    public void dumpBottom() {
        this.o.print("*BOTTOM*)");
    }

    @Override
    public void dumpNumber(int n) {
        this.o.print(n + " ");
    }

    @Override
    public void startOp(DIOp Op, int n) {
        this.startOp(Op);
        this.dumpNumber(n);
    }

    @Override
    public void contOp(DIOp Op) {
        if (Op == DIOp.diAnd || Op == DIOp.diOr) {
            this.skipIndent();
        } else {
            this.o.print(" ");
        }
    }

    @Override
    public void finishOp(DIOp Op) {
        if (Op == DIOp.diAnd || Op == DIOp.diOr) {
            this.decIndent();
        }
        this.o.print(")");
    }

    @Override
    public void contAx(DIOp Ax) {
        this.o.print(" ");
    }

    @Override
    public void finishAx(DIOp Ax) {
        this.o.print(")\n");
    }

    @Override
    public void dumpName(NamedEntry p) {
        this.o.print("|" + p.getName() + "|");
    }

    @Override
    public void dumpConcept(Concept p) {
        this.dumpName(p);
    }

    @Override
    public void dumpRole(Role p) {
        if (p.getId() < 0) {
            this.o.print("(inv ");
            this.dumpName(p.inverse());
            this.o.print(")");
        } else {
            this.dumpName(p);
        }
    }

    @Override
    public void startOp(DIOp Op) {
        if (Op == DIOp.diAnd || Op == DIOp.diOr) {
            this.incIndent();
        }
        this.o.print("(");
        this.o.print(Op.getString());
        if (Op == DIOp.diEndOp) {
            throw new UnreachableSituationException();
        }
        this.contOp(Op);
    }

    @Override
    public void startAx(DIOp Ax) {
        this.o.print("(");
        this.o.print(Ax.getString());
        if (Ax == DIOp.diEndOp) {
            throw new UnreachableSituationException();
        }
        this.contAx(Ax);
    }
}

