/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.manchester.cs.jfact.kernel.NameCreator;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptNot;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectSelf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOr;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.DataBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataNot;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOr;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTypeName;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTypeRestriction;
import uk.ac.manchester.cs.jfact.kernel.dl.FacetMaxExclusive;
import uk.ac.manchester.cs.jfact.kernel.dl.FacetMaxInclusive;
import uk.ac.manchester.cs.jfact.kernel.dl.FacetMinExclusive;
import uk.ac.manchester.cs.jfact.kernel.dl.FacetMinInclusive;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleChain;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionFrom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionInto;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataTypeExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.FacetExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleComplexExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public final class ExpressionManager {
    private final NameSet<ConceptName> conceptNameset = new NameSet<ConceptName>(new ConceptNameCreator());
    private final NameSet<IndividualName> individualNameset = new NameSet<IndividualName>(new IndividualNameCreator());
    private final NameSet<ObjectRoleName> objectRoleNameset = new NameSet<ObjectRoleName>(new ObjectroleNameCreator());
    private final NameSet<DataRoleName> dataRoleNameset = new NameSet<DataRoleName>(new DataroleNameCreator());
    private final ConceptTop top = new ConceptTop();
    private final ConceptBottom bottom = new ConceptBottom();
    private final DataTop DTop = new DataTop();
    private ObjectRoleExpression objectRoleTop = new ObjectRoleTop();
    private ObjectRoleExpression objectRoleBottom = new ObjectRoleBottom();
    private DataRoleExpression dataRoleTop = new DataRoleTop();
    private DataRoleExpression dataRoleBottom = new DataRoleBottom();
    private final DataTop dataTop = new DataTop();
    private final DataBottom dataBottom = new DataBottom();
    private final List<Expression> referenceRecorder = new ArrayList<Expression>();
    private final InverseRoleCache inverseRoleCache = new InverseRoleCache();

    protected <T extends Expression> T record(T arg) {
        this.referenceRecorder.add(arg);
        return arg;
    }

    public void setTopBottomRoles(String topORoleName, String botORoleName, String topDRoleName, String botDRoleName) {
        this.objectRoleTop = new ObjectRoleName(topORoleName);
        this.objectRoleBottom = new ObjectRoleName(botORoleName);
        this.dataRoleTop = new DataRoleName(topDRoleName);
        this.dataRoleBottom = new DataRoleName(botDRoleName);
    }

    public boolean isUniversalRole(ObjectRoleExpression R) {
        return R.equals(this.objectRoleTop);
    }

    public boolean isUniversalRole(DataRoleExpression R) {
        return R.equals(this.dataRoleTop);
    }

    public boolean isEmptyRole(ObjectRoleExpression R) {
        return R.equals(this.objectRoleBottom);
    }

    public boolean isEmptyRole(DataRoleExpression R) {
        return R.equals(this.dataRoleBottom);
    }

    public int nConcepts() {
        return this.conceptNameset.size();
    }

    public int nIndividuals() {
        return this.individualNameset.size();
    }

    public int nORoles() {
        return this.objectRoleNameset.size();
    }

    public int nDRoles() {
        return this.dataRoleNameset.size();
    }

    public ConceptExpression top() {
        return this.top;
    }

    public ConceptExpression bottom() {
        return this.bottom;
    }

    public ConceptExpression concept(String name) {
        return this.conceptNameset.insert(name);
    }

    public ConceptExpression not(ConceptExpression C) {
        return this.record(new ConceptNot(C));
    }

    public ConceptExpression and(List<Expression> l) {
        return this.record(new ConceptAnd(l));
    }

    public ConceptExpression and(ConceptExpression C, ConceptExpression D) {
        return this.and(Arrays.asList(C, D));
    }

    public ConceptExpression or(ConceptExpression C, ConceptExpression D) {
        return this.or(Arrays.asList(C, D));
    }

    public ConceptExpression or(List<Expression> l) {
        return this.record(new ConceptOr(l));
    }

    public ConceptExpression oneOf(List<Expression> l) {
        return this.record(new ConceptOneOf(l));
    }

    public ObjectRoleExpression inverse(ObjectRoleExpression R) {
        return this.inverseRoleCache.get(R);
    }

    public ConceptExpression oneOf(IndividualExpression I) {
        return this.oneOf(Arrays.asList(I));
    }

    public ConceptExpression selfReference(ObjectRoleExpression R) {
        return this.record(new ConceptObjectSelf(R));
    }

    public ConceptExpression value(ObjectRoleExpression R, IndividualExpression I) {
        return this.record(new ConceptObjectValue(R, I));
    }

    public ConceptExpression exists(ObjectRoleExpression R, ConceptExpression C) {
        return this.record(new ConceptObjectExists(R, C));
    }

    public ConceptExpression forall(ObjectRoleExpression R, ConceptExpression C) {
        return this.record(new ConceptObjectForall(R, C));
    }

    public ConceptExpression minCardinality(int n, ObjectRoleExpression R, ConceptExpression C) {
        return this.record(new ConceptObjectMinCardinality(n, R, C));
    }

    public ConceptExpression maxCardinality(int n, ObjectRoleExpression R, ConceptExpression C) {
        return this.record(new ConceptObjectMaxCardinality(n, R, C));
    }

    public ConceptExpression cardinality(int n, ObjectRoleExpression R, ConceptExpression C) {
        return this.record(new ConceptObjectExactCardinality(n, R, C));
    }

    public ConceptExpression value(DataRoleExpression R, DataValue V) {
        return this.record(new ConceptDataValue(R, V));
    }

    public ConceptExpression exists(DataRoleExpression R, DataExpression E) {
        return this.record(new ConceptDataExists(R, E));
    }

    public ConceptExpression forall(DataRoleExpression R, DataExpression E) {
        return this.record(new ConceptDataForall(R, E));
    }

    public ConceptExpression minCardinality(int n, DataRoleExpression R, DataExpression E) {
        return this.record(new ConceptDataMinCardinality(n, R, E));
    }

    public ConceptExpression maxCardinality(int n, DataRoleExpression R, DataExpression E) {
        return this.record(new ConceptDataMaxCardinality(n, R, E));
    }

    public ConceptExpression cardinality(int n, DataRoleExpression R, DataExpression E) {
        return this.record(new ConceptDataExactCardinality(n, R, E));
    }

    public IndividualExpression individual(String name) {
        return this.individualNameset.insert(name);
    }

    public ObjectRoleExpression objectRoleTop() {
        return this.objectRoleTop;
    }

    public ObjectRoleExpression objectRoleBottom() {
        return this.objectRoleBottom;
    }

    public ObjectRoleExpression objectRole(String name) {
        return this.objectRoleNameset.insert(name);
    }

    public ObjectRoleComplexExpression compose(List<Expression> l) {
        return this.record(new ObjectRoleChain(l));
    }

    public ObjectRoleComplexExpression projectFrom(ObjectRoleExpression R, ConceptExpression C) {
        return this.record(new ObjectRoleProjectionFrom(R, C));
    }

    public ObjectRoleComplexExpression projectInto(ObjectRoleExpression R, ConceptExpression C) {
        return this.record(new ObjectRoleProjectionInto(R, C));
    }

    public DataRoleExpression dataRoleTop() {
        return this.dataRoleTop;
    }

    public DataRoleExpression dataRoleBottom() {
        return this.dataRoleBottom;
    }

    public DataRoleExpression dataRole(String name) {
        return this.dataRoleNameset.insert(name);
    }

    public DataExpression dataTop() {
        return this.dataTop;
    }

    public DataExpression dataBottom() {
        return this.dataBottom;
    }

    public String getDataTop() {
        return "http://www.w3.org/2000/01/rdf-schema#Literal";
    }

    public DataTypeRestriction restrictedType(DataTypeExpression type, FacetExpression facet) {
        DataTypeRestriction ret = null;
        if (type instanceof DataTypeRestriction) {
            ret = (DataTypeRestriction)type;
        } else {
            DataTypeName hostType = (DataTypeName)type;
            assert (hostType != null);
            ret = this.record(new DataTypeRestriction(hostType));
        }
        ret.add(facet);
        return ret;
    }

    public final DataValue dataValue(String value, DataTypeExpression type) {
        return ExpressionManager.getBasicDataType(type).getValue(value);
    }

    public DataExpression dataNot(DataExpression E) {
        return this.record(new DataNot(E));
    }

    public DataExpression dataAnd(List<Expression> l) {
        return this.record(new DataAnd(l));
    }

    public DataExpression dataOr(List<Expression> l) {
        return this.record(new DataOr(l));
    }

    public DataExpression dataOneOf(List<Expression> l) {
        return this.record(new DataOneOf(l));
    }

    public final FacetExpression facetMinInclusive(DataValue V) {
        return this.record(new FacetMinInclusive(V));
    }

    public final FacetExpression facetMinExclusive(DataValue V) {
        return this.record(new FacetMinExclusive(V));
    }

    public final FacetExpression facetMaxInclusive(DataValue V) {
        return this.record(new FacetMaxInclusive(V));
    }

    public final FacetExpression facetMaxExclusive(DataValue V) {
        return this.record(new FacetMaxExclusive(V));
    }

    public void clear() {
        this.conceptNameset.clear();
        this.individualNameset.clear();
        this.objectRoleNameset.clear();
        this.dataRoleNameset.clear();
        this.inverseRoleCache.clear();
        this.referenceRecorder.clear();
    }

    private static DataTypeName getBasicDataType(DataTypeExpression type) {
        if (type instanceof DataTypeName) {
            return (DataTypeName)type;
        }
        DataTypeRestriction hostType = (DataTypeRestriction)type;
        return hostType.getExpr();
    }

    protected static final class ConceptNameCreator
    implements NameCreator<ConceptName> {
        protected ConceptNameCreator() {
        }

        @Override
        public ConceptName makeEntry(String name) {
            return new ConceptName(name);
        }
    }

    protected static final class IndividualNameCreator
    implements NameCreator<IndividualName> {
        protected IndividualNameCreator() {
        }

        @Override
        public IndividualName makeEntry(String name) {
            return new IndividualName(name);
        }
    }

    protected static final class ObjectroleNameCreator
    implements NameCreator<ObjectRoleName> {
        protected ObjectroleNameCreator() {
        }

        @Override
        public ObjectRoleName makeEntry(String name) {
            return new ObjectRoleName(name);
        }
    }

    protected static final class DataroleNameCreator
    implements NameCreator<DataRoleName> {
        protected DataroleNameCreator() {
        }

        @Override
        public DataRoleName makeEntry(String name) {
            return new DataRoleName(name);
        }
    }

    protected final class InverseRoleCache {
        private Map<ObjectRoleExpression, ObjectRoleExpression> map;

        protected InverseRoleCache() {
        }

        public ObjectRoleExpression get(ObjectRoleExpression tail) {
            if (this.map != null && this.map.containsKey(tail)) {
                return this.map.get(tail);
            }
            ObjectRoleExpression concat = this.build(tail);
            if (this.map == null) {
                this.map = new HashMap<ObjectRoleExpression, ObjectRoleExpression>();
            }
            this.map.put(tail, concat);
            return concat;
        }

        public void clear() {
            if (this.map != null) {
                this.map.clear();
            }
        }

        public ObjectRoleExpression build(ObjectRoleExpression tail) {
            return ExpressionManager.this.record(new ObjectRoleInverse(tail));
        }
    }
}

