/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import uk.ac.manchester.cs.jfact.helpers.LeveLogger;

public final class IFOption {
    private final String optionName;
    private final String optionDescription;
    private final String defaultValue;
    private String tValue;
    private final IOType type;
    private int iValue;
    private boolean bValue;

    public boolean getBool() {
        assert (this.type == IOType.iotBool);
        return this.bValue;
    }

    public int getInt() {
        assert (this.type == IOType.iotInt);
        return this.iValue;
    }

    public String getText() {
        assert (this.type == IOType.iotText);
        return this.tValue;
    }

    public IFOption(String name, String desc, IOType t, String defVal) {
        this.optionName = name;
        this.optionDescription = desc;
        this.defaultValue = defVal;
        this.type = t;
        this.setAValue(defVal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setAValue(String s) {
        if (this.type == IOType.iotBool) {
            if (s.equals("0") || s.equals("off") || s.equals("no") || s.equals("false")) {
                this.bValue = false;
                return false;
            } else {
                if (!s.equals("1") && !s.equals("on") && !s.equals("yes") && !s.equals("true")) return true;
                this.bValue = true;
            }
            return false;
        } else if (this.type == IOType.iotInt) {
            if (!Character.isDigit(s.charAt(0))) {
                return true;
            }
            this.iValue = Integer.parseInt(s);
            return false;
        } else {
            this.tValue = s;
        }
        return false;
    }

    public void printConfString(LeveLogger.LogAdapter o) {
        o.print(String.format("\n;---\n;--- Option '%s': %s ---\n;---\n;* %s\n;* Default value: '%s'\n\n; %s = %s\n", new Object[]{this.optionName, this.type, this.optionDescription, this.defaultValue, this.optionName, this.type.get(this)}));
    }

    public static enum IOType {
        iotBool("boolean"){

            @Override
            public Object get(IFOption i) {
                return i.getBool();
            }
        }
        ,
        iotInt("integer"){

            @Override
            public Object get(IFOption i) {
                return i.getInt();
            }
        }
        ,
        iotText("text"){

            @Override
            public Object get(IFOption i) {
                return i.getText();
            }
        };

        private final String s;

        private IOType(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }

        public abstract Object get(IFOption var1);
    }
}

