/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.Related;
import uk.ac.manchester.cs.jfact.kernel.Role;

public class Individual
extends Concept {
    private DlCompletionTree node = null;
    private final List<Related> relatedIndex = new ArrayList<Related>();
    private Map<Role, List<Individual>> pRelatedMap = new HashMap<Role, List<Individual>>();

    public Individual(String name) {
        super(name);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void initToldSubsumers() {
        boolean CD;
        this.toldSubsumers.clear();
        this.setHasSP(false);
        if (this.isRelated()) {
            this.updateToldFromRelated();
        }
        if (this.isPrimitive() && this.description != null && this.description.isTOP()) {
            this.removeDescription();
        }
        boolean bl = CD = !this.hasExtraRules() && this.isPrimitive() && !this.isRelated();
        if (this.description != null || this.hasToldSubsumers()) {
            CD &= super.initToldSubsumers(this.description, new HashSet<Role>());
        }
        this.setCompletelyDefined(CD);
    }

    private <T extends Related> void updateTold(List<T> begin, Set<Role> RolesProcessed) {
        for (int i = 0; i < begin.size(); ++i) {
            this.searchTSbyRoleAndSupers(((Related)begin.get(i)).getRole(), RolesProcessed);
        }
    }

    private boolean isRelated() {
        return !this.relatedIndex.isEmpty();
    }

    public void addRelated(Related p) {
        this.relatedIndex.add(p);
    }

    public void addRelated(Individual p) {
        this.relatedIndex.addAll(p.relatedIndex);
    }

    public boolean hasRelatedCache(Role R) {
        return this.pRelatedMap.containsKey(R);
    }

    public List<Individual> getRelatedCache(Role R) {
        assert (this.pRelatedMap.containsKey(R));
        return this.pRelatedMap.get(R);
    }

    public void setRelatedCache(Role R, List<Individual> v) {
        assert (!this.pRelatedMap.containsKey(R));
        this.pRelatedMap.put(R, v);
    }

    private void updateToldFromRelated() {
        HashSet<Role> RolesProcessed = new HashSet<Role>();
        this.updateTold(this.relatedIndex, RolesProcessed);
    }

    public DlCompletionTree getNode() {
        return this.node;
    }

    public void setNode(DlCompletionTree node) {
        this.node = node;
    }

    public List<Related> getRelatedIndex() {
        return this.relatedIndex;
    }
}

