/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Token;

public final class Lexeme {
    private final Token token;
    private final NamedEntry pName;
    int data;

    private Lexeme(Token tok, NamedEntry e, int i) {
        this.token = tok;
        this.pName = e;
        this.data = i;
    }

    public Lexeme(Token tok, NamedEntry p) {
        this(tok, p, 0);
    }

    public Lexeme(Token tok) {
        this(tok, null, 0);
    }

    public Lexeme(Token tok, int val) {
        this(tok, null, val);
    }

    public Lexeme(Lexeme t) {
        this(t.token, t.pName, t.data);
    }

    public Token getToken() {
        return this.token;
    }

    public NamedEntry getNE() {
        return this.pName;
    }

    public int getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Lexeme) {
            Lexeme lex = (Lexeme)obj;
            if (!this.token.equals((Object)lex.token)) {
                return false;
            }
            if (this.pName == null && lex.pName == null) {
                return this.data == lex.data;
            }
            if (this.pName == null) {
                return false;
            }
            return this.pName.equals(lex.pName);
        }
        return false;
    }

    public int hashCode() {
        return this.token.hashCode() + this.data;
    }

    public String toString() {
        if (this.pName == null) {
            return this.token.getName();
        }
        if (this.token == Token.INAME) {
            return "(" + this.token.getName() + " " + this.pName.toString() + ")";
        }
        return this.token.getName() + " " + this.pName.toString();
    }
}

