/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.BitSet;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Role;

public final class LogicFeatures {
    private BitSet flags = new BitSet();
    private static final int lfTransitiveRoles = 1;
    private static final int lfRolesSubsumption = 2;
    private static final int lfDirectRoles = 3;
    private static final int lfInverseRoles = 4;
    private static final int lfRangeAndDomain = 5;
    private static final int lfFunctionalRoles = 6;
    private static final int lfSomeConstructor = 7;
    private static final int lfFConstructor = 8;
    private static final int lfNConstructor = 9;
    private static final int lfQConstructor = 10;
    private static final int lfSingleton = 11;
    private static final int lfGeneralAxioms = 12;
    private static final int lfBothRoles = 13;
    private static final int lfSelfRef = 14;
    private static final int lfTopRole = 15;

    private void setX(int val) {
        this.flags.set(val);
    }

    private boolean getX(int val) {
        return this.flags.get(val);
    }

    public LogicFeatures() {
    }

    public LogicFeatures(LogicFeatures lf) {
        this.flags.or(lf.flags);
    }

    public void or(LogicFeatures lf) {
        this.flags.or(lf.flags);
    }

    public boolean hasInverseRole() {
        return this.getX(13);
    }

    private boolean hasRoleHierarchy() {
        return this.getX(2);
    }

    private boolean hasTransitiveRole() {
        return this.getX(1);
    }

    public boolean hasSomeAll() {
        return this.getX(7);
    }

    public boolean hasFunctionalRestriction() {
        return this.getX(8) || this.getX(6);
    }

    public boolean hasNumberRestriction() {
        return this.getX(9);
    }

    public boolean hasQNumberRestriction() {
        return this.getX(10);
    }

    public boolean hasSingletons() {
        return this.getX(11);
    }

    public boolean hasSelfRef() {
        return this.getX(14);
    }

    public boolean hasTopRole() {
        return this.getX(15);
    }

    public boolean isEmpty() {
        return this.flags.isEmpty();
    }

    public void mergeRoles() {
        if (this.getX(3) && this.getX(4)) {
            this.setX(13);
        }
    }

    public void setInverseRoles() {
        this.setX(13);
    }

    public static LogicFeatures plus(LogicFeatures f1, LogicFeatures f2) {
        LogicFeatures f = new LogicFeatures(f1);
        f.flags.or(f2.flags);
        return f;
    }

    public void fillConceptData(Concept p) {
        if (p.isSingleton()) {
            this.setX(11);
        }
    }

    public void fillRoleData(Role p, boolean both) {
        if (p.isTop()) {
            if (!p.isDataRole()) {
                this.setX(15);
            }
            return;
        }
        if (p.getId() > 0) {
            this.setX(3);
        } else {
            this.setX(4);
        }
        if (both) {
            this.setX(13);
        }
        if (p.isTransitive()) {
            this.setX(1);
        }
        if (p.hasToldSubsumers()) {
            this.setX(2);
        }
        if (p.isFunctional()) {
            this.setX(6);
        }
        if (p.getBPDomain() != 1 || p.getBPRange() != 1) {
            this.setX(5);
        }
    }

    public void fillDAGData(DLVertex v, boolean pos) {
        switch (v.getType()) {
            case dtForall: {
                this.setX(7);
                break;
            }
            case dtLE: {
                this.setX(9);
                if (v.getConceptIndex() == 1) break;
                this.setX(10);
                break;
            }
            case dtPSingleton: 
            case dtNSingleton: {
                this.setX(11);
                break;
            }
            case dtIrr: {
                this.setX(14);
                break;
            }
        }
    }

    public void writeState() {
        String NO = "NO ";
        String Q = "qualified ";
        Object[] objectArray = new Object[8];
        objectArray[0] = this.hasInverseRole() ? "" : NO;
        objectArray[1] = this.hasRoleHierarchy() ? "" : NO;
        objectArray[2] = this.hasTransitiveRole() ? "" : NO;
        objectArray[3] = this.hasTopRole() ? "" : NO;
        objectArray[4] = this.hasSomeAll() ? "" : NO;
        Object object = objectArray[5] = this.hasFunctionalRestriction() ? "" : NO;
        objectArray[6] = this.hasNumberRestriction() ? (this.hasQNumberRestriction() ? Q : "") : NO;
        objectArray[7] = this.hasSingletons() ? "" : NO;
        LeveLogger.logger.print(LeveLogger.Templates.WRITE_STATE, objectArray);
    }
}

