/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.NameCreator;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.ReasonerFreshEntityException;

public class NamedEntryCollection<T extends NamedEntry> {
    private final List<T> base = new ArrayList<T>();
    private final NameSet<T> nameset;
    private final String typeName;
    private boolean locked;

    public void registerNew(T p) {
    }

    public T registerElem(T p) {
        ((NamedEntry)p).setId(this.base.size());
        this.base.add(p);
        this.registerNew(p);
        return p;
    }

    public NamedEntryCollection(String name, NameCreator<T> creator) {
        this.typeName = name;
        this.locked = false;
        this.base.add(null);
        this.nameset = new NameSet<T>(creator);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean setLocked(boolean val) {
        boolean old = this.locked;
        this.locked = val;
        return old;
    }

    public boolean isRegistered(String name) {
        return this.nameset.get(name) != null;
    }

    public T get(String name) {
        NamedEntry p = (NamedEntry)this.nameset.get(name);
        if (p != null) {
            return (T)p;
        }
        if (this.isLocked()) {
            throw new ReasonerFreshEntityException("Unable to register '" + name + "' as a " + this.typeName, name);
        }
        return (T)this.registerElem((NamedEntry)this.nameset.add(name));
    }

    public boolean remove(T p) {
        if (!this.isRegistered(((NamedEntry)p).getName())) {
            return true;
        }
        if (this.base.size() - ((NamedEntry)p).getId() != 1) {
            return true;
        }
        Helper.resize(this.base, ((NamedEntry)p).getId());
        this.nameset.remove(((NamedEntry)p).getName());
        return false;
    }

    public List<T> getList() {
        return this.base.subList(1, this.base.size());
    }

    public int size() {
        return this.base.size() - 1;
    }
}

