/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.dep.DepSetFactory;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.Pair;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.DlSatTester;
import uk.ac.manchester.cs.jfact.kernel.IFOptionSet;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.Related;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;

public final class NominalReasoner
extends DlSatTester {
    protected List<Individual> nominals = new ArrayList<Individual>();

    @Override
    public boolean hasNominals() {
        return true;
    }

    protected void registerNominalCache(Individual p) {
        this.dlHeap.setCache(p.getpName(), this.createModelCache(p.getNode().resolvePBlocker()));
    }

    protected boolean initNominalNode(Individual nom) {
        DlCompletionTree node = this.cGraph.getNewNode();
        node.setNominalLevel();
        nom.setNode(node);
        return this.initNewNode(node, DepSetFactory.create(), nom.getpName());
    }

    protected void updateClassifiedSingleton(Individual p) {
        this.registerNominalCache(p);
        if (p.getNode().isPBlocked()) {
            int bp = p.getNode().getBlocker().label().get_sc().get(0).getConcept();
            Individual blocker = (Individual)this.dlHeap.get(bp).getConcept();
            assert (blocker.getNode().equals(p.getNode().getBlocker()));
            this.tBox.sameIndividuals.put(p, new Pair<Individual, Boolean>(blocker, p.getNode().getPurgeDep().isEmpty()));
        }
    }

    public NominalReasoner(TBox tbox, IFOptionSet Options) {
        super(tbox, Options);
        for (Individual pi : this.tBox.i_begin()) {
            if (pi.isSynonym()) continue;
            this.nominals.add(pi);
        }
    }

    @Override
    protected void prepareReasoner() {
        LeveLogger.logger.print("\nInitNominalReasoner:");
        this.restore(1);
        if (!(this.bContext instanceof DlSatTester.BCBarrier)) {
            this.stack.pop();
            this.createBCBarrier();
        }
        this.save();
        this.resetSessionFlags();
    }

    public boolean consistentNominalCloud() {
        LeveLogger.logger.print("\n\nChecking consistency of an ontology with individuals:\n");
        boolean result = false;
        if (this.initNewNode(this.cGraph.getRoot(), DepSetFactory.create(), 1) || this.initNominalCloud()) {
            LeveLogger.logger.print("\ninit done\n");
            result = false;
        } else {
            LeveLogger.logger.print("\nrunning sat...");
            result = this.runSat();
            LeveLogger.logger.print(" done: ");
            LeveLogger.logger.print(result);
            LeveLogger.logger.print("\n");
        }
        if (result && this.noBranchingOps()) {
            LeveLogger.logger.print("InitNominalReasoner[");
            this.curNode = null;
            this.createBCBarrier();
            this.save();
            this.nonDetShift = 1;
            LeveLogger.logger.print("]");
        }
        LeveLogger.logger.print(LeveLogger.Templates.CONSISTENT_NOMINAL, result ? "consistent" : "INCONSISTENT");
        if (!result) {
            return false;
        }
        for (Individual p : this.nominals) {
            this.updateClassifiedSingleton(p);
        }
        return true;
    }

    private boolean initNominalCloud() {
        for (Individual p : this.nominals) {
            if (!this.initNominalNode(p)) continue;
            return true;
        }
        for (int i = 0; i < this.tBox.getRelatedI().size(); i += 2) {
            if (!this.initRelatedNominals(this.tBox.getRelatedI().get(i))) continue;
            return true;
        }
        if (this.tBox.getDifferent().isEmpty()) {
            return false;
        }
        DepSet dummy = DepSetFactory.create();
        for (List<Individual> r : this.tBox.getDifferent()) {
            this.cGraph.initIR();
            for (Individual p : r) {
                if (!this.cGraph.setCurIR(ClassifiableEntry.resolveSynonym(p).getNode(), dummy)) continue;
                return true;
            }
            this.cGraph.finiIR();
        }
        return false;
    }

    @Override
    protected boolean isNNApplicable(Role r, int C, int stopper) {
        if (!this.curNode.isNominalNode()) {
            return false;
        }
        if (this.curNode.isLabelledBy(stopper)) {
            return false;
        }
        List<DlCompletionTreeArc> neighbour = this.curNode.getNeighbour();
        for (int i = 0; i < neighbour.size(); ++i) {
            DlCompletionTreeArc p = neighbour.get(i);
            DlCompletionTree suspect = p.getArcEnd();
            if (!p.isPredEdge() || !suspect.isBlockableNode() || !p.isNeighbour(r) || !suspect.isLabelledBy(C)) continue;
            LeveLogger.logger.print(LeveLogger.Templates.NN, suspect.getId());
            return true;
        }
        return false;
    }

    private boolean initRelatedNominals(Related rel) {
        DlCompletionTree from = ClassifiableEntry.resolveSynonym(rel.getA()).getNode();
        DlCompletionTree to = ClassifiableEntry.resolveSynonym(rel.getB()).getNode();
        Role R = ClassifiableEntry.resolveSynonym(rel.getRole());
        DepSet dep = DepSetFactory.create();
        if (R.isDisjoint() && this.checkDisjointRoleClash(from, to, R, dep)) {
            return true;
        }
        DlCompletionTreeArc pA = this.cGraph.addRoleLabel(from, to, false, R, dep);
        return this.setupEdge(pA, dep, 0);
    }

    private void createBCBarrier() {
        this.bContext = this.stack.pushBarrier();
    }
}

