/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.Role;

public final class RAStateTransitions {
    protected final List<RATransition> base = new ArrayList<RATransition>();
    protected boolean emptyTransition = false;
    private final BitSet applicableRoles = new BitSet();
    private int from;
    private boolean dataRole;
    private int size = 0;

    public List<RATransition> begin() {
        return this.base;
    }

    public void add(RATransition trans) {
        this.base.add(trans);
        ++this.size;
        if (trans.isEmpty()) {
            this.emptyTransition = true;
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean hasEmptyTransition() {
        return this.emptyTransition;
    }

    public void print(LeveLogger.LogAdapter o) {
        for (int i = 0; i < this.size; ++i) {
            this.base.get(i).print(o, this.from);
        }
    }

    public void setup(int state, int nRoles, boolean data) {
        this.from = state;
        this.dataRole = data;
        for (int i = 0; i < this.size; ++i) {
            for (Role t : this.base.get(i).begin()) {
                this.applicableRoles.set(t.getAbsoluteIndex());
            }
        }
    }

    public boolean addToExisting(RATransition trans) {
        int to = trans.final_state();
        boolean tEmpty = trans.isEmpty();
        for (int i = 0; i < this.size; ++i) {
            RATransition p = this.base.get(i);
            if (p.final_state() != to || p.isEmpty() != tEmpty) continue;
            p.add(trans);
            return true;
        }
        return false;
    }

    public boolean recognise(Role R) {
        if (R == null) {
            return false;
        }
        return R.isDataRole() == this.dataRole && this.applicableRoles.get(R.getAbsoluteIndex());
    }

    public boolean isSingleton() {
        return this.size == 1;
    }

    public int getTransitionEnd() {
        return this.base.get(0).final_state();
    }
}

