/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.Role;

public final class RATransition {
    private final LinkedHashSet<Role> label;
    BitSet cache = null;
    private final int state;

    public RATransition(int st) {
        this.state = st;
        this.label = new LinkedHashSet();
    }

    public RATransition(int st, Role R) {
        this(st);
        this.label.add(R);
    }

    public void add(RATransition trans) {
        this.label.addAll(trans.label);
        this.cache = null;
    }

    public Collection<Role> begin() {
        return this.label;
    }

    public int final_state() {
        return this.state;
    }

    public boolean applicable(Role R) {
        if (this.cache == null) {
            this.cache = new BitSet();
            for (Role t : this.label) {
                this.cache.set(t.getAbsoluteIndex());
            }
        }
        return this.cache.get(R.getAbsoluteIndex());
    }

    public boolean isEmpty() {
        return this.label.isEmpty();
    }

    public void print(LeveLogger.LogAdapter o, int from) {
        o.print(String.format("\n%s -- ", from));
        if (this.isEmpty()) {
            o.print("e");
        } else {
            ArrayList<Role> l = new ArrayList<Role>(this.label);
            for (int i = 0; i < l.size(); ++i) {
                if (i > 0) {
                    o.print(",");
                }
                o.print("\"");
                o.print(((Role)l.get(i)).getName());
                o.print("\"");
            }
        }
        o.print(" -> ");
        o.print(this.final_state());
    }
}

