/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.IfDefs;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.CacheStatus;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.ExpressionTranslator;
import uk.ac.manchester.cs.jfact.kernel.IFOption;
import uk.ac.manchester.cs.jfact.kernel.IFOptionSet;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBStatus;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.OntologyLoader;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.actors.Actor;
import uk.ac.manchester.cs.jfact.kernel.actors.RIActor;
import uk.ac.manchester.cs.jfact.kernel.actors.SupConceptActor;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDeclaration;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDifferentIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointUnion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomFairnessConstraint;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomInstanceOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedTo;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedToNot;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleAsymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverseFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleIrreflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleReflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleSymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleTransitive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomSameIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOfNot;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Axiom;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleComplexExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;
import uk.ac.manchester.cs.jfact.split.TAxiomSplitter;

public final class ReasoningKernel {
    private final IFOptionSet kernelOptions = new IFOptionSet();
    private TBox pTBox = null;
    private final Ontology ontology = new Ontology();
    private ExpressionTranslator pET = null;
    private String topORoleName;
    private String botORoleName;
    private String topDRoleName;
    private String botDRoleName;
    private ReasonerProgressMonitor pMonitor = null;
    private AtomicBoolean interrupted;
    private boolean useELReasoner;
    private final long opTimeout;
    private boolean verboseOutput;
    private CacheStatus cacheLevel;
    private DLTree cachedQuery;
    private Concept cachedConcept;
    private TaxonomyVertex cachedVertex;
    private boolean reasoningFailed;
    private final List<Axiom> traceVec = new ArrayList<Axiom>();
    private boolean needTracing;

    public void setInterruptedSwitch(AtomicBoolean b) {
        this.interrupted = b;
    }

    private KBStatus getStatus() {
        if (this.pTBox == null) {
            return KBStatus.kbEmpty;
        }
        if (this.ontology.isChanged()) {
            return KBStatus.kbLoading;
        }
        return this.pTBox.getStatus();
    }

    private DLTree e(Expression expr) {
        return expr.accept(this.pET);
    }

    private DLTree getFreshFiller(DLTree R) {
        if (Role.resolveRole(R).isDataRole()) {
            return this.getTBox().getDataTypeCenter().getFreshDataType();
        }
        return this.getTBox().getFreshConcept();
    }

    private void initCacheAndFlags() {
        this.cacheLevel = CacheStatus.csEmpty;
        this.cachedQuery = null;
        this.cachedConcept = null;
        this.cachedVertex = null;
        this.reasoningFailed = false;
        this.needTracing = false;
    }

    public void needTracing() {
        this.needTracing = true;
    }

    public List<Axiom> getTrace() {
        ArrayList<Axiom> toReturn = new ArrayList<Axiom>(this.traceVec);
        this.traceVec.clear();
        return toReturn;
    }

    public Axiom disjointUnion(ConceptExpression C, List<Expression> l) {
        return this.ontology.add(new AxiomDisjointUnion(C, l));
    }

    private List<Individual> getRelated(Individual I, Role R) {
        if (!I.hasRelatedCache(R)) {
            I.setRelatedCache(R, this.buildRelatedCache(I, R));
        }
        return I.getRelatedCache(R);
    }

    private boolean checkSat(DLTree C) {
        if (C.isCN()) {
            return this.getTBox().isSatisfiable(this.getTBox().getCI(C));
        }
        this.setUpCache(C, CacheStatus.csSat);
        return this.getTBox().isSatisfiable(this.cachedConcept);
    }

    private boolean checkSub(Concept C, Concept D) {
        if (this.getStatus().ordinal() < KBStatus.kbClassified.ordinal()) {
            return this.getTBox().isSubHolds(C, D);
        }
        SupConceptActor actor = new SupConceptActor(D);
        Taxonomy tax = this.getCTaxonomy();
        if (tax.getRelativesInfo(C.getTaxVertex(), actor, true, false, true)) {
            return false;
        }
        tax.clearCheckedLabel();
        return true;
    }

    private boolean checkSub(DLTree C, DLTree D) {
        if (C.isCN() && D.isCN()) {
            return this.checkSub(this.getTBox().getCI(C), this.getTBox().getCI(D));
        }
        return !this.checkSat(DLTreeFactory.createSNFAnd(C, DLTreeFactory.createSNFNot(D)));
    }

    private void checkTBox() {
        if (this.pTBox == null) {
            throw new ReasonerInternalException("KB Not Initialised");
        }
    }

    private TBox getTBox() {
        this.checkTBox();
        return this.pTBox;
    }

    private void clearTBox() {
        this.pTBox = null;
        this.pET = null;
        this.cachedQuery = null;
    }

    private RoleMaster getORM() {
        return this.getTBox().getORM();
    }

    private RoleMaster getDRM() {
        return this.getTBox().getDRM();
    }

    private Taxonomy getCTaxonomy() {
        if (!this.isKBClassified()) {
            throw new ReasonerInternalException("No access to concept taxonomy: ontology not classified");
        }
        return this.getTBox().getTaxonomy();
    }

    private Taxonomy getORTaxonomy() {
        if (!this.isKBPreprocessed()) {
            throw new ReasonerInternalException("No access to the object role taxonomy: ontology not preprocessed");
        }
        return this.getORM().getTaxonomy();
    }

    private Taxonomy getDRTaxonomy() {
        if (!this.isKBPreprocessed()) {
            throw new ReasonerInternalException("No access to the data role taxonomy: ontology not preprocessed");
        }
        return this.getDRM().getTaxonomy();
    }

    private Individual getIndividual(IndividualExpression i, String reason) {
        DLTree I = this.e(i);
        if (I == null) {
            throw new ReasonerInternalException(reason);
        }
        return (Individual)this.getTBox().getCI(I);
    }

    private Role getRole(RoleExpression r, String reason) {
        return Role.resolveRole(this.e(r));
    }

    private Taxonomy getTaxonomy(Role R) {
        return R.isDataRole() ? this.getDRTaxonomy() : this.getORTaxonomy();
    }

    private TaxonomyVertex getTaxVertex(Role R) {
        return R.getTaxVertex();
    }

    private IFOptionSet getOptions() {
        return this.kernelOptions;
    }

    public boolean isKBPreprocessed() {
        return this.getStatus().ordinal() >= KBStatus.kbCChecked.ordinal();
    }

    public boolean isKBClassified() {
        return this.getStatus().ordinal() >= KBStatus.kbClassified.ordinal();
    }

    public boolean isKBRealised() {
        return this.getStatus().ordinal() >= KBStatus.kbRealised.ordinal();
    }

    public void setProgressMonitor(ReasonerProgressMonitor pMon) {
        this.pMonitor = pMon;
        if (this.pTBox != null) {
            this.pTBox.setProgressMonitor(pMon);
        }
    }

    public void setVerboseOutput(boolean value) {
        this.verboseOutput = value;
        if (this.pTBox != null) {
            this.pTBox.setVerboseOutput(value);
        }
    }

    public void setTopBottomRoleNames(String topO, String botO, String topD, String botD) {
        this.topORoleName = topO;
        this.botORoleName = botO;
        this.topDRoleName = topD;
        this.botDRoleName = botD;
        this.ontology.getExpressionManager().setTopBottomRoles(this.topORoleName, this.botORoleName, this.topDRoleName, this.botDRoleName);
    }

    public void writeReasoningResult(LeveLogger.LogAdapter o, long time) {
        this.getTBox().writeReasoningResult(o, time);
    }

    private boolean checkFunctionality(DLTree R) {
        DLTree tmp = DLTreeFactory.createSNFExists(R.copy(), DLTreeFactory.createSNFNot(this.getFreshFiller(R)));
        return !this.checkSat(tmp = DLTreeFactory.createSNFAnd(tmp, DLTreeFactory.createSNFExists(R, this.getFreshFiller(R))));
    }

    private boolean getFunctionality(Role R) {
        if (!R.isFunctionalityKnown()) {
            R.setFunctional(this.checkFunctionality(DLTreeFactory.buildTree(new Lexeme(R.isDataRole() ? Token.DNAME : Token.RNAME, R))));
        }
        return R.isFunctional();
    }

    private boolean checkTransitivity(DLTree R) {
        DLTree tmp = DLTreeFactory.createSNFExists(R.copy(), DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept()));
        tmp = DLTreeFactory.createSNFExists(R.copy(), tmp);
        return !this.checkSat(tmp = DLTreeFactory.createSNFAnd(tmp, DLTreeFactory.createSNFForall(R, this.getTBox().getFreshConcept())));
    }

    private boolean checkSymmetry(DLTree R) {
        DLTree tmp = DLTreeFactory.createSNFForall(R.copy(), DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept()));
        tmp = DLTreeFactory.createSNFAnd(this.getTBox().getFreshConcept(), DLTreeFactory.createSNFExists(R, tmp));
        return !this.checkSat(tmp);
    }

    private boolean checkReflexivity(DLTree R) {
        DLTree tmp = DLTreeFactory.createSNFForall(R, DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept()));
        tmp = DLTreeFactory.createSNFAnd(this.getTBox().getFreshConcept(), tmp);
        return !this.checkSat(tmp);
    }

    private boolean checkRoleSubsumption(DLTree R, DLTree S) {
        if (Role.resolveRole(R).isDataRole() != Role.resolveRole(S).isDataRole()) {
            return false;
        }
        DLTree tmp = DLTreeFactory.createSNFForall(S, DLTreeFactory.createSNFNot(this.getFreshFiller(S)));
        tmp = DLTreeFactory.createSNFAnd(DLTreeFactory.createSNFExists(R, this.getFreshFiller(R)), tmp);
        return !this.checkSat(tmp);
    }

    public ExpressionManager getExpressionManager() {
        return this.ontology.getExpressionManager();
    }

    private boolean newKB() {
        if (this.pTBox != null) {
            return true;
        }
        this.pTBox = new TBox(this.getOptions(), this.topORoleName, this.botORoleName, this.topDRoleName, this.botDRoleName, this.interrupted, this.opTimeout);
        this.pTBox.setProgressMonitor(this.pMonitor);
        this.pTBox.setVerboseOutput(this.verboseOutput);
        this.pET = new ExpressionTranslator(this.pTBox);
        this.initCacheAndFlags();
        return false;
    }

    private boolean releaseKB() {
        this.clearTBox();
        this.ontology.clear();
        return false;
    }

    public boolean clearKB() {
        if (this.pTBox == null) {
            return true;
        }
        return this.releaseKB() || this.newKB();
    }

    public Axiom declare(Expression C) {
        return this.ontology.add(new AxiomDeclaration(C));
    }

    public Axiom impliesConcepts(ConceptExpression C, ConceptExpression D) {
        return this.ontology.add(new AxiomConceptInclusion(C, D));
    }

    public Axiom equalConcepts(List<Expression> l) {
        return this.ontology.add(new AxiomEquivalentConcepts(l));
    }

    public Axiom disjointConcepts(List<Expression> l) {
        return this.ontology.add(new AxiomDisjointConcepts(l));
    }

    public Axiom setInverseRoles(ObjectRoleExpression R, ObjectRoleExpression S) {
        return this.ontology.add(new AxiomRoleInverse(R, S));
    }

    public Axiom impliesORoles(ObjectRoleComplexExpression R, ObjectRoleExpression S) {
        return this.ontology.add(new AxiomORoleSubsumption(R, S));
    }

    public Axiom impliesDRoles(DataRoleExpression R, DataRoleExpression S) {
        return this.ontology.add(new AxiomDRoleSubsumption(R, S));
    }

    public Axiom equalORoles(List<Expression> l) {
        return this.ontology.add(new AxiomEquivalentORoles(l));
    }

    public Axiom equalDRoles(List<Expression> l) {
        return this.ontology.add(new AxiomEquivalentDRoles(l));
    }

    public Axiom disjointORoles(List<Expression> l) {
        return this.ontology.add(new AxiomDisjointORoles(l));
    }

    public Axiom disjointDRoles(List<Expression> l) {
        return this.ontology.add(new AxiomDisjointDRoles(l));
    }

    public Axiom setODomain(ObjectRoleExpression R, ConceptExpression C) {
        return this.ontology.add(new AxiomORoleDomain(R, C));
    }

    public Axiom setDDomain(DataRoleExpression R, ConceptExpression C) {
        return this.ontology.add(new AxiomDRoleDomain(R, C));
    }

    public Axiom setORange(ObjectRoleExpression R, ConceptExpression C) {
        return this.ontology.add(new AxiomORoleRange(R, C));
    }

    public Axiom setDRange(DataRoleExpression R, DataExpression E) {
        return this.ontology.add(new AxiomDRoleRange(R, E));
    }

    public Axiom setTransitive(ObjectRoleExpression R) {
        return this.ontology.add(new AxiomRoleTransitive(R));
    }

    public Axiom setReflexive(ObjectRoleExpression R) {
        return this.ontology.add(new AxiomRoleReflexive(R));
    }

    public Axiom setIrreflexive(ObjectRoleExpression R) {
        return this.ontology.add(new AxiomRoleIrreflexive(R));
    }

    public Axiom setSymmetric(ObjectRoleExpression R) {
        return this.ontology.add(new AxiomRoleSymmetric(R));
    }

    public Axiom setAsymmetric(ObjectRoleExpression R) {
        return this.ontology.add(new AxiomRoleAsymmetric(R));
    }

    public Axiom setOFunctional(ObjectRoleExpression R) {
        return this.ontology.add(new AxiomORoleFunctional(R));
    }

    public Axiom setDFunctional(DataRoleExpression R) {
        return this.ontology.add(new AxiomDRoleFunctional(R));
    }

    public Axiom setInverseFunctional(ObjectRoleExpression R) {
        return this.ontology.add(new AxiomRoleInverseFunctional(R));
    }

    public Axiom instanceOf(IndividualExpression I, ConceptExpression C) {
        return this.ontology.add(new AxiomInstanceOf(I, C));
    }

    public Axiom relatedTo(IndividualExpression I, ObjectRoleExpression R, IndividualExpression J) {
        return this.ontology.add(new AxiomRelatedTo(I, R, J));
    }

    public Axiom relatedToNot(IndividualExpression I, ObjectRoleExpression R, IndividualExpression J) {
        return this.ontology.add(new AxiomRelatedToNot(I, R, J));
    }

    public Axiom valueOf(IndividualExpression I, DataRoleExpression A, DataValue V) {
        return this.ontology.add(new AxiomValueOf(I, A, V));
    }

    public Axiom valueOfNot(IndividualExpression I, DataRoleExpression A, DataValue V) {
        return this.ontology.add(new AxiomValueOfNot(I, A, V));
    }

    public Axiom processSame(List<Expression> l) {
        return this.ontology.add(new AxiomSameIndividuals(l));
    }

    public Axiom processDifferent(List<Expression> l) {
        return this.ontology.add(new AxiomDifferentIndividuals(l));
    }

    public Axiom setFairnessConstraint(List<Expression> l) {
        return this.ontology.add(new AxiomFairnessConstraint(l));
    }

    public void retract(Axiom axiom) {
        this.ontology.retract(axiom);
    }

    public boolean isKBConsistent() {
        if (this.getStatus().ordinal() <= KBStatus.kbLoading.ordinal()) {
            this.processKB(KBStatus.kbCChecked);
        }
        return this.getTBox().isConsistent();
    }

    private void preprocessKB() {
        if (!this.isKBConsistent()) {
            throw new InconsistentOntologyException();
        }
    }

    public void classifyKB() {
        if (!this.isKBClassified()) {
            this.processKB(KBStatus.kbClassified);
        }
        if (!this.isKBConsistent()) {
            throw new InconsistentOntologyException();
        }
    }

    public void realiseKB() {
        if (!this.isKBRealised()) {
            this.processKB(KBStatus.kbRealised);
        }
        if (!this.isKBConsistent()) {
            throw new InconsistentOntologyException();
        }
    }

    public boolean isFunctional(ObjectRoleExpression R) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R)) {
            return false;
        }
        if (this.getExpressionManager().isEmptyRole(R)) {
            return true;
        }
        return this.getFunctionality(this.getRole(R, "Role expression expected in isFunctional()"));
    }

    public boolean isFunctional(DataRoleExpression R) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R)) {
            return false;
        }
        if (this.getExpressionManager().isEmptyRole(R)) {
            return true;
        }
        return this.getFunctionality(this.getRole(R, "Role expression expected in isFunctional()"));
    }

    public boolean isInverseFunctional(ObjectRoleExpression R) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R)) {
            return false;
        }
        if (this.getExpressionManager().isEmptyRole(R)) {
            return true;
        }
        return this.getFunctionality(this.getRole(R, "Role expression expected in isInverseFunctional()").inverse());
    }

    public boolean isTransitive(ObjectRoleExpression R) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R)) {
            return true;
        }
        if (this.getExpressionManager().isEmptyRole(R)) {
            return true;
        }
        Role r = this.getRole(R, "Role expression expected in isTransitive()");
        if (!r.isTransitivityKnown()) {
            r.setTransitive(this.checkTransitivity(this.e(R)));
        }
        return r.isTransitive();
    }

    public boolean isSymmetric(ObjectRoleExpression R) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R)) {
            return true;
        }
        if (this.getExpressionManager().isEmptyRole(R)) {
            return true;
        }
        Role r = this.getRole(R, "Role expression expected in isSymmetric()");
        if (!r.isSymmetryKnown()) {
            r.setSymmetric(this.checkSymmetry(this.e(R)));
        }
        return r.isSymmetric();
    }

    public boolean isAsymmetric(ObjectRoleExpression R) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R)) {
            return false;
        }
        if (this.getExpressionManager().isEmptyRole(R)) {
            return true;
        }
        Role r = this.getRole(R, "Role expression expected in isAsymmetric()");
        if (!r.isAsymmetryKnown()) {
            r.setAsymmetric(this.getTBox().isDisjointRoles(r, r.inverse()));
        }
        return r.isAsymmetric();
    }

    public boolean isReflexive(ObjectRoleExpression R) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R)) {
            return true;
        }
        if (this.getExpressionManager().isEmptyRole(R)) {
            return false;
        }
        Role r = this.getRole(R, "Role expression expected in isReflexive()");
        if (!r.isReflexivityKnown()) {
            r.setReflexive(this.checkReflexivity(this.e(R)));
        }
        return r.isReflexive();
    }

    public boolean isIrreflexive(ObjectRoleExpression R) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R)) {
            return false;
        }
        if (this.getExpressionManager().isEmptyRole(R)) {
            return true;
        }
        Role r = this.getRole(R, "Role expression expected in isIrreflexive()");
        if (!r.isIrreflexivityKnown()) {
            r.setIrreflexive(this.getTBox().isIrreflexive(r));
        }
        return r.isIrreflexive();
    }

    public boolean isDisjointRoles(ObjectRoleExpression R, ObjectRoleExpression S) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R) || this.getExpressionManager().isUniversalRole(S)) {
            return false;
        }
        if (this.getExpressionManager().isEmptyRole(R) || this.getExpressionManager().isEmptyRole(S)) {
            return true;
        }
        return this.getTBox().isDisjointRoles(this.getRole(R, "Role expression expected in isDisjointRoles()"), this.getRole(S, "Role expression expected in isDisjointRoles()"));
    }

    public boolean isDisjointRoles(DataRoleExpression R, DataRoleExpression S) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R) || this.getExpressionManager().isUniversalRole(S)) {
            return false;
        }
        if (this.getExpressionManager().isEmptyRole(R) || this.getExpressionManager().isEmptyRole(S)) {
            return true;
        }
        return this.getTBox().isDisjointRoles(this.getRole(R, "Role expression expected in isDisjointRoles()"), this.getRole(S, "Role expression expected in isDisjointRoles()"));
    }

    public boolean isSubRoles(ObjectRoleExpression R, ObjectRoleExpression S) {
        this.preprocessKB();
        if (this.getExpressionManager().isEmptyRole(R) || this.getExpressionManager().isUniversalRole(S)) {
            return true;
        }
        if (this.getExpressionManager().isUniversalRole(R) && this.getExpressionManager().isEmptyRole(S)) {
            return false;
        }
        if (this.getRole(R, "Role expression expected in isSubRoles()").lesserequal(this.getRole(S, "Role expression expected in isSubRoles()"))) {
            return true;
        }
        DLTree r = this.e(R);
        DLTree s = this.e(S);
        return this.checkRoleSubsumption(r, s);
    }

    public boolean isSatisfiable(ConceptExpression C) {
        this.preprocessKB();
        try {
            return this.checkSat(this.e(C));
        }
        catch (OWLRuntimeException crn) {
            if (C instanceof ConceptName) {
                return true;
            }
            throw crn;
        }
    }

    public boolean isSubsumedBy(ConceptExpression C, ConceptExpression D) {
        this.preprocessKB();
        return this.checkSub(this.e(C), this.e(D));
    }

    public boolean isDisjoint(ConceptExpression C, ConceptExpression D) {
        this.preprocessKB();
        return this.checkSub(this.e(C), DLTreeFactory.createSNFNot(this.e(D)));
    }

    public boolean isEquivalent(ConceptExpression C, ConceptExpression D) {
        this.preprocessKB();
        return this.isSubsumedBy(C, D) && this.isSubsumedBy(D, C);
    }

    public void getSupConcepts(ConceptExpression C, boolean direct, Actor actor) {
        this.classifyKB();
        this.setUpCache(this.e(C), CacheStatus.csClassified);
        Taxonomy tax = this.getCTaxonomy();
        if (direct) {
            tax.getRelativesInfo(this.cachedVertex, actor, false, true, true);
        } else {
            tax.getRelativesInfo(this.cachedVertex, actor, false, false, true);
        }
    }

    public void getSubConcepts(ConceptExpression C, boolean direct, Actor actor) {
        this.classifyKB();
        this.setUpCache(this.e(C), CacheStatus.csClassified);
        Taxonomy tax = this.getCTaxonomy();
        tax.getRelativesInfo(this.cachedVertex, actor, false, direct, false);
    }

    public void getEquivalentConcepts(ConceptExpression C, Actor actor) {
        this.classifyKB();
        this.setUpCache(this.e(C), CacheStatus.csClassified);
        actor.apply(this.cachedVertex);
    }

    public void getDisjointConcepts(ConceptExpression C, Actor actor) {
        this.classifyKB();
        this.setUpCache(DLTreeFactory.createSNFNot(this.e(C)), CacheStatus.csClassified);
        Taxonomy tax = this.getCTaxonomy();
        tax.getRelativesInfo(this.cachedVertex, actor, true, false, false);
    }

    public void getSupRoles(RoleExpression r, boolean direct, Actor actor) {
        this.preprocessKB();
        Role R = this.getRole(r, "Role expression expected in getSupRoles()");
        Taxonomy tax = this.getTaxonomy(R);
        tax.getRelativesInfo(this.getTaxVertex(R), actor, false, direct, true);
    }

    public void getSubRoles(RoleExpression r, boolean direct, Actor actor) {
        this.preprocessKB();
        Role R = this.getRole(r, "Role expression expected in getSubRoles()");
        Taxonomy tax = this.getTaxonomy(R);
        tax.getRelativesInfo(this.getTaxVertex(R), actor, false, direct, false);
    }

    public void getEquivalentRoles(RoleExpression r, Actor actor) {
        this.preprocessKB();
        Role R = this.getRole(r, "Role expression expected in getEquivalentRoles()");
        actor.apply(this.getTaxVertex(R));
    }

    public void getRoleDomain(RoleExpression r, boolean direct, Actor actor) {
        this.classifyKB();
        this.setUpCache(DLTreeFactory.createSNFExists(this.e(r), DLTreeFactory.createTop()), CacheStatus.csClassified);
        Taxonomy tax = this.getCTaxonomy();
        tax.getRelativesInfo(this.cachedVertex, actor, true, direct, true);
    }

    public void getRoleRange(ObjectRoleExpression r, boolean direct, Actor actor) {
        this.getRoleDomain(this.getExpressionManager().inverse(r), direct, actor);
    }

    public void getInstances(ConceptExpression C, Actor actor, boolean direct) {
        if (direct) {
            this.getDirectInstances(C, actor);
        } else {
            this.getInstances(C, actor);
        }
    }

    public void getDirectInstances(ConceptExpression C, Actor actor) {
        this.realiseKB();
        this.setUpCache(this.e(C), CacheStatus.csClassified);
        if (actor.apply(this.cachedVertex)) {
            return;
        }
        for (TaxonomyVertex p : this.cachedVertex.neigh(false)) {
            actor.apply(p);
        }
    }

    public void getInstances(ConceptExpression C, Actor actor) {
        this.realiseKB();
        this.setUpCache(this.e(C), CacheStatus.csClassified);
        Taxonomy tax = this.getCTaxonomy();
        tax.getRelativesInfo(this.cachedVertex, actor, true, false, false);
    }

    public void getTypes(IndividualExpression I, boolean direct, Actor actor) {
        this.realiseKB();
        this.setUpCache(this.e(I), CacheStatus.csClassified);
        Taxonomy tax = this.getCTaxonomy();
        tax.getRelativesInfo(this.cachedVertex, actor, true, direct, true);
    }

    public void getSameAs(IndividualExpression I, Actor actor) {
        this.realiseKB();
        this.getEquivalentConcepts(this.getExpressionManager().oneOf(I), actor);
    }

    public boolean isSameIndividuals(IndividualExpression I, IndividualExpression J) {
        this.realiseKB();
        Individual i = this.getIndividual(I, "Only known individuals are allowed in the isSameAs()");
        Individual j = this.getIndividual(J, "Only known individuals are allowed in the isSameAs()");
        return this.getTBox().isSameIndividuals(i, j);
    }

    public boolean isInstance(IndividualExpression I, ConceptExpression C) {
        this.realiseKB();
        this.getIndividual(I, "individual name expected in the isInstance()");
        return this.isSubsumedBy(this.getExpressionManager().oneOf(I), C);
    }

    public ReasoningKernel(long timeOut) {
        this.opTimeout = timeOut;
        this.verboseOutput = false;
        this.cachedQuery = null;
        this.initCacheAndFlags();
        if (this.initOptions()) {
            throw new ReasonerInternalException("FaCT++ kernel: Cannot init options");
        }
        this.useELReasoner = false;
    }

    private boolean tryIncremental() {
        if (this.pTBox == null) {
            return true;
        }
        return this.ontology.isChanged();
    }

    private void forceReload() {
        this.clearTBox();
        this.newKB();
        this.pMonitor = null;
        if (IfDefs.splits) {
            TAxiomSplitter AxiomSplitter = new TAxiomSplitter(this.ontology);
            AxiomSplitter.buildSplit();
        }
        OntologyLoader OntologyLoader2 = new OntologyLoader(this.getTBox());
        OntologyLoader2.visitOntology(this.ontology);
        this.ontology.setProcessed();
    }

    private void processKB(KBStatus status) {
        assert (status.ordinal() >= KBStatus.kbCChecked.ordinal());
        if (this.reasoningFailed) {
            throw new ReasonerInternalException("Can't classify KB because of previous errors");
        }
        if (this.getStatus().ordinal() >= status.ordinal()) {
            if (!this.isKBConsistent()) {
                throw new InconsistentOntologyException();
            }
            return;
        }
        boolean stillGo = true;
        switch (this.getStatus()) {
            case kbEmpty: 
            case kbLoading: {
                break;
            }
            case kbCChecked: {
                this.classify(status);
                stillGo = false;
                break;
            }
            case kbClassified: {
                this.realise();
                stillGo = false;
                break;
            }
            default: {
                throw new UnreachableSituationException();
            }
        }
        if (stillGo) {
            this.reasoningFailed = true;
            if (this.tryIncremental()) {
                this.forceReload();
            }
            this.pTBox.isConsistent();
            this.reasoningFailed = false;
            if (status == KBStatus.kbCChecked) {
                return;
            }
            this.classify(status);
        }
    }

    private void classify(KBStatus status) {
        if (status != KBStatus.kbRealised) {
            if (!this.pTBox.isConsistent()) {
                return;
            }
            this.pTBox.performClassification();
            return;
        }
        this.realise();
    }

    private void realise() {
        if (!this.pTBox.isConsistent()) {
            return;
        }
        this.pTBox.performRealisation();
    }

    private void setUpCache(DLTree query, CacheStatus level) {
        assert (!this.ontology.isChanged());
        if (this.cachedQuery != null && DLTree.equalTrees(this.cachedQuery, query)) {
            query = null;
            if (level.ordinal() <= this.cacheLevel.ordinal()) {
                return;
            }
            assert (level == CacheStatus.csClassified && this.cacheLevel != CacheStatus.csClassified);
            if (this.cacheLevel == CacheStatus.csEmpty) {
                this.needSetup(level, query);
                return;
            }
            this.needClassify(level);
            return;
        }
        this.cachedQuery = query;
        this.needSetup(level, query);
    }

    private void needClassify(CacheStatus level) {
        if (level == CacheStatus.csClassified) {
            this.classifyKB();
            this.getTBox().classifyQueryConcept();
            assert (this.cachedConcept.isClassified());
            this.cachedVertex = this.cachedConcept.getTaxVertex();
        }
    }

    private void needSetup(CacheStatus level, DLTree query) {
        this.cachedVertex = null;
        if (query.isCN()) {
            this.cachedConcept = this.getTBox().getCI(query);
            if (this.cachedConcept == null) {
                this.cacheLevel = CacheStatus.csEmpty;
                throw new ReasonerInternalException("FaCT++ Kernel: incremental classification not supported");
            }
            this.cacheLevel = level;
            if (level == CacheStatus.csClassified) {
                this.classifyKB();
                this.cachedVertex = this.cachedConcept.getTaxVertex();
            }
            return;
        }
        this.cachedConcept = this.getTBox().createQueryConcept(query);
        this.cacheLevel = level;
        this.needClassify(level);
    }

    private boolean checkSubChain(Role R, List<Expression> l) {
        DLTree tmp = DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept());
        for (int i = l.size() - 1; i > -1; --i) {
            Expression p = l.get(i);
            if (!(p instanceof ObjectRoleExpression)) {
                throw new ReasonerInternalException("Role expression expected in the role chain construct");
            }
            ObjectRoleExpression Ri = (ObjectRoleExpression)p;
            tmp = DLTreeFactory.createSNFExists(this.e(Ri), tmp);
        }
        return !this.checkSat(tmp = DLTreeFactory.createSNFAnd(tmp, DLTreeFactory.createSNFForall(DLTreeFactory.buildTree(new Lexeme(Token.RNAME, R)), this.getTBox().getFreshConcept())));
    }

    public boolean isSubChain(ObjectRoleExpression R, List<Expression> l) {
        this.preprocessKB();
        if (this.getExpressionManager().isUniversalRole(R)) {
            return true;
        }
        if (this.getExpressionManager().isEmptyRole(R)) {
            return false;
        }
        return this.checkSubChain(this.getRole(R, "Role expression expected in isSubChain()"), l);
    }

    public boolean isSubRoles(DataRoleExpression R, DataRoleExpression S) {
        this.preprocessKB();
        if (this.getExpressionManager().isEmptyRole(R) || this.getExpressionManager().isUniversalRole(S)) {
            return true;
        }
        if (this.getExpressionManager().isUniversalRole(R) && this.getExpressionManager().isEmptyRole(S)) {
            return false;
        }
        if (this.getRole(R, "Role expression expected in isSubRoles()").lesserequal(this.getRole(S, "Role expression expected in isSubRoles()"))) {
            return true;
        }
        DLTree r = this.e(R);
        DLTree s = this.e(S);
        return this.checkRoleSubsumption(r, s);
    }

    public boolean isDisjointRoles(List<Expression> l) {
        ArrayList<Role> Roles = new ArrayList<Role>(l.size());
        for (Expression p : l) {
            if (p instanceof ObjectRoleExpression) {
                ObjectRoleExpression ORole = (ObjectRoleExpression)p;
                if (this.getExpressionManager().isUniversalRole(ORole)) {
                    return false;
                }
                if (this.getExpressionManager().isEmptyRole(ORole)) continue;
                Roles.add(this.getRole(ORole, "Role expression expected in isDisjointRoles()"));
                continue;
            }
            if (!(p instanceof DataRoleExpression)) {
                throw new ReasonerInternalException("Role expression expected in isDisjointRoles()");
            }
            DataRoleExpression DRole = (DataRoleExpression)p;
            if (this.getExpressionManager().isUniversalRole(DRole)) {
                return false;
            }
            if (this.getExpressionManager().isEmptyRole(DRole)) continue;
            Roles.add(this.getRole(DRole, "Role expression expected in isDisjointRoles()"));
        }
        for (int i = 0; i < Roles.size() - 1; ++i) {
            for (int j = i + 1; j < Roles.size(); ++j) {
                if (this.getTBox().isDisjointRoles((Role)Roles.get(i), (Role)Roles.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private List<Individual> buildRelatedCache(Individual I, Role R) {
        if (R.isSynonym()) {
            return this.getRelated(I, ClassifiableEntry.resolveSynonym(R));
        }
        if (R.isDataRole() || R.isBottom()) {
            return new ArrayList<Individual>();
        }
        RIActor actor = new RIActor();
        ObjectRoleExpression InvR = R.getId() > 0 ? this.getExpressionManager().inverse(this.getExpressionManager().objectRole(R.getName())) : this.getExpressionManager().objectRole(R.inverse().getName());
        ConceptExpression query = R.isTop() ? this.getExpressionManager().top() : this.getExpressionManager().value(InvR, this.getExpressionManager().individual(I.getName()));
        this.getInstances(query, actor);
        return actor.getAcc();
    }

    public void getRoleFillers(IndividualExpression I, ObjectRoleExpression R, List<NamedEntry> Result) {
        this.realiseKB();
        List<Individual> vec = this.getRelated(this.getIndividual(I, "Individual name expected in the getRoleFillers()"), this.getRole(R, "Role expression expected in the getRoleFillers()"));
        for (Individual p : vec) {
            Result.add(p);
        }
    }

    public boolean isRelated(IndividualExpression I, ObjectRoleExpression R, IndividualExpression J) {
        this.realiseKB();
        Individual i = this.getIndividual(I, "Individual name expected in the isRelated()");
        Role r = this.getRole(R, "Role expression expected in the isRelated()");
        if (r.isDataRole()) {
            return false;
        }
        Individual j = this.getIndividual(J, "Individual name expected in the isRelated()");
        List<Individual> vec = this.getRelated(i, r);
        for (Individual p : vec) {
            if (!j.equals(p)) continue;
            return true;
        }
        return false;
    }

    private boolean initOptions() {
        if (this.kernelOptions.registerOption("useRelevantOnly", "Option 'useRelevantOnly' is used when creating internal DAG representation for externally given TBox. If true, DAG contains only concepts, relevant to query. It is safe to leave this option false.", IFOption.IOType.iotBool, "false")) {
            return true;
        }
        if (this.kernelOptions.registerOption("dumpQuery", "Option 'dumpQuery' dumps sub-TBox relevant to given satisfiability/subsumption query.", IFOption.IOType.iotBool, "false")) {
            return true;
        }
        if (this.kernelOptions.registerOption("absorptionFlags", "Option 'absorptionFlags' sets up absorption process for general axioms. It text field of arbitrary length; every symbol means the absorption action: (B)ottom Absorption), (T)op absorption, (E)quivalent concepts replacement, (C)oncept absorption, (N)egated concept absorption, (F)orall expression replacement, (R)ole absorption, (S)plit", IFOption.IOType.iotText, "BTECFSR")) {
            return true;
        }
        if (this.kernelOptions.registerOption("alwaysPreferEquals", "Option 'alwaysPreferEquals' allows user to enforce usage of C=D definition instead of C[=D during absorption, even if implication appeares earlier in stream of axioms.", IFOption.IOType.iotBool, "true")) {
            return true;
        }
        if (this.kernelOptions.registerOption("orSortSub", "Option 'orSortSub' define the sorting order of OR vertices in the DAG used in subsumption tests. Option has form of string 'Mop', where 'M' is a sort field (could be 'D' for depth, 'S' for size, 'F' for frequency, and '0' for no sorting), 'o' is a order field (could be 'a' for ascending and 'd' for descending mode), and 'p' is a preference field (could be 'p' for preferencing non-generating rules and 'n' for not doing so).", IFOption.IOType.iotText, "0")) {
            return true;
        }
        if (this.kernelOptions.registerOption("orSortSat", "Option 'orSortSat' define the sorting order of OR vertices in the DAG used in satisfiability tests (used mostly in caching). Option has form of string 'Mop', see orSortSub for details.", IFOption.IOType.iotText, "0")) {
            return true;
        }
        if (this.kernelOptions.registerOption("IAOEFLG", "Option 'IAOEFLG' define the priorities of different operations in TODO list. Possible values are 7-digit strings with ony possible digit are 0-6. The digits on the places 1, 2, ..., 7 are for priority of Id, And, Or, Exists, Forall, LE and GE operations respectively. The smaller number means the higher priority. All other constructions (TOP, BOTTOM, etc) has priority 0.", IFOption.IOType.iotText, "1263005")) {
            return true;
        }
        if (this.kernelOptions.registerOption("useSemanticBranching", "Option 'useSemanticBranching' switch semantic branching on and off. The usage of semantic branching usually leads to faster reasoning, but sometime could give small overhead.", IFOption.IOType.iotBool, "true")) {
            return true;
        }
        if (this.kernelOptions.registerOption("useBackjumping", "Option 'useBackjumping' switch backjumping on and off. The usage of backjumping usually leads to much faster reasoning.", IFOption.IOType.iotBool, "true")) {
            return true;
        }
        if (this.kernelOptions.registerOption("testTimeout", "Option 'testTimeout' sets timeout for a single reasoning test in milliseconds.", IFOption.IOType.iotInt, "0")) {
            return true;
        }
        if (this.kernelOptions.registerOption("useLazyBlocking", "Option 'useLazyBlocking' makes checking of blocking status as small as possible. This greatly increase speed of reasoning.", IFOption.IOType.iotBool, "true")) {
            return true;
        }
        if (this.kernelOptions.registerOption("useAnywhereBlocking", "Option 'useAnywhereBlocking' allow user to choose between Anywhere and Ancestor blocking.", IFOption.IOType.iotBool, "true")) {
            return true;
        }
        return this.kernelOptions.registerOption("useCompletelyDefined", "Option 'useCompletelyDefined' leads to simpler Taxonomy creation if TBox contains no non-primitive concepts. Unfortunately, it is quite rare case.", IFOption.IOType.iotBool, "true");
    }
}

