/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.MergableLabel;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.RoleAutomaton;
import uk.ac.manchester.cs.jfact.kernel.RoleCompare;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.actors.AddRoleActor;

public final class Role
extends ClassifiableEntry {
    private Role inverse = null;
    private DLTree pDomain = null;
    private DLTree pSpecialDomain = null;
    private int bpSpecialDomain = 0;
    private int bpDomain = 0;
    private int functional = 0;
    private long rel = 0L;
    private final MergableLabel domLabel = new MergableLabel();
    private final List<Role> ancestorRoles = new ArrayList<Role>();
    private final List<Role> descendantRoles = new ArrayList<Role>();
    private final List<Role> topFunctionalRoles = new ArrayList<Role>();
    private final Set<Role> disjointRoles = new HashSet<Role>();
    private final List<List<Role>> subCompositions = new ArrayList<List<Role>>();
    private final FastSet ancestorMap = FastSetFactory.create();
    private final FastSet disjointRolesIndex = FastSetFactory.create();
    private final RoleAutomaton automaton = new RoleAutomaton();
    private final KnownValue functionality = new KnownValue();
    private final KnownValue symmetry = new KnownValue();
    private final KnownValue asymmetry = new KnownValue();
    private final KnownValue transitivity = new KnownValue();
    private final KnownValue reflexivity = new KnownValue();
    private final KnownValue irreflexivity = new KnownValue();
    private boolean specialDomain = false;
    private int absoluteIndex = this.buildIndex();
    private boolean simple;
    private boolean finished;
    private boolean dataRole;

    private void addSubRoleAutomaton(Role R) {
        if (this.equals(R)) {
            return;
        }
        if (R.isSimple()) {
            this.automaton.addSimpleRA(R.automaton);
        } else {
            this.automaton.addRA(R.automaton);
        }
    }

    private void addTrivialTransition(Role r) {
        this.automaton.addTransitionSafe(0, new RATransition(1, r));
    }

    private final RoleAutomaton completeAutomatonByRole(Role R, Set<Role> RInProcess) {
        assert (!R.isSynonym());
        assert (R != this);
        R.completeAutomaton(RInProcess);
        return R.automaton;
    }

    void mergeSupersDomain() {
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            this.domLabel.merge(this.ancestorRoles.get((int)i).domLabel);
        }
        if (this.isReflexive()) {
            this.domLabel.merge(this.getRangeLabel());
        }
        for (List<Role> q : this.subCompositions) {
            if (q.isEmpty()) continue;
            this.domLabel.merge(q.get((int)0).domLabel);
            this.getRangeLabel().merge(q.get(q.size() - 1).getRangeLabel());
        }
    }

    public Role inverse() {
        assert (this.inverse != null);
        return Role.resolveSynonym(this.inverse);
    }

    public Role realInverse() {
        assert (this.inverse != null);
        return this.inverse;
    }

    public void setInverse(Role p) {
        assert (this.inverse == null);
        this.inverse = p;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple() {
        this.simple = true;
    }

    public void clearSimple() {
        this.simple = false;
    }

    public void setSimple(boolean action) {
        this.simple = action;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
    }

    public void clearFinished() {
        this.finished = false;
    }

    public void setFinished(boolean action) {
        this.finished = action;
    }

    public DLTree getTSpecialDomain() {
        return this.pSpecialDomain;
    }

    public boolean hasSpecialDomain() {
        return this.specialDomain;
    }

    public void initSpecialDomain() {
        this.pSpecialDomain = !this.hasSpecialDomain() || this.getTRange() == null ? DLTreeFactory.createTop() : DLTreeFactory.createSNFForall(DLTreeFactory.buildTree(new Lexeme(Token.RNAME, this)), this.getTRange().copy());
    }

    public void setSpecialDomain(int bp) {
        this.bpSpecialDomain = bp;
    }

    public boolean isDataRole() {
        return this.dataRole;
    }

    public void setDataRole() {
        this.dataRole = true;
    }

    public void clearDataRole() {
        this.dataRole = false;
    }

    public void setDataRole(boolean action) {
        this.dataRole = action;
    }

    public boolean isFunctional() {
        return this.functionality.getValue();
    }

    public boolean isFunctionalityKnown() {
        return this.functionality.isKnown();
    }

    public void setFunctional(boolean value) {
        this.functionality.setValue(value);
    }

    public void setFunctional() {
        if (this.topFunctionalRoles.isEmpty()) {
            this.topFunctionalRoles.add(this);
        }
        this.setFunctional(true);
    }

    public boolean isTransitive() {
        return this.transitivity.getValue();
    }

    public boolean isTransitivityKnown() {
        return this.transitivity.isKnown();
    }

    public void setTransitive(boolean value) {
        this.transitivity.setValue(value);
        this.inverse().transitivity.setValue(value);
    }

    public void setTransitive() {
        this.setTransitive(true);
    }

    public boolean isSymmetric() {
        return this.symmetry.getValue();
    }

    public boolean isSymmetryKnown() {
        return this.symmetry.isKnown();
    }

    public void setSymmetric(boolean value) {
        this.symmetry.setValue(value);
        this.inverse().symmetry.setValue(value);
    }

    public void setSymmetric() {
        this.setSymmetric(true);
    }

    public boolean isAsymmetric() {
        return this.asymmetry.getValue();
    }

    public boolean isAsymmetryKnown() {
        return this.asymmetry.isKnown();
    }

    public void setAsymmetric(boolean value) {
        this.asymmetry.setValue(value);
        this.inverse().asymmetry.setValue(value);
    }

    public boolean isReflexive() {
        return this.reflexivity.getValue();
    }

    public boolean isReflexivityKnown() {
        return this.reflexivity.isKnown();
    }

    public void setReflexive(boolean value) {
        this.reflexivity.setValue(value);
        this.inverse().reflexivity.setValue(value);
    }

    public void setReflexive() {
        this.setReflexive(true);
    }

    public boolean isIrreflexive() {
        return this.irreflexivity.getValue();
    }

    public boolean isIrreflexivityKnown() {
        return this.irreflexivity.isKnown();
    }

    public void setIrreflexive(boolean value) {
        this.irreflexivity.setValue(value);
        this.inverse().irreflexivity.setValue(value);
    }

    public void setIrreflexive() {
        this.setIrreflexive(true);
    }

    public boolean isTopFunc() {
        return this.isFunctional() && this.topFunctionalRoles.get(0).equals(this);
    }

    public void setFunctional(int fNode) {
        this.functional = fNode;
    }

    public int getFunctional() {
        return this.functional;
    }

    public boolean isRelevant(long lab) {
        return lab == this.rel;
    }

    public void setRelevant(long lab) {
        this.rel = lab;
    }

    public MergableLabel getDomainLabel() {
        return this.domLabel;
    }

    public MergableLabel getRangeLabel() {
        return this.inverse().domLabel;
    }

    public void setDomain(DLTree p) {
        if (!DLTree.equalTrees(this.pDomain, p)) {
            if (DLTreeFactory.isFunctionalExpr(p, this)) {
                this.setFunctional();
            } else {
                this.pDomain = DLTreeFactory.createSNFAnd(Arrays.asList(this.pDomain, p));
            }
        }
    }

    public void setRange(DLTree p) {
        this.inverse().setDomain(p);
    }

    public DLTree getTDomain() {
        return this.pDomain;
    }

    private DLTree getTRange() {
        return this.inverse().pDomain;
    }

    public void collectDomainFromSupers() {
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            this.setDomain(this.ancestorRoles.get((int)i).pDomain.copy());
        }
    }

    public void setBPDomain(int p) {
        this.bpDomain = p;
    }

    public int getBPDomain() {
        return this.bpDomain;
    }

    public int getBPRange() {
        return this.inverse().bpDomain;
    }

    public void addDisjointRole(Role R) {
        this.disjointRoles.add(R);
        for (Role p : R.descendantRoles) {
            this.disjointRoles.add(p);
            p.disjointRoles.add(this);
        }
    }

    public void checkHierarchicalDisjoint() {
        this.checkHierarchicalDisjoint(this);
        if (this.isReflexive()) {
            this.checkHierarchicalDisjoint(this.inverse());
        }
    }

    public boolean isDisjoint() {
        return !this.disjointRoles.isEmpty();
    }

    public boolean isDisjoint(Role r) {
        return this.disjointRolesIndex.contains(r.getAbsoluteIndex());
    }

    private boolean lesser(Role r) {
        return this.isDataRole() == r.isDataRole() && this.ancestorMap.contains(r.getAbsoluteIndex());
    }

    public boolean lesserequal(Role r) {
        return this.equals(r) || this.lesser(r);
    }

    public List<Role> getAncestor() {
        return this.ancestorRoles;
    }

    public List<Role> begin_topfunc() {
        return this.topFunctionalRoles;
    }

    private void addAncestorsToBitMap(FastSet bitmap) {
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            bitmap.add(this.ancestorRoles.get(i).getAbsoluteIndex());
        }
    }

    public void addComposition(DLTree tree) {
        ArrayList<Role> RS = new ArrayList<Role>();
        this.fillsComposition(RS, tree);
        this.subCompositions.add(RS);
    }

    public RoleAutomaton getAutomaton() {
        return this.automaton;
    }

    public Role eliminateToldCycles() {
        HashSet<Role> RInProcess = new HashSet<Role>();
        ArrayList<Role> ToldSynonyms = new ArrayList<Role>();
        return this.eliminateToldCycles(RInProcess, ToldSynonyms);
    }

    public void completeAutomaton(int nRoles) {
        HashSet<Role> RInProcess = new HashSet<Role>();
        this.completeAutomaton(RInProcess);
        this.automaton.setup(nRoles, this.isDataRole());
    }

    public void consistent() {
        if (this.isSimple()) {
            return;
        }
        if (this.isFunctional()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + this.getName());
        }
        if (this.isDataRole()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + this.getName());
        }
        if (this.isDisjoint()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + this.getName());
        }
    }

    private static Role resolveRoleHelper(DLTree t) {
        if (t == null) {
            throw new ReasonerInternalException("Role expression expected");
        }
        switch (t.token()) {
            case RNAME: 
            case DNAME: {
                return (Role)t.elem().getNE();
            }
            case INV: {
                return Role.resolveRoleHelper(t.getChild()).inverse();
            }
        }
        throw new ReasonerInternalException("Invalid role expression");
    }

    public static Role resolveRole(DLTree t) {
        return Role.resolveSynonym(Role.resolveRoleHelper(t));
    }

    protected Role(String name) {
        super(name);
        this.setCompletelyDefined(true);
        this.addTrivialTransition(this);
    }

    public final int getAbsoluteIndex() {
        return this.absoluteIndex;
    }

    private final int buildIndex() {
        int i = 2 * this.extId;
        return i > 0 ? i : 1 - i;
    }

    @Override
    public void setId(int id) {
        super.setId(id);
        this.absoluteIndex = this.buildIndex();
    }

    private void fillsComposition(List<Role> Composition, DLTree tree) {
        if (tree.token() == Token.RCOMPOSITION) {
            this.fillsComposition(Composition, tree.getLeft());
            this.fillsComposition(Composition, tree.getRight());
        } else {
            Composition.add(Role.resolveRole(tree));
        }
    }

    public void addFeaturesToSynonym() {
        if (!this.isSynonym()) {
            return;
        }
        Role syn = Role.resolveSynonym(this);
        if (this.isFunctional() && !syn.isFunctional()) {
            syn.setFunctional();
        }
        if (this.isTransitive()) {
            syn.setTransitive();
        }
        if (this.isReflexive()) {
            syn.setReflexive();
        }
        if (this.isDataRole()) {
            syn.setDataRole();
        }
        if (this.pDomain != null) {
            syn.setDomain(this.pDomain.copy());
        }
        if (this.isDisjoint()) {
            syn.disjointRoles.addAll(this.disjointRoles);
        }
        syn.subCompositions.addAll(this.subCompositions);
        this.toldSubsumers.clear();
        this.addParent(syn);
    }

    private Role eliminateToldCycles(Set<Role> RInProcess, List<Role> ToldSynonyms) {
        if (this.isSynonym()) {
            return null;
        }
        if (RInProcess.contains(this)) {
            ToldSynonyms.add(this);
            return this;
        }
        Role ret = null;
        RInProcess.add(this);
        this.removeSynonymsFromParents();
        for (ClassifiableEntry r : this.toldSubsumers) {
            ret = ((Role)r).eliminateToldCycles(RInProcess, ToldSynonyms);
            if (ret == null) continue;
            if (ret.equals(this)) {
                Collections.sort(ToldSynonyms, new RoleCompare());
                ret = ToldSynonyms.get(0);
                for (int i = 1; i < ToldSynonyms.size(); ++i) {
                    Role p = ToldSynonyms.get(i);
                    p.setSynonym(ret);
                    ret.addParents(p.getToldSubsumers());
                }
                ToldSynonyms.clear();
                RInProcess.remove(this);
                return ret.eliminateToldCycles(RInProcess, ToldSynonyms);
            }
            ToldSynonyms.add(this);
            break;
        }
        RInProcess.remove(this);
        return ret;
    }

    @Override
    public String toString() {
        return this.extName + " " + this.extId;
    }

    @Override
    public void print(LeveLogger.LogAdapter o) {
        int i;
        ArrayList<Object> l;
        o.print(String.format("Role \"%s\"(%s)%s%s%s%s%s", this.getName(), this.getId(), this.isTransitive() ? "T" : "", this.isReflexive() ? "R" : "", this.isTopFunc() ? "t" : "", this.isFunctional() ? "F" : "", this.isDataRole() ? "D" : ""));
        if (this.isSynonym()) {
            o.print(String.format(" = \"%s\"\n", this.getSynonym().getName()));
            return;
        }
        if (!this.toldSubsumers.isEmpty()) {
            o.print(" parents={\"");
            l = new ArrayList(this.toldSubsumers);
            for (i = 0; i < l.size(); ++i) {
                if (i > 0) {
                    o.print("\", \"");
                }
                o.print(((ClassifiableEntry)l.get(i)).getName());
            }
            o.print("\"}");
        }
        if (!this.disjointRoles.isEmpty()) {
            o.print(" disjoint with {\"");
            l = new ArrayList<Role>(this.disjointRoles);
            for (i = 0; i < this.disjointRoles.size(); ++i) {
                if (i > 0) {
                    o.print("\", \"");
                }
                o.print(((Role)l.get(i)).getName());
            }
            o.print("\"}");
        }
        if (this.pDomain != null) {
            o.print(String.format(" Domain=(%s)=%s", this.bpDomain, this.pDomain));
        }
        if (this.getTRange() != null) {
            o.print(String.format(" Range=(%s)=%s", this.getBPRange(), this.getTRange()));
        }
        o.print(String.format("\nAutomaton (size %s): %s%s", this.automaton.size(), this.automaton.isISafe() ? "I" : "i", this.automaton.isOSafe() ? "O" : "o"));
        this.automaton.print(o);
        o.print("\n");
    }

    public void initADbyTaxonomy(Taxonomy pTax, int nRoles) {
        assert (this.isClassified());
        assert (this.ancestorRoles.isEmpty() && this.descendantRoles.isEmpty());
        AddRoleActor anc = new AddRoleActor(this.ancestorRoles);
        pTax.getRelativesInfo(this.getTaxVertex(), anc, false, false, true);
        AddRoleActor desc = new AddRoleActor(this.descendantRoles);
        pTax.getRelativesInfo(this.getTaxVertex(), desc, false, false, false);
        this.initSimple();
        this.addAncestorsToBitMap(this.ancestorMap);
    }

    public void postProcess() {
        this.initTopFunc();
        if (this.isDisjoint()) {
            this.initDJMap();
        }
    }

    private void initSimple() {
        assert (!this.isSynonym());
        this.setSimple(false);
        if (this.isTransitive() || !this.subCompositions.isEmpty()) {
            return;
        }
        for (Role p : this.descendantRoles) {
            if (!p.isTransitive() && p.subCompositions.isEmpty()) continue;
            return;
        }
        this.setSimple(true);
    }

    private boolean isRealTopFunc() {
        if (!this.isFunctional()) {
            return false;
        }
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            if (!this.ancestorRoles.get(i).isTopFunc()) continue;
            return false;
        }
        return true;
    }

    private void initTopFunc() {
        if (this.isRealTopFunc()) {
            return;
        }
        if (this.isTopFunc()) {
            this.topFunctionalRoles.clear();
        }
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            Role p = this.ancestorRoles.get(i);
            if (!p.isRealTopFunc()) continue;
            this.topFunctionalRoles.add(p);
        }
        if (!this.topFunctionalRoles.isEmpty()) {
            this.functionality.setValue(true);
        }
    }

    private void checkHierarchicalDisjoint(Role R) {
        if (this.disjointRoles.contains(R)) {
            this.setDomain(DLTreeFactory.createBottom());
            this.disjointRoles.clear();
            return;
        }
        for (Role p : R.descendantRoles) {
            if (!this.disjointRoles.contains(p)) continue;
            p.setDomain(DLTreeFactory.createBottom());
            this.disjointRoles.remove(p);
            p.disjointRoles.clear();
        }
    }

    private void initDJMap() {
        for (Role q : this.disjointRoles) {
            this.disjointRolesIndex.add(q.getAbsoluteIndex());
        }
    }

    private void preprocessComposition(List<Role> RS) {
        boolean same = false;
        int last = RS.size() - 1;
        for (int i = 0; i < RS.size(); ++i) {
            Role p = RS.get(i);
            Role R = Role.resolveSynonym(p);
            if (R.isTop()) {
                throw new ReasonerInternalException("Universal role can not be used in role composition chain");
            }
            if (R.isBottom()) {
                RS.clear();
                return;
            }
            if (R.equals(this)) {
                if (i != 0 && i != last) {
                    throw new ReasonerInternalException("Cycle in RIA " + this.getName());
                }
                if (same) {
                    if (last == 1) {
                        RS.clear();
                        this.setTransitive();
                        return;
                    }
                    throw new ReasonerInternalException("Cycle in RIA " + this.getName());
                }
                same = true;
            }
            RS.set(i, R);
        }
    }

    private void completeAutomaton(Set<Role> RInProcess) {
        if (this.isFinished()) {
            return;
        }
        if (RInProcess.contains(this)) {
            throw new ReasonerInternalException("Cycle in RIA " + this.getName());
        }
        RInProcess.add(this);
        for (Role role : this.descendantRoles) {
            role.completeAutomaton(RInProcess);
        }
        for (List list : this.subCompositions) {
            this.addSubCompositionAutomaton(list, RInProcess);
        }
        if (this.isTransitive()) {
            this.automaton.addTransitionSafe(1, new RATransition(0));
        }
        this.setFinished(true);
        for (ClassifiableEntry classifiableEntry : this.toldSubsumers) {
            Role R = (Role)Role.resolveSynonym(classifiableEntry);
            R.addSubRoleAutomaton(this);
            if (!this.hasSpecialDomain()) continue;
            R.specialDomain = true;
        }
        RInProcess.remove(this);
    }

    private void addSubCompositionAutomaton(List<Role> RS, Set<Role> RInProcess) {
        this.preprocessComposition(RS);
        if (RS.isEmpty()) {
            return;
        }
        this.specialDomain = true;
        int p = 0;
        int p_last = RS.size() - 1;
        int from = 0;
        int to = 1;
        if (RS.get(0).equals(this)) {
            ++p;
            from = 1;
        } else if (RS.get(p_last).equals(this)) {
            --p_last;
            to = 0;
        }
        assert (p <= p_last);
        boolean oSafe = false;
        this.automaton.initChain(from);
        while (p != p_last) {
            oSafe = this.automaton.addToChain(this.completeAutomatonByRole(RS.get(p), RInProcess), oSafe);
            ++p;
        }
        this.automaton.addToChain(this.completeAutomatonByRole(RS.get(p), RInProcess), oSafe, to);
    }

    public Role getInverse() {
        return this.inverse;
    }

    static class KnownValue {
        protected boolean value;
        protected boolean known;

        public KnownValue(boolean val) {
            this.value = val;
            this.known = false;
        }

        public KnownValue() {
            this(false);
        }

        protected boolean isKnown() {
            return this.known;
        }

        protected boolean getValue() {
            return this.value;
        }

        protected void setValue(boolean val) {
            this.value = val;
            this.known = true;
        }
    }
}

