/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.RATransition;

public final class RoleAutomaton {
    private final List<RAStateTransitions> base = new ArrayList<RAStateTransitions>();
    private int[] map = new int[0];
    private int initialRA = 0;
    private boolean inputSafe = true;
    private boolean outputSafe = true;
    public static final int initial = 0;
    public static final int final_state = 1;

    private void ensureState(int state) {
        if (state >= this.base.size()) {
            Helper.resize(this.base, state + 1);
        }
        for (int i = 0; i < this.base.size(); ++i) {
            if (this.base.get(i) != null) continue;
            this.base.set(i, new RAStateTransitions());
        }
    }

    public RoleAutomaton() {
        this.ensureState(1);
    }

    public void initChain(int from) {
        this.initialRA = from;
    }

    public boolean addToChain(RoleAutomaton RA, boolean oSafe) {
        return this.addToChain(RA, oSafe, this.size() + 1);
    }

    public boolean isISafe() {
        return this.inputSafe;
    }

    public boolean isOSafe() {
        return this.outputSafe;
    }

    public void addSimpleRA(RoleAutomaton RA) {
        boolean ok = this.base.get(0).addToExisting(RA.base.get(0).begin().get(0));
        assert (ok);
    }

    public void addRA(RoleAutomaton RA) {
        this.initChain(0);
        this.addToChain(RA, false, 1);
    }

    public void addTransitionSafe(int state, RATransition trans) {
        this.ensureState(state);
        this.ensureState(trans.final_state());
        this.addTransition(state, trans);
    }

    public void setIUnsafe() {
        this.inputSafe = false;
    }

    public void setOUnsafe() {
        this.outputSafe = false;
    }

    public void checkTransition(int from, int to) {
        if (from == 1) {
            this.setOUnsafe();
        }
        if (to == 0) {
            this.setIUnsafe();
        }
    }

    public void addTransition(int from, RATransition trans) {
        this.checkTransition(from, trans.final_state());
        this.base.get(from).add(trans);
    }

    public void nextChainTransition(int to) {
        this.addTransition(this.initialRA, new RATransition(to));
        this.initialRA = to;
    }

    public int newState() {
        int ret = this.base.size();
        this.ensureState(ret);
        return ret;
    }

    public RAStateTransitions begin(int state) {
        return this.base.get(state);
    }

    public int size() {
        return this.base.size();
    }

    public void setup(int nRoles, boolean data) {
        for (int i = 0; i < this.base.size(); ++i) {
            this.base.get(i).setup(i, nRoles, data);
        }
    }

    public void print(LeveLogger.LogAdapter o) {
        for (int state = 0; state < this.base.size(); ++state) {
            this.base.get(state).print(o);
        }
    }

    public void addCopy(RoleAutomaton RA) {
        for (int i = 0; i < RA.size(); ++i) {
            int from = this.map[i];
            RAStateTransitions RST = this.base.get(from);
            RAStateTransitions RSTOrig = RA.base.get(i);
            if (RSTOrig.isEmpty()) continue;
            List<RATransition> begin = RSTOrig.begin();
            for (int j = 0; j < begin.size(); ++j) {
                RATransition p = begin.get(j);
                int to = p.final_state();
                RATransition trans = new RATransition(this.map[to]);
                this.checkTransition(from, trans.final_state());
                trans.add(p);
                if (to == 1 && RST.addToExisting(trans)) continue;
                RST.add(trans);
            }
        }
    }

    public void initMap(int RASize, int fRA) {
        this.map = Arrays.copyOf(this.map, RASize);
        int newState = this.size() - 1;
        this.map[0] = this.initialRA;
        if (fRA >= this.size()) {
            fRA = this.size();
            ++newState;
        }
        this.map[1] = fRA;
        this.checkTransition(this.initialRA, fRA);
        this.initialRA = fRA;
        for (int i = 2; i < RASize; ++i) {
            this.map[i] = ++newState;
        }
        this.ensureState(newState);
    }

    public boolean addToChain(RoleAutomaton RA, boolean oSafe, int fRA) {
        boolean needFinalTrans;
        boolean bl = needFinalTrans = fRA < this.size() && !RA.isOSafe();
        if (!oSafe && !RA.isISafe()) {
            this.nextChainTransition(this.newState());
        }
        this.initMap(RA.size(), needFinalTrans ? this.size() : fRA);
        this.addCopy(RA);
        if (needFinalTrans) {
            this.nextChainTransition(fRA);
        }
        return RA.isOSafe();
    }

    public List<RAStateTransitions> getBase() {
        return this.base;
    }
}

