/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.NameCreator;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.Token;

public final class RoleMaster {
    private int newRoleId = 1;
    private final List<Role> roles = new ArrayList<Role>();
    private final Role emptyRole;
    private final Role universalRole;
    private final NameSet<Role> roleNS;
    private final Taxonomy pTax;
    private final List<Role> disjointRolesA = new ArrayList<Role>();
    private final List<Role> disjointRolesB = new ArrayList<Role>();
    private final boolean dataRoles;
    private boolean useUndefinedNames;
    private static final int firstRoleIndex = 2;

    private void registerRole(Role r) {
        assert (r != null && r.getInverse() == null);
        assert (r.getId() == 0);
        if (this.dataRoles) {
            r.setDataRole();
        }
        this.roles.add(r);
        r.setId(this.newRoleId);
        String iname = "-";
        iname = iname + r.getName();
        Role ri = new Role(iname);
        r.setInverse(ri);
        ri.setInverse(r);
        this.roles.add(ri);
        ri.setId(-this.newRoleId);
        ++this.newRoleId;
    }

    private boolean isRegisteredRole(NamedEntry p) {
        if (!(p instanceof Role)) {
            return false;
        }
        Role R = (Role)p;
        int ind = R.getAbsoluteIndex();
        return ind >= 2 && ind < this.roles.size() && this.roles.get(ind).equals(p);
    }

    public int size() {
        return this.roles.size() / 2 - 1;
    }

    public RoleMaster(boolean d, String TopRoleName, String BotRoleName) {
        this.emptyRole = new Role(BotRoleName.equals("") ? "emptyRole" : BotRoleName);
        this.universalRole = new Role(TopRoleName.equals("") ? "universalRole" : TopRoleName);
        this.roleNS = new NameSet<Role>(new RoleCreator());
        this.dataRoles = d;
        this.useUndefinedNames = true;
        this.roles.add(null);
        this.roles.add(null);
        this.emptyRole.setId(0);
        this.emptyRole.setInverse(this.emptyRole);
        this.emptyRole.setDataRole(this.dataRoles);
        this.emptyRole.setBPDomain(-1);
        this.emptyRole.setBottom();
        this.emptyRole.setSimple();
        this.universalRole.setId(0);
        this.universalRole.setInverse(this.universalRole);
        this.universalRole.setDataRole(this.dataRoles);
        this.universalRole.setBPDomain(1);
        this.universalRole.setTop();
        this.pTax = new Taxonomy(this.universalRole, this.emptyRole);
    }

    public NamedEntry ensureRoleName(String name) {
        if (name.equals(this.emptyRole.getName())) {
            return this.emptyRole;
        }
        if (name.equals(this.universalRole.getName())) {
            return this.universalRole;
        }
        Role p = this.roleNS.insert(name);
        if (p == null) {
            throw new OWLRuntimeException("Unable to register '" + name + "' as a " + (this.dataRoles ? "data role" : "role"));
        }
        if (this.isRegisteredRole(p)) {
            return p;
        }
        if (p.getId() != 0 || !this.useUndefinedNames) {
            throw new OWLRuntimeException("Unable to register '" + name + "' as a " + (this.dataRoles ? "data role" : "role"));
        }
        this.registerRole(p);
        return p;
    }

    public void addRoleParent(Role role, Role parent) {
        if (role.isDataRole() != parent.isDataRole()) {
            throw new ReasonerInternalException("Mixed object and data roles in role subsumption axiom");
        }
        role.addParent(parent);
        role.getInverse().addParent(parent.getInverse());
    }

    public void addRoleSynonym(Role role, Role syn) {
        if (!role.equals(syn)) {
            this.addRoleParent(role, syn);
            this.addRoleParent(syn, role);
        }
    }

    public void addDisjointRoles(Role R, Role S) {
        if (R.isDataRole() != S.isDataRole()) {
            return;
        }
        this.disjointRolesA.add(R);
        this.disjointRolesB.add(S);
    }

    public void setUndefinedNames(boolean val) {
        this.useUndefinedNames = val;
    }

    public List<Role> getRoles() {
        return this.roles.subList(2, this.roles.size());
    }

    public Taxonomy getTaxonomy() {
        return this.pTax;
    }

    public void print(LeveLogger.LogAdapter o, String type) {
        if (this.size() == 0) {
            return;
        }
        o.print(String.format("%s Roles (%s):\n", type, this.size()));
        for (int i = 2; i < this.roles.size(); ++i) {
            Role p = this.roles.get(i);
            p.print(o);
        }
    }

    public boolean hasReflexiveRoles() {
        for (int i = 2; i < this.roles.size(); ++i) {
            Role p = this.roles.get(i);
            if (!p.isReflexive()) continue;
            return true;
        }
        return false;
    }

    public void fillReflexiveRoles(List<Role> RR) {
        RR.clear();
        for (int i = 2; i < this.roles.size(); ++i) {
            Role p = this.roles.get(i);
            if (p.isSynonym() || !p.isReflexive()) continue;
            RR.add(p);
        }
    }

    public void addRoleParent(DLTree tree, Role parent) {
        if (tree == null) {
            return;
        }
        if (tree.token() == Token.RCOMPOSITION) {
            parent.addComposition(tree);
            DLTree inv = DLTreeFactory.inverseComposition(tree);
            parent.inverse().addComposition(inv);
        } else if (tree.token() == Token.PROJINTO) {
            Role R = Role.resolveRole(tree.getLeft());
            if (R.isDataRole()) {
                throw new ReasonerInternalException("Projection into not implemented for the data role");
            }
            DLTree C = tree.getRight().copy();
            DLTree InvP = DLTreeFactory.buildTree(new Lexeme(Token.RNAME, parent.inverse()));
            DLTree InvR = DLTreeFactory.buildTree(new Lexeme(Token.RNAME, R.inverse()));
            C = DLTreeFactory.buildTree(new Lexeme(Token.PROJINTO), InvP, C);
            C = DLTreeFactory.buildTree(new Lexeme(Token.PROJFROM), InvR, C);
            R.setRange(C);
        } else if (tree.token() == Token.PROJFROM) {
            Role R = Role.resolveRole(tree.getLeft());
            DLTree C = tree.getRight().copy();
            DLTree P = DLTreeFactory.buildTree(new Lexeme(Token.RNAME, parent));
            C = DLTreeFactory.buildTree(new Lexeme(Token.PROJINTO), P, C);
            C = DLTreeFactory.buildTree(new Lexeme(Token.PROJFROM), tree.getLeft().copy(), C);
            R.setDomain(C);
        } else {
            this.addRoleParent(Role.resolveRole(tree), parent);
        }
    }

    public void initAncDesc() {
        Role p;
        int i;
        int nRoles = this.roles.size();
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            p.eliminateToldCycles();
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (!p.isSynonym()) continue;
            p.canonicaliseSynonym();
            p.addFeaturesToSynonym();
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym()) continue;
            p.removeSynonymsFromParents();
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym() || p.hasToldSubsumers()) continue;
            p.addParent(this.universalRole);
        }
        this.pTax.setCompletelyDefined(true);
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isClassified()) continue;
            this.pTax.classifyEntry(p);
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym()) continue;
            p.initADbyTaxonomy(this.pTax, nRoles);
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym()) continue;
            p.completeAutomaton(nRoles);
        }
        this.pTax.finalise();
        if (!this.disjointRolesA.isEmpty()) {
            for (i = 0; i < this.disjointRolesA.size(); ++i) {
                Role q = this.disjointRolesA.get(i);
                Role r = this.disjointRolesB.get(i);
                Role R = ClassifiableEntry.resolveSynonym(q);
                Role S = ClassifiableEntry.resolveSynonym(r);
                R.addDisjointRole(S);
                S.addDisjointRole(R);
                R.inverse().addDisjointRole(S.inverse());
                S.inverse().addDisjointRole(R.inverse());
            }
            for (i = 2; i < this.roles.size(); ++i) {
                p = this.roles.get(i);
                if (p.isSynonym() || !p.isDisjoint()) continue;
                p.checkHierarchicalDisjoint();
            }
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym()) continue;
            p.postProcess();
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym()) continue;
            p.consistent();
        }
    }

    protected static final class RoleCreator
    implements NameCreator<Role> {
        protected RoleCreator() {
        }

        @Override
        public Role makeEntry(String name) {
            return new Role(name);
        }
    }
}

