/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.Pair;
import uk.ac.manchester.cs.jfact.helpers.Timer;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.AxiomSet;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DIOp;
import uk.ac.manchester.cs.jfact.kernel.DLConceptTaxonomy;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlSatTester;
import uk.ac.manchester.cs.jfact.kernel.DumpInterface;
import uk.ac.manchester.cs.jfact.kernel.DumpLisp;
import uk.ac.manchester.cs.jfact.kernel.IFOptionSet;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBFlags;
import uk.ac.manchester.cs.jfact.kernel.KBStatus;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.LogicFeatures;
import uk.ac.manchester.cs.jfact.kernel.NameCreator;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.NamedEntryCollection;
import uk.ac.manchester.cs.jfact.kernel.NominalReasoner;
import uk.ac.manchester.cs.jfact.kernel.Related;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataEntry;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataTypeCenter;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTypeName;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheConst;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheSingleton;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.split.TSplitVar;
import uk.ac.manchester.cs.jfact.split.TSplitVars;

public final class TBox {
    private long relevance = 1L;
    private DLDag dlHeap;
    private DlSatTester stdReasoner;
    private NominalReasoner nomReasoner;
    private ReasonerProgressMonitor pMonitor;
    private DLConceptTaxonomy pTax;
    private DataTypeCenter datatypeCenter = new DataTypeCenter();
    private final IFOptionSet pOptions;
    private KBStatus kbStatus;
    private LogicFeatures KBFeatures = new LogicFeatures();
    private LogicFeatures GCIFeatures = new LogicFeatures();
    private LogicFeatures nominalCloudFeatures = new LogicFeatures();
    private LogicFeatures auxFeatures = new LogicFeatures();
    private LogicFeatures curFeature = new LogicFeatures();
    private Concept pTemp;
    private Concept defConcept;
    private final NamedEntryCollection<Concept> concepts;
    private final NamedEntryCollection<Individual> individuals;
    private RoleMaster objectRoleMaster;
    private RoleMaster dataRoleMaster;
    private AxiomSet axioms;
    private List<Related> relatedIndividuals = new ArrayList<Related>();
    private List<List<Individual>> differentIndividuals = new ArrayList<List<Individual>>();
    private List<SimpleRule> simpleRules = new ArrayList<SimpleRule>();
    private int internalisedGeneralAxiom;
    private KBFlags GCIs;
    private Map<DLTree, Concept> forall_R_C_Cache = new HashMap<DLTree, Concept>();
    private int auxConceptID;
    private int nNominalReferences;
    private Set<Concept> conceptInProcess = new HashSet<Concept>();
    private List<Concept> fairness = new ArrayList<Concept>();
    private final long testTimeout;
    private boolean useRelevantOnly;
    private boolean useCompletelyDefined;
    private boolean dumpQuery;
    private boolean alwaysPreferEquals;
    private boolean verboseOutput;
    private boolean useSortedReasoning;
    private boolean isLikeGALEN;
    private boolean isLikeWINE;
    private boolean consistent;
    private long preprocTime;
    private long consistTime;
    protected int nC = 0;
    protected int nR = 0;
    private final List<Concept> ConceptMap = new ArrayList<Concept>();
    Map<Concept, Pair<Individual, Boolean>> sameIndividuals = new HashMap<Concept, Pair<Individual, Boolean>>();
    Set<Concept> toldSynonyms = new HashSet<Concept>();
    int depth;
    private List<Concept> arrayCD = new ArrayList<Concept>();
    private List<Concept> arrayNoCD = new ArrayList<Concept>();
    private List<Concept> arrayNP = new ArrayList<Concept>();
    private int nItems = 0;
    private AtomicBoolean interrupted;
    private Concept top;
    private Concept bottom;
    private static final String defConceptName = "jfact.default";
    private long nRelevantCCalls;
    private long nRelevantBCalls;

    public List<Individual> i_begin() {
        return this.individuals.getList();
    }

    public DataEntry<?> getDataEntryByBP(int bp) {
        DataEntry p = (DataEntry)this.dlHeap.get(bp).getConcept();
        assert (p != null);
        return p;
    }

    public boolean initNonPrimitive(Concept p, DLTree desc) {
        if (!p.canInitNonPrim(desc)) {
            return true;
        }
        this.makeNonPrimitive(p, desc);
        return false;
    }

    public DLTree makeNonPrimitive(Concept p, DLTree desc) {
        DLTree ret = p.makeNonPrimitive(desc);
        this.checkEarlySynonym(p);
        return ret;
    }

    public void checkEarlySynonym(Concept p) {
        if (p.isSynonym()) {
            return;
        }
        if (p.isPrimitive()) {
            return;
        }
        if (!p.getDescription().isCN()) {
            return;
        }
        p.setSynonym(this.getCI(p.getDescription()));
        p.initToldSubsumers();
    }

    public void processDisjoint(List<DLTree> beg) {
        while (beg.size() > 0) {
            DLTree r = beg.remove(0);
            this.addSubsumeAxiom(r, DLTreeFactory.buildDisjAux(beg));
        }
    }

    public int reflexive2dag(Role R) {
        if (!R.isSimple()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + R.getName());
        }
        return -this.dlHeap.add(new DLVertex(DagTag.dtIrr, 0, R, 0, null));
    }

    public int dataForall2dag(Role R, int C) {
        return this.dlHeap.add(new DLVertex(DagTag.dtForall, 0, R, C, null));
    }

    public int dataAtMost2dag(int n, Role R, int C) {
        return this.dlHeap.add(new DLVertex(DagTag.dtLE, n, R, C, null));
    }

    public int concept2dag(Concept p) {
        if (p == null) {
            return 0;
        }
        if (!Helper.isValid(p.getpName())) {
            this.addConceptToHeap(p);
        }
        return p.resolveId();
    }

    public void processGCI(DLTree C, DLTree D) {
        this.axioms.addAxiom(C, D);
    }

    public void absorbAxioms() {
        int nSynonyms = this.countSynonyms();
        this.axioms.absorb();
        if (this.countSynonyms() > nSynonyms) {
            this.replaceAllSynonyms();
        }
        if (this.axioms.wasRoleAbsorptionApplied()) {
            this.initToldSubsumers();
        }
    }

    public void initToldSubsumers() {
        for (Concept pc : this.concepts.getList()) {
            if (pc.isSynonym()) continue;
            pc.initToldSubsumers();
        }
        for (Individual pi : this.individuals.getList()) {
            if (pi.isSynonym()) continue;
            pi.initToldSubsumers();
        }
    }

    public void setToldTop() {
        for (Concept pc : this.concepts.getList()) {
            pc.setToldTop(this.top);
        }
        for (Individual pi : this.individuals.getList()) {
            pi.setToldTop(this.top);
        }
    }

    public void calculateTSDepth() {
        for (Concept pc : this.concepts.getList()) {
            pc.calculateTSDepth();
        }
        for (Individual pi : this.individuals.getList()) {
            pi.calculateTSDepth();
        }
    }

    public int countSynonyms() {
        int nSynonyms = 0;
        for (Concept pc : this.concepts.getList()) {
            if (!pc.isSynonym()) continue;
            ++nSynonyms;
        }
        for (Individual pi : this.individuals.getList()) {
            if (!pi.isSynonym()) continue;
            ++nSynonyms;
        }
        return nSynonyms;
    }

    public void initRuleFields(List<Concept> v, int index) {
        for (Concept q : v) {
            q.addExtraRule(index);
        }
    }

    public void fillsClassificationTag() {
        for (Concept pc : this.concepts.getList()) {
            pc.getClassTag();
        }
        for (Individual pi : this.individuals.getList()) {
            pi.getClassTag();
        }
    }

    public void setConceptIndex(Concept C) {
        C.setIndex(this.nC);
        this.ConceptMap.add(C);
        ++this.nC;
    }

    public DlSatTester getReasoner() {
        assert (this.curFeature != null);
        if (this.curFeature.hasSingletons()) {
            return this.nomReasoner;
        }
        return this.stdReasoner;
    }

    public void printConcepts(LeveLogger.LogAdapter o) {
        if (this.concepts.size() == 0) {
            return;
        }
        o.print(String.format("Concepts (%s):\n", this.concepts.size()));
        for (Concept pc : this.concepts.getList()) {
            this.printConcept(o, pc);
        }
    }

    public void printIndividuals(LeveLogger.LogAdapter o) {
        if (this.individuals.size() == 0) {
            return;
        }
        o.print(String.format("Individuals (%s):\n", this.individuals.size()));
        for (Individual pi : this.individuals.getList()) {
            this.printConcept(o, pi);
        }
    }

    public void printSimpleRules(LeveLogger.LogAdapter o) {
        if (this.simpleRules.isEmpty()) {
            return;
        }
        o.print(String.format("Simple rules (%s):\n", this.simpleRules.size()));
        for (SimpleRule p : this.simpleRules) {
            o.print("(");
            for (int i = 0; i < p.getBody().size(); ++i) {
                if (i > 0) {
                    o.print(", ");
                }
                o.print(p.getBody().get(i).getName());
            }
            o.print(String.format(") => %s\n", p.tHead));
        }
    }

    public void printAxioms(LeveLogger.LogAdapter o) {
        if (this.internalisedGeneralAxiom == 1) {
            return;
        }
        o.print("Axioms:\nT [=");
        this.depth = 0;
        this.printDagEntry(o, this.internalisedGeneralAxiom);
    }

    public boolean isIrreflexive(Role R) {
        assert (R != null);
        if (R.isDataRole()) {
            return true;
        }
        this.curFeature = this.KBFeatures;
        this.getReasoner().setBlockingMethod(this.isIRinQuery(), this.isNRinQuery());
        boolean result = this.getReasoner().checkIrreflexivity(R);
        this.clearFeatures();
        return result;
    }

    private void collectLogicFeature(Concept p) {
        if (this.curFeature != null) {
            this.curFeature.fillConceptData(p);
        }
    }

    private void collectLogicFeature(Role p) {
        if (this.curFeature != null) {
            this.curFeature.fillRoleData(p, p.inverse().isRelevant(this.relevance));
        }
    }

    private void collectLogicFeature(DLVertex v, boolean pos) {
        if (this.curFeature != null) {
            this.curFeature.fillDAGData(v, pos);
        }
    }

    private void markGCIsRelevant() {
        this.setRelevant(this.internalisedGeneralAxiom);
    }

    private void markAllRelevant() {
        for (Concept pc : this.concepts.getList()) {
            if (pc.isRelevant(this.relevance)) continue;
            ++this.nRelevantCCalls;
            pc.setRelevant(this.relevance);
            this.collectLogicFeature(pc);
            this.setRelevant(pc.getpBody());
        }
        for (Individual pi : this.individuals.getList()) {
            if (pi.isRelevant(this.relevance)) continue;
            ++this.nRelevantCCalls;
            pi.setRelevant(this.relevance);
            this.collectLogicFeature(pi);
            this.setRelevant(pi.getpBody());
        }
        this.markGCIsRelevant();
    }

    public void clearRelevanceInfo() {
        ++this.relevance;
    }

    public DLTree getFreshConcept() {
        return DLTreeFactory.buildTree(new Lexeme(Token.CNAME, this.pTemp));
    }

    private void setConceptRelevant(Concept p) {
        this.curFeature = p.getPosFeatures();
        this.setRelevant(p.getpBody());
        this.KBFeatures.or(p.getPosFeatures());
        this.collectLogicFeature(p);
        this.clearRelevanceInfo();
        if (p.isPrimitive()) {
            return;
        }
        this.curFeature = p.getNegFeatures();
        this.setRelevant(-p.getpBody());
        this.KBFeatures.or(p.getNegFeatures());
        this.clearRelevanceInfo();
    }

    private void updateAuxFeatures(LogicFeatures lf) {
        if (!lf.isEmpty()) {
            this.auxFeatures.or(lf);
            this.auxFeatures.mergeRoles();
        }
    }

    public void clearFeatures() {
        this.curFeature = null;
    }

    public RoleMaster getORM() {
        return this.objectRoleMaster;
    }

    public RoleMaster getDRM() {
        return this.dataRoleMaster;
    }

    public RoleMaster getRM(Role R) {
        return R.isDataRole() ? this.dataRoleMaster : this.objectRoleMaster;
    }

    public DataTypeCenter getDataTypeCenter() {
        return this.datatypeCenter;
    }

    public Concept getConcept(String name) {
        return this.concepts.get(name);
    }

    public Individual getIndividual(String name) {
        return this.individuals.get(name);
    }

    private boolean isIndividual(String name) {
        return this.individuals.isRegistered(name);
    }

    public boolean isIndividual(DLTree tree) {
        return tree.token() == Token.INAME && this.isIndividual(tree.elem().getNE().getName());
    }

    public Concept getCI(DLTree name) {
        if (name.isTOP()) {
            return this.top;
        }
        if (name.isBOTTOM()) {
            return this.bottom;
        }
        if (!name.isName()) {
            return null;
        }
        if (name.token() == Token.CNAME) {
            return (Concept)name.elem().getNE();
        }
        return (Individual)name.elem().getNE();
    }

    public DLTree getTree(Concept C) {
        if (C == null) {
            return null;
        }
        if (C.isTop()) {
            return DLTreeFactory.createTop();
        }
        if (C.isBottom()) {
            return DLTreeFactory.createBottom();
        }
        return DLTreeFactory.buildTree(new Lexeme(this.isIndividual(C.getName()) ? Token.INAME : Token.CNAME, C));
    }

    public boolean setForbidUndefinedNames(boolean val) {
        this.objectRoleMaster.setUndefinedNames(!val);
        this.dataRoleMaster.setUndefinedNames(!val);
        this.individuals.setLocked(val);
        return this.concepts.setLocked(val);
    }

    public void registerIndividualRelation(NamedEntry a, NamedEntry R, NamedEntry b) {
        if (!this.isIndividual(a.getName()) || !this.isIndividual(b.getName())) {
            throw new ReasonerInternalException("Individual expected in related()");
        }
        this.relatedIndividuals.add(new Related((Individual)a, (Individual)b, (Role)R));
        this.relatedIndividuals.add(new Related((Individual)b, (Individual)a, ((Role)R).inverse()));
    }

    public void addSubsumeAxiom(Concept C, DLTree D) {
        this.addSubsumeAxiom(this.getTree(C), D);
    }

    public void addSimpleRule(SimpleRule Rule) {
        this.initRuleFields(Rule.getBody(), this.simpleRules.size());
        this.simpleRules.add(Rule);
    }

    public boolean hasFC() {
        return !this.fairness.isEmpty();
    }

    public void setFairnessConstraintDLTrees(List<DLTree> l) {
        for (int i = 0; i < l.size(); ++i) {
            Concept fc = this.getAuxConcept(null);
            this.fairness.add(fc);
            this.addSubsumeAxiom(l.get(i), this.getTree(fc));
        }
    }

    public int getTG() {
        return this.internalisedGeneralAxiom;
    }

    public final SimpleRule getSimpleRule(int index) {
        return this.simpleRules.get(index);
    }

    public boolean isIRinQuery() {
        if (this.curFeature != null) {
            return this.curFeature.hasInverseRole();
        }
        return this.KBFeatures.hasInverseRole();
    }

    public boolean isNRinQuery() {
        LogicFeatures p = this.curFeature != null ? this.curFeature : this.KBFeatures;
        return p.hasFunctionalRestriction() || p.hasNumberRestriction() || p.hasQNumberRestriction();
    }

    public boolean testHasNominals() {
        if (this.curFeature != null) {
            return this.curFeature.hasSingletons();
        }
        return this.KBFeatures.hasSingletons();
    }

    public boolean canUseSortedReasoning() {
        return this.useSortedReasoning && !this.GCIs.isGCI() && !this.GCIs.isReflexive();
    }

    public void performClassification() {
        this.createTaxonomy(false);
    }

    public void performRealisation() {
        this.createTaxonomy(true);
    }

    public DLConceptTaxonomy getTaxonomy() {
        return this.pTax;
    }

    public void setProgressMonitor(ReasonerProgressMonitor pMon) {
        this.pMonitor = pMon;
    }

    public void setVerboseOutput(boolean value) {
        this.verboseOutput = value;
    }

    public KBStatus getStatus() {
        return this.kbStatus;
    }

    public void setConsistency(boolean val) {
        this.kbStatus = KBStatus.kbCChecked;
        this.consistent = val;
    }

    public boolean isConsistent() {
        if (this.kbStatus.ordinal() < KBStatus.kbCChecked.ordinal()) {
            this.prepareReasoning();
            if (this.kbStatus.ordinal() < KBStatus.kbCChecked.ordinal() && this.consistent) {
                this.setConsistency(this.performConsistencyCheck());
            }
        }
        return this.consistent;
    }

    public boolean testSortedNonSubsumption(Concept p, Concept q) {
        if (!this.canUseSortedReasoning()) {
            return false;
        }
        if (q == null) {
            return false;
        }
        return !this.dlHeap.haveSameSort(p.getpName(), q.getpName());
    }

    public void print(LeveLogger.LogAdapter o) {
        this.dlHeap.printStat(o);
        this.objectRoleMaster.print(o, "Object");
        this.dataRoleMaster.print(o, "Data");
        this.printConcepts(o);
        this.printIndividuals(o);
        this.printSimpleRules(o);
        this.printAxioms(o);
        this.dlHeap.print(o);
    }

    public void buildDAG() {
        int nInd;
        this.nNominalReferences = 0;
        this.concept2dag(this.pTemp);
        DLTree freshDT = this.datatypeCenter.getFreshDataType();
        NamedEntry ne = freshDT.elem().getNE();
        if (ne instanceof DataTypeName) {
            this.addDataExprToHeap(((DataTypeName)ne).getDatatype());
        } else {
            this.addDataExprToHeap((DataEntry)ne);
        }
        for (Concept pc : this.concepts.getList()) {
            this.concept2dag(pc);
        }
        for (Individual pi : this.individuals.getList()) {
            this.concept2dag(pi);
        }
        for (SimpleRule q : this.simpleRules) {
            q.setBpHead(this.tree2dag(q.tHead));
        }
        this.initRangeDomain(this.objectRoleMaster);
        this.initRangeDomain(this.dataRoleMaster);
        for (TSplitVar s : this.getSplits().getEntries()) {
            this.split2dag(s);
        }
        DLTree GCI = this.axioms.getGCI();
        ArrayList<DLTree> list = new ArrayList<DLTree>();
        for (Role p : this.objectRoleMaster.getRoles()) {
            if (p.isSynonym() || !p.hasSpecialDomain()) continue;
            list.add(p.getTSpecialDomain().copy());
        }
        if (list.size() > 0) {
            list.add(GCI);
            GCI = DLTreeFactory.createSNFAnd(list);
        }
        this.internalisedGeneralAxiom = this.tree2dag(GCI);
        GCI = null;
        this.GCIs.setGCI(this.internalisedGeneralAxiom != 1);
        this.GCIs.setReflexive(this.objectRoleMaster.hasReflexiveRoles());
        for (Role p : this.objectRoleMaster.getRoles()) {
            if (p.isSynonym() || !p.isTopFunc()) continue;
            p.setFunctional(this.atmost2dag(1, p, 1));
        }
        for (Role p : this.dataRoleMaster.getRoles()) {
            if (p.isSynonym() || !p.isTopFunc()) continue;
            p.setFunctional(this.atmost2dag(1, p, 1));
        }
        if (this.nNominalReferences > 0 && (nInd = this.individuals.getList().size()) > 100 && this.nNominalReferences > nInd) {
            this.isLikeWINE = true;
        }
    }

    public void initRangeDomain(RoleMaster RM) {
        for (Role p : RM.getRoles()) {
            if (p.isSynonym()) continue;
            Role R = p;
            DLTree dom = R.getTDomain();
            int bp = 1;
            if (dom != null) {
                bp = this.tree2dag(dom);
                this.GCIs.setRnD();
            }
            R.setBPDomain(bp);
            R.initSpecialDomain();
            if (!R.hasSpecialDomain()) continue;
            R.setSpecialDomain(this.tree2dag(R.getTSpecialDomain()));
        }
    }

    public int addDataExprToHeap(DataEntry p) {
        int toReturn = 0;
        if (Helper.isValid(p.getBP())) {
            toReturn = p.getBP();
        } else {
            DagTag dt = p.isBasicDataType() ? DagTag.dtDataType : (p.isDataValue() ? DagTag.dtDataValue : DagTag.dtDataExpr);
            int hostBP = 1;
            if (p.getType() != null) {
                hostBP = this.addDataExprToHeap(p.getType());
            }
            DLVertex ver = new DLVertex(dt, 0, null, hostBP, null);
            ver.setConcept(p);
            p.setBP(this.dlHeap.directAdd(ver));
            toReturn = p.getBP();
        }
        return toReturn;
    }

    public int addDataExprToHeap(Datatypes p) {
        int toReturn = 0;
        DataTypeName concept = new DataTypeName(p);
        int index = this.dlHeap.index(concept);
        if (index != 0) {
            toReturn = index;
        } else {
            int directAdd;
            DLVertex ver = new DLVertex(DagTag.dtDataType, 0, null, 1, null);
            ver.setConcept(concept);
            toReturn = directAdd = this.dlHeap.directAdd(ver);
        }
        return toReturn;
    }

    public void addConceptToHeap(Concept pConcept) {
        DagTag tag;
        DagTag dagTag = pConcept.isPrimitive() ? (pConcept.isSingleton() ? DagTag.dtPSingleton : DagTag.dtPConcept) : (tag = pConcept.isSingleton() ? DagTag.dtNSingleton : DagTag.dtNConcept);
        if (tag == DagTag.dtNSingleton && !pConcept.isSynonym()) {
            ((Individual)pConcept).setNominal(true);
        }
        DLVertex ver = new DLVertex(tag);
        ver.setConcept(pConcept);
        pConcept.setpName(this.dlHeap.directAdd(ver));
        int desc = 1;
        if (pConcept.getDescription() != null) {
            desc = this.tree2dag(pConcept.getDescription());
        } else assert (pConcept.isPrimitive());
        pConcept.setpBody(desc);
        ver.setChild(desc);
    }

    public int tree2dag(DLTree t) {
        if (t == null) {
            return 0;
        }
        Lexeme cur = t.elem();
        int ret = 0;
        boolean index = false;
        switch (cur.getToken()) {
            case BOTTOM: {
                ret = -1;
                break;
            }
            case TOP: {
                ret = 1;
                break;
            }
            case DATAEXPR: {
                if (cur.getNE() instanceof DataEntry) {
                    ret = this.addDataExprToHeap((DataEntry)cur.getNE());
                    break;
                }
                ret = this.addDataExprToHeap(((DataTypeName)cur.getNE()).getDatatype());
                break;
            }
            case CNAME: {
                ret = this.concept2dag((Concept)cur.getNE());
                break;
            }
            case INAME: {
                ++this.nNominalReferences;
                Individual ind = (Individual)cur.getNE();
                ind.setNominal(true);
                ret = this.concept2dag(ind);
                break;
            }
            case NOT: {
                ret = -this.tree2dag(t.getChild());
                break;
            }
            case AND: {
                ret = this.and2dag(new DLVertex(DagTag.dtAnd), t);
                break;
            }
            case FORALL: {
                ret = this.forall2dag(Role.resolveRole(t.getLeft()), this.tree2dag(t.getRight()));
                break;
            }
            case SELF: {
                ret = this.reflexive2dag(Role.resolveRole(t.getChild()));
                break;
            }
            case LE: {
                ret = this.atmost2dag(cur.getData(), Role.resolveRole(t.getLeft()), this.tree2dag(t.getRight()));
                break;
            }
            case PROJFROM: {
                ret = this.dlHeap.directAdd(new DLVertex(DagTag.dtProj, 0, Role.resolveRole(t.getLeft()), this.tree2dag(t.getRight().getRight()), Role.resolveRole(t.getRight().getLeft())));
                break;
            }
            default: {
                assert (DLTreeFactory.isSNF(t));
                throw new UnreachableSituationException();
            }
        }
        return ret;
    }

    public int and2dag(DLVertex v, DLTree t) {
        int ret = -1;
        if (!this.fillANDVertex(v, t)) {
            int value = v.getAndToDagValue();
            if (value != 0) {
                return value;
            }
            return this.dlHeap.add(v);
        }
        return ret;
    }

    public int forall2dag(Role R, int C) {
        if (R.isDataRole()) {
            return this.dataForall2dag(R, C);
        }
        int ret = this.dlHeap.add(new DLVertex(DagTag.dtForall, 0, R, C, null));
        if (R.isSimple()) {
            return ret;
        }
        if (!this.dlHeap.isLast(ret)) {
            return ret;
        }
        for (int i = 1; i < R.getAutomaton().size(); ++i) {
            this.dlHeap.directAddAndCache(new DLVertex(DagTag.dtForall, i, R, C, null));
        }
        return ret;
    }

    public int atmost2dag(int n, Role R, int C) {
        if (!R.isSimple()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + R.getName());
        }
        if (R.isDataRole()) {
            return this.dataAtMost2dag(n, R, C);
        }
        int ret = this.dlHeap.add(new DLVertex(DagTag.dtLE, n, R, C, null));
        if (!this.dlHeap.isLast(ret)) {
            return ret;
        }
        for (int m = n - 1; m > 0; --m) {
            this.dlHeap.directAddAndCache(new DLVertex(DagTag.dtLE, m, R, C, null));
        }
        this.dlHeap.directAddAndCache(new DLVertex(DagTag.dtNN));
        return ret;
    }

    void split2dag(TSplitVar split) {
        DLVertex v = new DLVertex(DagTag.dtSplitConcept);
        for (TSplitVar.Entry p : split.getEntries()) {
            v.addChild(p.concept.getpName());
        }
        split.C.setpBody(this.dlHeap.directAdd(v));
        split.C.setPrimitive(false);
        this.dlHeap.replaceVertex(split.C.getpName(), new DLVertex(DagTag.dtNConcept, 0, null, split.C.getpBody(), null), split.C);
        this.dlHeap.directAdd(new DLVertex(DagTag.dtChoose, 0, null, split.C.getpName(), null));
    }

    private final boolean fillANDVertex(DLVertex v, DLTree t) {
        if (t.isAND()) {
            boolean ret = false;
            List<DLTree> children = t.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                ret |= this.fillANDVertex(v, children.get(i));
            }
            return ret;
        }
        return v.addChild(this.tree2dag(t));
    }

    public <T extends Concept> int fillArrays(List<T> begin) {
        int n = 0;
        block4: for (Concept p : begin) {
            if (p.isNonClassifiable()) continue;
            ++n;
            switch (p.getClassTag()) {
                case cttTrueCompletelyDefined: {
                    this.arrayCD.add(p);
                    continue block4;
                }
                case cttNonPrimitive: 
                case cttHasNonPrimitiveTS: {
                    this.arrayNP.add(p);
                    continue block4;
                }
            }
            this.arrayNoCD.add(p);
        }
        return n;
    }

    public int getNItems() {
        return this.nItems;
    }

    public void createTaxonomy(boolean needIndividual) {
        boolean needConcept = !needIndividual;
        this.dlHeap.setSubOrder();
        this.pTax.setBottomUp(this.GCIs);
        needConcept |= needIndividual;
        if (this.verboseOutput) {
            LeveLogger.logger.println("Processing query...");
        }
        Timer locTimer = new Timer();
        locTimer.start();
        this.nItems = 0;
        this.arrayCD.clear();
        this.arrayNoCD.clear();
        this.arrayNP.clear();
        this.nItems += this.fillArrays(this.concepts.getList());
        this.nItems += this.fillArrays(this.individuals.getList());
        if (this.pMonitor != null) {
            this.pMonitor.reasonerTaskStarted("Classifying");
            this.pTax.setProgressIndicator(this.pMonitor);
        }
        this.stdReasoner.setDuringClassification(true);
        if (this.nomReasoner != null) {
            this.nomReasoner.setDuringClassification(true);
        }
        this.classifyConcepts(this.arrayCD, true, "completely defined");
        this.classifyConcepts(this.arrayNoCD, false, "regular");
        this.classifyConcepts(this.arrayNP, false, "non-primitive");
        this.stdReasoner.setDuringClassification(false);
        if (this.nomReasoner != null) {
            this.nomReasoner.setDuringClassification(false);
        }
        this.pTax.processSplits();
        if (this.pMonitor != null) {
            this.pMonitor.reasonerTaskStopped();
            this.pMonitor = null;
        }
        this.pTax.finalise();
        locTimer.stop();
        if (this.verboseOutput) {
            LeveLogger.logger.println(" done in " + locTimer.calcDelta() + " seconds\n");
        }
        if (needConcept && this.kbStatus.ordinal() < KBStatus.kbClassified.ordinal()) {
            this.kbStatus = KBStatus.kbClassified;
        }
        if (needIndividual) {
            this.kbStatus = KBStatus.kbRealised;
        }
        if (this.verboseOutput) {
            // empty if block
        }
    }

    public void classifyConcepts(List<Concept> collection, boolean curCompletelyDefined, String type) {
        this.pTax.setCompletelyDefined(curCompletelyDefined);
        LeveLogger.logger.print(LeveLogger.Templates.CLASSIFY_CONCEPTS, type);
        int n = 0;
        for (Concept q : collection) {
            if (this.interrupted.get() || q.isClassified()) continue;
            this.classifyEntry(q);
            if (!q.isClassified()) continue;
            ++n;
        }
        LeveLogger.logger.print(LeveLogger.Templates.CLASSIFY_CONCEPTS2, n, type);
    }

    void classifyEntry(Concept entry) {
        if (this.isBlockedInd(entry)) {
            this.classifyEntry(this.getBlockingInd(entry));
        }
        if (!entry.isClassified()) {
            this.pTax.classifyEntry(entry);
        }
    }

    public TBox(IFOptionSet Options, String TopORoleName, String BotORoleName, String TopDRoleName, String BotDRoleName, AtomicBoolean interrupted, long timeOut) {
        this.interrupted = interrupted;
        this.axioms = new AxiomSet(this);
        this.GCIs = new KBFlags();
        this.dlHeap = new DLDag(Options);
        this.testTimeout = timeOut;
        this.stdReasoner = null;
        this.nomReasoner = null;
        this.pMonitor = null;
        this.pOptions = Options;
        this.kbStatus = KBStatus.kbLoading;
        this.curFeature = null;
        this.defConcept = null;
        this.concepts = new NamedEntryCollection<Concept>("concept", new ConceptCreator());
        this.individuals = new NamedEntryCollection<Individual>("individual", new IndividualCreator());
        this.objectRoleMaster = new RoleMaster(false, TopORoleName, BotORoleName);
        this.dataRoleMaster = new RoleMaster(true, TopDRoleName, BotDRoleName);
        this.axioms = new AxiomSet(this);
        this.internalisedGeneralAxiom = 1;
        this.auxConceptID = 0;
        this.useSortedReasoning = true;
        this.isLikeGALEN = false;
        this.isLikeWINE = false;
        this.consistent = true;
        this.preprocTime = 0L;
        this.consistTime = 0L;
        this.readConfig(Options);
        this.initTopBottom();
        this.setForbidUndefinedNames(false);
        this.pTax = new DLConceptTaxonomy(this.top, this.bottom, this);
    }

    public Concept getAuxConcept(DLTree desc) {
        Concept C = this.getConcept(" aux" + ++this.auxConceptID);
        C.setSystem();
        C.setNonClassifiable();
        C.setPrimitive();
        C.addDesc(desc);
        C.initToldSubsumers();
        return C;
    }

    private void initTopBottom() {
        this.top = Concept.getTOP();
        this.bottom = Concept.getBOTTOM();
        this.pTemp = Concept.getTEMP();
    }

    public void prepareReasoning() {
        this.preprocess();
        this.initReasoner();
        this.setForbidUndefinedNames(true);
        if (this.dumpQuery) {
            PrintStream of;
            this.markAllRelevant();
            try {
                of = new PrintStream("tbox");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            DumpLisp lDump = new DumpLisp(of);
            this.dump(lDump);
            of.close();
            this.clearRelevanceInfo();
        }
        this.dlHeap.setSatOrder();
        this.setToDoPriorities();
    }

    public void prepareFeatures(Concept pConcept, Concept qConcept) {
        this.auxFeatures = new LogicFeatures(this.GCIFeatures);
        if (pConcept != null) {
            this.updateAuxFeatures(pConcept.getPosFeatures());
        }
        if (qConcept != null) {
            this.updateAuxFeatures(qConcept.getNegFeatures());
        }
        if (this.auxFeatures.hasSingletons()) {
            this.updateAuxFeatures(this.nominalCloudFeatures);
        }
        this.curFeature = this.auxFeatures;
        this.getReasoner().setBlockingMethod(this.isIRinQuery(), this.isNRinQuery());
    }

    public void buildSimpleCache() {
        this.initConstCache(-1);
        this.initSingletonCache(this.pTemp, true);
        this.initSingletonCache(this.pTemp, false);
        if (this.GCIs.isGCI() || this.GCIs.isReflexive()) {
            return;
        }
        this.initConstCache(1);
        for (Concept pc : this.concepts.getList()) {
            if (!pc.isPrimitive()) continue;
            this.initSingletonCache(pc, false);
        }
        for (Individual pi : this.individuals.getList()) {
            if (!pi.isPrimitive()) continue;
            this.initSingletonCache(pi, false);
        }
    }

    public boolean performConsistencyCheck() {
        if (this.verboseOutput) {
            LeveLogger.logger.println("Consistency checking...");
        }
        Timer pt = new Timer();
        pt.start();
        this.buildSimpleCache();
        Individual test = this.nominalCloudFeatures.hasSingletons() && this.individuals.getList().size() > 0 ? this.individuals.getList().get(0) : null;
        this.prepareFeatures(test, null);
        boolean ret = false;
        if (test != null) {
            if (this.dlHeap.getCache(1) == null) {
                this.initConstCache(1);
            }
            ret = this.nomReasoner.consistentNominalCloud();
        } else {
            ret = this.isSatisfiable(this.top);
            if (this.GCIs.isGCI()) {
                this.dlHeap.setCache(-this.internalisedGeneralAxiom, new ModelCacheConst(false));
            }
        }
        pt.stop();
        this.consistTime = pt.calcDelta();
        if (this.verboseOutput) {
            LeveLogger.logger.println(" done in " + this.consistTime + " seconds\n");
        }
        return ret;
    }

    public boolean isSatisfiable(Concept pConcept) {
        assert (pConcept != null);
        ModelCacheInterface cache = this.dlHeap.getCache(pConcept.getpName());
        if (cache != null) {
            return cache.getState() != ModelCacheState.csInvalid;
        }
        LeveLogger.logger.println(LeveLogger.Templates.IS_SATISFIABLE, pConcept.getName());
        this.prepareFeatures(pConcept, null);
        boolean result = this.getReasoner().runSat(pConcept.resolveId(), 1);
        cache = this.getReasoner().buildCacheByCGraph(result);
        this.dlHeap.setCache(pConcept.getpName(), cache);
        this.clearFeatures();
        LeveLogger.logger.print(LeveLogger.Templates.IS_SATISFIABLE1, pConcept.getName(), !result ? "un" : "");
        return result;
    }

    public boolean isSubHolds(Concept pConcept, Concept qConcept) {
        assert (pConcept != null && qConcept != null);
        LeveLogger.logger.print(LeveLogger.Templates.ISSUBHOLDS1, pConcept.getName(), qConcept.getName());
        this.prepareFeatures(pConcept, qConcept);
        boolean result = !this.getReasoner().runSat(pConcept.resolveId(), -qConcept.resolveId());
        this.clearFeatures();
        LeveLogger.logger.print(LeveLogger.Templates.ISSUBHOLDS2, pConcept.getName(), qConcept.getName(), !result ? " NOT" : "");
        return result;
    }

    public boolean isSameIndividuals(Individual _a, Individual _b) {
        Individual b;
        Individual a = ClassifiableEntry.resolveSynonym(_a);
        if (a.equals(b = ClassifiableEntry.resolveSynonym(_b))) {
            return true;
        }
        if (!this.isIndividual(a.getName()) || !this.isIndividual(b.getName())) {
            throw new ReasonerInternalException("Individuals are expected in the isSameIndividuals() query");
        }
        if (a.getNode() == null || b.getNode() == null) {
            if (a.isSynonym()) {
                return this.isSameIndividuals((Individual)a.getSynonym(), b);
            }
            if (b.isSynonym()) {
                return this.isSameIndividuals(a, (Individual)b.getSynonym());
            }
            throw new ReasonerInternalException("isSameIndividuals() query with non-realised ontology");
        }
        return a.getNode().resolvePBlocker().equals(b.getNode().resolvePBlocker());
    }

    public boolean isDisjointRoles(Role R, Role S) {
        assert (R != null && S != null);
        if (R.isDataRole() != S.isDataRole()) {
            return true;
        }
        this.curFeature = this.KBFeatures;
        this.getReasoner().setBlockingMethod(this.isIRinQuery(), this.isNRinQuery());
        boolean result = this.getReasoner().checkDisjointRoles(R, S);
        this.clearFeatures();
        return result;
    }

    public void readConfig(IFOptionSet Options) {
        assert (Options != null);
        this.useCompletelyDefined = Options.getBool("useCompletelyDefined");
        this.useRelevantOnly = Options.getBool("useRelevantOnly");
        this.dumpQuery = Options.getBool("dumpQuery");
        this.alwaysPreferEquals = Options.getBool("alwaysPreferEquals");
        LeveLogger.logger.println(LeveLogger.Templates.READ_CONFIG, this.useCompletelyDefined, this.useRelevantOnly, this.dumpQuery, this.alwaysPreferEquals);
        if (this.axioms.initAbsorptionFlags(Options.getText("absorptionFlags"))) {
            throw new ReasonerInternalException("Incorrect absorption flags given");
        }
        this.verboseOutput = true;
    }

    public void removeConcept(Concept p) {
        assert (p.equals(this.defConcept));
        if (Helper.isCorrect(p.getpName())) {
            this.dlHeap.removeAfter(p.getpName());
        }
        if (this.concepts.remove(p)) {
            throw new UnreachableSituationException();
        }
    }

    public void clearQueryConcept() {
        this.removeConcept(this.defConcept);
    }

    public Concept createQueryConcept(DLTree desc) {
        assert (desc != null);
        if (this.defConcept != null) {
            this.clearQueryConcept();
        }
        boolean old = this.setForbidUndefinedNames(false);
        this.defConcept = this.getConcept(defConceptName);
        this.setForbidUndefinedNames(old);
        assert (this.defConcept != null);
        this.makeNonPrimitive(this.defConcept, desc.copy());
        this.defConcept.setSystem();
        this.defConcept.setIndex(this.nC - 1);
        this.dlHeap.setExpressionCache(false);
        this.addConceptToHeap(this.defConcept);
        this.setConceptRelevant(this.defConcept);
        this.initCache(this.defConcept, false);
        return this.defConcept;
    }

    public void classifyQueryConcept() {
        this.defConcept.initToldSubsumers();
        assert (this.pTax != null);
        this.pTax.setCompletelyDefined(false);
        this.pTax.setProgressIndicator(null);
        this.pTax.classifyEntry(this.defConcept);
    }

    public void writeReasoningResult(LeveLogger.LogAdapter o, long time) {
        if (this.nomReasoner != null) {
            o.print("Query processing reasoning statistic: Nominals");
            this.nomReasoner.writeTotalStatistic(o);
        }
        o.print("Query processing reasoning statistic: Standard");
        this.stdReasoner.writeTotalStatistic(o);
        assert (this.kbStatus.ordinal() >= KBStatus.kbCChecked.ordinal());
        if (this.consistent) {
            o.print("Required");
        } else {
            o.print("KB is inconsistent. Query is NOT processed\nConsistency");
        }
        long sum = this.preprocTime + this.consistTime;
        o.print(String.format(" check done in %s seconds\nof which:\nPreproc. takes %s seconds\nConsist. takes %s seconds", time, this.preprocTime, this.consistTime));
        if (this.nomReasoner != null) {
            o.print("\nReasoning NOM:");
            sum = (long)((float)sum + this.nomReasoner.printReasoningTime(o));
        }
        o.print("\nReasoning STD:");
        sum = (long)((float)sum + this.stdReasoner.printReasoningTime(o));
        o.print("\nThe rest takes ");
        long f = time - sum;
        if (f < 0L) {
            f = 0L;
        }
        o.print((float)f / 1000.0f);
        o.print(" seconds\n");
        this.print(o);
    }

    public void printDagEntry(LeveLogger.LogAdapter o, int p) {
        ++this.depth;
        assert (Helper.isValid(p));
        if (p == 1) {
            o.print(" *TOP*");
            return;
        }
        if (p == -1) {
            o.print(" *BOTTOM*");
            return;
        }
        if (p < 0) {
            o.print(" (not");
            this.printDagEntry(o, -p);
            o.print(")");
            return;
        }
        DLVertex v = this.dlHeap.get(Math.abs(p));
        DagTag type = v.getType();
        switch (type) {
            case dtTop: {
                o.print(" *TOP*");
                return;
            }
            case dtPConcept: 
            case dtNConcept: 
            case dtPSingleton: 
            case dtNSingleton: 
            case dtDataType: 
            case dtDataValue: {
                o.print(" ");
                o.print(v.getConcept().getName());
                return;
            }
            case dtDataExpr: {
                o.print(" ");
                o.print(this.getDataEntryByBP(p).getFacet().toString());
                return;
            }
            case dtIrr: {
                o.print(String.format(" (%s %s)", type.getName(), v.getRole().getName()));
                return;
            }
            case dtCollection: 
            case dtAnd: 
            case dtSplitConcept: {
                o.print(" (");
                o.print(type.getName());
                for (int q : v.begin()) {
                    this.printDagEntry(o, q);
                }
                o.print(")");
                return;
            }
            case dtForall: 
            case dtLE: {
                o.print(" (");
                o.print(type.getName());
                if (type == DagTag.dtLE) {
                    o.print(" ");
                    o.print(v.getNumberLE());
                }
                o.print(" ");
                o.print(v.getRole().getName());
                this.printDagEntry(o, v.getConceptIndex());
                o.print(")");
                return;
            }
            case dtProj: {
                o.print(String.format(" (%s %s)", type.getName(), v.getRole().getName()));
                this.printDagEntry(o, v.getConceptIndex());
                o.print(String.format(" => %s)", v.getProjRole().getName()));
                return;
            }
            case dtNN: 
            case dtChoose: {
                throw new UnreachableSituationException();
            }
            case dtBad: {
                o.println("WRONG: printing a badtag dtBad!");
                break;
            }
            default: {
                throw new ReasonerInternalException("Error printing vertex of type " + type.getName() + "(" + (Object)((Object)type) + ")");
            }
        }
    }

    public void printConcept(LeveLogger.LogAdapter o, Concept p) {
        if (Helper.isValid(p.getpName())) {
            o.print(p.getClassTagPlain().getCTTagName());
            if (p.isSingleton()) {
                o.print(p.isNominal() ? (char)'o' : '!');
            }
            o.print(String.format(".%s [%s] %s", p.getName(), p.getTsDepth(), p.isNonPrimitive() ? "=" : "[="));
            if (Helper.isValid(p.getpBody())) {
                this.depth = 0;
                this.printDagEntry(o, p.getpBody());
            }
            if (p.getDescription() != null) {
                o.print(p.isNonPrimitive() ? "\n-=" : "\n-[=");
                o.print(p.getDescription().toString());
            }
            o.print("\n");
        }
    }

    private void dump(DumpInterface dump) {
        dump.prologue();
        this.dumpAllRoles(dump);
        for (Concept pc : this.concepts.getList()) {
            if (!pc.isRelevant(this.relevance)) continue;
            this.dumpConcept(dump, pc);
        }
        for (Individual pi : this.individuals.getList()) {
            if (!pi.isRelevant(this.relevance)) continue;
            this.dumpConcept(dump, pi);
        }
        if (this.internalisedGeneralAxiom != 1) {
            dump.startAx(DIOp.diImpliesC);
            dump.dumpTop();
            dump.contAx(DIOp.diImpliesC);
            this.dumpExpression(dump, this.internalisedGeneralAxiom);
            dump.finishAx(DIOp.diImpliesC);
        }
        dump.epilogue();
    }

    public void dumpConcept(DumpInterface dump, Concept p) {
        dump.startAx(DIOp.diDefineC);
        dump.dumpConcept(p);
        dump.finishAx(DIOp.diDefineC);
        if (p.getpBody() != 1) {
            DIOp Ax = p.isNonPrimitive() ? DIOp.diEqualsC : DIOp.diImpliesC;
            dump.startAx(Ax);
            dump.dumpConcept(p);
            dump.contAx(Ax);
            this.dumpExpression(dump, p.getpBody());
            dump.finishAx(Ax);
        }
    }

    public void dumpRole(DumpInterface dump, Role p) {
        if (p.getId() > 0 || !p.inverse().isRelevant(this.relevance)) {
            Role q = p.getId() > 0 ? p : p.inverse();
            dump.startAx(DIOp.diDefineR);
            dump.dumpRole(q);
            dump.finishAx(DIOp.diDefineR);
            for (ClassifiableEntry i : q.getToldSubsumers()) {
                dump.startAx(DIOp.diImpliesR);
                dump.dumpRole(q);
                dump.contAx(DIOp.diImpliesR);
                dump.dumpRole((Role)i);
                dump.finishAx(DIOp.diImpliesR);
            }
        }
        if (p.isTransitive()) {
            dump.startAx(DIOp.diTransitiveR);
            dump.dumpRole(p);
            dump.finishAx(DIOp.diTransitiveR);
        }
        if (p.isTopFunc()) {
            dump.startAx(DIOp.diFunctionalR);
            dump.dumpRole(p);
            dump.finishAx(DIOp.diFunctionalR);
        }
        if (p.getBPDomain() != 1) {
            dump.startAx(DIOp.diDomainR);
            dump.dumpRole(p);
            dump.contAx(DIOp.diDomainR);
            this.dumpExpression(dump, p.getBPDomain());
            dump.finishAx(DIOp.diDomainR);
        }
        if (p.getBPRange() != 1) {
            dump.startAx(DIOp.diRangeR);
            dump.dumpRole(p);
            dump.contAx(DIOp.diRangeR);
            this.dumpExpression(dump, p.getBPRange());
            dump.finishAx(DIOp.diRangeR);
        }
    }

    public void dumpExpression(DumpInterface dump, int p) {
        assert (Helper.isValid(p));
        if (p == 1) {
            dump.dumpTop();
            return;
        }
        if (p == -1) {
            dump.dumpBottom();
            return;
        }
        if (p < 0) {
            dump.startOp(DIOp.diNot);
            this.dumpExpression(dump, -p);
            dump.finishOp(DIOp.diNot);
            return;
        }
        DLVertex v = this.dlHeap.get(Math.abs(p));
        DagTag type = v.getType();
        switch (type) {
            case dtTop: {
                dump.dumpTop();
                return;
            }
            case dtPConcept: 
            case dtNConcept: 
            case dtPSingleton: 
            case dtNSingleton: {
                dump.dumpConcept((Concept)v.getConcept());
                return;
            }
            case dtAnd: {
                int[] begin;
                dump.startOp(DIOp.diAnd);
                for (int q : begin = v.begin()) {
                    if (q != begin[0]) {
                        dump.contOp(DIOp.diAnd);
                    }
                    this.dumpExpression(dump, q);
                }
                dump.finishOp(DIOp.diAnd);
                return;
            }
            case dtForall: {
                dump.startOp(DIOp.diForall);
                dump.dumpRole(v.getRole());
                dump.contOp(DIOp.diForall);
                this.dumpExpression(dump, v.getConceptIndex());
                dump.finishOp(DIOp.diForall);
                return;
            }
            case dtLE: {
                dump.startOp(DIOp.diLE, v.getNumberLE());
                dump.dumpRole(v.getRole());
                dump.contOp(DIOp.diLE);
                this.dumpExpression(dump, v.getConceptIndex());
                dump.finishOp(DIOp.diLE);
                return;
            }
        }
        throw new ReasonerInternalException("Error dumping vertex of type " + type.getName() + "(" + (Object)((Object)type) + ")");
    }

    public void dumpAllRoles(DumpInterface dump) {
        for (Role p : this.objectRoleMaster.getRoles()) {
            if (!p.isRelevant(this.relevance)) continue;
            assert (!p.isSynonym());
            this.dumpRole(dump, p);
        }
        for (Role p : this.dataRoleMaster.getRoles()) {
            if (!p.isRelevant(this.relevance)) continue;
            assert (!p.isSynonym());
            this.dumpRole(dump, p);
        }
    }

    public void addSubsumeAxiom(DLTree sub, DLTree sup) {
        if (DLTree.equalTrees(sub, sup)) {
            return;
        }
        if (sup.isCN() && (sup = this.applyAxiomCToCN(sub, sup)) == null) {
            return;
        }
        if (sub.isCN() && (sub = this.applyAxiomCNToC(sub, sup)) == null) {
            return;
        }
        if (!this.axiomToRangeDomain(sub, sup)) {
            this.processGCI(sub, sup);
        }
    }

    public DLTree applyAxiomCToCN(DLTree D, DLTree CN) {
        Concept C = ClassifiableEntry.resolveSynonym(this.getCI(CN));
        assert (C != null);
        if (C.isBottom()) {
            return DLTreeFactory.createBottom();
        }
        if (!C.isTop()) {
            if (!(C.isSingleton() && D.isName() || !DLTree.equalTrees(C.getDescription(), D))) {
                this.makeNonPrimitive(C, D);
            } else {
                return CN;
            }
        }
        return null;
    }

    public DLTree applyAxiomCNToC(DLTree CN, DLTree D) {
        Concept C = ClassifiableEntry.resolveSynonym(this.getCI(CN));
        assert (C != null);
        if (C.isTop()) {
            return DLTreeFactory.createTop();
        }
        if (!C.isBottom()) {
            if (C.isPrimitive()) {
                C.addDesc(D);
            } else {
                this.addSubsumeForDefined(C, D);
            }
        }
        return null;
    }

    public void addSubsumeForDefined(Concept C, DLTree D) {
        if (DLTreeFactory.isSubTree(D, C.getDescription())) {
            return;
        }
        DLTree oldDesc = C.getDescription().copy();
        C.removeSelfFromDescription();
        if (DLTree.equalTrees(oldDesc, C.getDescription())) {
            this.processGCI(oldDesc, D);
            return;
        }
        C.setPrimitive();
        C.addDesc(D);
        this.addSubsumeAxiom(oldDesc, this.getTree(C));
    }

    public boolean axiomToRangeDomain(DLTree sub, DLTree sup) {
        if (sub.isTOP() && sup.token() == Token.FORALL) {
            Role.resolveRole(sup.getLeft()).setRange(sup.getRight().copy());
            return true;
        }
        if (sub.token() == Token.NOT && sub.getChild().token() == Token.FORALL && sub.getChild().getRight().isBOTTOM()) {
            Role.resolveRole(sub.getChild().getLeft()).setDomain(sup);
            return true;
        }
        return false;
    }

    private void addEqualityAxiom(DLTree left, DLTree right) {
        if (this.addNonprimitiveDefinition(left, right)) {
            return;
        }
        if (this.addNonprimitiveDefinition(right, left)) {
            return;
        }
        if (this.switchToNonprimitive(left, right)) {
            return;
        }
        if (this.switchToNonprimitive(right, left)) {
            return;
        }
        this.addSubsumeAxiom(left.copy(), right.copy());
        this.addSubsumeAxiom(right, left);
    }

    public boolean addNonprimitiveDefinition(DLTree left, DLTree right) {
        Concept C = ClassifiableEntry.resolveSynonym(this.getCI(left));
        if (C == null || C.isTop() || C.isBottom()) {
            return false;
        }
        Concept D = this.getCI(right);
        if (D != null && ClassifiableEntry.resolveSynonym(D).equals(C)) {
            return true;
        }
        if (C.isSingleton() && D != null && !D.isSingleton()) {
            return false;
        }
        return (D == null || C.getDescription() == null || D.isPrimitive()) && !this.initNonPrimitive(C, right);
    }

    public boolean switchToNonprimitive(DLTree left, DLTree right) {
        Concept C = ClassifiableEntry.resolveSynonym(this.getCI(left));
        if (C == null || C.isTop() || C.isBottom()) {
            return false;
        }
        Concept D = ClassifiableEntry.resolveSynonym(this.getCI(right));
        if (C.isSingleton() && D != null && !D.isSingleton()) {
            return false;
        }
        if (this.alwaysPreferEquals && C.isPrimitive()) {
            this.addSubsumeForDefined(C, this.makeNonPrimitive(C, right));
            return true;
        }
        return false;
    }

    public void processDisjointC(Collection<DLTree> beg) {
        ArrayList<DLTree> prim = new ArrayList<DLTree>();
        ArrayList<DLTree> rest = new ArrayList<DLTree>();
        for (DLTree d : beg) {
            if (d.isName() && ((Concept)d.elem().getNE()).isPrimitive()) {
                prim.add(d);
                continue;
            }
            rest.add(d);
        }
        if (!prim.isEmpty() && !rest.isEmpty()) {
            DLTree nrest = DLTreeFactory.buildDisjAux(rest);
            for (DLTree q : prim) {
                this.addSubsumeAxiom(q.copy(), nrest.copy());
            }
        }
        if (!rest.isEmpty()) {
            this.processDisjoint(rest);
        }
        if (!prim.isEmpty()) {
            this.processDisjoint(prim);
        }
    }

    public void processEquivalentC(List<DLTree> l) {
        for (int i = 0; i < l.size() - 1; ++i) {
            this.addEqualityAxiom(l.get(i), l.get(i + 1).copy());
        }
    }

    public void processDifferent(List<DLTree> l) {
        ArrayList<Individual> acc = new ArrayList<Individual>();
        for (int i = 0; i < l.size(); ++i) {
            if (!this.isIndividual(l.get(i))) {
                throw new ReasonerInternalException("Only individuals allowed in processDifferent()");
            }
            acc.add((Individual)l.get(i).elem().getNE());
            l.set(i, null);
        }
        if (acc.size() > 1) {
            this.differentIndividuals.add(acc);
        }
    }

    public void processSame(List<DLTree> l) {
        int i;
        int size = l.size();
        for (i = 0; i < size; ++i) {
            if (this.isIndividual(l.get(i))) continue;
            throw new ReasonerInternalException("Only individuals allowed in processSame()");
        }
        for (i = 0; i < size - 1; ++i) {
            this.addEqualityAxiom(l.get(i), l.get(i + 1).copy());
        }
    }

    public void processDisjointR(List<DLTree> l) {
        if (l.isEmpty()) {
            throw new ReasonerInternalException("Empty disjoint role axiom");
        }
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            if (!DLTreeFactory.isUniversalRole(l.get(i))) continue;
            throw new ReasonerInternalException("Universal role in the disjoint roles axiom");
        }
        ArrayList<Role> roles = new ArrayList<Role>(size);
        for (int i = 0; i < size; ++i) {
            roles.add(Role.resolveRole(l.get(i)));
        }
        RoleMaster RM = this.getRM((Role)roles.get(0));
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                RM.addDisjointRoles((Role)roles.get(i), (Role)roles.get(j));
            }
        }
    }

    public void processEquivalentR(List<DLTree> l) {
        if (l.size() > 0) {
            RoleMaster RM = this.getRM(Role.resolveRole(l.get(0)));
            for (int i = 0; i < l.size() - 1; ++i) {
                RM.addRoleSynonym(Role.resolveRole(l.get(i)), Role.resolveRole(l.get(i + 1)));
            }
            l.clear();
        }
    }

    public void preprocess() {
        if (this.verboseOutput) {
            LeveLogger.logger.println("\nPreprocessing...");
        }
        Timer pt = new Timer();
        pt.start();
        this.objectRoleMaster.initAncDesc();
        this.dataRoleMaster.initAncDesc();
        if (this.verboseOutput) {
            try {
                PrintStream oroles = new PrintStream("Taxonomy.ORoles");
                LeveLogger.LogAdapterStringBuilder b = new LeveLogger.LogAdapterStringBuilder();
                this.objectRoleMaster.getTaxonomy().print(b);
                oroles.print(b.toString());
                oroles.close();
                b = new LeveLogger.LogAdapterStringBuilder();
                PrintStream droles = new PrintStream("Taxonomy.DRoles");
                this.dataRoleMaster.getTaxonomy().print(b);
                droles.print(b.toString());
                droles.close();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.countSynonyms() > 0) {
            this.replaceAllSynonyms();
        }
        this.preprocessRelated();
        this.initToldSubsumers();
        this.transformToldCycles();
        this.transformSingletonHierarchy();
        this.absorbAxioms();
        this.setToldTop();
        this.buildDAG();
        this.fillsClassificationTag();
        this.calculateTSDepth();
        this.setAllIndexes();
        this.determineSorts();
        this.gatherRelevanceInfo();
        this.printFeatures();
        this.dlHeap.setOrderDefaults(this.isLikeGALEN ? "Fdn" : (this.isLikeWINE ? "Sdp" : "Sap"), this.isLikeGALEN ? "Ban" : (this.isLikeWINE ? "Fdn" : "Dap"));
        this.dlHeap.gatherStatistic();
        this.calculateStatistic();
        this.removeExtraDescriptions();
        pt.stop();
        this.preprocTime = pt.calcDelta();
        if (this.verboseOutput) {
            LeveLogger.logger.println(" done in " + pt.calcDelta() + " seconds\n");
        }
    }

    private void setAllIndexes() {
        this.nC = 1;
        this.ConceptMap.add(null);
        this.pTemp.setIndex(this.nC++);
        for (Concept pc : this.concepts.getList()) {
            if (pc.isSynonym()) continue;
            pc.setIndex(this.nC++);
        }
        for (Individual pi : this.individuals.getList()) {
            if (pi.isSynonym()) continue;
            pi.setIndex(this.nC++);
        }
        ++this.nC;
        this.nR = 1;
        for (Role r : this.objectRoleMaster.getRoles()) {
            if (r.isSynonym()) continue;
            r.setIndex(this.nR++);
        }
        for (Role r : this.dataRoleMaster.getRoles()) {
            if (r.isSynonym()) continue;
            r.setIndex(this.nR++);
        }
    }

    private void replaceAllSynonyms() {
        for (Role r : this.objectRoleMaster.getRoles()) {
            if (r.isSynonym()) continue;
            DLTreeFactory.replaceSynonymsFromTree(r.getTDomain());
        }
        for (Role dr : this.dataRoleMaster.getRoles()) {
            if (dr.isSynonym()) continue;
            DLTreeFactory.replaceSynonymsFromTree(dr.getTDomain());
        }
        for (Concept pc : this.concepts.getList()) {
            if (!DLTreeFactory.replaceSynonymsFromTree(pc.getDescription())) continue;
            pc.initToldSubsumers();
        }
        for (Individual pi : this.individuals.getList()) {
            if (!DLTreeFactory.replaceSynonymsFromTree(pi.getDescription())) continue;
            pi.initToldSubsumers();
        }
    }

    public void preprocessRelated() {
        for (Related q : this.relatedIndividuals) {
            q.simplify();
        }
    }

    public void transformToldCycles() {
        int nSynonyms = this.countSynonyms();
        this.clearRelevanceInfo();
        for (Concept pc : this.concepts.getList()) {
            if (pc.isSynonym()) continue;
            this.checkToldCycle(pc);
        }
        for (Individual pi : this.individuals.getList()) {
            if (pi.isSynonym()) continue;
            this.checkToldCycle(pi);
        }
        this.clearRelevanceInfo();
        nSynonyms = this.countSynonyms() - nSynonyms;
        if (nSynonyms > 0) {
            LeveLogger.logger.print(LeveLogger.Templates.TRANSFORM_TOLD_CYCLES, nSynonyms);
            this.replaceAllSynonyms();
        }
    }

    public Concept checkToldCycle(Concept _p) {
        assert (_p != null);
        Concept p = ClassifiableEntry.resolveSynonym(_p);
        if (p.isTop()) {
            return null;
        }
        if (this.conceptInProcess.contains(p)) {
            return p;
        }
        if (p.isRelevant(this.relevance)) {
            return null;
        }
        Concept ret = null;
        this.conceptInProcess.add(p);
        boolean redo = false;
        block0: while (!redo) {
            redo = true;
            for (ClassifiableEntry r : p.getToldSubsumers()) {
                ret = this.checkToldCycle((Concept)r);
                if (ret == null) continue;
                if (ret.equals(p)) {
                    this.toldSynonyms.add(p);
                    for (Concept q : this.toldSynonyms) {
                        if (!q.isSingleton()) continue;
                        p = q;
                    }
                    HashSet<DLTree> leaves = new HashSet<DLTree>();
                    for (Concept q : this.toldSynonyms) {
                        if (q == p) continue;
                        DLTree d = this.makeNonPrimitive(q, this.getTree(p));
                        if (d.isBOTTOM()) {
                            leaves.clear();
                            leaves.add(d);
                            break;
                        }
                        leaves.add(d);
                    }
                    this.toldSynonyms.clear();
                    p.setPrimitive();
                    p.addLeaves(leaves);
                    p.removeSelfFromDescription();
                    if (!ret.equals(p)) {
                        this.conceptInProcess.remove(ret);
                        this.conceptInProcess.add(p);
                        ret.setRelevant(this.relevance);
                        p.dropRelevant(this.relevance);
                    }
                    ret = null;
                    redo = false;
                    continue block0;
                }
                this.toldSynonyms.add(p);
                redo = true;
                continue block0;
            }
        }
        this.conceptInProcess.remove(p);
        p.setRelevant(this.relevance);
        return ret;
    }

    public void transformSingletonHierarchy() {
        boolean changed;
        int nSynonyms = this.countSynonyms();
        do {
            changed = false;
            for (Individual pi : this.individuals.getList()) {
                if (pi.isSynonym() || !pi.isHasSP()) continue;
                Individual i = this.transformSingletonWithSP(pi);
                i.removeSelfFromDescription();
                changed = true;
            }
        } while (changed);
        nSynonyms = this.countSynonyms() - nSynonyms;
        if (nSynonyms > 0) {
            this.replaceAllSynonyms();
        }
    }

    public Individual getSPForConcept(Concept p) {
        for (ClassifiableEntry r : p.getToldSubsumers()) {
            Concept i = (Concept)r;
            if (i.isSingleton()) {
                return (Individual)i;
            }
            if (!i.isHasSP()) continue;
            return this.transformSingletonWithSP(i);
        }
        throw new UnreachableSituationException();
    }

    private Individual transformSingletonWithSP(Concept p) {
        Individual i = this.getSPForConcept(p);
        if (p.isSingleton()) {
            i.addRelated((Individual)p);
        }
        this.addSubsumeAxiom(i, this.makeNonPrimitive(p, this.getTree(i)));
        return i;
    }

    public void determineSorts() {
    }

    public void calculateStatistic() {
        Concept n;
        int npFull = 0;
        int nsFull = 0;
        int nPC = 0;
        int nNC = 0;
        int nSing = 0;
        int nNoTold = 0;
        for (Concept pc : this.concepts.getList()) {
            n = pc;
            if (!Helper.isValid(n.getpName())) continue;
            if (n.isPrimitive()) {
                ++nPC;
            } else if (n.isNonPrimitive()) {
                ++nNC;
            }
            if (n.isSynonym()) {
                ++nsFull;
            }
            if (n.isCompletelyDefined()) {
                if (!n.isPrimitive()) continue;
                ++npFull;
                continue;
            }
            if (n.hasToldSubsumers()) continue;
            ++nNoTold;
        }
        for (Individual pi : this.individuals.getList()) {
            n = pi;
            if (!Helper.isValid(n.getpName())) continue;
            ++nSing;
            if (n.isPrimitive()) {
                ++nPC;
            } else if (n.isNonPrimitive()) {
                ++nNC;
            }
            if (n.isSynonym()) {
                ++nsFull;
            }
            if (n.isCompletelyDefined()) {
                if (!n.isPrimitive()) continue;
                ++npFull;
                continue;
            }
            if (n.hasToldSubsumers()) continue;
            ++nNoTold;
        }
    }

    public void removeExtraDescriptions() {
        for (Concept pc : this.concepts.getList()) {
            pc.removeDescription();
        }
        for (Individual pi : this.individuals.getList()) {
            pi.removeDescription();
        }
    }

    public void setToDoPriorities() {
        this.stdReasoner.initToDoPriorities(this.pOptions);
        if (this.nomReasoner != null) {
            this.nomReasoner.initToDoPriorities(this.pOptions);
        }
    }

    public boolean isBlockedInd(Concept C) {
        return this.sameIndividuals.containsKey(C);
    }

    public Individual getBlockingInd(Concept C) {
        return (Individual)this.sameIndividuals.get((Object)C).first;
    }

    public boolean isBlockingDet(Concept C) {
        return (Boolean)this.sameIndividuals.get((Object)C).second;
    }

    private void initConstCache(int p) {
        this.dlHeap.setCache(p, ModelCacheConst.createConstCache(p));
    }

    private void initSingletonCache(Concept p, boolean pos) {
        this.dlHeap.setCache(Helper.createBiPointer(p.getpName(), pos), new ModelCacheSingleton(Helper.createBiPointer(p.index(), pos)));
    }

    public ModelCacheInterface initCache(Concept pConcept, boolean sub) {
        int bp = sub ? -pConcept.getpName() : pConcept.getpName();
        ModelCacheInterface cache = this.dlHeap.getCache(bp);
        if (cache == null) {
            if (sub) {
                this.prepareFeatures(null, pConcept);
            } else {
                this.prepareFeatures(pConcept, null);
            }
            cache = this.getReasoner().createCache(bp, FastSetFactory.create());
            this.clearFeatures();
        }
        return cache;
    }

    public ModelCacheState testCachedNonSubsumption(Concept p, Concept q) {
        ModelCacheInterface pCache = this.initCache(p, false);
        ModelCacheInterface nCache = this.initCache(q, true);
        return pCache.canMerge(nCache);
    }

    public void initReasoner() {
        if (this.stdReasoner == null) {
            assert (this.nomReasoner == null);
            this.stdReasoner = new DlSatTester(this, this.pOptions);
            this.stdReasoner.setTestTimeout(this.testTimeout);
            if (this.nominalCloudFeatures.hasSingletons()) {
                this.nomReasoner = new NominalReasoner(this, this.pOptions);
                this.nomReasoner.setTestTimeout(this.testTimeout);
            }
        }
    }

    private final void setRelevant(int _p) {
        FastSet done = FastSetFactory.create();
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(_p);
        block8: while (queue.size() > 0) {
            int p = (Integer)queue.remove(0);
            if (done.contains(p)) continue;
            done.add(p);
            assert (Helper.isValid(p));
            if (p == 1 || p == -1) continue;
            DLVertex v = this.realSetRelevant(p);
            DagTag type = v.getType();
            switch (type) {
                case dtDataType: 
                case dtDataValue: 
                case dtDataExpr: 
                case dtNN: {
                    break;
                }
                case dtPConcept: 
                case dtNConcept: 
                case dtPSingleton: 
                case dtNSingleton: {
                    Concept concept = (Concept)v.getConcept();
                    if (concept.isRelevant(this.relevance)) continue block8;
                    ++this.nRelevantCCalls;
                    concept.setRelevant(this.relevance);
                    this.collectLogicFeature(concept);
                    queue.add(concept.getpBody());
                    break;
                }
                case dtForall: 
                case dtLE: {
                    Role _role = v.getRole();
                    LinkedList<Role> rolesToExplore = new LinkedList<Role>();
                    rolesToExplore.add(_role);
                    while (rolesToExplore.size() > 0) {
                        Role roleToExplore = (Role)rolesToExplore.remove(0);
                        if (roleToExplore.getId() == 0 && !roleToExplore.isTop() || roleToExplore.isRelevant(this.relevance)) continue;
                        roleToExplore.setRelevant(this.relevance);
                        this.collectLogicFeature(roleToExplore);
                        queue.add(roleToExplore.getBPDomain());
                        queue.add(roleToExplore.getBPRange());
                        rolesToExplore.addAll(roleToExplore.getAncestor());
                    }
                    queue.add(v.getConceptIndex());
                    break;
                }
                case dtProj: 
                case dtChoose: {
                    queue.add(v.getConceptIndex());
                    break;
                }
                case dtIrr: {
                    Role _role = v.getRole();
                    LinkedList<Role> rolesToExplore = new LinkedList<Role>();
                    rolesToExplore.add(_role);
                    while (rolesToExplore.size() > 0) {
                        Role roleToExplore = (Role)rolesToExplore.remove(0);
                        if (roleToExplore.getId() == 0 || roleToExplore.isRelevant(this.relevance)) continue;
                        roleToExplore.setRelevant(this.relevance);
                        this.collectLogicFeature(roleToExplore);
                        queue.add(roleToExplore.getBPDomain());
                        queue.add(roleToExplore.getBPRange());
                        rolesToExplore.addAll(roleToExplore.getAncestor());
                    }
                    continue block8;
                }
                case dtCollection: 
                case dtAnd: 
                case dtSplitConcept: {
                    for (int q : v.begin()) {
                        queue.add(q);
                    }
                    continue block8;
                }
                default: {
                    throw new ReasonerInternalException("Error setting relevant vertex of type " + (Object)((Object)type));
                }
            }
        }
    }

    private DLVertex realSetRelevant(int p) {
        DLVertex v = this.dlHeap.get(p);
        boolean pos = p > 0;
        ++this.nRelevantBCalls;
        this.collectLogicFeature(v, pos);
        return v;
    }

    private void gatherRelevanceInfo() {
        this.nRelevantCCalls = 0L;
        this.nRelevantBCalls = 0L;
        int bSize = 0;
        this.curFeature = this.GCIFeatures;
        this.markGCIsRelevant();
        this.clearRelevanceInfo();
        this.KBFeatures.or(this.GCIFeatures);
        this.nominalCloudFeatures = new LogicFeatures(this.GCIFeatures);
        for (Individual pi : this.individuals.getList()) {
            this.setConceptRelevant(pi);
            this.nominalCloudFeatures.or(pi.getPosFeatures());
        }
        if (this.nominalCloudFeatures.hasSomeAll() && !this.relatedIndividuals.isEmpty()) {
            this.nominalCloudFeatures.setInverseRoles();
        }
        for (Concept pc : this.concepts.getList()) {
            this.setConceptRelevant(pc);
        }
        bSize = this.dlHeap.size() - 2;
        this.curFeature = null;
        double bRatio = 0.0;
        double sqBSize = 1.0;
        if (bSize > 20) {
            bRatio = (float)this.nRelevantBCalls / (float)bSize;
            sqBSize = Math.sqrt(bSize);
        }
        boolean bl = this.isLikeGALEN = bRatio > sqBSize * 20.0 && bRatio < (double)bSize;
        if (this.KBFeatures.hasTopRole()) {
            this.useSortedReasoning = false;
        }
    }

    public void printFeatures() {
        this.KBFeatures.writeState();
        LeveLogger.logger.print("KB contains " + (this.GCIs.isGCI() ? "" : "NO ") + "GCIs\nKB contains " + (this.GCIs.isReflexive() ? "" : "NO ") + "reflexive roles\nKB contains " + (this.GCIs.isRnD() ? "" : "NO ") + "range and domain restrictions\n");
    }

    public List<List<Individual>> getDifferent() {
        return this.differentIndividuals;
    }

    public List<Related> getRelatedI() {
        return this.relatedIndividuals;
    }

    public DLDag getDLHeap() {
        return this.dlHeap;
    }

    public KBFlags getGCIs() {
        return this.GCIs;
    }

    public Concept replaceForall(DLTree RC) {
        if (this.forall_R_C_Cache.containsKey(RC)) {
            return this.forall_R_C_Cache.get(RC);
        }
        Concept X = this.getAuxConcept(null);
        DLTree C = DLTreeFactory.createSNFNot(RC.getRight().copy());
        this.addSubsumeAxiom(C, DLTreeFactory.createSNFForall(DLTreeFactory.createInverse(RC.getLeft().copy()), this.getTree(X)));
        this.forall_R_C_Cache.put(RC, X);
        return X;
    }

    public AtomicBoolean isCancelled() {
        return this.interrupted;
    }

    TSplitVars getSplits() {
        return this.getTaxonomy().getSplits();
    }

    static final class SimpleRule {
        private final List<Concept> simpleRuleBody = new ArrayList<Concept>();
        protected final DLTree tHead;
        private int bpHead;

        public SimpleRule(List<Concept> body, DLTree head) {
            this.simpleRuleBody.addAll(body);
            this.tHead = head;
            this.setBpHead(0);
        }

        public boolean applicable(DlSatTester Reasoner) {
            return Reasoner.applicable(this);
        }

        public List<Concept> getBody() {
            return this.simpleRuleBody;
        }

        public void setBpHead(int bpHead) {
            this.bpHead = bpHead;
        }

        public int getBpHead() {
            return this.bpHead;
        }
    }

    protected static final class ConceptCreator
    implements NameCreator<Concept> {
        protected ConceptCreator() {
        }

        @Override
        public Concept makeEntry(String name) {
            return new Concept(name);
        }
    }

    protected static final class IndividualCreator
    implements NameCreator<Individual> {
        protected IndividualCreator() {
        }

        @Override
        public Individual makeEntry(String name) {
            return new Individual(name);
        }
    }
}

