/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.actors.Actor;
import uk.ac.manchester.cs.jfact.kernel.actors.SupConceptActor;

public class Taxonomy {
    private final List<TaxonomyVertex> graph = new ArrayList<TaxonomyVertex>();
    List<ClassifiableEntry> Syns = new ArrayList<ClassifiableEntry>();
    protected TaxonomyVertex current;
    protected ClassifiableEntry curEntry = null;
    protected int nEntries = 0;
    protected long nCDEntries = 0L;
    protected boolean useCompletelyDefined = false;
    protected boolean willInsertIntoTaxonomy = true;
    private final LinkedList<ClassifiableEntry> waitStack = new LinkedList();
    protected final LinkedList<KnownSubsumers> ksStack = new LinkedList();
    protected long checkLabel = 1L;
    protected long valueLabel = 1L;

    public boolean getRelativesInfo(TaxonomyVertex node, SupConceptActor actor, boolean needCurrent, boolean onlyDirect, boolean upDirection) {
        if (needCurrent) {
            if (!actor.apply(node)) {
                return false;
            }
            if (onlyDirect) {
                return true;
            }
        }
        LinkedList<List<TaxonomyVertex>> queue = new LinkedList<List<TaxonomyVertex>>();
        queue.add(node.neigh(upDirection));
        while (queue.size() > 0) {
            List neigh = (List)queue.remove();
            int size = neigh.size();
            for (int i = 0; i < size; ++i) {
                TaxonomyVertex _node = (TaxonomyVertex)neigh.get(i);
                if (_node.isChecked(this.checkLabel)) continue;
                _node.setChecked(this.checkLabel);
                if (!actor.apply(_node)) {
                    return false;
                }
                if (onlyDirect) continue;
                queue.add(_node.neigh(upDirection));
            }
        }
        this.clearCheckedLabel();
        return true;
    }

    public void getRelativesInfo(TaxonomyVertex node, Actor actor, boolean needCurrent, boolean onlyDirect, boolean upDirection) {
        if (needCurrent && actor.apply(node) && onlyDirect) {
            return;
        }
        LinkedList<List<TaxonomyVertex>> queue = new LinkedList<List<TaxonomyVertex>>();
        queue.add(node.neigh(upDirection));
        while (queue.size() > 0) {
            List neigh = (List)queue.remove();
            int size = neigh.size();
            for (int i = 0; i < size; ++i) {
                TaxonomyVertex _node = (TaxonomyVertex)neigh.get(i);
                if (_node.isChecked(this.checkLabel)) continue;
                _node.setChecked(this.checkLabel);
                if (actor.apply(_node) && onlyDirect) continue;
                queue.add(_node.neigh(upDirection));
            }
        }
        this.clearCheckedLabel();
    }

    protected final void clearCheckedLabel() {
        ++this.checkLabel;
    }

    protected void clearLabels() {
        ++this.checkLabel;
        ++this.valueLabel;
    }

    protected void setCurrentEntry(ClassifiableEntry p) {
        this.current.clear();
        this.curEntry = p;
    }

    protected boolean immediatelyClassified() {
        return this.classifySynonym();
    }

    protected boolean needTopDown() {
        return false;
    }

    protected void runTopDown() {
    }

    protected boolean needBottomUp() {
        return false;
    }

    protected void runBottomUp() {
    }

    protected void preClassificationActions() {
    }

    private void addTop(ClassifiableEntry p) {
        this.waitStack.push(p);
        this.ksStack.push(new ToldSubsumers(p.getToldSubsumers()));
    }

    protected void removeTop() {
        this.waitStack.pop();
        this.ksStack.pop();
    }

    protected boolean needLogging() {
        return true;
    }

    public Taxonomy(ClassifiableEntry pTop, ClassifiableEntry pBottom) {
        this.current = new TaxonomyVertex();
        this.graph.add(new TaxonomyVertex(pBottom));
        this.graph.add(new TaxonomyVertex(pTop));
    }

    public TaxonomyVertex getTopVertex() {
        return this.graph.get(1);
    }

    public TaxonomyVertex getBottomVertex() {
        return this.graph.get(0);
    }

    public void setCompletelyDefined(boolean use) {
        this.useCompletelyDefined = use;
    }

    public void finalise() {
        boolean upDirection = false;
        for (int i = 1; i < this.graph.size(); ++i) {
            TaxonomyVertex p = this.graph.get(i);
            if (!p.noNeighbours(false)) continue;
            p.addNeighbour(false, this.getBottomVertex());
            this.getBottomVertex().addNeighbour(true, p);
        }
        this.willInsertIntoTaxonomy = false;
    }

    private void setupTopDown() {
        this.setToldSubsumers();
        if (!this.needTopDown()) {
            ++this.nCDEntries;
            this.setNonRedundantCandidates();
        }
    }

    public void print(LeveLogger.LogAdapter o) {
        o.print(String.format("Taxonomy consists of %s entries\n            of which %s are completely defined\n\nAll entries are in format:\n\"entry\" {n: parent_1 ... parent_n} {m: child_1 child_m}\n\n", this.nEntries, this.nCDEntries));
        TreeSet<TaxonomyVertex> sorted = new TreeSet<TaxonomyVertex>(new Comparator<TaxonomyVertex>(){

            @Override
            public int compare(TaxonomyVertex o1, TaxonomyVertex o2) {
                return o1.getPrimer().getName().compareTo(o2.getPrimer().getName());
            }
        });
        sorted.addAll(this.graph.subList(1, this.graph.size()));
        for (TaxonomyVertex p : sorted) {
            p.print(o);
        }
        this.getBottomVertex().print(o);
    }

    public String toString() {
        LeveLogger.LogAdapterStringBuilder l = new LeveLogger.LogAdapterStringBuilder();
        this.print(l);
        return ((Object)l).toString();
    }

    public void insertCurrent(TaxonomyVertex syn) {
        if (this.willInsertIntoTaxonomy) {
            if (syn != null) {
                syn.addSynonym(this.curEntry);
            } else {
                this.current.incorporate(this.curEntry);
                this.graph.add(this.current);
                this.current = new TaxonomyVertex();
            }
        } else if (syn != null) {
            this.curEntry.setTaxVertex(syn);
        } else {
            this.current.setSample(this.curEntry);
        }
    }

    void removeNode(TaxonomyVertex node) {
        this.graph.remove(node);
    }

    boolean isDirectParent(TaxonomyVertex v) {
        for (TaxonomyVertex q : v.neigh(false)) {
            if (!q.isValued(this.valueLabel) || !q.getValue()) continue;
            return false;
        }
        return true;
    }

    private void performClassification() {
        this.preClassificationActions();
        ++this.nEntries;
        LeveLogger.logger.print("\n\nTAX: start classifying entry ");
        LeveLogger.logger.print(this.curEntry.getName());
        if (this.immediatelyClassified()) {
            return;
        }
        this.generalTwoPhaseClassification();
        this.insertCurrent(this.current.isSynonymNode());
        this.clearLabels();
    }

    private void generalTwoPhaseClassification() {
        this.setupTopDown();
        if (this.needTopDown()) {
            this.getTopVertex().setValued(true, this.valueLabel);
            this.getBottomVertex().setValued(false, this.valueLabel);
            this.runTopDown();
        }
        this.clearLabels();
        if (this.needBottomUp()) {
            this.getBottomVertex().setValued(true, this.valueLabel);
            this.runBottomUp();
        }
        this.clearLabels();
    }

    protected boolean classifySynonym() {
        ClassifiableEntry syn = ClassifiableEntry.resolveSynonym(this.curEntry);
        if (syn.equals(this.curEntry)) {
            return false;
        }
        assert (this.willInsertIntoTaxonomy);
        assert (syn.getTaxVertex() != null);
        this.insertCurrent(syn.getTaxVertex());
        return true;
    }

    private void setNonRedundantCandidates() {
        if (!this.curEntry.hasToldSubsumers()) {
            LeveLogger.logger.print("\nTAX: TOP");
        }
        LeveLogger.logger.print(" completely defines concept ");
        LeveLogger.logger.print(this.curEntry.getName());
        for (ClassifiableEntry p : this.ksStack.peek().s_begin()) {
            TaxonomyVertex par = p.getTaxVertex();
            if (par == null || !this.isDirectParent(par)) continue;
            this.current.addNeighbour(true, par);
        }
    }

    private void setToldSubsumers() {
        List<ClassifiableEntry> top = this.ksStack.peek().s_begin();
        if (this.needLogging() && !top.isEmpty()) {
            LeveLogger.logger.print("\nTAX: told subsumers");
        }
        for (ClassifiableEntry p : top) {
            if (!p.isClassified()) continue;
            if (this.needLogging()) {
                LeveLogger.logger.print(LeveLogger.Templates.TOLD_SUBSUMERS, p.getName());
            }
            this.propagateTrueUp(p.getTaxVertex());
        }
    }

    ClassifiableEntry prepareTS(ClassifiableEntry cur) {
        if (this.waitStack.contains(cur)) {
            return cur;
        }
        this.addTop(cur);
        boolean cycleFound = false;
        for (ClassifiableEntry p : this.ksStack.peek().s_begin()) {
            ClassifiableEntry v;
            if (p.isClassified() || p.isNonClassifiable() || (v = this.prepareTS(p)) == null) continue;
            if (v == cur) {
                cycleFound = true;
                continue;
            }
            this.Syns.add(cur);
            this.removeTop();
            return v;
        }
        this.classifyTop();
        if (cycleFound) {
            TaxonomyVertex syn = cur.getTaxVertex();
            for (ClassifiableEntry q : this.Syns) {
                syn.addSynonym(q);
            }
            this.Syns.clear();
        }
        return null;
    }

    public void classifyEntry(ClassifiableEntry p) {
        assert (this.waitStack.isEmpty());
        if (p.isNonClassifiable()) {
            return;
        }
        this.prepareTS(p);
    }

    private boolean checkToldSubsumers() {
        assert (!this.waitStack.isEmpty());
        boolean ret = true;
        for (ClassifiableEntry r : this.ksStack.peek().s_begin()) {
            assert (r != null);
            if (r.isClassified()) continue;
            if (this.waitStack.contains(r)) {
                this.addTop(r);
                ret = false;
                break;
            }
            this.addTop(r);
            ret = this.checkToldSubsumers();
            break;
        }
        return ret;
    }

    private void classifyTop() {
        assert (!this.waitStack.isEmpty());
        this.setCurrentEntry(this.waitStack.peek());
        this.performClassification();
        this.removeTop();
    }

    private void classifyCycle() {
        assert (!this.waitStack.isEmpty());
        ClassifiableEntry p = this.waitStack.peek();
        this.classifyTop();
        StringBuilder b = new StringBuilder("\n* Concept definitions cycle found: ");
        b.append(p.getName());
        b.append('\n');
        while (!this.waitStack.isEmpty()) {
            b.append(", ");
            b.append(this.waitStack.peek().getName());
            b.append('\n');
            this.waitStack.peek().setTaxVertex(p.getTaxVertex());
            this.removeTop();
        }
        throw new ReasonerInternalException(b.toString());
    }

    protected void propagateTrueUp(TaxonomyVertex node) {
        if (node.isValued(this.valueLabel)) {
            assert (node.getValue());
            return;
        }
        node.setValued(true, this.valueLabel);
        List<TaxonomyVertex> list = node.neigh(true);
        for (int i = 0; i < list.size(); ++i) {
            this.propagateTrueUp(list.get(i));
        }
    }

    class ToldSubsumers
    extends KnownSubsumers {
        List<ClassifiableEntry> beg;

        public ToldSubsumers(Collection<ClassifiableEntry> b) {
            this.beg = new ArrayList<ClassifiableEntry>(b);
        }

        @Override
        List<ClassifiableEntry> s_begin() {
            return this.beg;
        }

        @Override
        List<ClassifiableEntry> p_begin() {
            return Collections.emptyList();
        }
    }

    abstract class KnownSubsumers {
        KnownSubsumers() {
        }

        abstract List<ClassifiableEntry> s_begin();

        abstract List<ClassifiableEntry> p_begin();

        boolean s_empty() {
            return this.s_begin().isEmpty();
        }

        boolean p_empty() {
            return this.p_begin().isEmpty();
        }

        boolean isPossibleSub(ClassifiableEntry ce) {
            return true;
        }
    }
}

