/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;

public final class TaxonomyVertex {
    private final List<TaxonomyVertex> linksParent = new ArrayList<TaxonomyVertex>();
    private final List<TaxonomyVertex> linksChild = new ArrayList<TaxonomyVertex>();
    private ClassifiableEntry sample = null;
    private final Set<ClassifiableEntry> synonyms = new LinkedHashSet<ClassifiableEntry>();
    private long checked;
    private long isValued;
    private int common;
    private boolean checkValue;

    public void setSample(ClassifiableEntry entry) {
        this.sample = entry;
        entry.setTaxVertex(this);
    }

    public List<TaxonomyVertex> neigh(boolean upDirection) {
        return upDirection ? this.linksParent : this.linksChild;
    }

    public boolean isChecked(long checkLab) {
        return checkLab == this.checked;
    }

    public void setChecked(long checkLab) {
        this.checked = checkLab;
    }

    public boolean isValued(long valueLab) {
        return valueLab == this.isValued;
    }

    public boolean getValue() {
        return this.checkValue;
    }

    public boolean setValued(boolean val, long valueLab) {
        this.isValued = valueLab;
        this.checkValue = val;
        return val;
    }

    public boolean isCommon() {
        return this.common != 0;
    }

    public void setCommon() {
        ++this.common;
    }

    public void clearCommon() {
        this.common = 0;
    }

    public boolean correctCommon(int n) {
        if (this.common == n) {
            return true;
        }
        this.common = 0;
        return false;
    }

    private void initFlags() {
        this.checked = 0L;
        this.isValued = 0L;
        this.common = 0;
    }

    public Set<ClassifiableEntry> begin_syn() {
        return this.synonyms;
    }

    public TaxonomyVertex() {
        this.initFlags();
    }

    public TaxonomyVertex(ClassifiableEntry p) {
        this.initFlags();
        this.setSample(p);
    }

    public void addSynonym(ClassifiableEntry p) {
        this.synonyms.add(p);
        p.setTaxVertex(this);
    }

    public void clear() {
        this.linksParent.clear();
        this.linksChild.clear();
        this.sample = null;
        this.initFlags();
    }

    public ClassifiableEntry getPrimer() {
        return this.sample;
    }

    public void addNeighbour(boolean upDirection, TaxonomyVertex p) {
        if (p == null) {
            System.out.println("TaxonomyVertex.addNeighbour() passed in a null");
        }
        this.neigh(upDirection).add(p);
    }

    public boolean noNeighbours(boolean upDirection) {
        return this.neigh(upDirection).isEmpty();
    }

    public TaxonomyVertex isSynonymNode() {
        for (TaxonomyVertex q : this.neigh(true)) {
            for (TaxonomyVertex r : this.neigh(false)) {
                if (!q.equals(r)) continue;
                return q;
            }
        }
        return null;
    }

    public void removeLastLink(boolean upDirection) {
        Helper.resize(this.neigh(upDirection), this.neigh(upDirection).size() - 1);
    }

    public void clearLinks(boolean upDirection) {
        this.neigh(upDirection).clear();
    }

    public void print(LeveLogger.LogAdapter o) {
        this.printSynonyms(o);
        this.printNeighbours(o, true);
        this.printNeighbours(o, false);
        o.println();
    }

    public boolean removeLink(boolean upDirection, TaxonomyVertex p) {
        List<TaxonomyVertex> begin = this.neigh(upDirection);
        int index = begin.indexOf(p);
        if (index > -1) {
            begin.set(index, begin.get(begin.size() - 1));
            this.removeLastLink(upDirection);
            return true;
        }
        return false;
    }

    public void incorporate(ClassifiableEntry entry) {
        this.setSample(entry);
        ArrayList<TaxonomyVertex> falselist = new ArrayList<TaxonomyVertex>(this.neigh(false));
        ArrayList<TaxonomyVertex> truelist = new ArrayList<TaxonomyVertex>(this.neigh(true));
        for (TaxonomyVertex d : falselist) {
            for (TaxonomyVertex u : truelist) {
                if (!d.removeLink(true, u)) continue;
                u.removeLink(false, d);
            }
            d.addNeighbour(true, this);
        }
        for (TaxonomyVertex u : truelist) {
            u.addNeighbour(false, this);
        }
    }

    void mergeIndepNode(TaxonomyVertex node, Set<TaxonomyVertex> excludes, ClassifiableEntry curEntry) {
        if (!node.getPrimer().equals(curEntry)) {
            this.addSynonym(node.getPrimer());
        }
        for (ClassifiableEntry q : node.begin_syn()) {
            this.addSynonym(q);
        }
        boolean upDirection = true;
        for (TaxonomyVertex p : node.neigh(upDirection)) {
            if (!excludes.contains(p)) {
                this.addNeighbour(upDirection, p);
            }
            p.removeLink(!upDirection, node);
        }
        upDirection = false;
        for (TaxonomyVertex p : node.neigh(upDirection)) {
            if (!excludes.contains(p)) {
                this.addNeighbour(upDirection, p);
            }
            p.removeLink(!upDirection, node);
        }
    }

    public void printSynonyms(LeveLogger.LogAdapter o) {
        assert (this.sample != null);
        if (this.synonyms.isEmpty()) {
            o.print(String.format("\"%s\"", this.sample.getName()));
        } else {
            o.print("(\"");
            o.print(this.sample.getName());
            for (ClassifiableEntry q : this.begin_syn()) {
                o.print("\"=\"");
                o.print(q.getName());
            }
            o.print("\")");
        }
    }

    public void printNeighbours(LeveLogger.LogAdapter o, boolean upDirection) {
        o.print(String.format(" {%s:", this.neigh(upDirection).size()));
        TreeSet<TaxonomyVertex> sorted = new TreeSet<TaxonomyVertex>(new Comparator<TaxonomyVertex>(){

            @Override
            public int compare(TaxonomyVertex o1, TaxonomyVertex o2) {
                return o1.getPrimer().getName().compareTo(o2.getPrimer().getName());
            }
        });
        sorted.addAll(this.neigh(upDirection));
        for (TaxonomyVertex p : sorted) {
            o.print(String.format(" \"%s\"", p.sample.getName()));
        }
        o.print("}");
    }

    public String toString() {
        LeveLogger.LogAdapterStringBuilder l = new LeveLogger.LogAdapterStringBuilder();
        this.print(l);
        return ((Object)l).toString();
    }
}

