/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.manchester.cs.jfact.dep.DepSetFactory;
import uk.ac.manchester.cs.jfact.helpers.FastSetSimple;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.SaveStack;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.IFOptionSet;
import uk.ac.manchester.cs.jfact.kernel.ToDoPriorMatrix;

public final class ToDoList {
    static final int limit = 1000;
    protected final TODOListSaveState[] states = new TODOListSaveState[1000];
    protected int nextState = 0;
    volatile boolean change = true;
    private boolean saveStateGenerationStarted = false;
    private ArrayQueue queueID = new ArrayQueue();
    private QueueQueue queueNN = new QueueQueue();
    private List<ArrayQueue> waitQueue = new ArrayList<ArrayQueue>(7);
    private SaveStack<TODOListSaveState> saveStack = new SaveStack();
    private ToDoPriorMatrix matrix = new ToDoPriorMatrix();
    private int noe = 0;

    public final TODOListSaveState getInstance() {
        TODOListSaveState toReturn;
        if (this.nextState == 1000) {
            this.nextState = 0;
        }
        if ((toReturn = this.states[this.nextState]) != null) {
            this.states[this.nextState++] = null;
            this.change = true;
            return toReturn;
        }
        if (!this.isSaveStateGenerationStarted()) {
            this.startSaveStateGeneration();
        }
        return new TODOListSaveState();
    }

    public final boolean isSaveStateGenerationStarted() {
        return this.saveStateGenerationStarted;
    }

    public void startSaveStateGeneration() {
        this.saveStateGenerationStarted = true;
        Thread stateFiller = new Thread(){

            @Override
            public void run() {
                long last = System.currentTimeMillis();
                while (System.currentTimeMillis() - last < 60000L) {
                    for (int wait = 0; wait < 10000; ++wait) {
                        if (ToDoList.this.change) {
                            for (int i = 0; i < 1000; ++i) {
                                if (ToDoList.this.states[i] != null) continue;
                                ToDoList.this.states[i] = new TODOListSaveState();
                            }
                            ToDoList.this.change = false;
                            last = System.currentTimeMillis();
                        }
                        try {
                            Thread.sleep(5L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ToDoList.this.saveStateGenerationStarted = false;
            }
        };
        stateFiller.setPriority(1);
        stateFiller.setDaemon(true);
        stateFiller.start();
    }

    public void saveState(TODOListSaveState tss) {
        tss.backupID_sp = this.queueID.sPointer;
        tss.backupID_ep = this.queueID.Wait.size();
        this.queueNN.save(tss.backupNN);
        for (int i = 6; i >= 0; --i) {
            this.waitQueue.get(i).save(tss.backup, i);
        }
        tss.noe = this.noe;
    }

    public void restoreState(TODOListSaveState tss) {
        this.queueID.restore(tss.backupID_sp, tss.backupID_ep);
        this.queueNN.restore(tss.backupNN);
        for (int i = 6; i >= 0; --i) {
            this.waitQueue.get(i).restore(tss.backup[i][0], tss.backup[i][1]);
        }
        this.noe = tss.noe;
    }

    public ToDoList() {
        for (int i = 0; i < 7; ++i) {
            this.waitQueue.add(new ArrayQueue());
        }
    }

    public void initPriorities(IFOptionSet Options, String optionName) {
        this.matrix.initPriorities(Options.getText(optionName), optionName);
    }

    public void clear() {
        this.queueID.clear();
        this.queueNN.clear();
        for (int i = 6; i >= 0; --i) {
            this.waitQueue.get(i).clear();
        }
        this.saveStack.clear();
        this.noe = 0;
    }

    public boolean isEmpty() {
        return this.noe == 0;
    }

    public void addEntry(DlCompletionTree node, DagTag type, ConceptWDep C) {
        int index = this.matrix.getIndex(type, C.getConcept() > 0, node.isNominalNode());
        switch (index) {
            case 7: {
                return;
            }
            case 8: {
                this.queueID.add(node, C);
                break;
            }
            case 9: {
                this.queueNN.add(node, C);
                break;
            }
            default: {
                this.waitQueue.get(index).add(node, C);
            }
        }
        ++this.noe;
    }

    public void save() {
        TODOListSaveState state = this.getInstance();
        this.saveState(state);
        this.saveStack.push(state);
    }

    public void restore(int level) {
        this.restoreState(this.saveStack.pop(level));
    }

    public ToDoEntry getNextEntry() {
        assert (!this.isEmpty());
        --this.noe;
        if (!this.queueID.isEmpty()) {
            return this.queueID.get();
        }
        if (!this.queueNN.isEmpty()) {
            return this.queueNN.get();
        }
        for (int i = 0; i < 7; ++i) {
            ArrayQueue arrayQueue = this.waitQueue.get(i);
            if (arrayQueue.isEmpty()) continue;
            return arrayQueue.get();
        }
        return null;
    }

    public void print(LeveLogger.LogAdapter lL) {
        lL.print("Todolist{");
        lL.println();
        this.queueID.print(lL);
        lL.println();
        for (int i = 0; i < 7; ++i) {
            this.waitQueue.get(i).print(lL);
            lL.println();
        }
        lL.println();
        lL.print("}");
    }

    static final class TODOListSaveState {
        protected int backupID_sp;
        protected int backupID_ep;
        protected final QueueQueueSaveState backupNN = new QueueQueueSaveState();
        protected final int[][] backup = new int[7][2];
        protected int noe;

        TODOListSaveState() {
        }

        public String toString() {
            return "" + this.noe + " " + this.backupID_sp + "," + this.backupID_ep + " " + this.backupNN + " " + Arrays.toString((Object[])this.backup);
        }
    }

    static final class QueueQueue {
        private List<ToDoEntry> _Wait = new ArrayList<ToDoEntry>();
        private int sPointer = 0;
        private boolean queueBroken = false;
        int size = 0;

        QueueQueue() {
        }

        void add(DlCompletionTree Node2, ConceptWDep offset) {
            int n;
            ToDoEntry e = new ToDoEntry(Node2, offset);
            if (this.isEmpty() || this._Wait.get(this.size - 1).getNode().getNominalLevel() <= Node2.getNominalLevel()) {
                this._Wait.add(e);
                ++this.size;
                return;
            }
            for (n = this.size; n > this.sPointer && this._Wait.get(n - 1).getNode().getNominalLevel() > Node2.getNominalLevel(); --n) {
            }
            this._Wait.add(n, e);
            this.queueBroken = true;
            ++this.size;
        }

        void clear() {
            this.sPointer = 0;
            this.queueBroken = false;
            this._Wait.clear();
            this.size = 0;
        }

        boolean isEmpty() {
            return this.sPointer == this.size;
        }

        final ToDoEntry get() {
            return this._Wait.get(this.sPointer++);
        }

        void save(QueueQueueSaveState tss) {
            tss.queueBroken = this.queueBroken;
            tss.sp = this.sPointer;
            if (this.queueBroken) {
                tss.waitingQueue = new ArrayList<ToDoEntry>(this._Wait);
            } else {
                tss.ep = this.size;
            }
            this.queueBroken = false;
        }

        void restore(QueueQueueSaveState tss) {
            this.queueBroken = tss.queueBroken;
            this.sPointer = tss.sp;
            if (this.queueBroken) {
                this._Wait = tss.waitingQueue;
                this.size = this._Wait.size();
            } else {
                Helper.resize(this._Wait, tss.ep);
                this.size = tss.ep;
            }
        }

        public String toString() {
            return "{" + (!this.isEmpty() ? this._Wait.get(this.sPointer) : "empty") + " sPointer: " + this.sPointer + " size: " + this.size + " Wait: " + this._Wait + "}";
        }
    }

    static final class QueueQueueSaveState {
        protected List<ToDoEntry> waitingQueue;
        protected int sp;
        protected int ep;
        protected boolean queueBroken;

        QueueQueueSaveState() {
        }
    }

    static final class ArrayQueue {
        final List<ToDoEntry> Wait = new ArrayList<ToDoEntry>(50);
        int sPointer = 0;

        ArrayQueue() {
        }

        public void add(DlCompletionTree node, ConceptWDep offset) {
            this.Wait.add(new ToDoEntry(node, offset));
        }

        public void clear() {
            this.sPointer = 0;
            this.Wait.clear();
        }

        public boolean isEmpty() {
            return this.sPointer == this.Wait.size();
        }

        public final ToDoEntry get() {
            return this.Wait.get(this.sPointer++);
        }

        public void save(int[][] tss, int pos) {
            tss[pos][0] = this.sPointer;
            tss[pos][1] = this.Wait.size();
        }

        public void restore(int[][] tss, int pos) {
            this.sPointer = tss[pos][0];
            Helper.resize(this.Wait, tss[pos][1]);
        }

        public void restore(int sp, int ep) {
            this.sPointer = sp;
            Helper.resize(this.Wait, ep);
        }

        public void print(LeveLogger.LogAdapter l) {
            l.print("ArrayQueue{" + this.sPointer + ",");
            for (ToDoEntry t : this.Wait) {
                t.print(l);
                l.print(" ");
            }
            l.print("}");
        }
    }

    public static class ToDoEntry {
        private final DlCompletionTree node;
        private int concept;
        private FastSetSimple delegate;

        ToDoEntry(DlCompletionTree n, ConceptWDep off) {
            this.node = n;
            this.concept = off.getConcept();
            this.delegate = off.getDep().getDelegate();
        }

        protected DlCompletionTree getNode() {
            return this.node;
        }

        protected int getOffsetConcept() {
            return this.concept;
        }

        protected FastSetSimple getOffsetDepSet() {
            return this.delegate;
        }

        public String toString() {
            return "Node(" + this.node.getId() + "), offset(" + new ConceptWDep(this.concept, DepSetFactory.create(this.delegate)) + ")";
        }

        public void print(LeveLogger.LogAdapter l) {
            l.print("Node(" + this.node.getId() + "), offset(");
            new ConceptWDep(this.concept, DepSetFactory.create(this.delegate)).print(l);
            l.print(")");
        }
    }
}

