/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.DagTag;

class ToDoPriorMatrix {
    private int indexAnd;
    private int indexOr;
    private int indexExists;
    private int indexForall;
    private int indexLE;
    private int indexGE;
    protected static final int nRegularOptions = 7;
    protected static final int priorityIndexID = 8;
    protected static final int priorityIndexNominalNode = 9;

    public void initPriorities(String options, String optionName) {
        if (options.length() < 7) {
            throw new ReasonerInternalException("ToDo List option string should have length 7");
        }
        this.indexAnd = options.charAt(1) - 48;
        this.indexOr = options.charAt(2) - 48;
        this.indexExists = options.charAt(3) - 48;
        this.indexForall = options.charAt(4) - 48;
        this.indexLE = options.charAt(5) - 48;
        this.indexGE = options.charAt(6) - 48;
        if (this.indexAnd >= 7 || this.indexOr >= 7 || this.indexExists >= 7 || this.indexForall >= 7 || this.indexGE >= 7 || this.indexLE >= 7) {
            throw new ReasonerInternalException("ToDo List option out of range");
        }
    }

    public int getIndex(DagTag Op, boolean Sign, boolean NominalNode) {
        switch (Op) {
            case dtAnd: {
                return Sign ? this.indexAnd : this.indexOr;
            }
            case dtSplitConcept: {
                return this.indexAnd;
            }
            case dtForall: 
            case dtUAll: 
            case dtIrr: {
                return Sign ? this.indexForall : this.indexExists;
            }
            case dtProj: 
            case dtChoose: {
                return this.indexOr;
            }
            case dtLE: {
                return Sign ? (NominalNode ? 9 : this.indexLE) : this.indexGE;
            }
            case dtDataType: 
            case dtDataValue: 
            case dtDataExpr: 
            case dtNN: 
            case dtTop: {
                return 7;
            }
            case dtPSingleton: 
            case dtPConcept: {
                return Sign ? 8 : 7;
            }
            case dtNSingleton: 
            case dtNConcept: {
                return 8;
            }
        }
        throw new UnreachableSituationException();
    }
}

