/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.actors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.actors.Actor;
import uk.ac.manchester.cs.jfact.kernel.actors.Policy;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public final class TaxonomyActor
implements Actor {
    private final ExpressionManager expressionManager;
    private final List<List<Expression>> acc = new ArrayList<List<Expression>>();
    private final List<Expression> plain = new ArrayList<Expression>();
    private final Policy policy;

    public List<Expression> tryEntry(ClassifiableEntry p) {
        ArrayList<Expression> toReturn = new ArrayList<Expression>();
        if (p.isSystem()) {
            return toReturn;
        }
        if (this.policy.applicable(p)) {
            toReturn.add(this.policy.buildTree(this.expressionManager, p));
        }
        return toReturn;
    }

    public TaxonomyActor(ExpressionManager em, Policy policy) {
        this.expressionManager = em;
        this.policy = policy;
    }

    public Collection<ConceptExpression> getClassSynonyms() {
        ArrayList<ConceptExpression> toReturn = new ArrayList<ConceptExpression>();
        if (!this.acc.isEmpty()) {
            for (Expression e : this.acc.get(0)) {
                toReturn.add((ConceptExpression)e);
            }
        }
        return toReturn;
    }

    public Collection<IndividualExpression> getIndividualSynonyms() {
        ArrayList<IndividualExpression> toReturn = new ArrayList<IndividualExpression>();
        if (!this.acc.isEmpty()) {
            for (Expression e : this.acc.get(0)) {
                toReturn.add((IndividualExpression)e);
            }
        }
        return toReturn;
    }

    public Collection<ObjectRoleExpression> getObjectPropertySynonyms() {
        ArrayList<ObjectRoleExpression> toReturn = new ArrayList<ObjectRoleExpression>();
        if (!this.acc.isEmpty()) {
            for (Expression e : this.acc.get(0)) {
                toReturn.add((ObjectRoleExpression)e);
            }
        }
        return toReturn;
    }

    public Collection<DataRoleExpression> getDataPropertySynonyms() {
        ArrayList<DataRoleExpression> toReturn = new ArrayList<DataRoleExpression>();
        if (!this.acc.isEmpty()) {
            for (Expression e : this.acc.get(0)) {
                toReturn.add((DataRoleExpression)e);
            }
        }
        return toReturn;
    }

    public Collection<IndividualExpression> getPlainIndividualElements() {
        ArrayList<IndividualExpression> toReturn = new ArrayList<IndividualExpression>(this.plain.size());
        for (Expression e : this.plain) {
            toReturn.add((IndividualExpression)e);
        }
        return toReturn;
    }

    public Collection<ConceptExpression> getPlainClassElements() {
        ArrayList<ConceptExpression> toReturn = new ArrayList<ConceptExpression>(this.plain.size());
        for (Expression e : this.plain) {
            toReturn.add((ConceptExpression)e);
        }
        return toReturn;
    }

    public Collection<Collection<ConceptExpression>> getClassElements() {
        ArrayList<Collection<ConceptExpression>> toReturn = new ArrayList<Collection<ConceptExpression>>();
        for (List<Expression> l : this.acc) {
            ArrayList<ConceptExpression> list = new ArrayList<ConceptExpression>();
            for (Expression e : l) {
                list.add((ConceptExpression)e);
            }
            toReturn.add(list);
        }
        return toReturn;
    }

    public Collection<Collection<ObjectRoleExpression>> getObjectPropertyElements() {
        ArrayList<Collection<ObjectRoleExpression>> toReturn = new ArrayList<Collection<ObjectRoleExpression>>();
        for (List<Expression> l : this.acc) {
            ArrayList<ObjectRoleExpression> list = new ArrayList<ObjectRoleExpression>();
            for (Expression e : l) {
                list.add((ObjectRoleExpression)e);
            }
            toReturn.add(list);
        }
        return toReturn;
    }

    public Collection<Collection<DataRoleExpression>> getDataPropertyElements() {
        ArrayList<Collection<DataRoleExpression>> toReturn = new ArrayList<Collection<DataRoleExpression>>();
        for (List<Expression> l : this.acc) {
            ArrayList<DataRoleExpression> list = new ArrayList<DataRoleExpression>();
            for (Expression e : l) {
                list.add((DataRoleExpression)e);
            }
            toReturn.add(list);
        }
        return toReturn;
    }

    public Collection<Collection<IndividualExpression>> getIndividualElements() {
        ArrayList<Collection<IndividualExpression>> toReturn = new ArrayList<Collection<IndividualExpression>>();
        for (List<Expression> l : this.acc) {
            ArrayList<IndividualExpression> list = new ArrayList<IndividualExpression>();
            for (Expression e : l) {
                list.add((IndividualExpression)e);
            }
            toReturn.add(list);
        }
        return toReturn;
    }

    @Override
    public boolean apply(TaxonomyVertex v) {
        List<Expression> syn = this.tryEntry(v.getPrimer());
        for (ClassifiableEntry p : v.begin_syn()) {
            syn.addAll(this.tryEntry(p));
        }
        if (syn.isEmpty()) {
            return false;
        }
        if (this.policy.needPlain()) {
            this.plain.addAll(syn);
        } else {
            this.acc.add(syn);
        }
        return true;
    }
}

