/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataInterval;
import uk.ac.manchester.cs.jfact.kernel.datatype.DatatypeRepresentation;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatyped;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;

public class DataEntry<O>
extends NamedEntry
implements Datatyped {
    private Datatypes type = null;
    private int pName = 0;
    private DatatypeRepresentation<O> comp;
    private final DataInterval<O> constraints = new DataInterval();

    public DataEntry(String name) {
        super(name);
    }

    public boolean isBasicDataType() {
        return this.type == null && this.constraints.isEmpty();
    }

    public boolean isDataValue() {
        return this.type != null && this.constraints.isEmpty();
    }

    public void setHostType(Datatypes t) {
        this.type = t;
        if (this.getName().equals("expr") && this.type != Datatypes.STRING) {
            if (this.type == Datatypes.DATETIME) {
                try {
                    this.comp = this.type.build(DatatypeFactory.newInstance().newXMLGregorianCalendar());
                }
                catch (DatatypeConfigurationException e) {
                    throw new ReasonerInternalException((Throwable)e);
                }
            } else {
                this.initComp("0");
            }
        } else {
            this.initComp();
        }
    }

    public void initComp() {
        if (this.type != null) {
            this.comp = this.type.parse(this.getName());
        }
    }

    public void initComp(String s) {
        if (this.type != null) {
            this.comp = this.type.parse(s);
        }
    }

    public DatatypeRepresentation<O> getComp() {
        return this.comp;
    }

    public Datatypes getType() {
        return this.type;
    }

    @Override
    public Datatypes getDatatype() {
        return this.type;
    }

    public DataInterval<O> getFacet() {
        return this.constraints;
    }

    public int getBP() {
        return this.pName;
    }

    public void setBP(int p) {
        this.pName = p;
    }
}

