/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import uk.ac.manchester.cs.jfact.kernel.datatype.DatatypeRepresentation;

public class DataInterval<O> {
    protected DatatypeRepresentation<O> min;
    protected DatatypeRepresentation<O> max;
    protected boolean minExcl;
    protected boolean maxExcl;

    public DataInterval() {
    }

    public DataInterval(DataInterval<O> copy) {
        this.min = copy.min == null ? null : copy.min.getDatatype().build(copy.min.getValue());
        this.max = copy.max == null ? null : copy.max.getDatatype().build(copy.max.getValue());
        this.minExcl = copy.minExcl;
        this.maxExcl = copy.maxExcl;
    }

    public boolean hasMin() {
        return this.min != null;
    }

    public boolean hasMax() {
        return this.max != null;
    }

    public boolean isEmpty() {
        return !this.hasMin() && !this.hasMax();
    }

    public boolean closed() {
        return this.hasMin() && this.hasMax();
    }

    public boolean updateMin(boolean excl, DatatypeRepresentation<O> value) {
        if (this.hasMin()) {
            if (value.lesser(this.min)) {
                return false;
            }
            if (this.min.equals(value) && this.minExcl && !excl) {
                return false;
            }
        }
        try {
            this.min = value.getDatatype().build(value.getValue());
            this.minExcl = this.min.correctMin(excl);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean updateMax(boolean excl, DatatypeRepresentation<O> value) {
        if (this.hasMax()) {
            if (this.max.lesser(value)) {
                return false;
            }
            if (this.max.equals(value) && this.maxExcl && !excl) {
                return false;
            }
        }
        try {
            this.max = value.getDatatype().build(value.getValue());
            this.maxExcl = this.max.correctMax(excl);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean update(boolean minimum, boolean excl, DatatypeRepresentation<O> value) {
        return minimum ? this.updateMin(excl, value) : this.updateMax(excl, value);
    }

    public boolean consistent(DatatypeRepresentation<?> dtype) {
        if (this.hasMin() && !this.min.getDatatype().compatible(dtype.getDatatype())) {
            return false;
        }
        return !this.hasMax() || this.max.getDatatype().compatible(dtype.getDatatype());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.hasMin()) {
            b.append(this.minExcl ? (char)'(' : '[');
            b.append(this.min);
        } else {
            b.append('{');
        }
        b.append(",");
        if (this.hasMax()) {
            b.append(this.max);
            b.append(this.maxExcl ? (char)')' : ']');
        } else {
            b.append('}');
        }
        return b.toString();
    }
}

