/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.dep.DepSetFactory;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.Reference;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataInterval;
import uk.ac.manchester.cs.jfact.kernel.datatype.DatatypeRepresentation;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;
import uk.ac.manchester.cs.jfact.kernel.datatype.DepInterval;

public final class DataTypeAppearance<O> {
    private DepDTE pType;
    private DepDTE nType;
    private List<DepInterval<O>> constraints = new ArrayList<DepInterval<O>>();
    private DepSet accDep = DepSetFactory.create();
    private final Reference<DepSet> clashDep;
    private boolean localMin;
    private boolean localExcl;
    private DatatypeRepresentation<O> localValue;
    private DepSet localDep;

    private boolean reportClash(DepSet dep, String reason) {
        LeveLogger.logger.print(LeveLogger.Templates.CLASH, reason);
        this.clashDep.setReference(dep);
        return true;
    }

    private void setLocal(boolean min, boolean excl, DatatypeRepresentation<O> value, DepSet dep) {
        this.localMin = min;
        this.localExcl = excl;
        this.localValue = value.getDatatype().build(value.getValue());
        this.localDep = DepSetFactory.create(dep);
    }

    private boolean addUpdatedInterval(DepInterval<O> i) {
        Reference<DepSet> ref = new Reference<DepSet>(this.localDep);
        if (!i.consistent(this.localValue, ref)) {
            this.localDep = ref.getReference();
            return this.reportClash(this.localDep, "C-IT");
        }
        if (!i.update(this.localMin, this.localExcl, this.localValue, this.localDep)) {
            this.constraints.add(i);
        }
        ref = new Reference<DepSet>(this.accDep);
        if (!this.hasPType() || !i.checkMinMaxClash(ref)) {
            this.constraints.add(i);
        }
        this.accDep = ref.getReference();
        return false;
    }

    private boolean addIntervals(List<DepInterval<O>> c) {
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            if (!this.addUpdatedInterval(new DepInterval<O>(c.get(i)))) continue;
            return true;
        }
        return false;
    }

    protected DataTypeAppearance(Reference<DepSet> dep) {
        this.clashDep = dep;
    }

    protected void clear() {
        this.pType = null;
        this.nType = null;
        this.constraints.clear();
        this.constraints.add(new DepInterval());
        this.accDep.clear();
    }

    public boolean hasPType() {
        return this.pType != null;
    }

    public boolean hasNType() {
        return this.nType != null;
    }

    protected void setPType(DepDTE type) {
        if (!this.hasPType()) {
            this.pType = type;
        }
    }

    protected boolean addInterval(boolean pos, DataInterval<O> Int, DepSet dep) {
        LeveLogger.logger.print(LeveLogger.Templates.INTERVAL, pos ? "+" : "-", Int);
        return pos ? this.addPosInterval(Int, dep) : this.addNegInterval(Int, dep);
    }

    protected boolean checkPNTypeClash() {
        if (this.hasNType() && this.hasPType()) {
            return this.reportClash(DepSetFactory.plus(this.pType.second, this.nType.second), "TNT");
        }
        return false;
    }

    private boolean addPosInterval(DataInterval<O> Int, DepSet dep) {
        ArrayList<DepInterval<O>> aux;
        if (Int.hasMin()) {
            aux = new ArrayList<DepInterval<O>>(this.constraints);
            this.constraints.clear();
            this.setLocal(true, Int.minExcl, Int.min, dep);
            if (this.addIntervals(aux)) {
                return true;
            }
            aux.clear();
        }
        if (Int.hasMax()) {
            aux = new ArrayList<DepInterval<O>>(this.constraints);
            this.constraints.clear();
            this.setLocal(false, Int.maxExcl, Int.max, dep);
            if (this.addIntervals(aux)) {
                return true;
            }
            aux.clear();
        }
        if (this.constraints.isEmpty()) {
            return this.reportClash(this.accDep, "C-MM");
        }
        return false;
    }

    private boolean addNegInterval(DataInterval<O> Int, DepSet dep) {
        ArrayList<DepInterval<O>> aux = new ArrayList<DepInterval<O>>(this.constraints);
        this.constraints.clear();
        if (Int.hasMin()) {
            this.setLocal(false, !Int.minExcl, Int.min, dep);
            if (this.addIntervals(aux)) {
                return true;
            }
        }
        if (Int.hasMax()) {
            this.setLocal(true, !Int.maxExcl, Int.max, dep);
            if (this.addIntervals(aux)) {
                return true;
            }
        }
        aux.clear();
        if (this.constraints.isEmpty()) {
            return this.reportClash(this.accDep, "C-MM");
        }
        return false;
    }

    protected void setNType(DepDTE t) {
        this.nType = t;
    }

    protected DepDTE getPType() {
        return this.pType;
    }

    protected DepDTE getNType() {
        return this.nType;
    }

    public boolean checkCompatibleValue(DataTypeAppearance<?> other, Datatypes thisDatatype, Datatypes otherDatatype) {
        if (this.localValue == null && other.localValue == null || this.localValue != null && this.localValue.equals(other.localValue)) {
            return thisDatatype.compatible(otherDatatype, this.localValue);
        }
        return false;
    }

    public static class DepDTE {
        protected final Object first;
        protected final DepSet second;

        protected DepDTE(Object e, DepSet s) {
            this.first = e;
            this.second = DepSetFactory.create(s);
        }
    }
}

