/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import java.util.HashMap;
import java.util.Map;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataEntry;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataTypeEntryCollection;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataTypeReasoner;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTypeName;

public final class DataTypeCenter {
    private final Map<Datatypes, DataTypeEntryCollection<?>> Types = new HashMap();

    public DataTypeCenter() {
        for (Datatypes d : Datatypes.values()) {
            this.Types.put(d, new DataTypeEntryCollection(d));
        }
    }

    public DLTree getNumberType() {
        return DLTreeFactory.wrap(new DataTypeName(Datatypes.INT));
    }

    public DLTree getStringType() {
        return DLTreeFactory.wrap(new DataTypeName(Datatypes.STRING));
    }

    public DLTree getDateTimeDataType() {
        return DLTreeFactory.wrap(new DataTypeName(Datatypes.DATETIME));
    }

    public DLTree getFreshDataType() {
        return DLTreeFactory.wrap(new DataTypeName(Datatypes.FRESH));
    }

    public DLTree getRealType() {
        return DLTreeFactory.wrap(new DataTypeName(Datatypes.FLOAT));
    }

    public DLTree getBoolType() {
        return DLTreeFactory.wrap(new DataTypeName(Datatypes.BOOLEAN));
    }

    public DLTree getDataValue(String name, Datatypes type) {
        return DLTreeFactory.wrap(this.create(name, type));
    }

    public DLTree getIntervalFacetExpr(DLTree val, boolean min, boolean excl) {
        DataEntry value = (DataEntry)DLTreeFactory.unwrap(val);
        DataEntry ret = this.createFacet(value.getDatatype());
        ret.getFacet().update(min, excl, value.getComp());
        return DLTreeFactory.wrap(ret);
    }

    private DataEntry create(String name, Datatypes type) {
        return (DataEntry)this.Types.get((Object)type).get(name);
    }

    private DataEntry createFacet(Datatypes type) {
        return this.Types.get((Object)type).getExpr();
    }

    public void initDataTypeReasoner(DataTypeReasoner DTReasoner) {
        for (Datatypes type : Datatypes.values()) {
            DTReasoner.registerDataType(type);
        }
    }
}

